/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import java.math.BigDecimal;
import org.seasar.cubby.validator.MessageHelper;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;
import org.seasar.framework.util.StringUtil;

public class NumberValidator
implements ScalarFieldValidator {
    private final MessageHelper messageHelper;

    public NumberValidator() {
        this("valid.number");
    }

    public NumberValidator(String messageKey) {
        this.messageHelper = new MessageHelper(messageKey);
    }

    public void validate(ValidationContext context, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtil.isEmpty((String)str)) {
                return;
            }
            try {
                new BigDecimal(str);
                return;
            }
            catch (NumberFormatException e) {}
        } else if (value == null) {
            return;
        }
        context.addMessageInfo(this.messageHelper.createMessageInfo(new Object[0]));
    }
}

