/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt.mobylet.image;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobylet.core.image.ImageConfig;
import org.mobylet.core.util.RequestUtils;

public class YmirImageConfig
extends ImageConfig {
    private static final Log log = LogFactory.getLog(YmirImageConfig.class);
    private String scaleServletPath;

    public String getScaleServletPath() {
        String original = super.getScaleServletPath();
        HttpServletRequest request = RequestUtils.get();
        if (request == null) {
            return original;
        }
        String contextPath = request.getContextPath();
        if (original == null) {
            return contextPath + this.scaleServletPath;
        }
        if (!original.startsWith("/")) {
            return original;
        }
        return this.getScaleServletPath(original, contextPath);
    }

    String getScaleServletPath(String original, String actualContextPath) {
        String originalContextPath = this.getContextPath(original);
        if (actualContextPath.equals(originalContextPath)) {
            return original;
        }
        if (originalContextPath.length() == 0) {
            return actualContextPath + original;
        }
        log.warn((Object)("ScaleServletPath's context (" + originalContextPath + ") is different from the actual context (" + actualContextPath + ")"));
        return original;
    }

    private String getContextPath(String path) {
        int slash = path.indexOf(47, 1);
        if (slash >= 0) {
            return path.substring(0, slash);
        }
        return "";
    }

    public void setScaleServletPath(String scaleServletPath) {
        this.scaleServletPath = scaleServletPath;
    }
}

