/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task.replaceschema;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.helper.jdbc.DfRunnerInformation;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileFireMan;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunner;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerDispatcher;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerExecute;
import org.seasar.dbflute.logic.replaceschema.schemainitializer.DfSchemaInitializer;
import org.seasar.dbflute.logic.replaceschema.schemainitializer.factory.DfSchemaInitializerFactory;
import org.seasar.dbflute.properties.DfReplaceSchemaProperties;
import org.seasar.dbflute.task.replaceschema.DfAbstractReplaceSchemaTask;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfCreateSchemaTask
extends DfAbstractReplaceSchemaTask {
    private static final Log _log = LogFactory.getLog(DfCreateSchemaTask.class);
    protected static final String LOG_PATH = "./log/create-schema.log";
    protected boolean _validTaskEndInformation = true;
    protected boolean _lazyConnection = false;
    protected String _currentUser;
    protected StringSet _goodByeUserSet = StringSet.createAsCaseInsensitive();
    protected StringSet _revivedUserSet = StringSet.createAsCaseInsensitive();
    protected StringKeyMap<Connection> _changeUserConnectionMap = StringKeyMap.createAsCaseInsensitive();

    @Override
    protected void setupDataSource() throws SQLException {
        try {
            super.setupDataSource();
            this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            this.setupLazyConnection(e);
        }
    }

    protected void setupLazyConnection(SQLException e) throws SQLException {
        if (this._lazyConnection) {
            throw e;
        }
        String msg = e.getMessage();
        if (msg.length() > 50) {
            msg = msg.substring(0, 47) + "...";
        }
        _log.info((Object)("...Being a lazy connection: " + msg));
        this.destroyDataSource();
        this._lazyConnection = true;
    }

    @Override
    protected void doExecute() {
        _log.info((Object)"");
        _log.info((Object)"{Replace Schema Properties}");
        _log.info((Object)("errorContinue     = " + this.getMyProperties().isErrorContinue()));
        _log.info((Object)("sqlFileEncoding   = " + this.getMyProperties().getSqlFileEncoding()));
        this.initializeSchema();
        DfRunnerInformation runInfo = this.createRunnerInformation();
        this.createSchema(runInfo);
    }

    @Override
    protected boolean isValidTaskEndInformation() {
        return this._validTaskEndInformation;
    }

    protected void initializeSchema() {
        this.initializeSchemaAdditionalDrop();
        this.initializeSchemaMainDrop();
    }

    protected void initializeSchemaAdditionalDrop() {
        List<Map<String, Object>> additionalDropMapList = this.getMyProperties().getAdditionalDropMapList();
        if (additionalDropMapList.isEmpty()) {
            return;
        }
        if (this.getBasicProperties().isDatabaseMySQL() || this.getBasicProperties().isDatabaseSQLServer()) {
            String msg = "AdditionalDropDefinitionSchema is unsupported at MySQL and SQLServer!";
            throw new UnsupportedOperationException(msg);
        }
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * * * * * * * * * * * *");
        _log.info((Object)"*                                     *");
        _log.info((Object)"* Initialize Schema (Additional Drop) *");
        _log.info((Object)"*                                     *");
        _log.info((Object)"* * * * * * * * * * * * * * * * * * * *");
        if (this._lazyConnection) {
            _log.info((Object)"*Passed because it's a lazy connection");
            return;
        }
        for (Map<String, Object> additionalDropMap : additionalDropMapList) {
            UnifiedSchema dropSchema = this.getMyProperties().getAdditionalDropSchema(additionalDropMap);
            String dropUrl = this.getMyProperties().getAdditionalDropUrl(additionalDropMap);
            StringBuilder logSb = new StringBuilder();
            if (dropSchema.hasSchema()) {
                logSb.append("[").append(dropSchema.getLoggingSchema()).append("]");
                if (dropUrl != null && dropUrl.trim().length() > 0) {
                    logSb.append(": ").append(dropUrl);
                }
            } else if (dropUrl != null && dropUrl.trim().length() > 0) {
                logSb.append(dropUrl);
            }
            _log.info((Object)logSb.toString());
            DfSchemaInitializer initializer = this.createSchemaInitializerAdditional(additionalDropMap);
            if (initializer == null) continue;
            initializer.initializeSchema();
        }
    }

    protected void initializeSchemaMainDrop() {
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * * *");
        _log.info((Object)"*                   *");
        _log.info((Object)"* Initialize Schema *");
        _log.info((Object)"*                   *");
        _log.info((Object)"* * * * * * * * * * *");
        if (this._lazyConnection) {
            _log.info((Object)"*Passed because it's a lazy connection");
            return;
        }
        DfSchemaInitializer initializer = this.createSchemaInitializer(DfSchemaInitializerFactory.InitializeType.MAIN);
        if (initializer != null) {
            initializer.initializeSchema();
        }
    }

    protected DfSchemaInitializer createSchemaInitializer(DfSchemaInitializerFactory.InitializeType initializeType) {
        DfSchemaInitializerFactory factory = this.createSchemaInitializerFactory(initializeType);
        return factory.createSchemaInitializer();
    }

    protected DfSchemaInitializer createSchemaInitializerAdditional(Map<String, Object> additionalDropMap) {
        DfSchemaInitializerFactory factory = this.createSchemaInitializerFactory(DfSchemaInitializerFactory.InitializeType.ADDTIONAL);
        factory.setAdditionalDropMap(additionalDropMap);
        return factory.createSchemaInitializer();
    }

    protected DfSchemaInitializerFactory createSchemaInitializerFactory(DfSchemaInitializerFactory.InitializeType initializeType) {
        return new DfSchemaInitializerFactory(this.getDataSource(), this.getBasicProperties(), this.getDatabaseProperties(), this.getMyProperties(), initializeType);
    }

    protected DfRunnerInformation createRunnerInformation() {
        DfRunnerInformation runInfo = new DfRunnerInformation();
        runInfo.setDriver(this._driver);
        runInfo.setUrl(this._url);
        runInfo.setUser(this._userId);
        runInfo.setPassword(this._password);
        runInfo.setEncoding(this.getReplaceSchemaSqlFileEncoding());
        runInfo.setAutoCommit(true);
        runInfo.setErrorContinue(this.getMyProperties().isErrorContinue());
        runInfo.setRollbackOnly(false);
        return runInfo;
    }

    protected String getReplaceSchemaSqlFileEncoding() {
        return this.getMyProperties().getSqlFileEncoding();
    }

    protected void createSchema(DfRunnerInformation runInfo) {
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * *");
        _log.info((Object)"*               *");
        _log.info((Object)"* Create Schema *");
        _log.info((Object)"*               *");
        _log.info((Object)"* * * * * * * * *");
        DfSqlFileFireMan fireMan = new DfSqlFileFireMan();
        fireMan.setExecutorName("Create Schema");
        DfSqlFileFireMan.FireResult result = fireMan.execute(this.getSqlFileRunner(runInfo), this.getReplaceSchemaSqlFileList());
        try {
            this.dumpFireResult(result);
        }
        catch (Throwable ignored) {
            _log.info((Object)("Failed to dump create-schema result: " + result), ignored);
        }
        _log.info((Object)"");
        this.destroyChangeUserConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dumpFireResult(DfSqlFileFireMan.FireResult result) {
        boolean deleted;
        File file = new File(LOG_PATH);
        if (file.exists() && !(deleted = file.delete())) {
            return;
        }
        String resultMessage = result.getResultMessage();
        if (resultMessage == null) return;
        if (resultMessage.trim().length() == 0) {
            return;
        }
        BufferedWriter bw = null;
        try {
            try {
                StringBuilder contentsSb = new StringBuilder();
                contentsSb.append(resultMessage).append(this.ln()).append(result.isExistsError());
                String detailMessage = result.getDetailMessage();
                if (detailMessage != null && detailMessage.trim().length() > 0) {
                    contentsSb.append(this.ln()).append(detailMessage);
                }
                FileOutputStream fos = new FileOutputStream(file);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                bw.write(contentsSb.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            Object var9_12 = null;
            if (bw == null) return;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (bw == null) throw throwable;
            try {
                bw.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        bw.close();
        return;
    }

    protected DfSqlFileRunner getSqlFileRunner(DfRunnerInformation runInfo) {
        final DfReplaceSchemaProperties prop = this.getMyProperties();
        DfSqlFileRunnerExecuteCreateSchema execute = new DfSqlFileRunnerExecuteCreateSchema(runInfo, this.getDataSource());
        execute.setDispatcher(new DfSqlFileRunnerDispatcher(){

            public boolean dispatch(File sqlFile, Statement st, String sql) throws SQLException {
                boolean e;
                block11: {
                    if (DfCreateSchemaTask.this._currentUser == null || DfCreateSchemaTask.this._currentUser.trim().length() == 0) {
                        return false;
                    }
                    Connection conn = (Connection)DfCreateSchemaTask.this._changeUserConnectionMap.get((Object)DfCreateSchemaTask.this._currentUser);
                    if (conn == null) {
                        _log.info((Object)("...Creating a connection to " + DfCreateSchemaTask.this._currentUser));
                        conn = prop.createAdditionalUserConnection(DfCreateSchemaTask.this._currentUser);
                        if (conn != null) {
                            DfCreateSchemaTask.this._changeUserConnectionMap.put(DfCreateSchemaTask.this._currentUser, (Object)conn);
                        }
                        if (conn == null) {
                            String msg = "...Saying good-bye to the user '" + DfCreateSchemaTask.this._currentUser + "'";
                            msg = msg + " because of no definition";
                            _log.info((Object)msg);
                            DfCreateSchemaTask.this._goodByeUserSet.add(DfCreateSchemaTask.this._currentUser);
                            return true;
                        }
                    }
                    Statement dispatchStmt = null;
                    dispatchStmt = conn.createStatement();
                    try {
                        dispatchStmt.execute(sql);
                        e = true;
                        Object var11_10 = null;
                        if (dispatchStmt == null) break block11;
                    }
                    catch (SQLException e2) {
                        block12: {
                            boolean bl;
                            block13: {
                                try {
                                    boolean checkUser = DfCreateSchemaTask.this.analyzeCheckUser(sql);
                                    if (!checkUser) break block12;
                                    String msg = "...Saying good-bye to the user '" + DfCreateSchemaTask.this._currentUser + "'";
                                    msg = msg + " because of checked";
                                    _log.info((Object)msg);
                                    DfCreateSchemaTask.this._goodByeUserSet.add(DfCreateSchemaTask.this._currentUser);
                                    bl = true;
                                    Object var11_11 = null;
                                    if (dispatchStmt == null) break block13;
                                }
                                catch (Throwable throwable) {
                                    block14: {
                                        Object var11_12 = null;
                                        if (dispatchStmt == null) break block14;
                                        dispatchStmt.close();
                                    }
                                    throw throwable;
                                }
                                dispatchStmt.close();
                            }
                            return bl;
                        }
                        throw e2;
                    }
                    dispatchStmt.close();
                }
                return e;
            }
        });
        return execute;
    }

    protected String analyzeChangeUser(String sql) {
        String beginMark = "#df:changeUser(";
        int markIndex = sql.indexOf("#df:changeUser(");
        if (markIndex < 0) {
            return null;
        }
        String rear = sql.substring(markIndex + "#df:changeUser(".length());
        int endIndex = rear.indexOf(")");
        if (endIndex < 0) {
            String msg = "The command changeUser should have its end mark ')':";
            msg = msg + " example=[#df:changeUser(system)#], sql=" + sql;
            throw new IllegalStateException(msg);
        }
        return rear.substring(0, endIndex).trim();
    }

    protected boolean analyzeCheckUser(String sql) {
        String mark = "#df:checkUser()#";
        return sql.contains("#df:checkUser()#");
    }

    protected boolean analyzeBackToMainUser(String sql) {
        String mark = "#df:backToMainUser()#";
        return sql.contains("#df:backToMainUser()#");
    }

    protected boolean analyzeReviveUser(String sql) {
        String mark = "#df:reviveUser()#";
        return sql.contains("#df:reviveUser()#");
    }

    protected List<File> getReplaceSchemaSqlFileList() {
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.addAll(this.getReplaceSchemaNextSqlFileList());
        fileList.addAll(this.getReplaceSchemaNextSqlFileListAdditional());
        return fileList;
    }

    protected List<File> getReplaceSchemaNextSqlFileList() {
        String path = this.getMyProperties().getReplaceSchemaPlaySqlDirectory();
        return this.doGetReplaceSchemaSqlFileList(path);
    }

    protected List<File> getReplaceSchemaNextSqlFileListAdditional() {
        ArrayList<File> fileList = new ArrayList<File>();
        String path = this.getMyProperties().getApplicationPlaySqlDirectory();
        if (Srl.is_Null_or_TrimmedEmpty((String)path)) {
            return DfCollectionUtil.emptyList();
        }
        fileList.addAll(this.doGetReplaceSchemaSqlFileList(path));
        return fileList;
    }

    protected List<File> doGetReplaceSchemaSqlFileList(String directoryPath) {
        File baseDir = new File(directoryPath);
        final String fileNameWithoutExt = this.getReplaceSchemaSqlFileNameWithoutExt();
        final String sqlFileExt = this.getReplaceSchemaSqlFileExt();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(fileNameWithoutExt) && name.endsWith("." + sqlFileExt);
            }
        };
        Comparator<File> fileNameAscComparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<File> treeSet = new TreeSet<File>(fileNameAscComparator);
        String[] targetList = baseDir.list(filter);
        if (targetList == null) {
            return DfCollectionUtil.emptyList();
        }
        for (String targetFileName : targetList) {
            String targetFilePath = directoryPath + "/" + targetFileName;
            treeSet.add(new File(targetFilePath));
        }
        return new ArrayList<File>(treeSet);
    }

    protected String getReplaceSchemaSqlFileNameWithoutExt() {
        return this.getMyProperties().getReplaceSchemaSqlFileNameWithoutExt();
    }

    protected String getReplaceSchemaSqlFileExt() {
        return this.getMyProperties().getReplaceSchemaSqlFileExt();
    }

    protected void destroyChangeUserConnection() {
        if (this._changeUserConnectionMap.isEmpty()) {
            return;
        }
        _log.info((Object)("...Closing connections to change-users: " + this._changeUserConnectionMap.keySet()));
        Set entrySet = this._changeUserConnectionMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String changeUser = (String)entry.getKey();
            Connection conn = (Connection)entry.getValue();
            try {
                conn.close();
            }
            catch (SQLException continued) {
                String msg = "Failed to close the connection for " + changeUser + ":";
                msg = msg + " message=" + continued.getMessage();
                _log.info((Object)msg);
            }
        }
    }

    protected DfReplaceSchemaProperties getMyProperties() {
        return DfBuildProperties.getInstance().getReplaceSchemaProperties();
    }

    protected String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace((String)text, (String)fromText, (String)toText);
    }

    public void setValidTaskEndInformation(String validTaskEndInformation) {
        this._validTaskEndInformation = validTaskEndInformation != null && validTaskEndInformation.trim().equalsIgnoreCase("true");
    }

    protected class DfSqlFileRunnerExecuteCreateSchema
    extends DfSqlFileRunnerExecute {
        public DfSqlFileRunnerExecuteCreateSchema(DfRunnerInformation runInfo, DataSource dataSource) {
            super(runInfo, dataSource);
        }

        public void prepare(File sqlFile) {
            super.prepare(sqlFile);
            this.restoreRevivedUser();
            this.restoreCurrentUser();
        }

        protected void restoreRevivedUser() {
            for (String revivedUser : DfCreateSchemaTask.this._revivedUserSet) {
                if (DfCreateSchemaTask.this._goodByeUserSet.contains((Object)revivedUser)) continue;
                _log.info((Object)("...Saying good-bye to the user '" + revivedUser + "' again"));
                DfCreateSchemaTask.this._goodByeUserSet.add(revivedUser);
            }
            if (!DfCreateSchemaTask.this._revivedUserSet.isEmpty()) {
                _log.info((Object)"...Clearing revived users");
                DfCreateSchemaTask.this._revivedUserSet.clear();
            }
        }

        protected void restoreCurrentUser() {
            if (DfCreateSchemaTask.this._currentUser != null) {
                _log.info((Object)("...Coming back to the main user from the user '" + DfCreateSchemaTask.this._currentUser + "'"));
                DfCreateSchemaTask.this._currentUser = null;
            }
        }

        protected String filterSql(String sql) {
            sql = super.filterSql(sql);
            sql = DfCreateSchemaTask.this.getMyProperties().resolveFilterVariablesIfNeeds(sql);
            return sql;
        }

        protected boolean isSqlTrimAndRemoveLineSeparator() {
            return true;
        }

        protected boolean isHandlingCommentOnLineSeparator() {
            return true;
        }

        protected boolean isDbCommentLine(String line) {
            boolean commentLine = super.isDbCommentLine(line);
            if (commentLine) {
                return commentLine;
            }
            return DfCreateSchemaTask.this.isDbCommentLineForIrregularPattern(line);
        }

        protected String getTerminater4Tool() {
            return DfCreateSchemaTask.this.resolveTerminater4Tool();
        }

        /*
         * Enabled aggressive block sorting
         */
        protected boolean isTargetSql(String sql) {
            boolean backToMainUser;
            String changeUesr = DfCreateSchemaTask.this.analyzeChangeUser(sql);
            if (changeUesr != null) {
                DfCreateSchemaTask.this._currentUser = changeUesr;
            }
            if (backToMainUser = DfCreateSchemaTask.this.analyzeBackToMainUser(sql)) {
                _log.info((Object)("...Coming back to the main user from the user '" + DfCreateSchemaTask.this._currentUser + "'"));
                DfCreateSchemaTask.this._currentUser = null;
            }
            boolean reviveUser = DfCreateSchemaTask.this.analyzeReviveUser(sql);
            if (DfCreateSchemaTask.this._currentUser != null && DfCreateSchemaTask.this._currentUser.trim().length() > 0) {
                if (!DfCreateSchemaTask.this._goodByeUserSet.contains((Object)DfCreateSchemaTask.this._currentUser)) return super.isTargetSql(sql);
                if (reviveUser) {
                    _log.info((Object)("...Reviving the user '" + DfCreateSchemaTask.this._currentUser + "' until the end of this SQL file"));
                    DfCreateSchemaTask.this._revivedUserSet.add(DfCreateSchemaTask.this._currentUser);
                    DfCreateSchemaTask.this._goodByeUserSet.remove((Object)DfCreateSchemaTask.this._currentUser);
                    return super.isTargetSql(sql);
                }
                String logSql = sql;
                if (logSql.length() > 30) {
                    logSql = logSql.substring(0, 27) + "...";
                }
                _log.info((Object)("passed: " + logSql));
                return false;
            }
            if (!reviveUser) return super.isTargetSql(sql);
            _log.warn((Object)"*The mark 'reviveUser()' is unsupported at the timing!");
            return super.isTargetSql(sql);
        }

        protected void lazyConnectIfNeeds() throws SQLException {
            if (DfCreateSchemaTask.this._lazyConnection) {
                _log.info((Object)"...Connecting by main user lazily");
                DfCreateSchemaTask.this.setupDataSource();
                this._dataSource = DfCreateSchemaTask.this.getDataSource();
                this.setupConnection();
                this.setupStatement();
                DfCreateSchemaTask.this._lazyConnection = false;
            }
        }
    }
}

