/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties.assistant.classification;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.token.line.LineTokenizingOption;
import org.seasar.dbflute.helper.token.line.impl.LineTokenImpl;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationElement;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationTop;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfClassificationResourceAnalyzer {
    private static final Log _log = LogFactory.getLog(DfClassificationResourceAnalyzer.class);
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static final String LN_MARK_PLAIN = "\\n";
    protected List<String> _additionalLineSeparatorList;

    public DfClassificationResourceAnalyzer() {
        ArrayList<String> additionalLineSeparatorList = new ArrayList<String>();
        additionalLineSeparatorList.add("&#x0D;&#x0A;");
        additionalLineSeparatorList.add("&#x0A;");
        additionalLineSeparatorList.add("&#x0D;");
        additionalLineSeparatorList.add("&#xD;&#xA;");
        additionalLineSeparatorList.add("&#xA;");
        additionalLineSeparatorList.add("&#xD;");
        additionalLineSeparatorList.add("&#13;&#10;");
        additionalLineSeparatorList.add("&#13;");
        additionalLineSeparatorList.add("&#10;");
        this._additionalLineSeparatorList = additionalLineSeparatorList;
    }

    public List<DfClassificationTop> analyze(String dirName, final String resourceName, final String extension) {
        File dir = new File(dirName);
        if (!dir.exists()) {
            return new ArrayList<DfClassificationTop>();
        }
        if (!dir.isDirectory()) {
            return new ArrayList<DfClassificationTop>();
        }
        File[] listFiles = dir.listFiles(new FileFilter(){

            public boolean accept(File currentFile) {
                if (currentFile.isDirectory()) {
                    return false;
                }
                String currentFileName = currentFile.getName();
                if (!currentFileName.startsWith(resourceName)) {
                    return false;
                }
                return currentFileName.endsWith(extension);
            }
        });
        ArrayList<DfClassificationTop> topList = new ArrayList<DfClassificationTop>();
        for (File file : listFiles) {
            List<String> lineList;
            try {
                String encoding = this.extractEncoding(file);
                if (encoding == null) {
                    encoding = DEFAULT_ENCODING;
                }
                _log.info((Object)("...Analyzing classification resources: encoding=" + encoding));
                lineList = this.createLineList(file, encoding);
            }
            catch (RuntimeException ignored) {
                String msg = "Failed to analyze classification resources: ";
                msg = msg + " " + dirName + "/" + resourceName + "." + extension;
                _log.info((Object)msg, (Throwable)ignored);
                continue;
            }
            List<DfClassificationTop> classificationTopList = this.analyze(lineList);
            for (DfClassificationTop top : classificationTopList) {
                _log.info((Object)("    " + top.getClassificationName() + ", " + top.getTopComment()));
            }
            topList.addAll(classificationTopList);
        }
        return topList;
    }

    protected List<DfClassificationTop> analyze(List<String> lineList) {
        ArrayList<DfClassificationTop> classificationList = new ArrayList<DfClassificationTop>();
        String relatedColumnName = null;
        boolean inGroup = false;
        int size = lineList.size();
        int index = -1;
        for (String line : lineList) {
            ++index;
            if (inGroup) {
                if (this.isTopLine(line)) {
                    DfClassificationTop classificationTop = this.extractClassificationTop(line);
                    classificationList.add(classificationTop);
                    if (relatedColumnName == null) continue;
                    classificationTop.setRelatedColumnName(relatedColumnName);
                    continue;
                }
                if (this.isElementLine(line)) {
                    DfClassificationElement classificationElement = this.extractClassificationElement(line);
                    DfClassificationTop classificationTop = (DfClassificationTop)classificationList.get(classificationList.size() - 1);
                    classificationTop.addClassificationElement(classificationElement);
                    continue;
                }
                inGroup = false;
                continue;
            }
            if (!this.isTitleLine(line)) continue;
            int nextIndex = index + 1;
            if (nextIndex >= size) break;
            String nextLine = lineList.get(nextIndex);
            if (!this.isTopLine(nextLine)) continue;
            int nextNextIndex = nextIndex + 1;
            if (nextNextIndex >= size) break;
            String nextNextLine = lineList.get(nextNextIndex);
            if (!this.isElementLine(nextNextLine)) continue;
            relatedColumnName = this.extractRelatedColumnNameFronTitleLine(line);
            inGroup = true;
        }
        return classificationList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> createLineList(File file, String encoding) {
        Object line;
        BufferedReader reader = null;
        ArrayList<Object> lineList = new ArrayList<Object>();
        try {
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
                while (true) {
                    if ((line = reader.readLine()) == null) {
                        line = lineList;
                        Object var8_9 = null;
                        if (reader == null) return line;
                        break;
                    }
                    if (this.containsLineSeparatorMark((String)(line = ((String)line).trim()))) {
                        List<String> nestedLineList = this.tokenizedLineSeparatorMark((String)line);
                        lineList.addAll(nestedLineList);
                        continue;
                    }
                    lineList.add(line);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
                throw throwable;
            }
        }
        try {}
        catch (IOException ignored) {
            ignored.printStackTrace();
            return line;
        }
        reader.close();
        return line;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String extractEncoding(File file) {
        String string;
        String encodingBegin = "encoding=\"";
        String encodingEnd = "\"";
        BufferedReader reader = null;
        try {
            try {
                String line;
                String temporaryEncoding = DEFAULT_ENCODING;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_ENCODING));
                String encoding = null;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() == 0) continue;
                    if (!line.contains("encoding=\"") || !(line = line.substring(line.indexOf("encoding=\"") + "encoding=\"".length())).contains("\"")) break;
                    encoding = line.substring(0, line.indexOf("\"")).trim();
                    break;
                }
                string = encoding;
                Object var9_10 = null;
                if (reader == null) return string;
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
                throw throwable;
            }
        }
        try {}
        catch (IOException ignored) {
            ignored.printStackTrace();
            return string;
        }
        reader.close();
        return string;
    }

    protected boolean isTitleLine(String line) {
        return line.contains("[") && line.contains("]") && line.indexOf("[") + 1 < line.indexOf("]");
    }

    protected boolean isTopLine(String line) {
        return line.contains("$ ");
    }

    protected boolean isElementLine(String line) {
        return line.contains("- ") && line.contains(",") && line.indexOf("- ") + 1 < line.indexOf(",");
    }

    protected String extractRelatedColumnNameFronTitleLine(String line) {
        if (!this.isTitleLine(line)) {
            String msg = "The line should be title line: line=" + line;
            throw new IllegalArgumentException(msg);
        }
        String connectMark = "]:";
        String wildCard = "*";
        String prefixMark = "prefix:";
        String suffixMark = "suffix:";
        if (!line.contains("]:")) {
            return null;
        }
        line = line.trim();
        String relatedColumnName = (line = this.removeRearXmlEndIfNeeds(line)).substring(line.indexOf("]:") + "]:".length()).trim();
        if (relatedColumnName == null) {
            return relatedColumnName;
        }
        if (relatedColumnName.startsWith("*")) {
            relatedColumnName = "suffix:" + relatedColumnName.substring("*".length());
        } else if (relatedColumnName.endsWith("*")) {
            relatedColumnName = relatedColumnName.substring(0, relatedColumnName.lastIndexOf("*"));
            relatedColumnName = "prefix:" + relatedColumnName;
        }
        return relatedColumnName;
    }

    protected DfClassificationTop extractClassificationTop(String line) {
        String topComment;
        String classificationName;
        if (!this.isTopLine(line)) {
            String msg = "The line should be top line: line=" + line;
            throw new IllegalArgumentException(msg);
        }
        line = line.trim();
        line = this.removeRearXmlEndIfNeeds(line);
        if ((line = line.substring(line.indexOf("$ ") + "$ ".length())).contains(",")) {
            classificationName = line.substring(0, line.indexOf(",")).trim();
            topComment = line.substring(line.indexOf(",") + ",".length()).trim();
        } else {
            classificationName = line.trim();
            topComment = null;
        }
        DfClassificationTop classificationTop = new DfClassificationTop();
        classificationTop.setClassificationName(classificationName);
        if (topComment != null) {
            classificationTop.setTopComment(topComment);
        }
        return classificationTop;
    }

    protected DfClassificationElement extractClassificationElement(String line) {
        String name;
        if (!this.isElementLine(line)) {
            String msg = "The line should be element line: line=" + line;
            throw new IllegalArgumentException(msg);
        }
        line = line.trim();
        line = this.removeRearXmlEndIfNeeds(line);
        line = line.substring(line.indexOf("- ") + "- ".length());
        String code = line.substring(0, line.indexOf(",")).trim();
        line = line.substring(line.indexOf(",") + ",".length());
        String alias = null;
        String comment = null;
        if (line.contains(",")) {
            name = line.substring(0, line.indexOf(",")).trim();
            if ((line = line.substring(line.indexOf(",") + ",".length())).contains(",")) {
                alias = line.substring(0, line.indexOf(",")).trim();
                line = line.substring(line.indexOf(",") + ",".length());
                comment = line.substring(0).trim();
            } else {
                alias = line.substring(0).trim();
            }
        } else {
            name = line.substring(0).trim();
        }
        DfClassificationElement classificationElement = new DfClassificationElement();
        classificationElement.setCode(code);
        classificationElement.setName(name);
        classificationElement.setAlias(alias);
        classificationElement.setComment(comment);
        return classificationElement;
    }

    protected String removeRearXmlEndIfNeeds(String line) {
        String endMark = "\"/>";
        if (line.endsWith("\"/>")) {
            line = line.substring(0, line.lastIndexOf("\"/>"));
        }
        return line;
    }

    protected boolean containsLineSeparatorMark(String line) {
        if (line.contains(LN_MARK_PLAIN)) {
            return true;
        }
        for (String lineSeparator : this._additionalLineSeparatorList) {
            if (!line.contains(lineSeparator)) continue;
            return true;
        }
        return false;
    }

    protected List<String> tokenizedLineSeparatorMark(String line) {
        String baseMark = LN_MARK_PLAIN;
        for (String lineSeparator : this._additionalLineSeparatorList) {
            line = DfStringUtil.replace((String)line, (String)lineSeparator, (String)LN_MARK_PLAIN);
        }
        return this.tokenize(line, LN_MARK_PLAIN);
    }

    protected List<String> tokenize(String value, String delimiter) {
        LineTokenImpl lineToken = new LineTokenImpl();
        LineTokenizingOption lineTokenizingOption = new LineTokenizingOption();
        lineTokenizingOption.setDelimiter(delimiter);
        return lineToken.tokenize(value, lineTokenizingOption);
    }

    public void setAdditionalLineSeparatorList(List<String> additionalLineSeparatorList) {
        if (additionalLineSeparatorList == null) {
            String msg = "The argument [additionalLineSeparatorList] should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this._additionalLineSeparatorList = additionalLineSeparatorList;
    }
}

