/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.outsidesql;

import java.util.ArrayList;
import org.seasar.dbflute.exception.DfIllegalAutoNamingClassNameException;
import org.seasar.dbflute.util.DfStringUtil;

public class DfSqlFileNameResolver {
    public static final String ENTITY_MARK = "df:entity";
    public static final String PMB_MARK = "df:pmb";

    public String resolveEntityNameIfNeeds(String className, String fileName) {
        return this.resolveObjectNameIfNeeds(className, fileName, ENTITY_MARK, "");
    }

    public String resolvePmbNameIfNeeds(String className, String fileName) {
        return this.resolveObjectNameIfNeeds(className, fileName, PMB_MARK, "Pmb");
    }

    protected String resolveObjectNameIfNeeds(String className, String fileName, String mark, String suffix) {
        if (className == null || className.trim().length() == 0) {
            String msg = "The argument[className] should not be null or empty: " + className;
            throw new IllegalArgumentException(msg);
        }
        if (!className.equalsIgnoreCase(mark)) {
            if (className.contains(":") || className.contains(";")) {
                this.throwIllegalAutoNamingClassNameException(className, fileName, mark);
            }
            return className;
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String msg = "The argument[fileName] should not be null or empty: " + fileName;
            throw new IllegalArgumentException(msg);
        }
        if ((fileName = DfStringUtil.replace((String)fileName, (String)"\\", (String)"/")).contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + "/".length());
        }
        if (!fileName.endsWith(".sql")) {
            String msg = "The SQL file should ends '.sql' if you use auto-naming:";
            msg = msg + " className=" + className + " fileName=" + fileName;
            throw new IllegalStateException(msg);
        }
        int beginIndex = fileName.contains("Bhv_") ? fileName.indexOf("Bhv_") + "Bhv_".length() : 0;
        String tmp = fileName.substring(beginIndex);
        int endIndex = tmp.indexOf("_");
        if (endIndex < 0) {
            endIndex = tmp.indexOf(".sql");
        }
        if (endIndex < 0) {
            String msg = "The SQL file should ends '.sql' if you use auto-naming:";
            msg = msg + " className=" + className + " fileName=" + fileName;
            throw new IllegalStateException(msg);
        }
        if (endIndex == 0) {
            String msg = "The name of SQL file have an unexpected underscore:";
            msg = msg + " className=" + className + " fileName=" + fileName;
            throw new IllegalStateException(msg);
        }
        tmp = tmp.substring(0, endIndex);
        char[] charArray = tmp.toCharArray();
        ArrayList<Character> charList = new ArrayList<Character>();
        boolean beginTarget = false;
        for (char c : charArray) {
            if (Character.isUpperCase(c)) {
                beginTarget = true;
            }
            if (!beginTarget) continue;
            charList.add(Character.valueOf(c));
        }
        if (charList.isEmpty()) {
            for (char c : charArray) {
                charList.add(Character.valueOf(c));
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Character c : charList) {
            sb.append(c);
        }
        sb.append(suffix);
        return DfStringUtil.initCap((String)sb.toString());
    }

    protected void throwIllegalAutoNamingClassNameException(String className, String fileName, String mark) {
        boolean entity = ENTITY_MARK.equalsIgnoreCase(mark);
        String targetName = entity ? "customize-entity" : "parameter-bean";
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The className for auto-naming(for " + targetName + ") is invalid." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Your className contained colon or semicolon but it was not auto-naming mark." + this.ln();
        msg = msg + "The auto-naming marks are '" + mark + "'." + this.ln();
        msg = msg + "  For example(@SQL):" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.ln();
        if (entity) {
            msg = msg + "    -- #" + mark + "#" + this.ln();
        } else {
            msg = msg + "    -- !" + mark + "!" + this.ln();
            msg = msg + "    -- !!Integer memberId!!" + this.ln();
            msg = msg + "    -- !!String memberName!!" + this.ln();
            msg = msg + "    -- ..." + this.ln();
        }
        msg = msg + "    " + this.ln();
        msg = msg + "    select * from ..." + this.ln();
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + "Confirm your auto-naming class definition if you want to use auto-naming." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Wrong Class Name]" + this.ln() + className + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL File]" + this.ln() + fileName + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfIllegalAutoNamingClassNameException(msg);
    }

    protected String ln() {
        return "\n";
    }
}

