/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.loaddata.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.helper.dataset.DfDataTable;
import org.seasar.dbflute.logic.replaceschema.loaddata.impl.DfXlsDataHandlerImpl;

public class DfXlsDataHandlerSQLServer
extends DfXlsDataHandlerImpl {
    private static final Log _log = LogFactory.getLog(DfXlsDataHandlerSQLServer.class);
    protected final Set<String> _identityTableSet = StringSet.createAsFlexible();

    public DfXlsDataHandlerSQLServer(DataSource dataSource) {
        super(dataSource);
    }

    protected void beforeHandlingTable(DfDataTable dataTable) {
        if (this.hasIdentityColumn(this._dataSource, dataTable)) {
            this.turnOnIdentityInsert(this._dataSource, dataTable);
            this._identityTableSet.add(dataTable.getTableName());
        }
    }

    protected void finallyHandlingTable(DfDataTable dataTable) {
        if (this._identityTableSet.contains(dataTable.getTableName())) {
            this.turnOffIdentityInsert(this._dataSource, dataTable);
        }
    }

    /*
     * Loose catch block
     */
    private boolean hasIdentityColumn(DataSource dataSource, DfDataTable dataTable) {
        SQLException ignored222222;
        boolean value222;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block27: {
            block23: {
                SQLException ignored222222;
                boolean bl;
                block24: {
                    String sql = "SELECT IDENT_CURRENT ('" + dataTable.getTableName() + "') AS IDENT_CURRENT";
                    conn = DfXlsDataHandlerSQLServer.getConnection(dataSource);
                    stmt = null;
                    rs = null;
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql);
                    if (!rs.next()) break block23;
                    Object value222 = rs.getObject(1);
                    bl = value222 != null;
                    Object var10_11 = null;
                    if (rs == null) break block24;
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored222222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ignored222222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored222222) {
                        // empty catch block
                    }
                }
                return bl;
            }
            value222 = true;
            Object var10_12 = null;
            if (rs == null) break block27;
            try {
                rs.close();
            }
            catch (SQLException ignored222222) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ignored222222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException ignored222222) {
                // empty catch block
            }
        }
        return value222;
        catch (SQLException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                block30: {
                    SQLException ignored222222;
                    Object var10_13 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignored222222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException ignored222222) {
                            // empty catch block
                        }
                    }
                    if (conn == null) break block30;
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored222222) {}
                }
                throw throwable;
            }
        }
    }

    private void turnOnIdentityInsert(DataSource dataSource, DfDataTable dataTable) {
        this.setIdentityInsert(dataSource, dataTable, "ON");
    }

    private void turnOffIdentityInsert(DataSource dataSource, DfDataTable dataTable) {
        this.setIdentityInsert(dataSource, dataTable, "OFF");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setIdentityInsert(DataSource dataSource, DfDataTable dataTable, String command) {
        String sql = "SET IDENTITY_INSERT " + dataTable.getTableName() + " " + command;
        if (this._loggingInsertSql) {
            _log.info((Object)sql);
        }
        Connection conn = null;
        try {
            block10: {
                conn = DfXlsDataHandlerSQLServer.getConnection(dataSource);
                Statement stmt = DfXlsDataHandlerSQLServer.createStatement(conn);
                try {
                    try {
                        stmt.execute(sql);
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException(e);
                    }
                    Object var9_7 = null;
                    if (stmt == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (SQLException ignored) {}
                stmt.close();
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            DfXlsDataHandlerSQLServer.close(conn);
            throw throwable;
        }
        DfXlsDataHandlerSQLServer.close(conn);
    }

    private static Connection getConnection(DataSource dataSource) {
        try {
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Statement createStatement(Connection conn) {
        try {
            return conn.createStatement();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

