/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.schemadiff;

import java.util.List;
import java.util.Map;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfAbstractDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfColumnDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfDiffType;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfForeignKeyDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfIndexDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNestDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNextPreviousDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfPrimaryKeyDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfUniqueKeyDiff;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfTableDiff
extends DfAbstractDiff
implements DfNestDiff {
    protected final String _tableName;
    protected final DfDiffType _diffType;
    protected DfNextPreviousDiff _unifiedSchemaDiff;
    protected DfNextPreviousDiff _objectTypeDiff;
    protected List<DfAbstractDiff.NextPreviousHandler> _nextPreviousItemList = DfCollectionUtil.newArrayList();
    protected final List<DfColumnDiff> _columnDiffAllList;
    protected final List<DfColumnDiff> _addedColumnDiffList;
    protected final List<DfColumnDiff> _changedColumnDiffList;
    protected final List<DfColumnDiff> _deletedColumnDiffList;
    protected final List<DfPrimaryKeyDiff> _primaryKeyDiffAllList;
    protected final List<DfPrimaryKeyDiff> _addedPrimaryKeyDiffList;
    protected final List<DfPrimaryKeyDiff> _changedPrimaryKeyDiffList;
    protected final List<DfPrimaryKeyDiff> _deletedPrimaryKeyDiffList;
    protected final List<DfForeignKeyDiff> _foreignKeyDiffAllList;
    protected final List<DfForeignKeyDiff> _addedForeignKeyDiffList;
    protected final List<DfForeignKeyDiff> _changedForeignKeyDiffList;
    protected final List<DfForeignKeyDiff> _deletedForeignKeyDiffList;
    protected final List<DfUniqueKeyDiff> _uniqueKeyDiffAllList;
    protected final List<DfUniqueKeyDiff> _addedUniqueKeyDiffList;
    protected final List<DfUniqueKeyDiff> _changedUniqueKeyDiffList;
    protected final List<DfUniqueKeyDiff> _deletedUniqueKeyDiffList;
    protected final List<DfIndexDiff> _indexDiffAllList;
    protected final List<DfIndexDiff> _addedIndexDiffList;
    protected final List<DfIndexDiff> _changedIndexDiffList;
    protected final List<DfIndexDiff> _deletedIndexDiffList;
    protected List<DfAbstractDiff.NestDiffSetupper> _nestDiffList;

    protected DfTableDiff(String tableName, DfDiffType diffType) {
        this._nextPreviousItemList.add(new DfAbstractDiff.NextPreviousHandler(){

            @Override
            public String titleName() {
                return "Schema";
            }

            @Override
            public String propertyName() {
                return "unifiedSchemaDiff";
            }

            @Override
            public DfNextPreviousDiff provide() {
                return DfTableDiff.this._unifiedSchemaDiff;
            }

            @Override
            public void restore(Map<String, Object> tableDiffMap) {
                DfTableDiff.this._unifiedSchemaDiff = DfTableDiff.this.restoreNextPreviousDiff(tableDiffMap, this.propertyName());
            }
        });
        this._nextPreviousItemList.add(new DfAbstractDiff.NextPreviousHandler(){

            @Override
            public String titleName() {
                return "Object Type";
            }

            @Override
            public String propertyName() {
                return "objectTypeDiff";
            }

            @Override
            public DfNextPreviousDiff provide() {
                return DfTableDiff.this._objectTypeDiff;
            }

            @Override
            public void restore(Map<String, Object> tableDiffMap) {
                DfTableDiff.this._objectTypeDiff = DfTableDiff.this.restoreNextPreviousDiff(tableDiffMap, this.propertyName());
            }
        });
        this._columnDiffAllList = DfCollectionUtil.newArrayList();
        this._addedColumnDiffList = DfCollectionUtil.newArrayList();
        this._changedColumnDiffList = DfCollectionUtil.newArrayList();
        this._deletedColumnDiffList = DfCollectionUtil.newArrayList();
        this._primaryKeyDiffAllList = DfCollectionUtil.newArrayList();
        this._addedPrimaryKeyDiffList = DfCollectionUtil.newArrayList();
        this._changedPrimaryKeyDiffList = DfCollectionUtil.newArrayList();
        this._deletedPrimaryKeyDiffList = DfCollectionUtil.newArrayList();
        this._foreignKeyDiffAllList = DfCollectionUtil.newArrayList();
        this._addedForeignKeyDiffList = DfCollectionUtil.newArrayList();
        this._changedForeignKeyDiffList = DfCollectionUtil.newArrayList();
        this._deletedForeignKeyDiffList = DfCollectionUtil.newArrayList();
        this._uniqueKeyDiffAllList = DfCollectionUtil.newArrayList();
        this._addedUniqueKeyDiffList = DfCollectionUtil.newArrayList();
        this._changedUniqueKeyDiffList = DfCollectionUtil.newArrayList();
        this._deletedUniqueKeyDiffList = DfCollectionUtil.newArrayList();
        this._indexDiffAllList = DfCollectionUtil.newArrayList();
        this._addedIndexDiffList = DfCollectionUtil.newArrayList();
        this._changedIndexDiffList = DfCollectionUtil.newArrayList();
        this._deletedIndexDiffList = DfCollectionUtil.newArrayList();
        this._nestDiffList = DfCollectionUtil.newArrayList();
        this._nestDiffList.add(new DfAbstractDiff.NestDiffSetupper(){

            @Override
            public String propertyName() {
                return "columnDiff";
            }

            @Override
            public List<? extends DfNestDiff> provide() {
                return DfTableDiff.this._columnDiffAllList;
            }

            @Override
            public void setup(Map<String, Object> diff) {
                DfTableDiff.this.addColumnDiff(DfTableDiff.this.createColumnDiff(diff));
            }
        });
        this._nestDiffList.add(new DfAbstractDiff.NestDiffSetupper(){

            @Override
            public String propertyName() {
                return "primaryKeyDiff";
            }

            @Override
            public List<? extends DfNestDiff> provide() {
                return DfTableDiff.this._primaryKeyDiffAllList;
            }

            @Override
            public void setup(Map<String, Object> diff) {
                DfTableDiff.this.addPrimaryKeyDiff(DfTableDiff.this.createPrimaryKeyDiff(diff));
            }
        });
        this._nestDiffList.add(new DfAbstractDiff.NestDiffSetupper(){

            @Override
            public String propertyName() {
                return "foreignKeyDiff";
            }

            @Override
            public List<? extends DfNestDiff> provide() {
                return DfTableDiff.this._foreignKeyDiffAllList;
            }

            @Override
            public void setup(Map<String, Object> diff) {
                DfTableDiff.this.addForeignKeyDiff(DfTableDiff.this.createForeignKeyDiff(diff));
            }
        });
        this._nestDiffList.add(new DfAbstractDiff.NestDiffSetupper(){

            @Override
            public String propertyName() {
                return "uniqueKeyDiff";
            }

            @Override
            public List<? extends DfNestDiff> provide() {
                return DfTableDiff.this._uniqueKeyDiffAllList;
            }

            @Override
            public void setup(Map<String, Object> diff) {
                DfTableDiff.this.addUniqueKeyDiff(DfTableDiff.this.createUniqueKeyDiff(diff));
            }
        });
        this._nestDiffList.add(new DfAbstractDiff.NestDiffSetupper(){

            @Override
            public String propertyName() {
                return "indexDiff";
            }

            @Override
            public List<? extends DfNestDiff> provide() {
                return DfTableDiff.this._indexDiffAllList;
            }

            @Override
            public void setup(Map<String, Object> diff) {
                DfTableDiff.this.addIndexDiff(DfTableDiff.this.createIndexDiff(diff));
            }
        });
        this._tableName = tableName;
        this._diffType = diffType;
    }

    protected DfTableDiff(Map<String, Object> tableDiffMap) {
        this._nextPreviousItemList.add(new /* invalid duplicate definition of identical inner class */);
        this._nextPreviousItemList.add(new /* invalid duplicate definition of identical inner class */);
        this._columnDiffAllList = DfCollectionUtil.newArrayList();
        this._addedColumnDiffList = DfCollectionUtil.newArrayList();
        this._changedColumnDiffList = DfCollectionUtil.newArrayList();
        this._deletedColumnDiffList = DfCollectionUtil.newArrayList();
        this._primaryKeyDiffAllList = DfCollectionUtil.newArrayList();
        this._addedPrimaryKeyDiffList = DfCollectionUtil.newArrayList();
        this._changedPrimaryKeyDiffList = DfCollectionUtil.newArrayList();
        this._deletedPrimaryKeyDiffList = DfCollectionUtil.newArrayList();
        this._foreignKeyDiffAllList = DfCollectionUtil.newArrayList();
        this._addedForeignKeyDiffList = DfCollectionUtil.newArrayList();
        this._changedForeignKeyDiffList = DfCollectionUtil.newArrayList();
        this._deletedForeignKeyDiffList = DfCollectionUtil.newArrayList();
        this._uniqueKeyDiffAllList = DfCollectionUtil.newArrayList();
        this._addedUniqueKeyDiffList = DfCollectionUtil.newArrayList();
        this._changedUniqueKeyDiffList = DfCollectionUtil.newArrayList();
        this._deletedUniqueKeyDiffList = DfCollectionUtil.newArrayList();
        this._indexDiffAllList = DfCollectionUtil.newArrayList();
        this._addedIndexDiffList = DfCollectionUtil.newArrayList();
        this._changedIndexDiffList = DfCollectionUtil.newArrayList();
        this._deletedIndexDiffList = DfCollectionUtil.newArrayList();
        this._nestDiffList = DfCollectionUtil.newArrayList();
        this._nestDiffList.add(new /* invalid duplicate definition of identical inner class */);
        this._nestDiffList.add(new /* invalid duplicate definition of identical inner class */);
        this._nestDiffList.add(new /* invalid duplicate definition of identical inner class */);
        this._nestDiffList.add(new /* invalid duplicate definition of identical inner class */);
        this._nestDiffList.add(new /* invalid duplicate definition of identical inner class */);
        this._tableName = (String)tableDiffMap.get("tableName");
        this.assertTableNameExists(this._tableName, tableDiffMap);
        this._diffType = DfDiffType.valueOf((String)tableDiffMap.get("diffType"));
        this.assertDiffTypeExists(this._tableName, tableDiffMap, this._diffType);
        this.acceptDiffMap(tableDiffMap);
    }

    protected void assertTableNameExists(String tableName, Map<String, Object> tableDiffMap) {
        if (tableName == null) {
            String msg = "The tableName is required in table diff-map:";
            msg = msg + " tableDiffMap=" + tableDiffMap;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertDiffTypeExists(String tableName, Map<String, Object> tableDiffMap, DfDiffType diffType) {
        if (diffType == null) {
            String msg = "The diffType is required in table diff-map:";
            msg = msg + " table=" + tableName + " tableDiffMap=" + tableDiffMap;
            throw new IllegalStateException(msg);
        }
    }

    public static DfTableDiff createAdded(String tableName) {
        return new DfTableDiff(tableName, DfDiffType.ADD);
    }

    public static DfTableDiff createChanged(String tableName) {
        return new DfTableDiff(tableName, DfDiffType.CHANGE);
    }

    public static DfTableDiff createDeleted(String tableName) {
        return new DfTableDiff(tableName, DfDiffType.DELETE);
    }

    public static DfTableDiff createFromDiffMap(Map<String, Object> tableDiffMap) {
        return new DfTableDiff(tableDiffMap);
    }

    @Override
    public Map<String, Object> createDiffMap() {
        Map map = DfCollectionUtil.newLinkedHashMap();
        map.put("tableName", this._tableName);
        map.put("diffType", this._diffType.toString());
        List<DfAbstractDiff.NextPreviousHandler> nextPreviousItemList = this._nextPreviousItemList;
        for (DfAbstractDiff.NextPreviousHandler provider : nextPreviousItemList) {
            DfNextPreviousDiff nextPreviousDiff = provider.provide();
            if (nextPreviousDiff == null) continue;
            map.put(provider.propertyName(), nextPreviousDiff.createNextPreviousDiffMap());
        }
        List<DfAbstractDiff.NestDiffSetupper> nestDiffList = this._nestDiffList;
        for (DfAbstractDiff.NestDiffSetupper setupper : nestDiffList) {
            List<? extends DfNestDiff> diffAllList = setupper.provide();
            if (diffAllList.isEmpty()) continue;
            Map diffMap = DfCollectionUtil.newLinkedHashMap();
            for (DfNestDiff dfNestDiff : diffAllList) {
                if (!dfNestDiff.hasDiff()) continue;
                diffMap.put(dfNestDiff.getKeyName(), dfNestDiff.createDiffMap());
            }
            map.put(setupper.propertyName(), diffMap);
        }
        return map;
    }

    @Override
    public void acceptDiffMap(Map<String, Object> tableDiffMap) {
        List<DfAbstractDiff.NextPreviousHandler> nextPreviousItemList = this._nextPreviousItemList;
        for (DfAbstractDiff.NextPreviousHandler provider : nextPreviousItemList) {
            provider.restore(tableDiffMap);
        }
        List<DfAbstractDiff.NestDiffSetupper> nestDiffList = this._nestDiffList;
        for (DfAbstractDiff.NestDiffSetupper setupper : nestDiffList) {
            this.restoreNestDiff(tableDiffMap, setupper);
        }
    }

    @Override
    public boolean hasDiff() {
        if (!DfDiffType.CHANGE.equals((Object)this._diffType)) {
            return true;
        }
        List<DfAbstractDiff.NextPreviousHandler> nextPreviousItemList = this._nextPreviousItemList;
        for (DfAbstractDiff.NextPreviousHandler provider : nextPreviousItemList) {
            if (provider.provide() == null) continue;
            return true;
        }
        List<DfAbstractDiff.NestDiffSetupper> nestDiffList = this._nestDiffList;
        for (DfAbstractDiff.NestDiffSetupper setupper : nestDiffList) {
            List<? extends DfNestDiff> diffAllList = setupper.provide();
            for (DfNestDiff dfNestDiff : diffAllList) {
                if (!dfNestDiff.hasDiff()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getKeyName() {
        return this.getTableName();
    }

    public String getTableName() {
        return this._tableName;
    }

    @Override
    public DfDiffType getDiffType() {
        return this._diffType;
    }

    public boolean isAdded() {
        return DfDiffType.ADD.equals((Object)this._diffType);
    }

    public boolean isChanged() {
        return DfDiffType.CHANGE.equals((Object)this._diffType);
    }

    public boolean isDeleted() {
        return DfDiffType.DELETE.equals((Object)this._diffType);
    }

    @Override
    public List<DfAbstractDiff.NextPreviousHandler> getNextPreviousValidList() {
        List<DfAbstractDiff.NextPreviousHandler> previousItemList = this._nextPreviousItemList;
        List validHandlerList = DfCollectionUtil.newArrayList();
        for (DfAbstractDiff.NextPreviousHandler handler : previousItemList) {
            DfNextPreviousDiff nextPreviousDiff = handler.provide();
            if (nextPreviousDiff == null || !nextPreviousDiff.hasDiff()) continue;
            validHandlerList.add(handler);
        }
        return validHandlerList;
    }

    public boolean hasUnifiedSchemaDiff() {
        return this._unifiedSchemaDiff != null;
    }

    public DfNextPreviousDiff getUnifiedSchemaDiff() {
        return this._unifiedSchemaDiff;
    }

    public void setUnifiedSchemaDiff(DfNextPreviousDiff unifiedSchemaDiff) {
        this._unifiedSchemaDiff = unifiedSchemaDiff;
    }

    public boolean hasObjectTypeDiff() {
        return this._objectTypeDiff != null;
    }

    public DfNextPreviousDiff getObjectTypeDiff() {
        return this._objectTypeDiff;
    }

    public void setObjectTypeDiff(DfNextPreviousDiff objectTypeDiff) {
        this._objectTypeDiff = objectTypeDiff;
    }

    public List<DfNestDiffContent> getNestDiffContentOrderedList() {
        List contentList = DfCollectionUtil.newArrayList();
        String typeName = "Column";
        this.setupNestDiffList(contentList, "Add Column", this._addedColumnDiffList);
        this.setupNestDiffList(contentList, "Change Column", this._changedColumnDiffList);
        this.setupNestDiffList(contentList, "Delete Column", this._deletedColumnDiffList);
        typeName = "PK";
        this.setupNestDiffList(contentList, "Add PK", this._addedPrimaryKeyDiffList);
        this.setupNestDiffList(contentList, "Change PK", this._changedPrimaryKeyDiffList);
        this.setupNestDiffList(contentList, "Delete PK", this._deletedPrimaryKeyDiffList);
        typeName = "FK";
        this.setupNestDiffList(contentList, "Add FK", this._addedForeignKeyDiffList);
        this.setupNestDiffList(contentList, "Change FK", this._changedForeignKeyDiffList);
        this.setupNestDiffList(contentList, "Delete FK", this._deletedForeignKeyDiffList);
        typeName = "UQ";
        this.setupNestDiffList(contentList, "Add UQ", this._addedUniqueKeyDiffList);
        this.setupNestDiffList(contentList, "Change UQ", this._changedUniqueKeyDiffList);
        this.setupNestDiffList(contentList, "Delete UQ", this._deletedUniqueKeyDiffList);
        typeName = "Index";
        this.setupNestDiffList(contentList, "Add Index", this._addedIndexDiffList);
        this.setupNestDiffList(contentList, "Change Index", this._changedIndexDiffList);
        this.setupNestDiffList(contentList, "Delete Index", this._deletedIndexDiffList);
        return contentList;
    }

    protected void setupNestDiffList(List<DfNestDiffContent> contentList, String title, List<? extends DfNestDiff> nestDiffList) {
        if (!nestDiffList.isEmpty()) {
            DfNestDiffContent content = new DfNestDiffContent();
            content.setTitleName(title);
            content.setNestDiffList(nestDiffList);
            content.setChange(DfDiffType.CHANGE.equals((Object)nestDiffList.get(0).getDiffType()));
            contentList.add(content);
        }
    }

    public boolean hasColumnDiff() {
        return !this._columnDiffAllList.isEmpty();
    }

    public List<DfColumnDiff> getColumnDiffAllList() {
        return this._columnDiffAllList;
    }

    public List<DfColumnDiff> getAddedColumnDiffList() {
        return this._addedColumnDiffList;
    }

    public List<DfColumnDiff> getChangedColumnDiffList() {
        return this._changedColumnDiffList;
    }

    public List<DfColumnDiff> getDeletedColumnDiffList() {
        return this._deletedColumnDiffList;
    }

    public void addColumnDiff(DfColumnDiff columnDiff) {
        this._columnDiffAllList.add(columnDiff);
        if (columnDiff.isAdded()) {
            this._addedColumnDiffList.add(columnDiff);
        } else if (columnDiff.isChanged()) {
            this._changedColumnDiffList.add(columnDiff);
        } else if (columnDiff.isDeleted()) {
            this._deletedColumnDiffList.add(columnDiff);
        } else {
            String msg = "Unknown diff-type of column: ";
            msg = msg + " diffType=" + (Object)((Object)columnDiff.getDiffType());
            msg = msg + " columnDiff=" + columnDiff;
            throw new IllegalStateException(msg);
        }
    }

    public boolean hasPrimaryKeyDiff() {
        return !this._primaryKeyDiffAllList.isEmpty();
    }

    public List<DfPrimaryKeyDiff> getPrimaryKeyDiffAllList() {
        return this._primaryKeyDiffAllList;
    }

    public List<DfPrimaryKeyDiff> getAddedPrimaryKeyDiffList() {
        return this._addedPrimaryKeyDiffList;
    }

    public List<DfPrimaryKeyDiff> getChangedPrimaryKeyDiffList() {
        return this._changedPrimaryKeyDiffList;
    }

    public List<DfPrimaryKeyDiff> getDeletedPrimaryKeyDiffList() {
        return this._deletedPrimaryKeyDiffList;
    }

    public void addPrimaryKeyDiff(DfPrimaryKeyDiff primaryKeyDiff) {
        this._primaryKeyDiffAllList.add(primaryKeyDiff);
        if (primaryKeyDiff.isAdded()) {
            this._addedPrimaryKeyDiffList.add(primaryKeyDiff);
        } else if (primaryKeyDiff.isChanged()) {
            this._changedPrimaryKeyDiffList.add(primaryKeyDiff);
        } else if (primaryKeyDiff.isDeleted()) {
            this._deletedPrimaryKeyDiffList.add(primaryKeyDiff);
        } else {
            String msg = "Unknown diff-type of column: ";
            msg = msg + " diffType=" + (Object)((Object)primaryKeyDiff.getDiffType());
            msg = msg + " primaryKeyDiff=" + primaryKeyDiff;
            throw new IllegalStateException(msg);
        }
    }

    public boolean hasForeignKeyDiff() {
        return !this._foreignKeyDiffAllList.isEmpty();
    }

    public List<DfForeignKeyDiff> getForeignKeyDiffAllList() {
        return this._foreignKeyDiffAllList;
    }

    public List<DfForeignKeyDiff> getAddedForeignKeyDiffList() {
        return this._addedForeignKeyDiffList;
    }

    public List<DfForeignKeyDiff> getChangedForeignKeyDiffList() {
        return this._changedForeignKeyDiffList;
    }

    public List<DfForeignKeyDiff> getDeletedForeignKeyDiffList() {
        return this._deletedForeignKeyDiffList;
    }

    public void addForeignKeyDiff(DfForeignKeyDiff foreignKeyDiff) {
        this._foreignKeyDiffAllList.add(foreignKeyDiff);
        if (foreignKeyDiff.isAdded()) {
            this._addedForeignKeyDiffList.add(foreignKeyDiff);
        } else if (foreignKeyDiff.isChanged()) {
            this._changedForeignKeyDiffList.add(foreignKeyDiff);
        } else if (foreignKeyDiff.isDeleted()) {
            this._deletedForeignKeyDiffList.add(foreignKeyDiff);
        } else {
            String msg = "Unknown diff-type of column: ";
            msg = msg + " diffType=" + (Object)((Object)foreignKeyDiff.getDiffType());
            msg = msg + " foreignKeyDiff=" + foreignKeyDiff;
            throw new IllegalStateException(msg);
        }
    }

    public boolean hasUniqueKeyDiff() {
        return !this._uniqueKeyDiffAllList.isEmpty();
    }

    public List<DfUniqueKeyDiff> getUniqueKeyDiffAllList() {
        return this._uniqueKeyDiffAllList;
    }

    public List<DfUniqueKeyDiff> getAddedUniqueKeyDiffList() {
        return this._addedUniqueKeyDiffList;
    }

    public List<DfUniqueKeyDiff> getChangedUniqueKeyDiffList() {
        return this._changedUniqueKeyDiffList;
    }

    public List<DfUniqueKeyDiff> getDeletedUniqueKeyDiffList() {
        return this._deletedUniqueKeyDiffList;
    }

    public void addUniqueKeyDiff(DfUniqueKeyDiff uniqueKeyDiff) {
        this._uniqueKeyDiffAllList.add(uniqueKeyDiff);
        if (uniqueKeyDiff.isAdded()) {
            this._addedUniqueKeyDiffList.add(uniqueKeyDiff);
        } else if (uniqueKeyDiff.isChanged()) {
            this._changedUniqueKeyDiffList.add(uniqueKeyDiff);
        } else if (uniqueKeyDiff.isDeleted()) {
            this._deletedUniqueKeyDiffList.add(uniqueKeyDiff);
        } else {
            String msg = "Unknown diff-type of column: ";
            msg = msg + " diffType=" + (Object)((Object)uniqueKeyDiff.getDiffType());
            msg = msg + " uniqueKeyDiff=" + uniqueKeyDiff;
            throw new IllegalStateException(msg);
        }
    }

    public boolean hasIndexDiff() {
        return !this._indexDiffAllList.isEmpty();
    }

    public List<DfIndexDiff> getIndexDiffAllList() {
        return this._indexDiffAllList;
    }

    public List<DfIndexDiff> getAddedIndexDiffList() {
        return this._addedIndexDiffList;
    }

    public List<DfIndexDiff> getChangedIndexDiffList() {
        return this._changedIndexDiffList;
    }

    public List<DfIndexDiff> getDeletedIndexDiffList() {
        return this._deletedIndexDiffList;
    }

    public void addIndexDiff(DfIndexDiff indexDiff) {
        this._indexDiffAllList.add(indexDiff);
        if (indexDiff.isAdded()) {
            this._addedIndexDiffList.add(indexDiff);
        } else if (indexDiff.isChanged()) {
            this._changedIndexDiffList.add(indexDiff);
        } else if (indexDiff.isDeleted()) {
            this._deletedIndexDiffList.add(indexDiff);
        } else {
            String msg = "Unknown diff-type of column: ";
            msg = msg + " diffType=" + (Object)((Object)indexDiff.getDiffType());
            msg = msg + " indexDiff=" + indexDiff;
            throw new IllegalStateException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DfNestDiffContent {
        protected String _titleName;
        protected boolean _change;
        protected List<? extends DfNestDiff> _nestDiffList;

        public String getTitleName() {
            return this._titleName;
        }

        public void setTitleName(String titleName) {
            this._titleName = titleName;
        }

        public boolean isChange() {
            return this._change;
        }

        public void setChange(boolean change) {
            this._change = change;
        }

        public List<? extends DfNestDiff> getNestDiffList() {
            return this._nestDiffList;
        }

        public void setNestDiffList(List<? extends DfNestDiff> nestDiffList) {
            this._nestDiffList = nestDiffList;
        }
    }
}

