/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.synonym;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.handler.DfProcedureHandler;
import org.seasar.dbflute.logic.jdbc.metadata.DfAbstractMetaDataExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.synonym.DfProcedureSynonymExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureSynonymExtractorOracle
extends DfAbstractMetaDataExtractor
implements DfProcedureSynonymExtractor {
    private static final Log _log = LogFactory.getLog(DfProcedureSynonymExtractorOracle.class);
    protected DataSource _dataSource;
    protected List<UnifiedSchema> _targetSchemaList;

    /*
     * Loose catch block
     */
    @Override
    public Map<String, DfProcedureSynonymMetaInfo> extractProcedureSynonymMap() {
        StringKeyMap procedureSynonymMap;
        block23: {
            SQLException ignored2222;
            ResultSet rs;
            Statement st;
            Connection conn;
            String sql;
            block21: {
                _log.info((Object)"...Extracting procedure synonym");
                procedureSynonymMap = StringKeyMap.createAsFlexibleOrdered();
                sql = this.buildSynonymSelect();
                conn = null;
                st = null;
                rs = null;
                conn = this._dataSource.getConnection();
                DatabaseMetaData metaData = conn.getMetaData();
                LinkedHashMap<String, DfProcedureMetaInfo> procedureMap = new LinkedHashMap<String, DfProcedureMetaInfo>();
                ArrayList<DfProcedureMetaInfo> procedureList = new ArrayList<DfProcedureMetaInfo>();
                DfProcedureHandler procedureHandler = new DfProcedureHandler();
                procedureHandler.suppressLogging();
                for (UnifiedSchema unifiedSchema : this._targetSchemaList) {
                    procedureList.addAll(procedureHandler.getPlainProcedureList(this._dataSource, metaData, unifiedSchema));
                }
                for (DfProcedureMetaInfo metaInfo : procedureList) {
                    String procedureKeyName = metaInfo.getProcedureFullQualifiedName();
                    procedureMap.put(procedureKeyName, metaInfo);
                }
                st = conn.createStatement();
                _log.info((Object)sql);
                rs = st.executeQuery(sql);
                while (rs.next()) {
                    String procedureKey;
                    DfProcedureMetaInfo procedureMetaInfo;
                    UnifiedSchema synonymOwner = this.createAsDynamicSchema(null, rs.getString("OWNER"));
                    String synonymName = rs.getString("SYNONYM_NAME");
                    UnifiedSchema tableOwner = this.createAsDynamicSchema(null, rs.getString("TABLE_OWNER"));
                    String tableName = rs.getString("TABLE_NAME");
                    String dbLinkName = rs.getString("DB_LINK");
                    DfSynonymMetaInfo synonymMetaInfo = new DfSynonymMetaInfo();
                    synonymMetaInfo.setSynonymOwner(synonymOwner);
                    synonymMetaInfo.setSynonymName(synonymName);
                    synonymMetaInfo.setTableOwner(tableOwner);
                    synonymMetaInfo.setTableName(tableName);
                    synonymMetaInfo.setDBLinkName(dbLinkName);
                    this.judgeSynonymSelectable(synonymMetaInfo);
                    if (synonymMetaInfo.isSelectable() || dbLinkName != null && dbLinkName.trim().length() > 0 || !tableOwner.hasSchema() || (procedureMetaInfo = (DfProcedureMetaInfo)procedureMap.get(procedureKey = tableOwner.buildSchemaQualifiedName(tableName))) == null) continue;
                    procedureMetaInfo.setProcedureSynonym(true);
                    DfProcedureSynonymMetaInfo procedureSynonymMetaInfo = new DfProcedureSynonymMetaInfo();
                    procedureSynonymMetaInfo.setProcedureMetaInfo(procedureMetaInfo);
                    procedureSynonymMetaInfo.setSynonymMetaInfo(synonymMetaInfo);
                    String synonymKey = this.buildSynonymMapKey(synonymOwner, synonymName);
                    procedureSynonymMap.put(synonymKey, procedureSynonymMetaInfo);
                }
                Object var21_22 = null;
                if (st == null) break block21;
                try {
                    st.close();
                }
                catch (SQLException ignored2222) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignored2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ignored2222) {}
            }
            break block23;
            {
                catch (SQLException e) {
                    String msg = "Failed to get procedure synonyms: sql=" + sql;
                    throw new SQLFailureException(msg, e);
                }
            }
            catch (Throwable throwable) {
                SQLException ignored2222;
                Object var21_23 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ignored2222) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return procedureSynonymMap;
    }

    protected String buildSynonymSelect() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (UnifiedSchema unifiedSchema : this._targetSchemaList) {
            if (count > 0) {
                sb.append(", ");
            }
            sb.append("'").append(unifiedSchema.getPureSchema()).append("'");
            ++count;
        }
        String sql = "select * from ALL_SYNONYMS where OWNER in (" + sb.toString() + ")";
        return sql;
    }

    protected String buildSynonymMapKey(UnifiedSchema synonymOwner, String synonymName) {
        return synonymOwner.buildSchemaQualifiedName(synonymName);
    }

    protected void judgeSynonymSelectable(DfSynonymMetaInfo info) {
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        String synonymSqlName = info.buildSynonymSqlName();
        String sql = "select * from " + synonymSqlName + " where 0 = 1";
        try {
            ArrayList<String> columnList = new ArrayList<String>();
            columnList.add("dummy");
            facade.selectStringList(sql, columnList);
            info.setSelectable(true);
        }
        catch (RuntimeException ignored) {
            info.setSelectable(false);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setTargetSchemaList(List<UnifiedSchema> targetSchemaList) {
        this._targetSchemaList = targetSchemaList;
    }
}

