/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.generate.deletefile;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.seasar.dbflute.friends.velocity.DfGenerator;
import org.seasar.dbflute.logic.generate.packagepath.DfPackagePathHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfOldTableClassDeletor {
    protected DfGenerator _generator;
    protected DfPackagePathHandler _packagePathHandler;
    protected List<String> _packagePathList = new ArrayList<String>();
    protected String _classPrefix;
    protected String _classSuffix;
    protected String _classExtension;
    protected Set<String> notDeleteClassNameSet;

    public DfOldTableClassDeletor(DfGenerator generator, DfPackagePathHandler packagePathHandler) {
        this._generator = generator;
        this._packagePathHandler = packagePathHandler;
    }

    public List<String> deleteOldTableClass() {
        ArrayList<String> deletedClassNameList = new ArrayList<String>();
        for (String packagePath : this._packagePathList) {
            List<File> files = this.findPackageFileList(packagePath, this._classPrefix, this._classSuffix);
            for (File file : files) {
                String name = file.getName();
                String nameWithoutExt = name.substring(0, name.lastIndexOf(this._classExtension));
                if (this.notDeleteClassNameSet.contains(nameWithoutExt)) continue;
                deletedClassNameList.add(nameWithoutExt);
                file.delete();
            }
        }
        return deletedClassNameList;
    }

    protected List<File> findPackageFileList(String packagePath, final String classPrefix, final String classSuffix) {
        String packageAsPath = this._packagePathHandler.getPackageAsPath(packagePath);
        String dirPath = this.getGeneratorInstance().getOutputPath() + "/" + packageAsPath;
        File dir = new File(dirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return new ArrayList<File>();
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!name.endsWith(DfOldTableClassDeletor.this._classExtension)) {
                    return false;
                }
                String nameWithoutExt = name.substring(0, name.lastIndexOf(DfOldTableClassDeletor.this._classExtension));
                if (!nameWithoutExt.startsWith(classPrefix)) {
                    return false;
                }
                if (classPrefix != null && classPrefix.trim().length() > 0 && !nameWithoutExt.startsWith(classPrefix)) {
                    return false;
                }
                return classSuffix == null || classSuffix.trim().length() <= 0 || nameWithoutExt.endsWith(classSuffix);
            }
        };
        File[] listFiles = dir.listFiles(filter);
        if (listFiles == null || listFiles.length == 0) {
            return new ArrayList<File>();
        }
        return Arrays.asList(listFiles);
    }

    public DfGenerator getGeneratorInstance() {
        return DfGenerator.getInstance();
    }

    public void addPackagePath(String packagePath) {
        this._packagePathList.add(packagePath);
    }

    protected String getClassPrefix() {
        return this._classPrefix;
    }

    public void setClassPrefix(String classPrefix) {
        this._classPrefix = classPrefix;
    }

    public String getClassSuffix() {
        return this._classSuffix;
    }

    public void setClassSuffix(String classSuffix) {
        this._classSuffix = classSuffix;
    }

    public String getClassExtension() {
        return this._classExtension;
    }

    public void setClassExtension(String classExtension) {
        this._classExtension = classExtension != null && !classExtension.startsWith(".") ? "." + classExtension : classExtension;
    }

    public Set<String> getNotDeleteClassNameSet() {
        return this.notDeleteClassNameSet;
    }

    public void setNotDeleteClassNameSet(Set<String> notDeleteClassNameSet) {
        this.notDeleteClassNameSet = notDeleteClassNameSet;
    }
}

