/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.generate.column;

import java.util.List;
import org.apache.torque.engine.database.model.Column;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.properties.DfBasicProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfColumnListToStringUtil {
    public static String getColumnArgsString(List<Column> columnList) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String javaNative;
            if (pk.isForceClassificationSetting()) {
                DfBasicProperties prop = DfColumnListToStringUtil.getBasicProperties();
                String projectPrefix = prop.getProjectPrefix();
                String classificationName = pk.getClassificationName();
                javaNative = projectPrefix + "CDef." + classificationName;
            } else {
                javaNative = pk.getJavaNative();
            }
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(javaNative).append(" ").append(uncapitalisedJavaName);
        }
        return sb.toString();
    }

    public static String getColumnArgsJavaDocString(List<Column> columnList, String ln) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            if (sb.length() > 0) {
                sb.append(ln).append("     * ");
            }
            sb.append("@param ").append(uncapitalisedJavaName);
            sb.append(" The one of primary key. (NotNull)");
        }
        return sb.toString();
    }

    public static String getColumnArgsAssertString(List<Column> columnList) {
        return DfColumnListToStringUtil.doGetColumnArgsAssertString(columnList, false);
    }

    public static String getColumnArgsAssertStringCSharp(List<Column> columnList) {
        return DfColumnListToStringUtil.doGetColumnArgsAssertString(columnList, true);
    }

    private static String doGetColumnArgsAssertString(List<Column> columnList, boolean initCap) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            sb.append(initCap ? "A" : "a").append("ssertObjectNotNull(\"");
            sb.append(uncapitalisedJavaName).append("\", ");
            sb.append(uncapitalisedJavaName).append(");");
        }
        return sb.toString();
    }

    public static String getColumnArgsSetupString(String beanName, List<Column> columnList) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        String beanPrefix = beanName != null ? beanName + "." : "";
        String result = "";
        for (Column pk : columnList) {
            String javaName = pk.getJavaName();
            String variable = pk.getUncapitalisedJavaName();
            String setter = beanPrefix + "set" + javaName + "(" + variable + ");";
            if ("".equals(result)) {
                result = setter;
                continue;
            }
            result = result + setter;
        }
        return result;
    }

    public static String getColumnArgsSetupStringCSharp(String beanName, List<Column> columnList) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        String beanPrefix = beanName != null ? beanName + "." : "";
        String result = "";
        for (Column pk : columnList) {
            String javaName = pk.getJavaName();
            String variable = pk.getUncapitalisedJavaName();
            String setter = beanPrefix + javaName + " = " + variable + ";";
            if ("".equals(result)) {
                result = setter;
                continue;
            }
            result = result + setter;
        }
        return result;
    }

    public static String getColumnArgsConditionSetupString(List<Column> columnList) {
        return DfColumnListToStringUtil.doGetColumnArgsConditionSetupString(columnList, false);
    }

    public static String getColumnArgsConditionSetupStringCSharp(List<Column> columnList) {
        return DfColumnListToStringUtil.doGetColumnArgsConditionSetupString(columnList, true);
    }

    private static String doGetColumnArgsConditionSetupString(List<Column> columnList, boolean csharp) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String setter;
            String javaName = pk.getJavaName();
            String variable = pk.getUncapitalisedJavaName();
            if (pk.isForceClassificationSetting()) {
                String cls = pk.getClassificationName();
                setter = csharp ? "cb.Query().Set" + javaName + "_Equal_As" + cls + "(" + variable + ");" : "cb.query().set" + javaName + "_Equal_As" + cls + "(" + variable + ");";
            } else {
                setter = csharp ? "cb.Query().Set" + javaName + "_Equal(" + variable + ");" : "cb.query().set" + javaName + "_Equal(" + variable + ");";
            }
            sb.append(setter);
        }
        return sb.toString();
    }

    public static String getColumnNameCommaString(List<Column> columnList) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column col : columnList) {
            String name = col.getName();
            if ("".equals(result)) {
                result = name;
                continue;
            }
            result = result + ", " + name;
        }
        return result;
    }

    public static String getColumnJavaNameCommaString(List<Column> columnList) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column col : columnList) {
            String name = col.getJavaName();
            if ("".equals(result)) {
                result = name;
                continue;
            }
            result = result + ", " + name;
        }
        return result;
    }

    public static String getColumnUncapitalisedJavaNameCommaString(List<Column> columnList) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column col : columnList) {
            String name = col.getUncapitalisedJavaName();
            if ("".equals(result)) {
                result = name;
                continue;
            }
            result = result + ", " + name;
        }
        return result;
    }

    public static String getColumnGetterCommaString(List<Column> columnList) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column col : columnList) {
            String javaName = col.getJavaName();
            String getterString = "get" + javaName + "()";
            if ("".equals(result)) {
                result = getterString;
                continue;
            }
            result = result + ", " + getterString;
        }
        return result;
    }

    public static String getColumnOrderByString(List<Column> columnList, String sortString) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String name = pk.getName();
            if ("".equals(sb.toString())) {
                sb.append(name).append(" ").append(sortString);
                continue;
            }
            sb.append(", ").append(name).append(" ").append(sortString);
        }
        return sb.toString();
    }

    public static String getColumnDispValueString(List<Column> columnList, String getterPrefix) {
        DfColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column pk : columnList) {
            String javaName = pk.getJavaName();
            String getterString = getterPrefix + javaName + "()";
            if ("".equals(result)) {
                result = getterString;
                continue;
            }
            result = result + " + \"-\" + " + getterString;
        }
        return result;
    }

    private static DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    private static void validateColumnList(List<Column> columnList) {
        if (columnList == null) {
            String msg = "The columnList is null.";
            throw new IllegalStateException(msg);
        }
    }
}

