/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.dataset.writers;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.dataset.DfDataTable;
import org.seasar.dbflute.helper.dataset.writers.DfDtsSqlTableWriter;

public class DfDtsSQLServerSqlTableWriter
extends DfDtsSqlTableWriter {
    private static final Log _log = LogFactory.getLog(DfDtsSQLServerSqlTableWriter.class);

    public DfDtsSQLServerSqlTableWriter(DataSource dataSource, UnifiedSchema unifiedSchema) {
        super(dataSource, unifiedSchema);
    }

    protected void doWrite(DfDataTable dataTable) {
        boolean hasIdentity = this.hasIdentityColumn(dataTable);
        if (hasIdentity) {
            this.turnOnIdentityInsert(dataTable);
        }
        super.doWrite(dataTable);
        if (hasIdentity) {
            this.turnOffIdentityInsert(dataTable);
        }
    }

    private void turnOnIdentityInsert(DfDataTable dataTable) {
        this.setIdentityInsert(dataTable, "ON");
    }

    private void turnOffIdentityInsert(DfDataTable dataTable) {
        this.setIdentityInsert(dataTable, "OFF");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setIdentityInsert(DfDataTable dataTable, String command) {
        String sql = "SET IDENTITY_INSERT " + dataTable.getTableName() + " " + command;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)sql);
        }
        Connection conn = DfDtsSQLServerSqlTableWriter.getConnection(this.getDataSource());
        try {
            block10: {
                Statement stmt = DfDtsSQLServerSqlTableWriter.createStatement(conn);
                try {
                    try {
                        stmt.execute(sql);
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException(e);
                    }
                    Object var8_6 = null;
                    if (stmt == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (SQLException ignored) {}
                stmt.close();
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            DfDtsSQLServerSqlTableWriter.close(conn);
            throw throwable;
        }
        DfDtsSQLServerSqlTableWriter.close(conn);
    }

    /*
     * Loose catch block
     */
    private boolean hasIdentityColumn(DfDataTable dataTable) {
        SQLException ignored222222;
        boolean value222;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block27: {
            block23: {
                SQLException ignored222222;
                boolean bl;
                block24: {
                    String sql = "SELECT IDENT_CURRENT ('" + dataTable.getTableName() + "') AS IDENT_CURRENT";
                    conn = DfDtsSQLServerSqlTableWriter.getConnection(this.getDataSource());
                    stmt = null;
                    rs = null;
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql);
                    if (!rs.next()) break block23;
                    Object value222 = rs.getObject(1);
                    bl = value222 != null;
                    Object var9_10 = null;
                    if (rs == null) break block24;
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored222222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ignored222222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored222222) {
                        // empty catch block
                    }
                }
                return bl;
            }
            value222 = true;
            Object var9_11 = null;
            if (rs == null) break block27;
            try {
                rs.close();
            }
            catch (SQLException ignored222222) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ignored222222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException ignored222222) {
                // empty catch block
            }
        }
        return value222;
        catch (SQLException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                block30: {
                    SQLException ignored222222;
                    Object var9_12 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignored222222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException ignored222222) {
                            // empty catch block
                        }
                    }
                    if (conn == null) break block30;
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored222222) {}
                }
                throw throwable;
            }
        }
    }

    private static Connection getConnection(DataSource dataSource) {
        try {
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Statement createStatement(Connection conn) {
        try {
            return conn.createStatement();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

