/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.helper.language.metadata.LanguageMetaData;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

public class TypeMap {
    public static final Log _log = LogFactory.getLog(TypeMap.class);
    public static final String CHAR = "CHAR";
    public static final String VARCHAR = "VARCHAR";
    public static final String LONGVARCHAR = "LONGVARCHAR";
    public static final String CLOB = "CLOB";
    public static final String NUMERIC = "NUMERIC";
    public static final String DECIMAL = "DECIMAL";
    public static final String BIT = "BIT";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String TINYINT = "TINYINT";
    public static final String SMALLINT = "SMALLINT";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String REAL = "REAL";
    public static final String FLOAT = "FLOAT";
    public static final String DOUBLE = "DOUBLE";
    public static final String BINARY = "BINARY";
    public static final String VARBINARY = "VARBINARY";
    public static final String LONGVARBINARY = "LONGVARBINARY";
    public static final String BLOB = "BLOB";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String ARRAY = "ARRAY";
    public static final String OTHER = "OTHER";
    public static final String UUID = "UUID";
    public static final String CHAR_NATIVE_TYPE = "String";
    public static final String VARCHAR_NATIVE_TYPE = "String";
    public static final String LONGVARCHAR_NATIVE_TYPE = "String";
    public static final String CLOB_NATIVE_TYPE = "String";
    public static final String NUMERIC_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String DECIMAL_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String BIT_NATIVE_TYPE = "Boolean";
    public static final String BOOLEAN_NATIVE_TYPE = "Boolean";
    public static final String TINYINT_NATIVE_TYPE = "Integer";
    public static final String SMALLINT_NATIVE_TYPE = "Integer";
    public static final String INTEGER_NATIVE_TYPE = "Integer";
    public static final String BIGINT_NATIVE_TYPE = "Long";
    public static final String REAL_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String FLOAT_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String DOUBLE_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String BINARY_NATIVE_TYPE = "byte[]";
    public static final String VARBINARY_NATIVE_TYPE = "byte[]";
    public static final String LONGVARBINARY_NATIVE_TYPE = "byte[]";
    public static final String BLOB_NATIVE_TYPE = "byte[]";
    public static final String DATE_NATIVE_TYPE = "java.util.Date";
    public static final String TIME_NATIVE_TYPE = "java.sql.Time";
    public static final String TIMESTAMP_NATIVE_TYPE = "java.sql.Timestamp";
    public static final String ARRAY_NATIVE_TYPE = "String";
    public static final String UUID_NATIVE_TYPE = "java.util.UUID";
    public static final String OTHER_NATIVE_TYPE = "Object";
    private static final Map<String, String> _jdbcTypeToJavaNativeMap = DfCollectionUtil.newHashMap();
    private static final Map<Integer, String> _jdbcDefValueToJdbcTypeMap = DfCollectionUtil.newHashMap();
    private static final Map<String, Integer> _jdbcTypeToJdbcDefValueMap = DfCollectionUtil.newHashMap();
    private static final Map<String, String> _javaNativeToFlexNativeMap = DfCollectionUtil.newHashMap();
    protected static Map<String, Object> _propertyJdbcTypeToJavaNativeMap;
    protected static Map<String, String> _propertyJavaNativeToFlexNativeMap;
    private static boolean _initialized;

    protected static void setupPropertyNativeMap() {
        DfBuildProperties prop = DfBuildProperties.getInstance();
        _propertyJdbcTypeToJavaNativeMap = prop.getTypeMappingProperties().getJdbcToJavaNativeMap();
        _propertyJavaNativeToFlexNativeMap = prop.getFlexDtoProperties().getJavaToFlexNativeMap();
    }

    public static void reload() {
        TypeMap.setupPropertyNativeMap();
        _initialized = false;
        TypeMap.initialize();
    }

    public static synchronized void initialize() {
        if (_initialized) {
            return;
        }
        _jdbcTypeToJavaNativeMap.put(CHAR, TypeMap.initializeJavaNative(CHAR, "String"));
        _jdbcTypeToJavaNativeMap.put(VARCHAR, TypeMap.initializeJavaNative(VARCHAR, "String"));
        _jdbcTypeToJavaNativeMap.put(LONGVARCHAR, TypeMap.initializeJavaNative(LONGVARCHAR, "String"));
        _jdbcTypeToJavaNativeMap.put(CLOB, TypeMap.initializeJavaNative(CLOB, "String"));
        _jdbcTypeToJavaNativeMap.put(NUMERIC, TypeMap.initializeJavaNative(NUMERIC, TypeMap.getDefaultNumericJavaNativeType()));
        _jdbcTypeToJavaNativeMap.put(DECIMAL, TypeMap.initializeJavaNative(DECIMAL, TypeMap.getDefaultDecimalJavaNativeType()));
        _jdbcTypeToJavaNativeMap.put(BIT, TypeMap.initializeJavaNative(BIT, "Boolean"));
        _jdbcTypeToJavaNativeMap.put(BOOLEAN, TypeMap.initializeJavaNative(BOOLEAN, "Boolean"));
        _jdbcTypeToJavaNativeMap.put(TINYINT, TypeMap.initializeJavaNative(TINYINT, "Integer"));
        _jdbcTypeToJavaNativeMap.put(SMALLINT, TypeMap.initializeJavaNative(SMALLINT, "Integer"));
        _jdbcTypeToJavaNativeMap.put(INTEGER, TypeMap.initializeJavaNative(INTEGER, "Integer"));
        _jdbcTypeToJavaNativeMap.put(BIGINT, TypeMap.initializeJavaNative(BIGINT, BIGINT_NATIVE_TYPE));
        _jdbcTypeToJavaNativeMap.put(REAL, TypeMap.initializeJavaNative(REAL, "java.math.BigDecimal"));
        _jdbcTypeToJavaNativeMap.put(FLOAT, TypeMap.initializeJavaNative(FLOAT, "java.math.BigDecimal"));
        _jdbcTypeToJavaNativeMap.put(DOUBLE, TypeMap.initializeJavaNative(DOUBLE, "java.math.BigDecimal"));
        _jdbcTypeToJavaNativeMap.put(BINARY, TypeMap.initializeJavaNative(BINARY, "byte[]"));
        _jdbcTypeToJavaNativeMap.put(VARBINARY, TypeMap.initializeJavaNative(VARBINARY, "byte[]"));
        _jdbcTypeToJavaNativeMap.put(LONGVARBINARY, TypeMap.initializeJavaNative(LONGVARBINARY, "byte[]"));
        _jdbcTypeToJavaNativeMap.put(BLOB, TypeMap.initializeJavaNative(BLOB, "byte[]"));
        _jdbcTypeToJavaNativeMap.put(DATE, TypeMap.initializeJavaNative(DATE, DATE_NATIVE_TYPE));
        _jdbcTypeToJavaNativeMap.put(TIME, TypeMap.initializeJavaNative(TIME, TIME_NATIVE_TYPE));
        _jdbcTypeToJavaNativeMap.put(TIMESTAMP, TypeMap.initializeJavaNative(TIMESTAMP, TIMESTAMP_NATIVE_TYPE));
        _jdbcTypeToJavaNativeMap.put(ARRAY, TypeMap.initializeJavaNative(ARRAY, "String"));
        _jdbcTypeToJavaNativeMap.put(UUID, TypeMap.initializeJavaNative(UUID, UUID_NATIVE_TYPE));
        _jdbcTypeToJavaNativeMap.put(OTHER, TypeMap.initializeJavaNative(OTHER, OTHER_NATIVE_TYPE));
        Set<String> propertyJdbcTypeSet = _propertyJdbcTypeToJavaNativeMap.keySet();
        for (String propertyJdbcType : propertyJdbcTypeSet) {
            if (_jdbcTypeToJavaNativeMap.containsKey(propertyJdbcType)) continue;
            String propertyJavaNative = (String)_propertyJdbcTypeToJavaNativeMap.get(propertyJdbcType);
            _jdbcTypeToJavaNativeMap.put(propertyJdbcType, propertyJavaNative);
        }
        _jdbcDefValueToJdbcTypeMap.put(new Integer(1), CHAR);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(12), VARCHAR);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-1), LONGVARCHAR);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(2005), CLOB);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(2), NUMERIC);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(3), DECIMAL);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-7), BIT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(16), BOOLEAN);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-6), TINYINT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(5), SMALLINT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(4), INTEGER);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-5), BIGINT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(7), REAL);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(6), FLOAT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(8), DOUBLE);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-2), BINARY);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-3), VARBINARY);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-4), LONGVARBINARY);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(2004), BLOB);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(91), DATE);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(92), TIME);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(93), TIMESTAMP);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(2003), ARRAY);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(1111), OTHER);
        Set<Integer> keySet = _jdbcDefValueToJdbcTypeMap.keySet();
        for (Integer jdbcDefValue : keySet) {
            String jdbcType = _jdbcDefValueToJdbcTypeMap.get(jdbcDefValue);
            _jdbcTypeToJdbcDefValueMap.put(jdbcType, jdbcDefValue);
        }
        _javaNativeToFlexNativeMap.put("String", TypeMap.initializeFlexNative("String", "String"));
        _javaNativeToFlexNativeMap.put("Short", TypeMap.initializeFlexNative("Short", "int"));
        _javaNativeToFlexNativeMap.put("Integer", TypeMap.initializeFlexNative("Integer", "int"));
        _javaNativeToFlexNativeMap.put(BIGINT_NATIVE_TYPE, TypeMap.initializeFlexNative(BIGINT_NATIVE_TYPE, "Number"));
        _javaNativeToFlexNativeMap.put("Float", TypeMap.initializeFlexNative("Float", "Number"));
        _javaNativeToFlexNativeMap.put("Double", TypeMap.initializeFlexNative("Double", "Number"));
        _javaNativeToFlexNativeMap.put("Number", TypeMap.initializeFlexNative("Number", "Number"));
        _javaNativeToFlexNativeMap.put("java.math.BigDecimal", TypeMap.initializeFlexNative("java.math.BigDecimal", "Number"));
        _javaNativeToFlexNativeMap.put(DATE_NATIVE_TYPE, TypeMap.initializeFlexNative(DATE_NATIVE_TYPE, "Date"));
        _javaNativeToFlexNativeMap.put(TIME_NATIVE_TYPE, TypeMap.initializeFlexNative(TIME_NATIVE_TYPE, "Date"));
        _javaNativeToFlexNativeMap.put(TIMESTAMP_NATIVE_TYPE, TypeMap.initializeFlexNative(TIMESTAMP_NATIVE_TYPE, "Date"));
        _javaNativeToFlexNativeMap.put("byte[]", TypeMap.initializeFlexNative("byte[]", OTHER_NATIVE_TYPE));
        _javaNativeToFlexNativeMap.put(OTHER_NATIVE_TYPE, TypeMap.initializeFlexNative(OTHER_NATIVE_TYPE, OTHER_NATIVE_TYPE));
        _initialized = true;
    }

    protected static String initializeJavaNative(String jdbcType, String defaultJavaNative) {
        String javaNative = (String)_propertyJdbcTypeToJavaNativeMap.get(jdbcType);
        if (javaNative == null) {
            return defaultJavaNative;
        }
        return javaNative;
    }

    protected static String initializeFlexNative(String javaNative, String defaultFlexNative) {
        String flexNative = _propertyJavaNativeToFlexNativeMap.get(javaNative);
        if (flexNative == null) {
            return defaultFlexNative;
        }
        return flexNative;
    }

    protected static void initializeIfNeeds() {
        if (!_initialized) {
            TypeMap.initialize();
        }
    }

    public static String findJdbcTypeByJdbcDefValue(Integer jdbcDefValue) {
        TypeMap.initializeIfNeeds();
        String jdbcType = _jdbcDefValueToJdbcTypeMap.get(jdbcDefValue);
        if (Srl.is_Null_or_TrimmedEmpty((String)jdbcType)) {
            return null;
        }
        return jdbcType;
    }

    public static Integer getJdbcDefValueByJdbcType(String jdbcType) {
        TypeMap.initializeIfNeeds();
        Integer defValue = _jdbcTypeToJdbcDefValueMap.get(jdbcType);
        if (defValue == null) {
            return 1111;
        }
        return defValue;
    }

    public static boolean isJdbcTypeChar(String jdbcType) {
        return CHAR.equals(jdbcType);
    }

    public static boolean isJdbcTypeClob(String jdbcType) {
        return CLOB.equals(jdbcType);
    }

    public static boolean isJdbcTypeDate(String jdbcType) {
        return DATE.equals(jdbcType);
    }

    public static boolean isJdbcTypeTimestamp(String jdbcType) {
        return TIMESTAMP.equals(jdbcType);
    }

    public static boolean isJdbcTypeTime(String jdbcType) {
        return TIME.equals(jdbcType);
    }

    public static boolean isJdbcTypeBlob(String jdbcType) {
        return BLOB.equals(jdbcType);
    }

    public static String findJavaNativeByJdbcType(String jdbcType, Integer columnSize, Integer decimalDigits) {
        TypeMap.initializeIfNeeds();
        if (Srl.is_Null_or_TrimmedEmpty((String)jdbcType)) {
            throw new IllegalArgumentException("The argument 'jdbcType' should not be null!");
        }
        DfLittleAdjustmentProperties prop = DfBuildProperties.getInstance().getLittleAdjustmentProperties();
        String javaType = TypeMap.getJavaNative(jdbcType);
        if (TypeMap.isAutoMappingTargetType(jdbcType) && javaType.equalsIgnoreCase("$$AutoMapping$$")) {
            String defaultJavaNativeType = NUMERIC.equalsIgnoreCase(jdbcType) ? TypeMap.getDefaultNumericJavaNativeType() : TypeMap.getDefaultDecimalJavaNativeType();
            if (columnSize == null || columnSize == 0) {
                return defaultJavaNativeType;
            }
            if (decimalDigits != null && decimalDigits > 0) {
                return defaultJavaNativeType;
            }
            if (columnSize > 9) {
                if (columnSize > 18) {
                    if (prop.isCompatibleAutoMappingOldStyle()) {
                        return TypeMap.getJavaNative(BIGINT);
                    }
                    return defaultJavaNativeType;
                }
                return TypeMap.getJavaNative(BIGINT);
            }
            return TypeMap.getJavaNative(INTEGER);
        }
        return javaType;
    }

    public static String findFlexNativeByJavaNative(String javaNative) {
        return TypeMap.getFlexNative(javaNative);
    }

    protected static boolean isAutoMappingTargetType(String torqueType) {
        return NUMERIC.equals(torqueType) || DECIMAL.equals(torqueType);
    }

    protected static String getDefaultNumericJavaNativeType() {
        DfBuildProperties prop = DfBuildProperties.getInstance();
        DfBasicProperties basicProperties = prop.getBasicProperties();
        if (basicProperties.isTargetLanguageJava()) {
            return "java.math.BigDecimal";
        }
        DfLanguageDependencyInfo languageDependencyInfo = basicProperties.getLanguageDependencyInfo();
        LanguageMetaData languageMetaData = languageDependencyInfo.createLanguageMetaData();
        Map<String, Object> jdbcToJavaNativeMap = languageMetaData.getJdbcToJavaNativeMap();
        return (String)jdbcToJavaNativeMap.get(NUMERIC);
    }

    public static String getDefaultDecimalJavaNativeType() {
        DfBuildProperties prop = DfBuildProperties.getInstance();
        DfBasicProperties basicProperties = prop.getBasicProperties();
        if (basicProperties.isTargetLanguageJava()) {
            return "java.math.BigDecimal";
        }
        DfLanguageDependencyInfo languageDependencyInfo = basicProperties.getLanguageDependencyInfo();
        LanguageMetaData languageMetaData = languageDependencyInfo.createLanguageMetaData();
        Map<String, Object> jdbcToJavaNativeMap = languageMetaData.getJdbcToJavaNativeMap();
        return (String)jdbcToJavaNativeMap.get(DECIMAL);
    }

    protected static String getJavaNative(String jdbcType) {
        TypeMap.initializeIfNeeds();
        if (!_jdbcTypeToJavaNativeMap.containsKey(jdbcType)) {
            String msg = "_jdbcTypeToJavaNativeMap doesn't contain the type as key: ";
            msg = msg + "key=" + jdbcType + " map=" + _jdbcTypeToJavaNativeMap;
            _log.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
        return _jdbcTypeToJavaNativeMap.get(jdbcType);
    }

    protected static String getFlexNative(String javaNative) {
        TypeMap.initializeIfNeeds();
        if (!_javaNativeToFlexNativeMap.containsKey(javaNative)) {
            String msg = "_javaNativeToFlexNativeMap doesn't contain the type as key: ";
            msg = msg + "key=" + javaNative + " map=" + _javaNativeToFlexNativeMap;
            _log.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
        return _javaNativeToFlexNativeMap.get(javaNative);
    }

    static {
        TypeMap.setupPropertyNativeMap();
        _initialized = false;
    }
}

