/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.io.File;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.apache.velocity.texen.util.FileUtil;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.config.DfDatabaseNameMapping;
import org.seasar.dbflute.exception.DfColumnNotFoundException;
import org.seasar.dbflute.exception.DfTableNotFoundException;
import org.seasar.dbflute.friends.velocity.DfGenerator;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.context.DfDataSourceContext;
import org.seasar.dbflute.logic.doc.historyhtml.DfSchemaHistory;
import org.seasar.dbflute.logic.generate.deletefile.DfOldClassHandler;
import org.seasar.dbflute.logic.generate.exmange.DfCopyrightResolver;
import org.seasar.dbflute.logic.generate.exmange.DfSerialVersionUIDResolver;
import org.seasar.dbflute.logic.generate.packagepath.DfPackagePathHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfProcedureHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfSchemaDiff;
import org.seasar.dbflute.logic.sql2entity.bqp.DfBehaviorQueryPathSetupper;
import org.seasar.dbflute.logic.sql2entity.outsidesql.DfSqlFileCollector;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbBasicHandler;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbMetaData;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfBuriProperties;
import org.seasar.dbflute.properties.DfClassificationProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfSequenceIdentityProperties;
import org.seasar.dbflute.properties.assistant.DfTableFinder;
import org.seasar.dbflute.properties.assistant.commoncolumn.CommonColumnSetupResource;
import org.seasar.dbflute.properties.initializer.DfAdditionalForeignKeyInitializer;
import org.seasar.dbflute.properties.initializer.DfAdditionalPrimaryKeyInitializer;
import org.seasar.dbflute.properties.initializer.DfAdditionalUniqueKeyInitializer;
import org.seasar.dbflute.properties.initializer.DfIncludeQueryInitializer;
import org.seasar.dbflute.util.Srl;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private static final Log _log = LogFactory.getLog(Database.class);
    protected Integer _version;
    protected String _name;
    protected AppData _appData;
    protected AppData _sql2entitySchemaData;
    protected List<Table> _tableList = new ArrayList<Table>(100);
    protected StringKeyMap<Table> _tableMap = StringKeyMap.createAsFlexibleOrdered();
    protected Map<String, DfPmbMetaData> _pmbMetaDataMap;
    protected DfSchemaHistory _schemaHistory;
    protected String _databaseType;
    protected String _defaultJavaNamingMethod;
    protected boolean _skipDeleteOldClass;
    protected DfPmbBasicHandler _pmbBasicHandler;
    protected Map<String, Map<String, Map<String, String>>> _tableBqpMap;
    protected List<DfProcedureMetaInfo> _procedureMetaInfoList;

    public void initializeVersion(Integer version) {
        DfBuildProperties.getInstance().setVersion(version);
    }

    public void loadFromXML(Attributes attrib) {
        this.setName(attrib.getValue("name"));
        this._defaultJavaNamingMethod = attrib.getValue("defaultJavaNamingMethod");
        if (this._defaultJavaNamingMethod == null) {
            this._defaultJavaNamingMethod = "underscore";
        }
    }

    public Table[] getTables() {
        int size = this._tableList.size();
        Table[] tbls = new Table[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = this._tableList.get(i);
        }
        return tbls;
    }

    public List<Table> getTableList() {
        Table[] tables;
        ArrayList<Table> ls = new ArrayList<Table>();
        for (Table table : tables = this.getTables()) {
            ls.add(table);
        }
        return ls;
    }

    public List<Table> getTableDisplaySortedList() {
        Comparator<Table> tableDisplayOrderBy = this.getProperties().getDocumentProperties().getTableDisplayOrderBy();
        TreeSet<Table> tableSet = new TreeSet<Table>(tableDisplayOrderBy);
        tableSet.addAll(this.getTableList());
        return new ArrayList<Table>(tableSet);
    }

    public Table getTable(String name) {
        return (Table)this._tableMap.get((Object)name);
    }

    public Table addTable(Attributes attrib) {
        Table tbl = new Table();
        tbl.setDatabase(this);
        tbl.loadFromXML(attrib);
        this.addTable(tbl);
        return tbl;
    }

    public void addTable(Table tbl) {
        tbl.setDatabase(this);
        this._tableList.add(tbl);
        this._tableMap.put(tbl.getName(), (Object)tbl);
    }

    public void doFinalInitialization() throws EngineException {
        Table[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            Table currTable = tables[i];
            currTable.doFinalInitialization();
            ForeignKey[] fks = currTable.getForeignKeys();
            for (int j = 0; j < fks.length; ++j) {
                ForeignKey currFK = fks[j];
                String foreignTableName = currFK.getForeignTableName();
                Table foreignTable = this.getTable(foreignTableName);
                if (foreignTable == null) {
                    String msg = "Not found the table:";
                    msg = msg + " fk=" + currFK.getName() + " foreignTableName=" + foreignTableName;
                    throw new DfTableNotFoundException(msg);
                }
                List<ForeignKey> refererList = foreignTable.getRefererList();
                if (refererList == null || !refererList.contains(currFK)) {
                    foreignTable.addReferrer(currFK);
                }
                for (String localColumnName : currFK.getLocalColumns()) {
                    Column local = currTable.getColumn(localColumnName);
                    if (local == null) {
                        String msg = "Not found the column in the table:";
                        msg = msg + " fk=" + currFK.getName() + " foreignTableName=" + foreignTableName;
                        msg = msg + " table=" + currTable + " localColumn=" + localColumnName;
                        throw new DfColumnNotFoundException(msg);
                    }
                    if (!local.isPrimaryKey()) continue;
                    currTable.setContainsForeignPK(true);
                }
                for (String foreignColumnName : currFK.getForeignColumns()) {
                    Column foreign = foreignTable.getColumn(foreignColumnName);
                    if (foreign == null) {
                        String msg = "Not found the column in the table:";
                        msg = msg + " fk=" + currFK.getName() + " foreignTableName=" + foreignTableName;
                        msg = msg + " table=" + currTable + " foreignColumn=" + foreignColumnName;
                        throw new DfColumnNotFoundException(msg);
                    }
                    foreign.addReferrer(currFK);
                }
            }
        }
    }

    protected DfPmbBasicHandler getPmbBasicHandler() {
        if (this._pmbBasicHandler != null) {
            return this._pmbBasicHandler;
        }
        DfBasicProperties basicProp = this.getBasicProperties();
        DfClassificationProperties classificationProp = this.getClassificationProperties();
        this._pmbBasicHandler = new DfPmbBasicHandler(this._pmbMetaDataMap, basicProp, classificationProp);
        return this._pmbBasicHandler;
    }

    public boolean isExistPmbMetaData() {
        return this.getPmbBasicHandler().isExistPmbMetaData();
    }

    public Collection<DfPmbMetaData> getPmbMetaDataList() {
        return this.getPmbBasicHandler().getPmbMetaDataList();
    }

    public String getPmbMetaDataSuperClassDefinition(String className) {
        return this.getPmbBasicHandler().getSuperClassDefinition(className);
    }

    public boolean hasPmbMetaDataCheckSafetyResult(String className) {
        return this.getPmbBasicHandler().hasPmbMetaDataCheckSafetyResult(className);
    }

    public Set<String> getPmbMetaDataPropertySet(String className) {
        return this.getPmbBasicHandler().getPropertySet(className);
    }

    public String getPmbMetaDataPropertyType(String className, String propertyName) {
        return this.getPmbBasicHandler().getPropertyType(className, propertyName);
    }

    public String getPmbMetaDataPropertyColumnName(String className, String propertyName) {
        return this.getPmbBasicHandler().getPropertyColumnName(className, propertyName);
    }

    public String getPmbMetaDataPropertyTypeRemovedCSharpNullable(String className, String propertyName) {
        return this.getPmbBasicHandler().getPropertyTypeRemovedCSharpNullable(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyJavaNativeStringObject(String className, String propertyName) {
        return this.getPmbBasicHandler().isPmbMetaDataPropertyJavaNativeStringObject(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyJavaNativeNumberObject(String className, String propertyName) {
        return this.getPmbBasicHandler().isPmbMetaDataPropertyJavaNativeNumberObject(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyJavaNativeBooleanObject(String className, String propertyName) {
        return this.getPmbBasicHandler().isPmbMetaDataPropertyJavaNativeBooleanObject(className, propertyName);
    }

    public boolean isPmbMetaDataForProcedure(String className) {
        return this.getPmbBasicHandler().isForProcedure(className);
    }

    public String getPmbMetaDataProcedureName(String className) {
        return this.getPmbBasicHandler().getProcedureName(className);
    }

    public boolean isPmbMetaDataProcedureCalledBySelect(String className) {
        return this.getPmbBasicHandler().isProcedureCalledBySelect(className);
    }

    public boolean isPmbMetaDataRefCustomizeEntity(String className) {
        return this.getPmbBasicHandler().isRefCustomizeEntity(className);
    }

    public boolean hasPmbMetaDataProcedureOverload(String className) {
        return this.getPmbBasicHandler().hasProcedureOverload(className);
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterIn(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionProcedureParameterIn(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterOut(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionProcedureParameterOut(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterInOut(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionProcedureParameterInOut(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterReturn(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionProcedureParameterReturn(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterResult(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionProcedureParameterResult(className, propertyName);
    }

    public boolean needsPmbMetaDataProcedureParameterStringClobHandling(String className, String propertyName) {
        return this.getPmbBasicHandler().needsStringClobHandling(className, propertyName);
    }

    public boolean needsPmbMetaDataProcedureParameterBytesOidHandling(String className, String propertyName) {
        return this.getPmbBasicHandler().needsBytesOidHandling(className, propertyName);
    }

    public boolean needsPmbMetaDataProcedureParameterFixedLengthStringHandling(String className, String propertyName) {
        return this.getPmbBasicHandler().needsFixedLengthStringHandling(className, propertyName);
    }

    public boolean needsPmbMetaDataProcedureParameterObjectBindingBigDecimalHandling(String className, String propertyName) {
        return this.getPmbBasicHandler().needsObjectBindingBigDecimalHandling(className, propertyName);
    }

    public boolean needsPmbMetaDataProcedureParameterOracleArrayHandling(String className, String propertyName) {
        return this.getPmbBasicHandler().needsOracleArrayHandling(className, propertyName);
    }

    public boolean needsPmbMetaDataProcedureParameterOracleStructHandling(String className, String propertyName) {
        return this.getPmbBasicHandler().needsOracleStructHandling(className, propertyName);
    }

    public String getPmbMetaDataProcedureParameterOracleArrayTypeName(String className, String propertyName) {
        return this.getPmbBasicHandler().getProcedureParameterOracleArrayTypeName(className, propertyName);
    }

    public String getPmbMetaDataProcedureParameterOracleArrayElementJavaNative(String className, String propertyName) {
        return this.getPmbBasicHandler().getProcedureParameterOracleArrayElementJavaNative(className, propertyName);
    }

    public String getPmbMetaDataProcedureParameterOracleArrayElementJavaNativeTypeLiteral(String className, String propertyName) {
        return this.getPmbBasicHandler().getProcedureParameterOracleArrayElementJavaNativeTypeLiteral(className, propertyName);
    }

    public String getPmbMetaDataProcedureParameterOracleStructTypeName(String className, String propertyName) {
        return this.getPmbBasicHandler().getProcedureParameterOracleStructTypeName(className, propertyName);
    }

    public String getPmbMetaDataProcedureParameterOracleStructEntityType(String className, String propertyName) {
        return this.getPmbBasicHandler().getProcedureParameterOracleStructEntityType(className, propertyName);
    }

    public String getPmbMetaDataProcedureParameterOracleStructEntityTypeTypeLiteral(String className, String propertyName) {
        return this.getPmbBasicHandler().getProcedureParameterOracleStructEntityTypeTypeLiteral(className, propertyName);
    }

    public boolean hasPmbMetaDataPropertyOptionOriginalOnlyOneSetter(String className, String propertyName) {
        return this.getPmbBasicHandler().hasPropertyOptionOriginalOnlyOneSetter(className, propertyName);
    }

    public boolean hasPmbMetaDataPropertyOptionAnyLikeSearch(String className) {
        return this.getPmbBasicHandler().hasPropertyOptionAnyLikeSearch(className);
    }

    public boolean hasPmbMetaDataPropertyOptionAnyLikeSearch(String className, String propertyName) {
        return this.getPmbBasicHandler().hasPropertyOptionAnyLikeSearch(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionLikeSearch(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionLikeSearch(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionPrefixSearch(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionPrefixSearch(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionContainSearch(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionContainSearch(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionSuffixSearch(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionSuffixSearch(className, propertyName);
    }

    public boolean hasPmbMetaDataPropertyOptionAnyFromTo(String className) {
        return this.getPmbBasicHandler().hasPropertyOptionAnyFromTo(className);
    }

    public boolean hasPmbMetaDataPropertyOptionAnyFromTo(String className, String propertyName) {
        return this.getPmbBasicHandler().hasPropertyOptionAnyFromTo(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionFromDate(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionFromDate(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionToDate(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionToDate(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionClassification(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyOptionClassification(className, propertyName, this._sql2entitySchemaData);
    }

    public String getPmbMetaDataPropertyOptionClassificationName(String className, String propertyName) {
        return this.getPmbBasicHandler().getPropertyOptionClassificationName(className, propertyName, this._sql2entitySchemaData);
    }

    protected String getPmbMetaDataPropertyOptionClassificationCodeType(String className, String propertyName) {
        return this.getPmbBasicHandler().getPropertyOptionClassificationName(className, propertyName, this._sql2entitySchemaData);
    }

    public List<Map<String, String>> getPmbMetaDataPropertyOptionClassificationMapList(String className, String propertyName) {
        return this.getPmbBasicHandler().getPropertyOptionClassificationMapList(className, propertyName, this._sql2entitySchemaData);
    }

    public String getPmbMetaDataPropertyRefColumnInfo(String className, String propertyName) {
        try {
            DfPmbBasicHandler handler = this.getPmbBasicHandler();
            return handler.getPropertyRefColumnInfo(className, propertyName, this._sql2entitySchemaData);
        }
        catch (RuntimeException e) {
            String msg = "Failed to get ref-column info:";
            msg = msg + " " + className + "." + propertyName;
            _log.debug((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public boolean isPmbMetaDataPropertyRefColumnChar(String className, String propertyName) {
        return this.getPmbBasicHandler().isPropertyRefColumnChar(className, propertyName, this._sql2entitySchemaData);
    }

    public String getPmbMetaDataPropertyRefSize(String className, String propertyName) {
        return this.getPmbBasicHandler().getPropertyRefSize(className, propertyName, this._sql2entitySchemaData);
    }

    public void initializeAdditionalPrimaryKey() {
        DfAdditionalPrimaryKeyInitializer initializer = new DfAdditionalPrimaryKeyInitializer(this);
        initializer.initializeAdditionalPrimaryKey();
    }

    public void initializeAdditionalUniqueKey() {
        DfAdditionalUniqueKeyInitializer initializer = new DfAdditionalUniqueKeyInitializer(this);
        initializer.initializeAdditionalUniqueKey();
    }

    public void initializeAdditionalForeignKey() {
        DfBuriProperties buriProperties = this.getProperties().getBuriProperties();
        buriProperties.setupImplicitAdditionalForeignKey(new DfTableFinder(){

            public Table findTable(String tableName) {
                return Database.this.getTable(tableName);
            }
        });
        DfAdditionalForeignKeyInitializer initializer = new DfAdditionalForeignKeyInitializer(this);
        initializer.initializeAdditionalForeignKey();
    }

    public void initializeClassificationDeployment() {
        DfClassificationProperties clsProp = this.getClassificationProperties();
        clsProp.initializeClassificationDefinition();
        clsProp.initializeClassificationDeployment(this);
        if (this._sql2entitySchemaData != null) {
            try {
                clsProp.initializeClassificationDeployment(this._sql2entitySchemaData.getDatabase());
            }
            catch (EngineException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }
    }

    public void initializeIncludeQuery() {
        DfIncludeQueryInitializer initializer = new DfIncludeQueryInitializer();
        initializer.setIncludeQueryProperties(this.getProperties().getIncludeQueryProperties());
        initializer.setTableFinder(new DfTableFinder(){

            public Table findTable(String name) {
                return Database.this.getTable(name);
            }
        });
        initializer.initializeIncludeQuery();
    }

    public void checkProperties() {
        this.getProperties().getSequenceIdentityProperties().checkSequenceDefinitionMap(new DfSequenceIdentityProperties.SequenceDefinitionMapChecker(){

            public boolean hasTable(String tableName) {
                return Database.this.getTable(tableName) != null;
            }
        });
        this.getProperties().getBasicProperties().checkDirectoryPackage();
    }

    public void deleteOldTableClass() {
        if (this._skipDeleteOldClass) {
            return;
        }
        if (this.getProperties().getLittleAdjustmentProperties().isDeleteOldTableClass()) {
            DfOldClassHandler handler = this.createOldClassHandler();
            handler.deleteOldTableClass();
        }
    }

    public void deleteOldCustomizeClass() {
        if (this._skipDeleteOldClass) {
            return;
        }
        if (this.getProperties().getLittleAdjustmentProperties().isDeleteOldTableClass()) {
            DfOldClassHandler handler = this.createOldClassHandler();
            handler.setPmbMetaDataMap(this._pmbMetaDataMap);
            handler.deleteOldCustomizeClass();
        }
    }

    protected DfOldClassHandler createOldClassHandler() {
        return new DfOldClassHandler(this.getGeneratorInstance(), this.getBasicProperties(), this.getProperties().getLittleAdjustmentProperties(), this.getTableList());
    }

    public void enableGenerateOutputDirectory() {
        String outputDirectory = this.getProperties().getBasicProperties().getGenerateOutputDirectory();
        _log.info((Object)("...Setting up generateOutputDirectory: " + outputDirectory));
        this.getGeneratorInstance().setOutputPath(outputDirectory);
    }

    public void enableSql2EntityOutputDirectory() {
        String outputDirectory = this.getProperties().getOutsideSqlProperties().getSql2EntityOutputDirectory();
        _log.info((Object)("...Setting up sql2EntityOutputDirectory: " + outputDirectory));
        this.getGeneratorInstance().setOutputPath(outputDirectory);
    }

    public void enableDocumentOutputDirectory() {
        String outputDirectory = this.getProperties().getDocumentProperties().getDocumentOutputDirectory();
        _log.info((Object)("...Setting up documentOutputDirectory: " + outputDirectory));
        File dir = new File(outputDirectory);
        if (!dir.exists()) {
            _log.info((Object)("...Making directories for documentOutputDirectory: " + dir));
            dir.mkdirs();
        }
        this.getGeneratorInstance().setOutputPath(outputDirectory);
    }

    public void enableFlexDtoOutputDirectory() {
        String outputDirectory = this.getProperties().getFlexDtoProperties().getOutputDirectory();
        _log.info((Object)("...Setting up flexDtoOutputDirectory: " + outputDirectory));
        this.getGeneratorInstance().setOutputPath(outputDirectory);
    }

    public DfGenerator getGeneratorInstance() {
        return DfGenerator.getInstance();
    }

    public String getDefaultDBDef() {
        return this.getBasicProperties().getCurrentDBDef().code();
    }

    public String getGenerateDbName() {
        return DfDatabaseNameMapping.getInstance().findGenerateName(this.getDatabaseType());
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    public String getProjectName() {
        return this.getBasicProperties().getProjectName();
    }

    public String getDatabaseName() {
        return this.getBasicProperties().getDatabaseType();
    }

    public boolean isDatabaseMySQL() {
        return this.getBasicProperties().isDatabaseMySQL();
    }

    public boolean isDatabasePostgreSQL() {
        return this.getBasicProperties().isDatabasePostgreSQL();
    }

    public boolean isDatabaseOracle() {
        return this.getBasicProperties().isDatabaseOracle();
    }

    public boolean isDatabaseDB2() {
        return this.getBasicProperties().isDatabaseDB2();
    }

    public boolean isDatabaseSQLServer() {
        return this.getBasicProperties().isDatabaseSQLServer();
    }

    public boolean isDatabaseDerby() {
        return this.getBasicProperties().isDatabaseDerby();
    }

    public boolean isDatabaseH2() {
        return this.getBasicProperties().isDatabaseH2();
    }

    public boolean isDatabaseMSAccess() {
        return this.getBasicProperties().isDatabaseMSAccess();
    }

    public String getTargetLanguage() {
        return this.getBasicProperties().getTargetLanguage();
    }

    public String getResourceDirectory() {
        return this.getBasicProperties().getResourceDirectory();
    }

    public String getTargetLanguageInitCap() {
        String targetLanguage = this.getBasicProperties().getTargetLanguage();
        return targetLanguage.substring(0, 1).toUpperCase() + targetLanguage.substring(1);
    }

    public boolean isTargetLanguageJava() {
        return this.getBasicProperties().isTargetLanguageJava();
    }

    public boolean isTargetLanguageCSharp() {
        return this.getBasicProperties().isTargetLanguageCSharp();
    }

    public boolean isTargetLanguagePhp() {
        return this.getBasicProperties().isTargetLanguagePhp();
    }

    public boolean isJavaVersionGreaterEqualTiger() {
        return this.getBasicProperties().isJavaVersionGreaterEqualTiger();
    }

    public boolean isJavaVersionGreaterEqualMustang() {
        return this.getBasicProperties().isJavaVersionGreaterEqualMustang();
    }

    public String getTargetContainerName() {
        return this.getBasicProperties().getTargetContainerName();
    }

    public boolean isTargetContainerSeasar() {
        return this.getBasicProperties().isTargetContainerSeasar();
    }

    public boolean isTargetContainerSpring() {
        return this.getBasicProperties().isTargetContainerSpring();
    }

    public boolean isTargetContainerLucy() {
        return this.getBasicProperties().isTargetContainerLucy();
    }

    public boolean isTargetContainerGuice() {
        return this.getBasicProperties().isTargetContainerGuice();
    }

    public boolean isTargetContainerSlim3() {
        return this.getBasicProperties().isTargetContainerSlim3();
    }

    public String getTemplateFileExtension() {
        return this.getBasicProperties().getTemplateFileExtension();
    }

    public String getClassFileExtension() {
        return this.getBasicProperties().getClassFileExtension();
    }

    public String getTemplateFileEncoding() {
        return this.getBasicProperties().getTemplateFileEncoding();
    }

    public String getJavaDir() {
        return this.getBasicProperties().getGenerateOutputDirectory();
    }

    public String getClassAuthor() {
        return this.getBasicProperties().getClassAuthor();
    }

    public String getAllClassCopyright() {
        return this.getProperties().getAllClassCopyrightProperties().getAllClassCopyright();
    }

    public void reflectAllExCopyright(String path) {
        String outputPath = DfGenerator.getInstance().getOutputPath();
        String absolutePath = outputPath + "/" + path;
        String sourceCodeEncoding = this.getTemplateFileEncoding();
        String sourceCodeLn = this.getBasicProperties().getSourceCodeLineSeparator();
        DfCopyrightResolver resolver = new DfCopyrightResolver(sourceCodeEncoding, sourceCodeLn);
        String copyright = this.getProperties().getAllClassCopyrightProperties().getAllClassCopyright();
        resolver.reflectAllExCopyright(absolutePath, copyright);
    }

    public String getProjectPrefix() {
        return this.getBasicProperties().getProjectPrefix();
    }

    public String getBasePrefix() {
        return this.getBasicProperties().getBasePrefix();
    }

    public String getBaseSuffixForEntity() {
        return "";
    }

    public String getPackageBase() {
        return this.getProperties().getBasicProperties().getPackageBase();
    }

    public String getBaseCommonPackage() {
        return this.getProperties().getBasicProperties().getBaseCommonPackage();
    }

    public String getBaseBehaviorPackage() {
        return this.getProperties().getBasicProperties().getBaseBehaviorPackage();
    }

    public String getBaseDaoPackage() {
        return this.getProperties().getBasicProperties().getBaseDaoPackage();
    }

    public String getBaseEntityPackage() {
        return this.getProperties().getBasicProperties().getBaseEntityPackage();
    }

    public String getDBMetaPackage() {
        return this.getProperties().getBasicProperties().getDBMetaPackage();
    }

    public String getConditionBeanPackage() {
        return this.getProperties().getBasicProperties().getConditionBeanPackage();
    }

    public String getExtendedConditionBeanPackage() {
        return this.getProperties().getBasicProperties().getExtendedConditionBeanPackage();
    }

    public String getExtendedBehaviorPackage() {
        return this.getProperties().getBasicProperties().getExtendedBehaviorPackage();
    }

    public String getExtendedDaoPackage() {
        return this.getProperties().getBasicProperties().getExtendedDaoPackage();
    }

    public String getExtendedEntityPackage() {
        return this.getProperties().getBasicProperties().getExtendedEntityPackage();
    }

    public String getLibraryAllCommonPackage() {
        return this.getBasicProperties().getLibraryAllCommonPackage();
    }

    public String getLibraryBehaviorPackage() {
        return this.getBasicProperties().getLibraryBehaviorPackage();
    }

    public String getLibraryProjectPrefix() {
        return this.getBasicProperties().getLibraryProjectPrefix();
    }

    public String getApplicationAllCommonPackage() {
        return this.getBasicProperties().getApplicationAllCommonPackage();
    }

    public boolean isFlatDirectoryPackageValid() {
        return this.getProperties().getBasicProperties().isFlatDirectoryPackageValid();
    }

    public String getFlatDirectoryPackage() {
        return this.getProperties().getBasicProperties().getFlatDirectoryPackage();
    }

    public boolean isOmitDirectoryPackageValid() {
        return this.getProperties().getBasicProperties().isOmitDirectoryPackageValid();
    }

    public String getOmitDirectoryPackage() {
        return this.getProperties().getBasicProperties().getOmitDirectoryPackage();
    }

    public boolean isAvailableHotDeploy() {
        return this.getBasicProperties().isAvailableHotDeploy();
    }

    public String getBehaviorQueryPathBeginMark() {
        return this.getBasicProperties().getBehaviorQueryPathBeginMark();
    }

    public String getBehaviorQueryPathEndMark() {
        return this.getBasicProperties().getBehaviorQueryPathEndMark();
    }

    public void reflectAllExSerialVersionUID(String path) {
        String outputPath = DfGenerator.getInstance().getOutputPath();
        String absolutePath = outputPath + "/" + path;
        String sourceCodeEncoding = this.getTemplateFileEncoding();
        String sourceCodeLn = this.getBasicProperties().getSourceCodeLineSeparator();
        DfSerialVersionUIDResolver resolver = new DfSerialVersionUIDResolver(sourceCodeEncoding, sourceCodeLn);
        resolver.reflectAllExSerialUID(absolutePath);
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return this.getProperties().getDatabaseProperties();
    }

    public UnifiedSchema getDatabaseSchema() {
        return this.getDatabaseProperties().getDatabaseSchema();
    }

    public boolean hasDatabaseSchema() {
        return this.getDatabaseSchema().hasSchema();
    }

    public boolean hasAdditionalSchema() {
        return this.getDatabaseProperties().hasAdditionalSchema();
    }

    public boolean hasCatalogAdditionalSchema() {
        return this.getDatabaseProperties().hasCatalogAdditionalSchema();
    }

    public String getDBFluteDiconNamespace() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteDiconNamespace();
    }

    public List<String> getDBFluteDiconPackageNameList() {
        String resourceOutputDirectory = this.getBasicProperties().getResourceOutputDirectory();
        if (resourceOutputDirectory != null) {
            ArrayList<String> resulList = new ArrayList<String>();
            resulList.add(resourceOutputDirectory);
            return resulList;
        }
        List<String> diconPackageNameList = this.getProperties().getDependencyInjectionProperties().getDBFluteDiconPackageNameList();
        if (diconPackageNameList != null && !diconPackageNameList.isEmpty()) {
            return diconPackageNameList;
        }
        ArrayList<String> resulList = new ArrayList<String>();
        resulList.add(this.getBasicProperties().getDefaultResourceOutputDirectory());
        return resulList;
    }

    public String getDBFluteCreatorDiconFileName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteCreatorDiconFileName();
    }

    public String getDBFluteCustomizerDiconFileName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteCustomizerDiconFileName();
    }

    public String getDBFluteDiconFileName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteDiconFileName();
    }

    public String getJ2eeDiconResourceName() {
        return this.getProperties().getDependencyInjectionProperties().getJ2eeDiconResourceName();
    }

    public List<String> getDBFluteDiconBeforeJ2eeIncludePathList() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteDiconBeforeJ2eeIncludePathList();
    }

    public List<String> getDBFluteDiconOtherIncludePathList() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteDiconOtherIncludePathList();
    }

    public String filterDBFluteDiconBhvAp(String filePath) {
        if (filePath.endsWith(".dicon")) {
            filePath = Srl.replace((String)filePath, (String)".dicon", (String)"++.dicon");
        }
        return filePath;
    }

    public List<String> getDBFluteBeansPackageNameList() {
        String resourceOutputDirectory = this.getBasicProperties().getResourceOutputDirectory();
        if (resourceOutputDirectory != null) {
            ArrayList<String> resulList = new ArrayList<String>();
            resulList.add(resourceOutputDirectory);
            return resulList;
        }
        List<String> diconPackageNameList = this.getProperties().getDependencyInjectionProperties().getDBFluteBeansPackageNameList();
        if (diconPackageNameList != null && !diconPackageNameList.isEmpty()) {
            return diconPackageNameList;
        }
        ArrayList<String> resulList = new ArrayList<String>();
        resulList.add(this.getBasicProperties().getDefaultResourceOutputDirectory());
        return resulList;
    }

    public String getDBFluteBeansFileName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteBeansFileName();
    }

    public String getDBFluteBeansDataSourceName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteBeansDataSourceName();
    }

    public String filterDBFluteBeansBhvAp(String filePath) {
        if (filePath.endsWith(".xml")) {
            filePath = Srl.replace((String)filePath, (String)".xml", (String)"BhvAp.xml");
        }
        return filePath;
    }

    public String getDBFluteModuleBhvApClassName() {
        return this.getProjectPrefix() + "DBFluteModuleBhvAp";
    }

    public String filterDBFluteModuleBhvAp(String filePath) {
        if (filePath.endsWith(".java")) {
            filePath = Srl.replace((String)filePath, (String)".java", (String)"BhvAp.java");
        }
        return filePath;
    }

    public boolean isQuillDataSourceNameValid() {
        return this.getProperties().getDependencyInjectionProperties().isQuillDataSourceNameValid();
    }

    public String getQuillDataSourceName() {
        return this.getProperties().getDependencyInjectionProperties().getQuillDataSourceName();
    }

    public String getSequenceReturnType() {
        return this.getProperties().getSequenceIdentityProperties().getSequenceReturnType();
    }

    public Map<String, String> getCommonColumnMap() {
        return this.getProperties().getCommonColumnProperties().getCommonColumnMap();
    }

    public List<String> getCommonColumnNameList() {
        return this.getProperties().getCommonColumnProperties().getCommonColumnNameList();
    }

    public List<String> getCommonColumnNameConversionList() {
        return this.getProperties().getCommonColumnProperties().getCommonColumnNameConversionList();
    }

    public String filterCommonColumn(String commonColumnName) {
        return this.getProperties().getCommonColumnProperties().filterCommonColumn(commonColumnName);
    }

    public boolean hasCommonColumn() {
        return !this.getProperties().getCommonColumnProperties().getCommonColumnNameList().isEmpty();
    }

    public boolean isExistCommonColumnSetupElement() {
        return this.getProperties().getCommonColumnProperties().isExistCommonColumnSetupElement();
    }

    public boolean hasCommonColumnConvertion(String commonColumnName) {
        return this.getProperties().getCommonColumnProperties().isCommonColumnConversion(commonColumnName);
    }

    public Map<String, Object> getCommonColumnSetupBeforeInsertInterceptorLogicMap() {
        return this.getProperties().getCommonColumnProperties().getBeforeInsertMap();
    }

    public boolean containsValidColumnNameKeyCommonColumnSetupBeforeInsertInterceptorLogicMap(String columnName) {
        return this.getProperties().getCommonColumnProperties().containsValidColumnNameKeyCommonColumnSetupBeforeInsertInterceptorLogicMap(columnName);
    }

    public String getCommonColumnSetupBeforeInsertInterceptorLogicByColumnName(String columnName) {
        return this.getProperties().getCommonColumnProperties().getCommonColumnSetupBeforeInsertInterceptorLogicByColumnName(columnName);
    }

    public Map<String, Object> getCommonColumnSetupBeforeUpdateInterceptorLogicMap() {
        return this.getProperties().getCommonColumnProperties().getBeforeUpdateMap();
    }

    public boolean containsValidColumnNameKeyCommonColumnSetupBeforeUpdateInterceptorLogicMap(String columnName) {
        return this.getProperties().getCommonColumnProperties().containsValidColumnNameKeyCommonColumnSetupBeforeUpdateInterceptorLogicMap(columnName);
    }

    public String getCommonColumnSetupBeforeUpdateInterceptorLogicByColumnName(String columnName) {
        return this.getProperties().getCommonColumnProperties().getCommonColumnSetupBeforeUpdateInterceptorLogicByColumnName(columnName);
    }

    public boolean hasCommonColumnSetupResource() {
        return this.getProperties().getCommonColumnProperties().hasCommonColumnSetupResource();
    }

    public List<CommonColumnSetupResource> getCommonColumnSetupResourceList() {
        return this.getProperties().getCommonColumnProperties().getCommonColumnSetupResourceList();
    }

    public boolean isCommonColumnSetupInvokingLogic(String logic) {
        return this.getProperties().getCommonColumnProperties().isCommonColumnSetupInvokingLogic(logic);
    }

    public String removeCommonColumnSetupInvokingMark(String logic) {
        return this.getProperties().getCommonColumnProperties().removeCommonColumnSetupInvokingMark(logic);
    }

    public DfClassificationProperties getClassificationProperties() {
        return this.getProperties().getClassificationProperties();
    }

    public Map<String, Map<String, String>> getClassificationTopDefinitionMap() {
        return this.getClassificationProperties().getClassificationTopDefinitionMap();
    }

    public boolean hasClassificationDefinitionMap() {
        return this.getClassificationProperties().hasClassificationDefinitionMap();
    }

    public Map<String, List<Map<String, String>>> getClassificationDefinitionMap() {
        return this.getClassificationProperties().getClassificationDefinitionMap();
    }

    public List<String> getClassificationNameList() {
        return this.getClassificationProperties().getClassificationNameList();
    }

    public String getClassificationDefinitionMapAsStringRemovedLineSeparatorFilteredQuotation() {
        return this.getClassificationProperties().getClassificationDefinitionMapAsStringRemovedLineSeparatorFilteredQuotation();
    }

    public List<Map<String, String>> getClassificationMapList(String classificationName) {
        return this.getClassificationProperties().getClassificationMapList(classificationName);
    }

    public String buildClassificationApplicationComment(Map<String, String> classificationMap) {
        return this.getClassificationProperties().buildClassificationApplicationComment(classificationMap);
    }

    public String buildClassificationCodeAliasVariables(Map<String, String> classificationMap) {
        return this.getClassificationProperties().buildClassificationCodeAliasVariables(classificationMap);
    }

    public String buildClassificationCodeNameAliasVariables(Map<String, String> classificationMap) {
        return this.getClassificationProperties().buildClassificationCodeNameAliasVariables(classificationMap);
    }

    public boolean isTableClassification(String classificationName) {
        return this.getClassificationProperties().isTableClassification(classificationName);
    }

    public Map<String, Map<String, String>> getClassificationDeploymentMap() {
        return this.getClassificationProperties().getClassificationDeploymentMap();
    }

    public String getClassificationDeploymentMapAsStringRemovedLineSeparatorFilteredQuotation() {
        return this.getClassificationProperties().getClassificationDeploymentMapAsStringRemovedLineSeparatorFilteredQuotation();
    }

    public boolean hasClassification(String tableName, String columnName) {
        return this.getClassificationProperties().hasClassification(tableName, columnName);
    }

    public String getClassificationName(String tableName, String columnName) {
        return this.getClassificationProperties().getClassificationName(tableName, columnName);
    }

    public boolean hasClassificationName(String tableName, String columnName) {
        return this.getClassificationProperties().hasClassificationName(tableName, columnName);
    }

    public boolean hasClassificationAlias(String tableName, String columnName) {
        return this.getClassificationProperties().hasClassificationAlias(tableName, columnName);
    }

    public boolean hasClassificationAlias(String classificationName) {
        return this.getClassificationProperties().hasClassificationAlias(classificationName);
    }

    public Map<String, String> getAllColumnClassificationMap() {
        return this.getClassificationProperties().getAllColumnClassificationMap();
    }

    public boolean isAllClassificationColumn(String columnName) {
        return this.getClassificationProperties().isAllClassificationColumn(columnName);
    }

    public String getAllClassificationName(String columnName) {
        return this.getClassificationProperties().getAllClassificationName(columnName);
    }

    public boolean isAvailableDatabaseDependency() {
        return this.getProperties().getLittleAdjustmentProperties().isAvailableDatabaseDependency();
    }

    public boolean isAvailableNonPrimaryKeyWritable() {
        return this.getProperties().getLittleAdjustmentProperties().isAvailableNonPrimaryKeyWritable();
    }

    public boolean isCheckSelectedClassification() {
        return this.getProperties().getLittleAdjustmentProperties().isCheckSelectedClassification();
    }

    public boolean isForceClassificationSetting() {
        return this.getProperties().getLittleAdjustmentProperties().isForceClassificationSetting();
    }

    public boolean isCDefToStringReturnsName() {
        return this.getProperties().getLittleAdjustmentProperties().isCDefToStringReturnsName();
    }

    public boolean isMakeEntityOldStyleClassify() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeEntityOldStyleClassify();
    }

    public boolean isMakeEntityChaseRelation() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeEntityChaseRelation();
    }

    public boolean isEntityConvertEmptyStringToNull() {
        return this.getProperties().getLittleAdjustmentProperties().isEntityConvertEmptyStringToNull();
    }

    public boolean isMakeConditionQueryEqualEmptyString() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeConditionQueryEqualEmptyString();
    }

    public String getConditionQueryNotEqualDefinitionName() {
        return this.getProperties().getLittleAdjustmentProperties().getConditionQueryNotEqualDefinitionName();
    }

    public boolean isAvailableDatabaseNativeJDBC() {
        return this.getProperties().getLittleAdjustmentProperties().isAvailableDatabaseNativeJDBC();
    }

    public boolean isAvailableOracleNativeJDBC() {
        return this.isDatabaseOracle() && this.isAvailableDatabaseNativeJDBC();
    }

    public boolean isMakeDeprecated() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeDeprecated();
    }

    public boolean isMakeRecentlyDeprecated() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeRecentlyDeprecated();
    }

    public boolean hasExtendedImplementedInvokerAssistantClass() {
        return this.getProperties().getLittleAdjustmentProperties().hasExtendedImplementedInvokerAssistantClass();
    }

    public String getExtendedImplementedInvokerAssistantClass() {
        return this.getProperties().getLittleAdjustmentProperties().getExtendedImplementedInvokerAssistantClass();
    }

    public boolean hasExtendedImplementedCommonColumnAutoSetupperClass() {
        return this.getProperties().getLittleAdjustmentProperties().hasExtendedImplementedCommonColumnAutoSetupperClass();
    }

    public String getExtendedImplementedCommonColumnAutoSetupperClass() {
        return this.getProperties().getLittleAdjustmentProperties().getExtendedImplementedCommonColumnAutoSetupperClass();
    }

    public boolean hasExtendedS2DaoSettingClassValid() {
        return this.getProperties().getLittleAdjustmentProperties().hasExtendedS2DaoSettingClassValid();
    }

    public String getExtendedS2DaoSettingClass() {
        return this.getProperties().getLittleAdjustmentProperties().getExtendedS2DaoSettingClass();
    }

    public boolean isShortCharHandlingValid() {
        return this.getProperties().getLittleAdjustmentProperties().isShortCharHandlingValid();
    }

    public String getShortCharHandlingMode() {
        return this.getProperties().getLittleAdjustmentProperties().getShortCharHandlingMode();
    }

    public String getShortCharHandlingModeCode() {
        return this.getProperties().getLittleAdjustmentProperties().getShortCharHandlingModeCode();
    }

    public boolean isStopGenerateExtendedBhv() {
        return this.getProperties().getLittleAdjustmentProperties().isStopGenerateExtendedBhv();
    }

    public boolean isStopGenerateExtendedDao() {
        return this.getProperties().getLittleAdjustmentProperties().isStopGenerateExtendedDao();
    }

    public boolean isStopGenerateExtendedEntity() {
        return this.getProperties().getLittleAdjustmentProperties().isStopGenerateExtendedEntity();
    }

    public boolean isMakeFlatExpansion() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeFlatExpansion();
    }

    public boolean isMakeDaoInterface() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeDaoInterface();
    }

    public boolean isAvailableToLowerInGeneratorUnderscoreMethod() {
        return this.getProperties().getLittleAdjustmentProperties().isAvailableToLowerInGeneratorUnderscoreMethod();
    }

    public boolean isUseBuri() {
        return this.getProperties().getBuriProperties().isUseBuri();
    }

    public List<String> getBuriPackageList() {
        return new ArrayList<String>(this.getProperties().getBuriProperties().getActivityDefinitionMap().keySet());
    }

    public List<String> getBuriProcessList(String packageName) {
        return new ArrayList<String>(this.getProperties().getBuriProperties().getProcessMap(packageName).keySet());
    }

    public List<String> getBuriStatusList(String packageName, String processName) {
        return this.getProperties().getBuriProperties().getStatusList(packageName, processName);
    }

    public List<String> getBuriActionList(String packageName, String processName) {
        return this.getProperties().getBuriProperties().getActionList(packageName, processName);
    }

    public boolean hasBuriAllRoundStateHistory() {
        return this.getProperties().getBuriProperties().hasBuriAllRoundStateHistory(new DfTableFinder(){

            public Table findTable(String name) {
                return Database.this.getTable(name);
            }
        });
    }

    public boolean isSqlLogRegistryValid() {
        return this.getProperties().getSqlLogRegistryProperties().isValid();
    }

    public int getSqlLogRegistryLimitSize() {
        return this.getProperties().getSqlLogRegistryProperties().getLimitSize();
    }

    public boolean isGenerateProcedureParameterBean() {
        return this.getProperties().getOutsideSqlProperties().isGenerateProcedureParameterBean();
    }

    public boolean hasSqlFileEncoding() {
        return this.getProperties().getOutsideSqlProperties().hasSqlFileEncoding();
    }

    public String getSqlFileEncoding() {
        return this.getProperties().getOutsideSqlProperties().getSqlFileEncoding();
    }

    public boolean isOutsideSqlPackageValid() {
        return this.getProperties().getOutsideSqlProperties().isSqlPackageValid();
    }

    public String getOutsideSqlPackage() {
        return this.getProperties().getOutsideSqlProperties().getSqlPackage();
    }

    public boolean isDefaultPackageValid() {
        return this.getProperties().getOutsideSqlProperties().isDefaultPackageValid();
    }

    public String getDefaultPackage() {
        return this.getProperties().getOutsideSqlProperties().getDefaultPackage();
    }

    public boolean isOmitResourcePathPackageValid() {
        return this.getProperties().getOutsideSqlProperties().isOmitResourcePathPackageValid();
    }

    public String getOmitResourcePathPackage() {
        return this.getProperties().getOutsideSqlProperties().getOmitResourcePathPackage();
    }

    public boolean isOmitFileSystemPathPackageValid() {
        return this.getProperties().getOutsideSqlProperties().isOmitFileSystemPathPackageValid();
    }

    public String getOmitFileSystemPathPackage() {
        return this.getProperties().getOutsideSqlProperties().getOmitFileSystemPathPackage();
    }

    public String getSql2EntityBaseEntityPackage() {
        return this.getProperties().getOutsideSqlProperties().getBaseEntityPackage();
    }

    public String getSql2EntityDBMetaPackage() {
        return this.getProperties().getOutsideSqlProperties().getDBMetaPackage();
    }

    public String getSql2EntityExtendedEntityPackage() {
        return this.getProperties().getOutsideSqlProperties().getExtendedEntityPackage();
    }

    public String getSql2EntityBaseCursorPackage() {
        return this.getProperties().getOutsideSqlProperties().getBaseCursorPackage();
    }

    public String getSql2EntityExtendedCursorPackage() {
        return this.getProperties().getOutsideSqlProperties().getExtendedCursorPackage();
    }

    public String getSql2EntityBaseParameterBeanPackage() {
        return this.getProperties().getOutsideSqlProperties().getBaseParameterBeanPackage();
    }

    public String getSql2EntityExtendedParameterBeanPackage() {
        return this.getProperties().getOutsideSqlProperties().getExtendedParameterBeanPackage();
    }

    public boolean isAliasDelimiterInDbCommentValid() {
        return this.getProperties().getDocumentProperties().isAliasDelimiterInDbCommentValid();
    }

    public boolean isEntityJavaDocDbCommentValid() {
        return this.getProperties().getDocumentProperties().isEntityJavaDocDbCommentValid();
    }

    public String getSchemaHtmlFileName() {
        String projectName = this.getProjectName();
        return this.getProperties().getDocumentProperties().getSchemaHtmlFileName(projectName);
    }

    public boolean isSchemaHtmlOutsideSqlValid() {
        if (this.getProperties().getDocumentProperties().isSuppressSchemaHtmlOutsideSql()) {
            return false;
        }
        return this.hasTableBqpMap() || this.isGenerateProcedureParameterBean();
    }

    public String getHistoryHtmlFileName() {
        String projectName = this.getProjectName();
        return this.getProperties().getDocumentProperties().getHistoryHtmlFileName(projectName);
    }

    public void deleteOldSchemaHtmlFile() {
        String outputDirectory;
        String oldFileName;
        String currentFileName = this.getSchemaHtmlFileName();
        if (currentFileName.equalsIgnoreCase(oldFileName = (outputDirectory = this.getProperties().getDocumentProperties().getDocumentOutputDirectory()) + "/project-schema-" + this.getProjectName() + ".html")) {
            return;
        }
        File file = new File(oldFileName);
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (RuntimeException continued) {
                _log.info((Object)("*Failed to delete old schemaHtml: " + file), (Throwable)continued);
            }
        }
    }

    public boolean hasSimpleDtoDefinition() {
        return this.getProperties().getSimpleDtoProperties().hasSimpleDtoDefinition();
    }

    public String getSimpleDtoBaseDtoPackage() {
        return this.getProperties().getSimpleDtoProperties().getBaseDtoPackage();
    }

    public String getSimpleDtoExtendedDtoPackage() {
        return this.getProperties().getSimpleDtoProperties().getExtendedDtoPackage();
    }

    public String getSimpleDtoBaseDtoPrefix() {
        return this.getProperties().getSimpleDtoProperties().getBaseDtoPrefix();
    }

    public String getSimpleDtoBaseDtoSuffix() {
        return this.getProperties().getSimpleDtoProperties().getBaseDtoSuffix();
    }

    public String getSimpleDtoExtendedDtoPrefix() {
        return this.getProperties().getSimpleDtoProperties().getExtendedDtoPrefix();
    }

    public String getSimpleDtoExtendedDtoSuffix() {
        return this.getProperties().getSimpleDtoProperties().getExtendedDtoSuffix();
    }

    public String getSimpleDtoDtoMapperPackage() {
        return this.getProperties().getSimpleDtoProperties().getMapperPackage();
    }

    public boolean isSimpleDtoUseDtoMapper() {
        return this.getProperties().getSimpleDtoProperties().isUseDtoMapper();
    }

    public boolean hasFlexDtoDefinition() {
        return this.getProperties().getFlexDtoProperties().hasFlexDtoDefinition();
    }

    public boolean isFlexDtoOverrideExtended() {
        return this.getProperties().getFlexDtoProperties().isOverrideExtended();
    }

    public String getFlexDtoBaseDtoPackage() {
        return this.getProperties().getFlexDtoProperties().getBaseDtoPackage();
    }

    public String getFlexDtoExtendedDtoPackage() {
        return this.getProperties().getFlexDtoProperties().getExtendedDtoPackage();
    }

    public String getFlexDtoBaseDtoPrefix() {
        return this.getProperties().getFlexDtoProperties().getBaseDtoPrefix();
    }

    public String getFlexDtoBaseDtoSuffix() {
        return this.getProperties().getFlexDtoProperties().getBaseDtoSuffix();
    }

    public String getFlexDtoExtendedDtoPrefix() {
        return this.getProperties().getFlexDtoProperties().getExtendedDtoPrefix();
    }

    public String getFlexDtoExtendedDtoSuffix() {
        return this.getProperties().getFlexDtoProperties().getExtendedDtoSuffix();
    }

    public boolean hasHibernateDefinition() {
        return this.getProperties().getHibernateProperties().hasHibernateDefinition();
    }

    public String getHibernateBaseEntityPackage() {
        return this.getBaseEntityPackage();
    }

    public String getHibernateExtendedEntityPackage() {
        return this.getExtendedEntityPackage();
    }

    public String getHibernateBaseEntityPrefix() {
        return this.getBasePrefix();
    }

    public String getHibernateManyToOneFetch() {
        return this.getProperties().getHibernateProperties().getManyToOneFetch();
    }

    public String getHibernateOneToOneFetch() {
        return this.getProperties().getHibernateProperties().getOneToOneFetch();
    }

    public String getHibernateOneToManyFetch() {
        return this.getProperties().getHibernateProperties().getOneToManyFetch();
    }

    public boolean hasS2jdbcDefinition() {
        return this.getProperties().getS2jdbcProperties().hasS2jdbcDefinition();
    }

    public String getS2jdbcBaseEntityPackage() {
        return this.getProperties().getS2jdbcProperties().getBaseEntityPackage();
    }

    public String getS2jdbcExtendedEntityPackage() {
        return this.getProperties().getS2jdbcProperties().getExtendedEntityPackage();
    }

    public String getS2jdbcBaseEntityPrefix() {
        return this.getProperties().getS2jdbcProperties().getBaseEntityPrefix();
    }

    public String getInvokerAssistantComponentName() {
        return this.filterComponentNameWithProjectPrefix("invokerAssistant");
    }

    public String getCommonColumnAutoSetupperComponentName() {
        return this.filterComponentNameWithProjectPrefix("commonColumnAutoSetupper");
    }

    public String getBehaviorSelectorComponentName() {
        return this.filterComponentNameWithProjectPrefix("behaviorSelector");
    }

    public String getBehaviorCommandInvokerComponentName() {
        return this.filterComponentNameWithProjectPrefix("behaviorCommandInvoker");
    }

    public String filterComponentNameWithProjectPrefix(String componentName) {
        String prefix = this.getBasicProperties().getProjectPrefix();
        if (prefix == null || prefix.trim().length() == 0) {
            return componentName;
        }
        String filteredPrefix = prefix.substring(0, 1).toLowerCase() + prefix.substring(1);
        return filteredPrefix + componentName.substring(0, 1).toUpperCase() + componentName.substring(1);
    }

    public String convertJavaNativeByJdbcType(String jdbcType) {
        try {
            return TypeMap.findJavaNativeByJdbcType(jdbcType, null, null);
        }
        catch (RuntimeException e) {
            _log.warn((Object)("TypeMap.findJavaNativeTypeString(jdbcType, null, null) threw the exception: jdbcType=" + jdbcType), (Throwable)e);
            throw e;
        }
    }

    public String convertJavaNameByJdbcNameAsTable(String jdbcName) {
        if (this.getBasicProperties().isTableNameCamelCase()) {
            return this.initCap(jdbcName);
        }
        ArrayList<String> inputs = new ArrayList<String>(2);
        inputs.add(jdbcName);
        inputs.add(this.getDefaultJavaNamingMethod());
        return this.initCap(this.generateName(inputs));
    }

    public String convertJavaNameByJdbcNameAsColumn(String jdbcName) {
        if (this.getBasicProperties().isColumnNameCamelCase()) {
            return this.initCap(jdbcName);
        }
        ArrayList<String> inputs = new ArrayList<String>(2);
        inputs.add(jdbcName);
        inputs.add(this.getDefaultJavaNamingMethod());
        return this.initCap(this.generateName(inputs));
    }

    public String convertUncapitalisedJavaNameByJdbcNameAsColumn(String jdbcName) {
        return Srl.initUncap((String)this.convertJavaNameByJdbcNameAsColumn(jdbcName));
    }

    protected String generateName(List<?> inputs) {
        String javaName = null;
        try {
            javaName = NameFactory.generateName(NameFactory.JAVA_GENERATOR, inputs);
        }
        catch (EngineException e) {
            String msg = "NameFactory.generateName() threw the exception: inputs=" + inputs;
            _log.warn((Object)msg, (Throwable)((Object)e));
            throw new RuntimeException(msg, (Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            String msg = "NameFactory.generateName() threw the exception: inputs=" + inputs;
            _log.warn((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        if (javaName == null) {
            String msg = "NameFactory.generateName() returned null: inputs=" + inputs;
            _log.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
        return javaName;
    }

    public String getWildCard() {
        return "%";
    }

    public String getSharp() {
        return "#";
    }

    public String getDollar() {
        return "$";
    }

    public String getOverrideComment() {
        return "{@inheritDoc}";
    }

    public String getImplementComment() {
        return "{@inheritDoc}";
    }

    public void info(String msg) {
        _log.info((Object)msg);
    }

    public void debug(String msg) {
        _log.debug((Object)msg);
    }

    public String getTimestampExpression() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(timestamp);
    }

    public String initCap(String str) {
        return Srl.initCap((String)str);
    }

    public String initUncap(String str) {
        return Srl.initUncap((String)str);
    }

    public boolean isInitNumber(String str) {
        if (str == null) {
            String msg = "Argument[str] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (str.length() == 0) {
            return false;
        }
        try {
            Integer.valueOf(str.substring(0, 1));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getMapValue(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value != null ? (String)value : "";
    }

    public void makeDirectory(String packagePath) {
        FileUtil.mkdir((String)(this.getGeneratorInstance().getOutputPath() + "/" + packagePath));
    }

    public String getPackageAsPath(String pckge) {
        DfPackagePathHandler handler = new DfPackagePathHandler(this.getBasicProperties());
        return handler.getPackageAsPath(pckge);
    }

    public boolean hasTableBqpMap() {
        return !this.getTableBqpMap().isEmpty();
    }

    protected Map<String, Map<String, Map<String, String>>> getTableBqpMap() {
        if (this._tableBqpMap != null) {
            return this._tableBqpMap;
        }
        DfBehaviorQueryPathSetupper setupper = new DfBehaviorQueryPathSetupper(this.getProperties());
        try {
            this._tableBqpMap = setupper.extractTableBqpMap(this.collectSqlFileList());
        }
        catch (RuntimeException e) {
            _log.warn((Object)"Failed to extract the map of table behavior query path!", (Throwable)e);
            this._tableBqpMap = new HashMap<String, Map<String, Map<String, String>>>();
        }
        return this._tableBqpMap;
    }

    protected List<File> collectSqlFileList() {
        String sqlDirectory = this.getProperties().getOutsideSqlProperties().getSqlDirectory();
        DfSqlFileCollector sqlFileCollector = new DfSqlFileCollector(sqlDirectory, this.getBasicProperties());
        sqlFileCollector.suppressDirectoryCheck();
        return sqlFileCollector.collectSqlFileList();
    }

    public List<DfProcedureMetaInfo> getAvailableProcedureList() throws SQLException {
        if (this._procedureMetaInfoList != null) {
            return this._procedureMetaInfoList;
        }
        _log.info((Object)" ");
        _log.info((Object)"...Setting up procedures for documents");
        DfProcedureHandler handler = new DfProcedureHandler();
        handler.includeProcedureSynonym(this.getDataSource());
        DataSource dataSource = this.getDataSource();
        this._procedureMetaInfoList = handler.getAvailableProcedureList(dataSource);
        return this._procedureMetaInfoList;
    }

    public void loadSchemaHistory() {
        _log.info((Object)"...Loading schema history");
        this._schemaHistory = new DfSchemaHistory();
        this._schemaHistory.loadHistory();
        if (this.existsSchemaHistory()) {
            _log.info((Object)("  -> found history: count=" + this.getSchemaDiffList().size()));
        } else {
            _log.info((Object)"  -> no history");
        }
    }

    public boolean existsSchemaHistory() {
        return this._schemaHistory.existsHistory();
    }

    public List<DfSchemaDiff> getSchemaDiffList() {
        return this._schemaHistory.getSchemaDiffList();
    }

    protected DataSource getDataSource() {
        return DfDataSourceContext.getDataSource();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<database name=\"").append(this.getName()).append('\"').append(">\n");
        Iterator<Table> i = this._tableList.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
        }
        sb.append("</database>");
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name == null ? "default" : name;
    }

    public String getDefaultJavaNamingMethod() {
        return this._defaultJavaNamingMethod;
    }

    public void setDefaultJavaNamingMethod(String v) {
        this._defaultJavaNamingMethod = v;
    }

    public void setAppData(AppData appData) {
        this._appData = appData;
    }

    public void setSql2EntitySchemaData(AppData sql2entitySchemaData) {
        this._sql2entitySchemaData = sql2entitySchemaData;
    }

    public AppData getAppData() {
        return this._appData;
    }

    public String getDatabaseType() {
        return this._databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this._databaseType = databaseType;
    }

    public Map<String, DfPmbMetaData> getPmbMetaDataMap() {
        return this._pmbMetaDataMap;
    }

    public void setPmbMetaDataMap(Map<String, DfPmbMetaData> pmbMetaDataMap) {
        this._pmbMetaDataMap = pmbMetaDataMap;
    }

    public void setSkipDeleteOldClass(boolean skipDeleteOldClass) {
        this._skipDeleteOldClass = skipDeleteOldClass;
    }
}

