/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException;
import org.seasar.dbflute.exception.EntityAlreadyDeletedException;
import org.seasar.dbflute.exception.EntityDuplicatedException;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlhandler.TnAbstractAutoHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnAbstractBatchAutoHandler
extends TnAbstractAutoHandler {
    private static final Log _log = LogFactory.getLog(TnAbstractBatchAutoHandler.class);

    public TnAbstractBatchAutoHandler(DataSource dataSource, StatementFactory statementFactory, TnBeanMetaData beanMetaData, TnPropertyType[] boundPropTypes) {
        super(dataSource, statementFactory, beanMetaData, boundPropTypes);
    }

    @Override
    public int execute(Object[] args) {
        List list = null;
        if (args[0] instanceof Object[]) {
            list = Arrays.asList((Object[])args[0]);
        } else if (args[0] instanceof List) {
            list = (List)args[0];
        }
        if (list == null) {
            throw new IllegalArgumentException("args[0]");
        }
        int[] ret = this.execute(list);
        int updatedRow = 0;
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] <= 0) continue;
            updatedRow += ret[i];
        }
        return updatedRow;
    }

    public int[] executeBatch(Object[] args) {
        List list = null;
        if (args[0] instanceof Object[]) {
            list = Arrays.asList((Object[])args[0]);
        } else if (args[0] instanceof List) {
            list = (List)args[0];
        }
        if (list == null) {
            throw new IllegalArgumentException("args[0]");
        }
        return this.execute(list);
    }

    public int[] execute(List<?> list, Class<?>[] argTypes) {
        return this.execute(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] execute(List<?> list) {
        if (list == null) {
            throw new IllegalArgumentException("list");
        }
        if (list.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Skip executeBatch() bacause of the empty list.");
            }
            return new int[0];
        }
        Connection conn = this.getConnection();
        try {
            int[] nArray;
            PreparedStatement ps = this.prepareStatement(conn);
            try {
                for (Object bean : list) {
                    this.prepareBatchElement(conn, ps, bean);
                }
                int[] result = this.executeBatch(ps, list);
                this.handleBatchUpdateResultWithOptimisticLock(ps, list, result);
                nArray = result;
            }
            catch (Throwable throwable) {
                this.close(ps);
                throw throwable;
            }
            this.close(ps);
            return nArray;
        }
        finally {
            this.close(conn);
        }
    }

    protected void prepareBatchElement(Connection conn, PreparedStatement ps, Object bean) {
        this.setupBindVariables(bean);
        this.logSql(this.getBindVariables(), this.getArgTypes(this.getBindVariables()));
        this.bindArgs(conn, ps, this.getBindVariables(), this.getBindVariableValueTypes());
        this.addBatch(ps);
    }

    protected void handleBatchUpdateResultWithOptimisticLock(PreparedStatement ps, List<?> list, int[] result) {
        if (this.isCurrentDBDef(DBDef.Oracle)) {
            int updateCount;
            try {
                updateCount = ps.getUpdateCount();
            }
            catch (SQLException e) {
                this.handleSQLException(e, ps);
                return;
            }
            this.handleBatchUpdateResultWithOptimisticLockByUpdateCount(list, updateCount);
        } else {
            this.handleBatchUpdateResultWithOptimisticLockByResult(list, result);
        }
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return ResourceContext.isCurrentDBDef(currentDBDef);
    }

    protected void handleBatchUpdateResultWithOptimisticLockByUpdateCount(List<?> list, int updateCount) {
        if (list.isEmpty()) {
            return;
        }
        if (updateCount < 0) {
            return;
        }
        int entityCount = list.size();
        if (updateCount < entityCount) {
            if (this._optimisticLockHandling) {
                throw new BatchEntityAlreadyUpdatedException(list.get(0), 0, updateCount);
            }
            String msg = "The entity have already deleted:";
            msg = msg + " updateCount=" + updateCount;
            msg = msg + " entityCount=" + entityCount;
            msg = msg + " allEntities=" + list;
            throw new EntityAlreadyDeletedException(msg);
        }
    }

    protected void handleBatchUpdateResultWithOptimisticLockByResult(List<?> list, int[] result) {
        if (list.isEmpty()) {
            return;
        }
        int[] updatedCountArray = result;
        int entityCount = list.size();
        int index = 0;
        boolean alreadyUpdated = false;
        for (int oneUpdateCount : updatedCountArray) {
            if (entityCount <= index) break;
            if (oneUpdateCount == 0) {
                alreadyUpdated = true;
                break;
            }
            if (oneUpdateCount > 1) {
                String msg = "The entity updated two or more records in batch update:";
                msg = msg + " entity=" + list.get(index);
                msg = msg + " updatedCount=" + oneUpdateCount;
                msg = msg + " allEntities=" + list;
                throw new EntityDuplicatedException(msg);
            }
            ++index;
        }
        if (alreadyUpdated) {
            int updateCount = 0;
            for (int oneUpdateCount : updatedCountArray) {
                updateCount += oneUpdateCount;
            }
            if (this._optimisticLockHandling) {
                throw new BatchEntityAlreadyUpdatedException(list.get(index), 0, updateCount);
            }
            String msg = "The entity have already deleted:";
            msg = msg + " entity=" + list.get(index);
            msg = msg + " updateCount=" + updateCount;
            msg = msg + " allEntities=" + list;
            throw new EntityAlreadyDeletedException(msg);
        }
    }

    protected int[] executeBatch(PreparedStatement ps, List<?> list) {
        try {
            return ps.executeBatch();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps, true);
            return null;
        }
    }

    protected void addBatch(PreparedStatement ps) {
        try {
            ps.addBatch();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps);
        }
    }
}

