/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.outsidesql.OutsideSqlFilter;
import org.seasar.dbflute.outsidesql.ProcedurePmb;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.metadata.TnProcedureMetaData;
import org.seasar.dbflute.s2dao.metadata.TnProcedureParameterType;
import org.seasar.dbflute.s2dao.sqlcommand.TnSqlCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnProcedureHandler;

public class TnProcedureCommand
implements TnSqlCommand,
SqlExecution {
    protected DataSource _dataSource;
    protected StatementFactory _statementFactory;
    protected TnProcedureMetaData _procedureMetaData;
    protected TnProcedureResultSetHandlerFactory _procedureResultSetHandlerFactory;
    protected OutsideSqlFilter _outsideSqlFilter;

    public TnProcedureCommand(DataSource dataSource, StatementFactory statementFactory, TnProcedureMetaData procedureMetaData, TnProcedureResultSetHandlerFactory procedureResultSetHandlerFactory) {
        this._dataSource = dataSource;
        this._statementFactory = statementFactory;
        this._procedureMetaData = procedureMetaData;
        this._procedureResultSetHandlerFactory = procedureResultSetHandlerFactory;
    }

    public Object execute(Object[] args) {
        OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
        Object pmb = outsideSqlContext.getParameterBean();
        TnProcedureHandler handler = this.createProcedureHandler(pmb);
        Object[] onlyPmbArgs = new Object[]{pmb};
        handler.setExceptionMessageSqlArgs(onlyPmbArgs);
        return handler.execute(onlyPmbArgs);
    }

    protected TnProcedureHandler createProcedureHandler(Object pmb) {
        String sql = this.buildSql(pmb);
        if (this._outsideSqlFilter != null) {
            sql = this._outsideSqlFilter.filterExecution(sql, OutsideSqlFilter.ExecutionFilterType.PROCEDURE);
        }
        return new TnProcedureHandler(this._dataSource, this._statementFactory, sql, this._procedureMetaData, this.createProcedureResultSetHandlerFactory());
    }

    protected String buildSql(Object pmb) {
        String procedureName = this._procedureMetaData.getProcedureName();
        int bindSize = this._procedureMetaData.getBindParameterTypeList().size();
        boolean existsReturn = this._procedureMetaData.hasReturnParameterType();
        return this.doBuildSql(pmb, procedureName, bindSize, existsReturn);
    }

    protected String doBuildSql(Object pmb, String procedureName, int bindSize, boolean existsReturn) {
        boolean kakou = true;
        boolean calledBySelect = false;
        if (pmb instanceof ProcedurePmb) {
            kakou = ((ProcedurePmb)pmb).isEscapeStatement();
            calledBySelect = ((ProcedurePmb)pmb).isCalledBySelect();
        }
        if (calledBySelect) {
            return this.doBuildSqlAsCalledBySelect(procedureName, bindSize);
        }
        return this.doBuildSqlAsProcedureCall(procedureName, bindSize, existsReturn, kakou);
    }

    protected String doBuildSqlAsCalledBySelect(String procedureName, int bindSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(procedureName).append("(");
        for (int i = 0; i < bindSize; ++i) {
            sb.append("?, ");
        }
        if (bindSize > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        return sb.toString();
    }

    protected String doBuildSqlAsProcedureCall(String procedureName, int bindSize, boolean existsReturn, boolean kakou) {
        int argSize;
        StringBuilder sb = new StringBuilder();
        if (existsReturn) {
            sb.append("? = ");
            argSize = bindSize - 1;
        } else {
            argSize = bindSize;
        }
        sb.append("call ").append(procedureName).append("(");
        for (int i = 0; i < argSize; ++i) {
            sb.append("?, ");
        }
        if (argSize > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        if (kakou) {
            sb.insert(0, "{").append("}");
        }
        return sb.toString();
    }

    protected TnProcedureHandler.TnProcedureResultSetHandlerProvider createProcedureResultSetHandlerFactory() {
        return new TnProcedureHandler.TnProcedureResultSetHandlerProvider(){

            public TnResultSetHandler provideResultSetHandler(TnProcedureParameterType ppt) {
                Class<?> parameterType = ppt.getParameterType();
                if (!List.class.isAssignableFrom(parameterType)) {
                    String msg = "The parameter type for result set should be List:";
                    msg = msg + " parameter=" + ppt.getParameterName() + " type=" + parameterType;
                    throw new IllegalStateException(msg);
                }
                Class<?> elementType = ppt.getElementType();
                if (elementType == null) {
                    String msg = "The parameter type for result set should have generic type of List:";
                    msg = msg + " parameter=" + ppt.getParameterName() + " type=" + parameterType;
                    throw new IllegalStateException(msg);
                }
                if (Map.class.isAssignableFrom(elementType)) {
                    return TnProcedureCommand.this._procedureResultSetHandlerFactory.createMapHandler();
                }
                return TnProcedureCommand.this._procedureResultSetHandlerFactory.createBeanHandler(elementType);
            }
        };
    }

    public void setOutsideSqlFilter(OutsideSqlFilter outsideSqlFilter) {
        this._outsideSqlFilter = outsideSqlFilter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TnProcedureResultSetHandlerFactory {
        public TnResultSetHandler createBeanHandler(Class<?> var1);

        public TnResultSetHandler createMapHandler();
    }
}

