/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.info;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferrerInfo
implements RelationInfo {
    protected final String _referrerPropertyName;
    protected final DBMeta _localDBMeta;
    protected final DBMeta _referrerDBMeta;
    protected final Map<ColumnInfo, ColumnInfo> _localReferrerColumnInfoMap;
    protected final Map<ColumnInfo, ColumnInfo> _referrerLocalColumnInfoMap;
    protected final boolean _oneToOne;

    public ReferrerInfo(String referrerPropertyName, DBMeta localDBMeta, DBMeta referrerDBMeta, Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap, boolean oneToOne) {
        this.assertObjectNotNull("referrerPropertyName", referrerPropertyName);
        this.assertObjectNotNull("localDBMeta", localDBMeta);
        this.assertObjectNotNull("referrerDBMeta", referrerDBMeta);
        this.assertObjectNotNull("localReferrerColumnInfoMap", localReferrerColumnInfoMap);
        this._referrerPropertyName = referrerPropertyName;
        this._localDBMeta = localDBMeta;
        this._referrerDBMeta = referrerDBMeta;
        this._localReferrerColumnInfoMap = localReferrerColumnInfoMap;
        Set<ColumnInfo> keySet = localReferrerColumnInfoMap.keySet();
        this._referrerLocalColumnInfoMap = new LinkedHashMap<ColumnInfo, ColumnInfo>();
        for (ColumnInfo key : keySet) {
            ColumnInfo value = localReferrerColumnInfoMap.get(key);
            this._referrerLocalColumnInfoMap.put(value, key);
        }
        this._oneToOne = oneToOne;
    }

    public ColumnInfo findLocalByReferrer(String referrerColumnDbName) {
        ColumnInfo keyColumnInfo = this._referrerDBMeta.findColumnInfo(referrerColumnDbName);
        ColumnInfo resultColumnInfo = this._referrerLocalColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by referrerColumnDbName in referrerLocalColumnInfoMap:";
            msg = msg + " referrerColumnDbName=" + referrerColumnDbName + " referrerLocalColumnInfoMap=" + this._referrerLocalColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public ColumnInfo findReferrerByLocal(String localColumnDbName) {
        ColumnInfo keyColumnInfo = this._localDBMeta.findColumnInfo(localColumnDbName);
        ColumnInfo resultColumnInfo = this._localReferrerColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by localColumnDbName in localReferrerColumnInfoMap:";
            msg = msg + " localColumnDbName=" + localColumnDbName + " localReferrerColumnInfoMap=" + this._localReferrerColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public <PROPERTY extends List> PROPERTY read(Entity localEntity) {
        return (PROPERTY)((List)this.invokeMethod(this.reader(), localEntity, new Object[0]));
    }

    public Method reader() {
        String methodName;
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        Method method = this.findMethod(localType, methodName = this.buildAccessorName("get"), new Class[0]);
        if (method == null) {
            String msg = "Failed to find the method by the name:";
            msg = msg + " methodName=" + methodName;
            throw new IllegalStateException(msg);
        }
        return method;
    }

    public void write(Entity localEntity, List<? extends Entity> referrerEntityList) {
        this.invokeMethod(this.writer(), localEntity, new Object[]{referrerEntityList});
    }

    public Method writer() {
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        String methodName = this.buildAccessorName("set");
        Method method = this.findMethod(localType, methodName, new Class[]{List.class});
        if (method == null) {
            String msg = "Failed to find the method by the name:";
            msg = msg + " methodName=" + methodName;
            throw new IllegalStateException(msg);
        }
        return method;
    }

    protected String buildAccessorName(String prefix) {
        return prefix + this.initCap(this._referrerPropertyName);
    }

    @Override
    public String getRelationPropertyName() {
        return this.getReferrerPropertyName();
    }

    @Override
    public DBMeta getTargetDBMeta() {
        return this.getReferrerDBMeta();
    }

    @Override
    public Map<ColumnInfo, ColumnInfo> getLocalTargetColumnInfoMap() {
        return this.getLocalReferrerColumnInfoMap();
    }

    @Override
    public boolean isReferrer() {
        return true;
    }

    protected String initCap(String name) {
        return Srl.initCap(name);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        return DfReflectionUtil.getAccessibleMethod(clazz, methodName, argTypes);
    }

    protected Object invokeMethod(Method method, Object target, Object[] args) {
        return DfReflectionUtil.invoke(method, target, args);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this._referrerPropertyName.hashCode() + this._localDBMeta.hashCode() + this._referrerDBMeta.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ReferrerInfo)) {
            return false;
        }
        ReferrerInfo target = (ReferrerInfo)obj;
        if (!this._referrerPropertyName.equals(target.getReferrerPropertyName())) {
            return false;
        }
        if (!this._localDBMeta.equals(target.getLocalDBMeta())) {
            return false;
        }
        return this._referrerDBMeta.equals(target.getReferrerDBMeta());
    }

    public String toString() {
        return this._localDBMeta.getTableDbName() + "." + this._referrerPropertyName + "<-" + this._referrerDBMeta.getTableDbName();
    }

    public String getReferrerPropertyName() {
        return this._referrerPropertyName;
    }

    @Override
    public DBMeta getLocalDBMeta() {
        return this._localDBMeta;
    }

    public DBMeta getReferrerDBMeta() {
        return this._referrerDBMeta;
    }

    public Map<ColumnInfo, ColumnInfo> getLocalReferrerColumnInfoMap() {
        return new LinkedHashMap<ColumnInfo, ColumnInfo>(this._localReferrerColumnInfoMap);
    }

    public Map<ColumnInfo, ColumnInfo> getReferrerLocalColumnInfoMap() {
        return new LinkedHashMap<ColumnInfo, ColumnInfo>(this._referrerLocalColumnInfoMap);
    }

    @Override
    public boolean isOneToOne() {
        return this._oneToOne;
    }
}

