/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.exception.IllegalClassificationCodeException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ClassificationMeta;
import org.seasar.dbflute.util.DfAssertUtil;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBMeta
implements DBMeta {
    private static final long serialVersionUID = 1L;
    protected static final Object DUMMY_VALUE = new Object();
    private volatile StringKeyMap<String> _tableDbNameFlexibleMap;
    private volatile StringKeyMap<String> _tablePropertyNameFlexibleMap;
    private volatile List<ColumnInfo> _columnInfoList;
    private volatile StringKeyMap<ColumnInfo> _columnInfoFlexibleMap;
    private volatile List<ForeignInfo> _foreignInfoList;
    private volatile StringKeyMap<ForeignInfo> _foreignInfoFlexibleMap;
    private volatile List<ReferrerInfo> _referrerInfoList;
    private volatile StringKeyMap<ReferrerInfo> _referrerInfoFlexibleMap;
    private final Map<String, Object> _methodNameMap = this.newConcurrentHashMap();

    protected void initializeInformationResource() {
        this.getTableDbNameFlexibleMap();
        this.getTablePropertyNameFlexibleMap();
        this.getColumnInfoList();
        this.getColumnInfoFlexibleMap();
        this.hasMethod("dummy");
    }

    @Override
    public String getTableAlias() {
        return null;
    }

    @Override
    public String getTableComment() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getTableDbNameFlexibleMap() {
        if (this._tableDbNameFlexibleMap != null) {
            return this._tableDbNameFlexibleMap;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._tableDbNameFlexibleMap != null) {
                return this._tableDbNameFlexibleMap;
            }
            this._tableDbNameFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            this._tableDbNameFlexibleMap.put(this.getTableDbName(), this.getTableDbName());
            return this._tableDbNameFlexibleMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getTablePropertyNameFlexibleMap() {
        if (this._tablePropertyNameFlexibleMap != null) {
            return this._tablePropertyNameFlexibleMap;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._tablePropertyNameFlexibleMap != null) {
                return this._tablePropertyNameFlexibleMap;
            }
            this._tablePropertyNameFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            this._tablePropertyNameFlexibleMap.put(this.getTableDbName(), this.getTablePropertyName());
            return this._tableDbNameFlexibleMap;
        }
    }

    @Override
    public boolean hasColumn(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        return this.getColumnInfoFlexibleMap().containsKey(columnFlexibleName);
    }

    @Override
    public ColumnInfo findColumnInfo(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        ColumnInfo columnInfo = this.getColumnInfoFlexibleMap().get(columnFlexibleName);
        if (columnInfo == null) {
            String msg = "Not found column by columnFlexibleName: " + columnFlexibleName;
            msg = msg + " tableName=" + this.getTableDbName();
            throw new IllegalArgumentException(msg);
        }
        return columnInfo;
    }

    protected ColumnInfo cci(String columnDbName, String columnSqlName, String columnSynonymName, String columnAlias, boolean notNull, String propertyName, Class<?> propertyType, boolean primary, boolean autoIncrement, String columnDbType, Integer columnSize, Integer decimalDigits, boolean commonColumn, DBMeta.OptimisticLockType optimisticLockType, String columnComment, String foreignListExp, String referrerListExp, ClassificationMeta classificationMeta) {
        String delimiter = ",";
        List<String> foreignPropList = null;
        if (foreignListExp != null && foreignListExp.trim().length() > 0) {
            foreignPropList = this.splitListTrimmed(foreignListExp, ",");
        }
        List<String> referrerPropList = null;
        if (referrerListExp != null && referrerListExp.trim().length() > 0) {
            referrerPropList = this.splitListTrimmed(referrerListExp, ",");
        }
        return new ColumnInfo(this, columnDbName, columnSqlName, columnSynonymName, columnAlias, notNull, propertyName, propertyType, primary, autoIncrement, columnDbType, columnSize, decimalDigits, commonColumn, optimisticLockType, columnComment, foreignPropList, referrerPropList, classificationMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnInfo> getColumnInfoList() {
        if (this._columnInfoList != null) {
            return this._columnInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._columnInfoList != null) {
                return this._columnInfoList;
            }
            this._columnInfoList = this.ccil();
            return this._columnInfoList;
        }
    }

    protected abstract List<ColumnInfo> ccil();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ColumnInfo> getColumnInfoFlexibleMap() {
        if (this._columnInfoFlexibleMap != null) {
            return this._columnInfoFlexibleMap;
        }
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._columnInfoFlexibleMap != null) {
                return this._columnInfoFlexibleMap;
            }
            this._columnInfoFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            for (ColumnInfo columnInfo : columnInfoList) {
                this._columnInfoFlexibleMap.put(columnInfo.getColumnDbName(), columnInfo);
                String columnSynonym = columnInfo.getColumnSynonym();
                if (columnSynonym == null) continue;
                this._columnInfoFlexibleMap.put(columnSynonym, columnInfo);
            }
            return this._columnInfoFlexibleMap;
        }
    }

    protected UniqueInfo cpui(ColumnInfo uniqueColumnInfo) {
        return this.cpui(Arrays.asList(uniqueColumnInfo));
    }

    protected UniqueInfo cpui(List<ColumnInfo> uniqueColumnInfoList) {
        UniqueInfo uniqueInfo = new UniqueInfo(this, uniqueColumnInfoList, true);
        return uniqueInfo;
    }

    @Override
    public RelationInfo findRelationInfo(String relationPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("relationPropertyName", relationPropertyName);
        return this.hasForeign(relationPropertyName) ? this.findForeignInfo(relationPropertyName) : this.findReferrerInfo(relationPropertyName);
    }

    @Override
    public boolean hasForeign(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("foreign", foreignPropertyName);
        return this.hasMethod(methodName);
    }

    @Override
    public DBMeta findForeignDBMeta(String foreignPropertyName) {
        return this.findForeignInfo(foreignPropertyName).getForeignDBMeta();
    }

    @Override
    public ForeignInfo findForeignInfo(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("foreign", foreignPropertyName);
        Method method = DfReflectionUtil.getPublicMethod(this.getClass(), methodName, null);
        return (ForeignInfo)DfReflectionUtil.invoke(method, this, null);
    }

    protected ForeignInfo cfi(String propName, DBMeta localDbm, DBMeta foreignDbm, Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap, int relNo, boolean oneToOne, boolean bizOneToOne) {
        return new ForeignInfo(propName, localDbm, foreignDbm, localForeignColumnInfoMap, relNo, oneToOne, bizOneToOne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ForeignInfo> getForeignInfoList() {
        if (this._foreignInfoList != null) {
            return this._foreignInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._foreignInfoList != null) {
                return this._foreignInfoList;
            }
            Method[] methods = this.getClass().getMethods();
            this._foreignInfoList = this.newArrayList();
            String prefix = "foreign";
            Class<ForeignInfo> returnType = ForeignInfo.class;
            for (Method method : methods) {
                if (!method.getName().startsWith("foreign") || !returnType.equals(method.getReturnType())) continue;
                this._foreignInfoList.add((ForeignInfo)DfReflectionUtil.invoke(method, this, null));
            }
            return this._foreignInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ForeignInfo> getForeignInfoFlexibleMap() {
        if (this._foreignInfoFlexibleMap != null) {
            return this._foreignInfoFlexibleMap;
        }
        List<ForeignInfo> foreignInfoList = this.getForeignInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._foreignInfoFlexibleMap != null) {
                return this._foreignInfoFlexibleMap;
            }
            this._foreignInfoFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            for (ForeignInfo foreignInfo : foreignInfoList) {
                this._foreignInfoFlexibleMap.put(foreignInfo.getForeignPropertyName(), foreignInfo);
            }
            return this._foreignInfoFlexibleMap;
        }
    }

    @Override
    public boolean hasReferrer(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("referrer", referrerPropertyName);
        return this.hasMethod(methodName);
    }

    @Override
    public DBMeta findReferrerDBMeta(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        return this.findReferrerInfo(referrerPropertyName).getReferrerDBMeta();
    }

    @Override
    public ReferrerInfo findReferrerInfo(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("referrer", referrerPropertyName);
        Method method = DfReflectionUtil.getPublicMethod(this.getClass(), methodName, null);
        return (ReferrerInfo)DfReflectionUtil.invoke(method, this, null);
    }

    protected ReferrerInfo cri(String propName, DBMeta localDbm, DBMeta referrerDbm, Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap, boolean oneToOne) {
        return new ReferrerInfo(propName, localDbm, referrerDbm, localReferrerColumnInfoMap, oneToOne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReferrerInfo> getReferrerInfoList() {
        if (this._referrerInfoList != null) {
            return this._referrerInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._referrerInfoList != null) {
                return this._referrerInfoList;
            }
            Method[] methods = this.getClass().getMethods();
            this._referrerInfoList = this.newArrayList();
            String prefix = "referrer";
            Class<ReferrerInfo> returnType = ReferrerInfo.class;
            for (Method method : methods) {
                if (!method.getName().startsWith("referrer") || !returnType.equals(method.getReturnType())) continue;
                this._referrerInfoList.add((ReferrerInfo)DfReflectionUtil.invoke(method, this, null));
            }
            return this._referrerInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ReferrerInfo> getReferrerInfoFlexibleMap() {
        if (this._referrerInfoFlexibleMap != null) {
            return this._referrerInfoFlexibleMap;
        }
        List<ReferrerInfo> referrerInfoList = this.getReferrerInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._referrerInfoFlexibleMap != null) {
                return this._referrerInfoFlexibleMap;
            }
            this._referrerInfoFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            for (ReferrerInfo referrerInfo : referrerInfoList) {
                this._referrerInfoFlexibleMap.put(referrerInfo.getReferrerPropertyName(), referrerInfo);
            }
            return this._referrerInfoFlexibleMap;
        }
    }

    protected String buildRelationInfoGetterMethodNameInitCap(String targetName, String relationPropertyName) {
        return targetName + relationPropertyName.substring(0, 1).toUpperCase() + relationPropertyName.substring(1);
    }

    @Override
    public boolean hasIdentity() {
        return false;
    }

    @Override
    public boolean hasSequence() {
        return false;
    }

    @Override
    public String getSequenceName() {
        return null;
    }

    @Override
    public String getSequenceNextValSql() {
        if (!this.hasSequence()) {
            return null;
        }
        return this.getCurrentDBDef().dbway().buildSequenceNextValSql(this.getSequenceName());
    }

    @Override
    public Integer getSequenceIncrementSize() {
        return null;
    }

    @Override
    public Integer getSequenceCacheSize() {
        return null;
    }

    @Override
    public boolean hasVersionNo() {
        return false;
    }

    @Override
    public ColumnInfo getVersionNoColumnInfo() {
        return null;
    }

    @Override
    public boolean hasUpdateDate() {
        return false;
    }

    @Override
    public ColumnInfo getUpdateDateColumnInfo() {
        return null;
    }

    @Override
    public boolean hasCommonColumn() {
        return false;
    }

    @Override
    public boolean hasFlexibleName(String flexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("flexibleName", flexibleName);
        return this.getColumnInfoFlexibleMap().containsKey(flexibleName) || this.getTableDbNameFlexibleMap().containsKey(flexibleName);
    }

    @Override
    public String findDbName(String flexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("flexibleName", flexibleName);
        ColumnInfo columnInfoMap = this.getColumnInfoFlexibleMap().get(flexibleName);
        if (columnInfoMap != null) {
            return columnInfoMap.getColumnDbName();
        }
        String tableDbName = this.getTableDbNameFlexibleMap().get(flexibleName);
        if (tableDbName != null) {
            return tableDbName;
        }
        String msg = "Not found DB name by the flexible name: flexibleName=" + flexibleName;
        throw new IllegalArgumentException(msg);
    }

    @Override
    public String findPropertyName(String flexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("flexibleName", flexibleName);
        ColumnInfo columnInfoMap = this.getColumnInfoFlexibleMap().get(flexibleName);
        if (columnInfoMap != null) {
            return columnInfoMap.getPropertyName();
        }
        String tablePropertyName = this.getTablePropertyNameFlexibleMap().get(flexibleName);
        if (tablePropertyName != null) {
            return tablePropertyName;
        }
        String msg = "Not found property name by the flexible name: flexibleName=" + flexibleName;
        throw new IllegalArgumentException(msg);
    }

    protected <ENTITY extends Entity> void doAcceptPrimaryKeyMap(ENTITY entity, Map<String, ? extends Object> primaryKeyMap, Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap) {
        if (primaryKeyMap == null || primaryKeyMap.isEmpty()) {
            String msg = "The argument 'primaryKeyMap' should not be null or empty:";
            msg = msg + " primaryKeyMap=" + primaryKeyMap;
            throw new IllegalArgumentException(msg);
        }
        entity.clearModifiedPropertyNames();
        MapStringValueAnalyzer analyzer = new MapStringValueAnalyzer(primaryKeyMap);
        List<ColumnInfo> columnInfoList = this.getPrimaryUniqueInfo().getUniqueColumnList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnName = columnInfo.getColumnDbName();
            String propertyName = columnInfo.getPropertyName();
            String uncapPropName = this.initUncap(propertyName);
            Class<?> propertyType = columnInfo.getPropertyType();
            if (!analyzer.init(columnName, uncapPropName, propertyName)) continue;
            Object value = String.class.isAssignableFrom(propertyType) ? analyzer.analyzeString(propertyType) : (Number.class.isAssignableFrom(propertyType) ? analyzer.analyzeNumber(propertyType) : (Date.class.isAssignableFrom(propertyType) ? analyzer.analyzeDate(propertyType) : (Boolean.class.isAssignableFrom(propertyType) ? analyzer.analyzeBoolean(propertyType) : (byte[].class.isAssignableFrom(propertyType) ? analyzer.analyzeBinary(propertyType) : (UUID.class.isAssignableFrom(propertyType) ? analyzer.analyzeUUID(propertyType) : analyzer.analyzeOther(propertyType))))));
            this.findEps(entityPropertySetupperMap, propertyName).setup(entity, value);
        }
    }

    protected Map<String, Object> doExtractPrimaryKeyMap(Entity entity) {
        return this.doConvertToColumnValueMap(entity, true);
    }

    protected Map<String, Object> doExtractAllColumnMap(Entity entity) {
        return this.doConvertToColumnValueMap(entity, false);
    }

    protected Map<String, Object> doConvertToColumnValueMap(Entity entity, boolean pkOnly) {
        LinkedHashMap<String, Object> valueMap = this.newLinkedHashMap();
        List<ColumnInfo> columnInfoList = pkOnly ? this.getPrimaryUniqueInfo().getUniqueColumnList() : this.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnName = columnInfo.getColumnDbName();
            Object value = columnInfo.read(entity);
            valueMap.put(columnName, value);
        }
        return valueMap;
    }

    protected <ENTITY extends Entity> void setupEps(Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap, DBMeta.Eps<ENTITY> setupper, ColumnInfo columnInfo) {
        String columnName = columnInfo.getColumnDbName();
        String propertyName = columnInfo.getPropertyName();
        this.registerEntityPropertySetupper(columnName, propertyName, setupper, entityPropertySetupperMap);
    }

    protected <ENTITY extends Entity> void registerEntityPropertySetupper(String columnName, String propertyName, DBMeta.Eps<ENTITY> setupper, Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap) {
        entityPropertySetupperMap.put(columnName, setupper);
    }

    protected <ENTITY extends Entity> DBMeta.Eps<ENTITY> findEps(Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap, String propertyName) {
        DBMeta.Eps<ENTITY> setupper = entityPropertySetupperMap.get(propertyName);
        if (setupper == null) {
            String msg = "The propertyName was not found in the map of setupper of entity property:";
            msg = msg + " propertyName=" + propertyName + " _entityPropertySetupperMap.keySet()=" + entityPropertySetupperMap.keySet();
            throw new IllegalStateException(msg);
        }
        return setupper;
    }

    protected Classification gcls(ColumnInfo columnInfo, Object code) {
        this.assertObjectNotNull("columnInfo", columnInfo);
        if (code == null) {
            return null;
        }
        ClassificationMeta classificationMeta = columnInfo.getClassificationMeta();
        if (classificationMeta == null) {
            return null;
        }
        return classificationMeta.codeOf(code);
    }

    protected void ccls(ColumnInfo columnInfo, Object code) {
        this.assertObjectNotNull("columnInfo", columnInfo);
        if (code == null) {
            return;
        }
        Classification classification = this.gcls(columnInfo, code);
        if (classification == null) {
            this.throwIllegalClassificationCodeException(columnInfo, code);
        }
    }

    protected void throwIllegalClassificationCodeException(ColumnInfo columnInfo, Object code) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to get the classification by the code.");
        br.addItem("Advice");
        br.addElement("Please confirm the code value of the classication column on your database.");
        br.addElement("The code may NOT be one of classification code defined on DBFlute.");
        br.addItem("Code");
        br.addElement(code);
        br.addItem("Classication");
        br.addElement(columnInfo.getClassificationMeta());
        br.addItem("Table");
        br.addElement(this.getTableDbName());
        br.addItem("Column");
        br.addElement(columnInfo.getColumnDbName());
        String msg = br.buildExceptionMessage();
        throw new IllegalClassificationCodeException(msg);
    }

    protected Integer cti(Object value) {
        return DfTypeUtil.toInteger(value);
    }

    protected Long ctl(Object value) {
        return DfTypeUtil.toLong(value);
    }

    protected BigDecimal ctb(Object value) {
        return DfTypeUtil.toBigDecimal(value);
    }

    protected <NUMBER extends Number> NUMBER ctn(Object value, Class<NUMBER> type) {
        return (NUMBER)DfTypeUtil.toNumber(value, type);
    }

    protected <ENTITY> ENTITY downcast(Entity entity) {
        this.checkDowncast(entity);
        return (ENTITY)entity;
    }

    protected void checkDowncast(Entity entity) {
        this.assertObjectNotNull("entity", entity);
        Class<? extends Entity> entityType = this.getEntityType();
        Class<?> targetType = entity.getClass();
        if (!entityType.isAssignableFrom(targetType)) {
            String titleName = DfTypeUtil.toClassTitle(entityType);
            String msg = "The entity should be " + titleName + " but it was: " + targetType;
            throw new IllegalStateException(msg);
        }
    }

    protected Map<String, String> setupKeyToLowerMap(boolean dbNameKey) {
        ConcurrentHashMap<String, String> map = dbNameKey ? this.newConcurrentHashMap(this.getTableDbName().toLowerCase(), this.getTablePropertyName()) : this.newConcurrentHashMap(this.getTablePropertyName().toLowerCase(), this.getTableDbName());
        Method[] methods = this.getClass().getMethods();
        String columnInfoMethodPrefix = "column";
        try {
            for (Method method : methods) {
                String name = method.getName();
                if (!name.startsWith("column")) continue;
                ColumnInfo columnInfo = (ColumnInfo)method.invoke((Object)this, new Object[0]);
                String dbName = columnInfo.getColumnDbName();
                String propertyName = columnInfo.getPropertyName();
                if (dbNameKey) {
                    map.put(dbName.toLowerCase(), propertyName);
                    continue;
                }
                map.put(propertyName.toLowerCase(), dbName);
            }
            return Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected final List<String> splitListTrimmed(String str, String delimiter) {
        return Srl.splitListTrimmed(str, delimiter);
    }

    protected final String initCap(String str) {
        return Srl.initCap(str);
    }

    protected final String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected final String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    protected <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    protected <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap(KEY key, VALUE value) {
        ConcurrentHashMap<KEY, VALUE> map = this.newConcurrentHashMap();
        map.put(key, value);
        return map;
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(KEY key, VALUE value) {
        LinkedHashMap<KEY, VALUE> map = this.newLinkedHashMap();
        map.put(key, value);
        return map;
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return new ArrayList();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(ELEMENT element) {
        ArrayList<ELEMENT> arrayList = new ArrayList<ELEMENT>();
        arrayList.add(element);
        return arrayList;
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> collection) {
        return new ArrayList<ELEMENT>(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasMethod(String methodName) {
        this.assertStringNotNullAndNotTrimmedEmpty("methodName", methodName);
        if (this._methodNameMap.isEmpty()) {
            Map<String, Object> map = this._methodNameMap;
            synchronized (map) {
                if (this._methodNameMap.isEmpty()) {
                    Method[] methods;
                    for (Method method : methods = this.getClass().getMethods()) {
                        this._methodNameMap.put(method.getName(), DUMMY_VALUE);
                    }
                }
            }
        }
        return this._methodNameMap.containsKey(methodName);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        DfAssertUtil.assertObjectNotNull(variableName, value);
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfAssertUtil.assertStringNotNullAndNotTrimmedEmpty(variableName, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapStringValueAnalyzer {
        protected final Map<String, ? extends Object> _valueMap;
        protected String _columnName;
        protected String _uncapPropName;
        protected String _propertyName;

        public MapStringValueAnalyzer(Map<String, ? extends Object> valueMap) {
            this._valueMap = valueMap;
        }

        public boolean init(String columnName, String uncapPropName, String propertyName) {
            this._columnName = columnName;
            this._uncapPropName = uncapPropName;
            this._propertyName = propertyName;
            return this._valueMap.containsKey(this._columnName);
        }

        public <PROPERTY> PROPERTY analyzeString(Class<PROPERTY> javaType) {
            Object obj = this.getColumnValue();
            return (PROPERTY)DfTypeUtil.toString(obj);
        }

        public <PROPERTY> PROPERTY analyzeNumber(Class<PROPERTY> javaType) {
            Object obj = this.getColumnValue();
            return (PROPERTY)DfTypeUtil.toNumber(obj, javaType);
        }

        public <PROPERTY> PROPERTY analyzeDate(Class<PROPERTY> javaType) {
            Object obj = this.getColumnValue();
            if (Time.class.isAssignableFrom(javaType)) {
                return (PROPERTY)DfTypeUtil.toTime(obj);
            }
            if (Timestamp.class.isAssignableFrom(javaType)) {
                return (PROPERTY)DfTypeUtil.toTimestamp(obj);
            }
            return (PROPERTY)DfTypeUtil.toDate(obj);
        }

        public <PROPERTY> PROPERTY analyzeBoolean(Class<PROPERTY> javaType) {
            Object obj = this.getColumnValue();
            return (PROPERTY)DfTypeUtil.toBoolean(obj);
        }

        public <PROPERTY> PROPERTY analyzeBinary(Class<PROPERTY> javaType) {
            Object obj = this.getColumnValue();
            if (obj == null) {
                return null;
            }
            if (obj instanceof Serializable) {
                return (PROPERTY)DfTypeUtil.toBinary((Serializable)obj);
            }
            throw new UnsupportedOperationException("unsupported binary type: " + obj.getClass());
        }

        public <PROPERTY> PROPERTY analyzeUUID(Class<PROPERTY> javaType) {
            Object obj = this.getColumnValue();
            return (PROPERTY)DfTypeUtil.toUUID(obj);
        }

        public <PROPERTY> PROPERTY analyzeOther(Class<PROPERTY> javaType) {
            Object obj = this.getColumnValue();
            if (obj == null) {
                return null;
            }
            if (Classification.class.isAssignableFrom(javaType)) {
                Class[] argTypes = new Class[]{Object.class};
                Method method = DfReflectionUtil.getPublicMethod(javaType, "codeOf", argTypes);
                return (PROPERTY)DfReflectionUtil.invokeStatic(method, new Object[]{obj});
            }
            return (PROPERTY)obj;
        }

        protected Object getColumnValue() {
            Object value = this._valueMap.get(this._columnName);
            return this.filterClassificationValue(value);
        }

        protected Object filterClassificationValue(Object value) {
            if (value != null && value instanceof Classification) {
                value = ((Classification)value).code();
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractRelationTrace
    implements DBMeta.RelationTrace {
        protected List<RelationInfo> _relationList;
        protected List<AbstractRelationTrace> _relationTraceList;
        protected List<RelationInfo> _traceRelationInfoList;
        protected ColumnInfo _traceColumnInfo;
        protected DBMeta.RelationTraceFixHandler _relationTraceFixHandler;

        public AbstractRelationTrace(DBMeta.RelationTraceFixHandler relationTraceFixHandler) {
            this(new ArrayList<RelationInfo>(), new ArrayList<AbstractRelationTrace>());
            this._relationTraceFixHandler = relationTraceFixHandler;
        }

        public AbstractRelationTrace(List<RelationInfo> relationList, List<AbstractRelationTrace> relationTraceList) {
            this._relationList = relationList;
            this._relationTraceList = relationTraceList;
            this._relationTraceList.add(this);
        }

        @Override
        public List<RelationInfo> getTraceRelation() {
            return this._traceRelationInfoList;
        }

        @Override
        public ColumnInfo getTraceColumn() {
            return this._traceColumnInfo;
        }

        protected DBMeta.RelationTrace fixTrace(List<RelationInfo> traceRelationInfoList, ColumnInfo traceColumnInfo) {
            AbstractRelationTrace localRelationTrace = this._relationTraceList.get(0);
            localRelationTrace.setTraceRelation(traceRelationInfoList);
            localRelationTrace.setTraceColumn(traceColumnInfo);
            localRelationTrace.recycle();
            localRelationTrace.handleFixedRelationTrace();
            return localRelationTrace;
        }

        protected void setTraceRelation(List<RelationInfo> traceRelationInfoList) {
            this._traceRelationInfoList = traceRelationInfoList;
        }

        protected void setTraceColumn(ColumnInfo traceColumn) {
            this._traceColumnInfo = traceColumn;
        }

        protected void recycle() {
            this._relationList = new ArrayList<RelationInfo>();
            this._relationTraceList = new ArrayList<AbstractRelationTrace>();
            this._relationTraceList.add(this);
        }

        protected void handleFixedRelationTrace() {
            if (this._relationTraceFixHandler != null) {
                this._relationTraceFixHandler.handleFixedTrace(this);
            }
        }
    }
}

