/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.coption;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.util.DfTypeUtil;

public class FromToOption
implements ConditionOption,
Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean _greaterThan;
    protected boolean _lessThan;
    protected boolean _fromPatternDayStart;
    protected boolean _fromPatternMonthStart;
    protected boolean _fromPatternYearStart;
    protected boolean _fromDateWithNoon;
    protected Integer _fromDateWithHour;
    protected boolean _toPatternNextDayStart;
    protected boolean _toPatternNextMonthStart;
    protected boolean _toPatternNextYearStart;
    protected boolean _toDateWithNoon;
    protected Integer _toDateWithHour;
    protected boolean _usePattern;

    public String getRearOption() {
        String msg = "Thie option does not use getRearOption()!";
        throw new UnsupportedOperationException(msg);
    }

    public FromToOption compareAsDate() {
        this.fromPatternDayStart();
        this.toPatternNextDayStart();
        this.clearOperand();
        this.lessThan();
        this._usePattern = true;
        return this;
    }

    public FromToOption compareAsMonth() {
        this.fromPatternMonthStart();
        this.toPatternNextMonthStart();
        this.clearOperand();
        this.lessThan();
        this._usePattern = true;
        return this;
    }

    public FromToOption compareAsYear() {
        this.fromPatternYearStart();
        this.toPatternNextYearStart();
        this.clearOperand();
        this.lessThan();
        this._usePattern = true;
        return this;
    }

    protected void clearAll() {
        this.clearOperand();
        this.clearFromPattern();
        this.clearToPattern();
        this.clearFromDateWith();
        this.clearToDateWith();
        this._usePattern = false;
    }

    public FromToOption greaterThan() {
        this.assertNotAdjustmentAfterPattern("greaterThan");
        this._greaterThan = true;
        return this;
    }

    public FromToOption lessThan() {
        this.assertNotAdjustmentAfterPattern("lessThan");
        this._lessThan = true;
        return this;
    }

    protected void clearOperand() {
        this._greaterThan = false;
        this._lessThan = false;
    }

    public FromToOption fromPatternDayStart() {
        this.assertNotAdjustmentAfterPattern("fromPatternDayStart");
        this.clearFromPattern();
        this._fromPatternDayStart = true;
        return this;
    }

    public FromToOption fromPatternMonthStart() {
        this.assertNotAdjustmentAfterPattern("fromPatternMonthStart");
        this.clearFromPattern();
        this._fromPatternMonthStart = true;
        return this;
    }

    public FromToOption fromPatternYearStart() {
        this.assertNotAdjustmentAfterPattern("fromPatternYearStart");
        this.clearFromPattern();
        this._fromPatternYearStart = true;
        return this;
    }

    protected void clearFromPattern() {
        this._fromPatternDayStart = false;
        this._fromPatternMonthStart = false;
        this._fromPatternYearStart = false;
    }

    public FromToOption fromDateWithNoon() {
        this.clearFromDateWith();
        this._fromDateWithNoon = true;
        return this;
    }

    public FromToOption fromDateWithHour(int hourOfDay) {
        this.clearFromDateWith();
        this._fromDateWithHour = hourOfDay;
        return this;
    }

    protected void clearFromDateWith() {
        this._fromDateWithNoon = false;
        this._fromDateWithHour = null;
    }

    public FromToOption toPatternNextDayStart() {
        this.assertNotAdjustmentAfterPattern("toPatternNextDayStart");
        this.clearToPattern();
        this._toPatternNextDayStart = true;
        return this;
    }

    public FromToOption toPatternNextMonthStart() {
        this.assertNotAdjustmentAfterPattern("toPatternNextMonthStart");
        this.clearToPattern();
        this._toPatternNextMonthStart = true;
        return this;
    }

    public FromToOption toPatternNextYearStart() {
        this.assertNotAdjustmentAfterPattern("toPatternNextYearStart");
        this.clearToPattern();
        this._toPatternNextYearStart = true;
        return this;
    }

    protected void clearToPattern() {
        this._toPatternNextDayStart = false;
        this._toPatternNextMonthStart = false;
        this._toPatternNextYearStart = false;
    }

    public FromToOption toDateWithNoon() {
        this.clearToDateWith();
        this._toDateWithNoon = true;
        return this;
    }

    public FromToOption toDateWithHour(int hourOfDay) {
        this.clearToDateWith();
        this._toDateWithHour = hourOfDay;
        return this;
    }

    protected void clearToDateWith() {
        this._toDateWithNoon = false;
        this._toDateWithHour = null;
    }

    protected void assertNotAdjustmentAfterPattern(String option) {
        if (this._usePattern) {
            String msg = "The option should not be call after pattern setting:";
            msg = msg + " option=" + option + "()";
            throw new IllegalStateException(msg);
        }
    }

    public Date filterFromDate(Date fromDate) {
        if (fromDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(fromDate.getTime());
        if (this._fromPatternDayStart) {
            this.moveToCalendarDayStart(cal);
        } else if (this._fromPatternMonthStart) {
            this.moveToCalendarMonthStart(cal);
        } else if (this._fromPatternYearStart) {
            this.moveToCalendarYearStart(cal);
        }
        if (this._fromDateWithNoon) {
            this.moveToNoon(cal);
        }
        if (this._fromDateWithHour != null) {
            this.moveToHour(cal, this._fromDateWithHour);
        }
        Date cloneDate = (Date)fromDate.clone();
        cloneDate.setTime(cal.getTimeInMillis());
        fromDate = cloneDate;
        return fromDate;
    }

    public Date filterToDate(Date toDate) {
        if (toDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(toDate.getTime());
        if (this._toPatternNextDayStart) {
            this.moveToCalendarNextDayStart(cal);
        } else if (this._toPatternNextMonthStart) {
            this.moveToCalendarNextMonthStart(cal);
        } else if (this._toPatternNextYearStart) {
            this.moveToCalendarNextYearStart(cal);
        }
        if (this._toDateWithNoon) {
            this.moveToNoon(cal);
        }
        if (this._toDateWithHour != null) {
            this.moveToHour(cal, this._toDateWithHour);
        }
        Date cloneDate = (Date)toDate.clone();
        cloneDate.setTime(cal.getTimeInMillis());
        toDate = cloneDate;
        return toDate;
    }

    protected Date filterNoon(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        this.moveToNoon(cal);
        Date cloneDate = (Date)date.clone();
        cloneDate.setTime(cal.getTimeInMillis());
        return cloneDate;
    }

    public ConditionKey getFromDateConditionKey() {
        if (this._greaterThan) {
            return ConditionKey.CK_GREATER_THAN;
        }
        return ConditionKey.CK_GREATER_EQUAL;
    }

    public ConditionKey getToDateConditionKey() {
        if (this._lessThan) {
            return ConditionKey.CK_LESS_THAN;
        }
        return ConditionKey.CK_LESS_EQUAL;
    }

    protected void addCalendarNextDay(Calendar cal) {
        cal.add(5, 1);
    }

    protected void addCalendarNextMonth(Calendar cal) {
        cal.add(2, 1);
    }

    protected void addCalendarNextYear(Calendar cal) {
        cal.add(1, 1);
    }

    protected void moveToCalendarDayStart(Calendar cal) {
        this.clearCalendarHourMinuteSecondMilli(cal);
    }

    protected void moveToCalendarNextDayStart(Calendar cal) {
        this.addCalendarNextDay(cal);
        this.moveToCalendarDayStart(cal);
    }

    protected void moveToCalendarMonthStart(Calendar cal) {
        cal.set(5, cal.getActualMinimum(5));
        this.clearCalendarHourMinuteSecondMilli(cal);
    }

    protected void moveToCalendarNextMonthStart(Calendar cal) {
        this.addCalendarNextMonth(cal);
        this.moveToCalendarMonthStart(cal);
    }

    protected void moveToCalendarYearStart(Calendar cal) {
        cal.set(2, cal.getActualMinimum(2));
        cal.set(5, cal.getActualMinimum(5));
        this.clearCalendarHourMinuteSecondMilli(cal);
    }

    protected void moveToCalendarNextYearStart(Calendar cal) {
        this.addCalendarNextYear(cal);
        this.moveToCalendarYearStart(cal);
    }

    protected void moveToNoon(Calendar cal) {
        cal.clear(14);
        cal.clear(13);
        cal.clear(12);
        cal.set(11, 12);
    }

    protected void moveToHour(Calendar cal, int hourOfDay) {
        cal.clear(14);
        cal.clear(13);
        cal.clear(12);
        cal.set(11, hourOfDay);
    }

    protected void clearCalendarHourMinuteSecondMilli(Calendar cal) {
        cal.clear(14);
        cal.clear(13);
        cal.clear(12);
        cal.set(11, cal.getActualMinimum(11));
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        return title + ":{greaterThan=" + this._greaterThan + ", lessThan=" + this._lessThan + ", usePattern=" + this._usePattern + "}";
    }
}

