/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import java.util.Set;
import javax.sql.DataSource;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnUpdateAutoDynamicCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnUpdateModifiedOnlyCommand
extends TnUpdateAutoDynamicCommand {
    public TnUpdateModifiedOnlyCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    protected TnPropertyType[] createUpdatePropertyTypes(TnBeanMetaData bmd, Object bean, String[] propertyNames, UpdateOption<ConditionBean> option) {
        Set<String> modifiedPropertyNames = this.getBeanMetaData().getModifiedPropertyNames(bean);
        ArrayList<TnPropertyType> types = new ArrayList<TnPropertyType>();
        String timestampProp = bmd.getTimestampPropertyName();
        String versionNoProp = bmd.getVersionNoPropertyName();
        for (int i = 0; i < propertyNames.length; ++i) {
            TnPropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey()) continue;
            String propertyName = pt.getPropertyName();
            String columnDbName = pt.getColumnDbName();
            if (!this.isOptimisticLockProperty(timestampProp, versionNoProp, propertyName) && !this.isModifiedProperty(modifiedPropertyNames, propertyName) && !this.isStatementProperty(option, columnDbName)) continue;
            types.add(pt);
        }
        TnPropertyType[] propertyTypes = types.toArray(new TnPropertyType[types.size()]);
        return propertyTypes;
    }

    protected boolean isOptimisticLockProperty(String timestampProp, String versionNoProp, String propertyName) {
        return propertyName.equalsIgnoreCase(timestampProp) || propertyName.equalsIgnoreCase(versionNoProp);
    }

    protected boolean isStatementProperty(UpdateOption<ConditionBean> option, String columnDbName) {
        return option != null && option.hasStatement(columnDbName);
    }

    protected boolean isModifiedProperty(Set<?> modifiedPropertyNames, String propertyName) {
        return modifiedPropertyNames.contains(propertyName);
    }
}

