/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task.replaceschema;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.logic.replaceschema.loaddata.DfDelimiterDataResultInfo;
import org.seasar.dbflute.logic.replaceschema.loaddata.DfDelimiterDataSeveralHandlingInfo;
import org.seasar.dbflute.logic.replaceschema.loaddata.impl.DfDelimiterDataHandlerImpl;
import org.seasar.dbflute.logic.replaceschema.loaddata.impl.DfXlsDataHandlerImpl;
import org.seasar.dbflute.logic.replaceschema.loaddata.impl.DfXlsDataHandlerSQLServer;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfReplaceSchemaProperties;
import org.seasar.dbflute.task.replaceschema.DfAbstractReplaceSchemaTask;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfLoadDataTask
extends DfAbstractReplaceSchemaTask {
    private static final Log _log = LogFactory.getLog(DfLoadDataTask.class);
    protected static final String LOG_PATH = "./log/load-data.log";
    protected boolean _validTaskEndInformation = true;
    protected DfXlsDataHandlerImpl _xlsDataHandlerImpl;
    protected DfDelimiterDataHandlerImpl _delimiterDataHandlerImpl;

    @Override
    protected void doExecute() {
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * * *");
        _log.info((Object)"*                   *");
        _log.info((Object)"* Load Data         *");
        _log.info((Object)"*                   *");
        _log.info((Object)"* * * * * * * * * * *");
        this.writeDbFromDelimiterFileAsCommonData("tsv", "\t");
        this.writeDbFromDelimiterFileAsCommonData("csv", ",");
        this.writeDbFromXlsAsCommonData();
        this.writeDbFromXlsAsCommonDataAdditional();
        this.writeDbFromDelimiterFileAsLoadingTypeData("tsv", "\t");
        this.writeDbFromDelimiterFileAsLoadingTypeData("csv", ",");
        this.writeDbFromXlsAsLoadingTypeData();
        this.writeDbFromXlsAsLoadingTypeDataAdditional();
    }

    @Override
    protected boolean isValidTaskEndInformation() {
        return this._validTaskEndInformation;
    }

    protected String getDataLoadingType() {
        return this.getMyProperties().getDataLoadingType();
    }

    public boolean isLoggingInsertSql() {
        return this.getMyProperties().isLoggingInsertSql();
    }

    public boolean isSuppressBatchUpdate() {
        return this.getMyProperties().isSuppressBatchUpdate();
    }

    protected DfReplaceSchemaProperties getMyProperties() {
        return DfBuildProperties.getInstance().getReplaceSchemaProperties();
    }

    protected void writeDbFromDelimiterFileAsCommonData(String typeName, String delimter) {
        String dir = this.getMyProperties().getReplaceSchemaPlaySqlDirectory();
        String path = this.doGetCommonDataDirectoryPath(dir, typeName);
        this.writeDbFromDelimiterFile(path, typeName, delimter);
    }

    protected void writeDbFromDelimiterFileAsLoadingTypeData(String typeName, String delimter) {
        String dir = this.getMyProperties().getReplaceSchemaPlaySqlDirectory();
        String envType = this.getDataLoadingType();
        String path = this.doGetLoadingTypeDataDirectoryPath(dir, envType, typeName);
        this.writeDbFromDelimiterFile(path, typeName, delimter);
    }

    protected void writeDbFromDelimiterFile(String directoryPath, String typeName, String delimter) {
        DfDelimiterDataHandlerImpl handler = this.getDelimiterDataHandlerImpl();
        DfDelimiterDataSeveralHandlingInfo handlingInfo = new DfDelimiterDataSeveralHandlingInfo();
        handlingInfo.setBasePath(directoryPath);
        handlingInfo.setTypeName(typeName);
        handlingInfo.setDelimter(delimter);
        handlingInfo.setErrorContinue(true);
        DfDelimiterDataResultInfo resultInfo = handler.writeSeveralData(handlingInfo);
        this.showNotFoundColumn(typeName, resultInfo.getNotFoundColumnMap());
    }

    protected DfDelimiterDataHandlerImpl getDelimiterDataHandlerImpl() {
        if (this._delimiterDataHandlerImpl != null) {
            return this._delimiterDataHandlerImpl;
        }
        DfDelimiterDataHandlerImpl handler = new DfDelimiterDataHandlerImpl();
        handler.setLoggingInsertSql(this.isLoggingInsertSql());
        handler.setDataSource(this.getDataSource());
        handler.setUnifiedSchema(this._mainSchema);
        handler.setSuppressBatchUpdate(this.isSuppressBatchUpdate());
        this._delimiterDataHandlerImpl = handler;
        return this._delimiterDataHandlerImpl;
    }

    protected void showNotFoundColumn(String typeName, Map<String, Set<String>> notFoundColumnMap) {
        if (notFoundColumnMap.isEmpty()) {
            return;
        }
        _log.warn((Object)"* * * * * * * * * * * * * * *");
        _log.warn((Object)("Not Persistent Columns in " + typeName));
        _log.warn((Object)"* * * * * * * * * * * * * * *");
        Set<Map.Entry<String, Set<String>>> entrySet = notFoundColumnMap.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            String tableName = entry.getKey();
            Set<String> columnNameSet = entry.getValue();
            _log.warn((Object)("[" + tableName + "]"));
            for (String columnName : columnNameSet) {
                _log.warn((Object)("    " + columnName));
            }
            _log.warn((Object)" ");
        }
    }

    protected void writeDbFromXlsAsCommonData() {
        String dir = this.getMyProperties().getReplaceSchemaPlaySqlDirectory();
        String path = this.doGetCommonDataDirectoryPath(dir, "xls");
        this.writeDbFromXls(path);
    }

    protected void writeDbFromXlsAsCommonDataAdditional() {
        String dir = this.getMyProperties().getApplicationPlaySqlDirectory();
        if (Srl.is_Null_or_TrimmedEmpty((String)dir)) {
            return;
        }
        String path = this.doGetCommonDataDirectoryPath(dir, "xls");
        this.writeDbFromXls(path);
    }

    protected void writeDbFromXlsAsLoadingTypeData() {
        String dir = this.getMyProperties().getReplaceSchemaPlaySqlDirectory();
        String envType = this.getDataLoadingType();
        String path = this.doGetLoadingTypeDataDirectoryPath(dir, envType, "xls");
        this.writeDbFromXls(path);
    }

    protected void writeDbFromXlsAsLoadingTypeDataAdditional() {
        String dir = this.getMyProperties().getApplicationPlaySqlDirectory();
        if (Srl.is_Null_or_TrimmedEmpty((String)dir)) {
            return;
        }
        String envType = this.getDataLoadingType();
        String path = this.doGetLoadingTypeDataDirectoryPath(dir, envType, "xls");
        this.writeDbFromXls(path);
    }

    protected void writeDbFromXls(String directoryPath) {
        DfXlsDataHandlerImpl xlsDataHandler = this.getXlsDataHandlerImpl();
        xlsDataHandler.writeSeveralData(directoryPath);
    }

    protected DfXlsDataHandlerImpl getXlsDataHandlerImpl() {
        if (this._xlsDataHandlerImpl != null) {
            return this._xlsDataHandlerImpl;
        }
        DfBasicProperties basicProperties = DfBuildProperties.getInstance().getBasicProperties();
        DfXlsDataHandlerImpl xlsDataHandler = basicProperties.isDatabaseSQLServer() ? new DfXlsDataHandlerSQLServer(this.getDataSource()) : new DfXlsDataHandlerImpl(this.getDataSource());
        xlsDataHandler.setUnifiedSchema(this._mainSchema);
        xlsDataHandler.setLoggingInsertSql(this.isLoggingInsertSql());
        xlsDataHandler.setSuppressBatchUpdate(this.isSuppressBatchUpdate());
        xlsDataHandler.setSkipSheet(this.getMyProperties().getSkipSheet());
        this._xlsDataHandlerImpl = xlsDataHandler;
        return this._xlsDataHandlerImpl;
    }

    protected String doGetCommonDataDirectoryPath(String dir, String typeName) {
        return this.getMyProperties().getCommonDataDirectoryPath(dir, typeName);
    }

    protected String doGetLoadingTypeDataDirectoryPath(String dir, String envType, String typeName) {
        return this.getMyProperties().getLoadingTypeDataDirectoryPath(dir, envType, typeName);
    }

    public void setValidTaskEndInformation(String validTaskEndInformation) {
        this._validTaskEndInformation = validTaskEndInformation != null && validTaskEndInformation.trim().equalsIgnoreCase("true");
    }
}

