/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.pmbean;

import java.util.List;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.exception.DfParameterBeanReferenceColumnNotFoundException;
import org.seasar.dbflute.exception.DfParameterBeanReferenceTableNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbPropertyOptionFinder;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfPmbPropertyOptionReference {
    protected static final String OPTION_PREFIX = "ref(";
    protected static final String OPTION_SUFFIX = ")";
    protected String _className;
    protected String _propertyName;
    protected DfPmbPropertyOptionFinder _pmbMetaDataPropertyOptionFinder;

    public DfPmbPropertyOptionReference(String className, String propertyName, DfPmbPropertyOptionFinder pmbMetaDataPropertyOptionFinder) {
        this._className = className;
        this._propertyName = propertyName;
        this._pmbMetaDataPropertyOptionFinder = pmbMetaDataPropertyOptionFinder;
    }

    public Column getPmbMetaDataPropertyOptionReferenceColumn(AppData appData) {
        Column column;
        String columnName;
        String tableName;
        Database database;
        if (appData == null) {
            return null;
        }
        try {
            database = appData.getDatabase();
        }
        catch (EngineException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        if (database == null) {
            return null;
        }
        String refPrefix = OPTION_PREFIX;
        String refSuffix = OPTION_SUFFIX;
        String optionExp = this.getPmbMetaDataPropertyOption();
        if (optionExp == null) {
            return null;
        }
        List<String> splitOption = this.splitOption(optionExp);
        String firstOption = null;
        for (String element : splitOption) {
            if (!(element = element.trim()).startsWith(OPTION_PREFIX) || !element.endsWith(OPTION_SUFFIX)) continue;
            firstOption = element;
            break;
        }
        if (firstOption == null) {
            return null;
        }
        String option = firstOption;
        Srl.ScopeInfo scope = Srl.extractScopeFirst(option, (String)OPTION_PREFIX, (String)OPTION_SUFFIX);
        String content = scope.getContent().trim();
        String delimiter = ".";
        if (content.contains(".")) {
            tableName = Srl.substringFirstFront((String)content, (String[])new String[]{"."});
            columnName = Srl.substringFirstRear((String)content, (String[])new String[]{"."});
        } else {
            tableName = content;
            columnName = null;
        }
        Table table = database.getTable(tableName);
        if (table == null) {
            this.throwParameterBeanReferenceTableNotFoundException(option, this._className, this._propertyName, tableName);
        }
        if ((column = columnName != null ? table.getColumn(columnName) : table.getColumn(this._propertyName)) == null) {
            this.throwParameterBeanReferenceColumnNotFoundException(option, this._className, this._propertyName, tableName, columnName);
        }
        return column;
    }

    protected void throwParameterBeanReferenceTableNotFoundException(String option, String className, String propertyName, String tableName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The reference table for parameter-bean property was not found!");
        br.addItem("Advice");
        br.addElement((Object)"Please confirm the table existence.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    -- !!String memberName:ref(NOT_EXIST.MEMBER_NAME)!!");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    -- !!String memberName:ref(MEMBER.MEMBER_NAME)!!");
        br.addItem("ParameterBean");
        br.addElement((Object)className);
        br.addItem("Property");
        br.addElement((Object)propertyName);
        br.addItem("NotFound Table");
        br.addElement((Object)tableName);
        br.addItem("Option");
        br.addElement((Object)option);
        String msg = br.buildExceptionMessage();
        throw new DfParameterBeanReferenceTableNotFoundException(msg);
    }

    protected void throwParameterBeanReferenceColumnNotFoundException(String option, String className, String propertyName, String tableName, String columnName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The reference column for parameter-bean property was not found!");
        br.addItem("Advice");
        br.addElement((Object)"Please confirm the column existence.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    -- !!String memberName:ref(MEMBER.NOT_EXIST_NAME)!!");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    -- !!String memberName:ref(MEMBER.MEMBER_NAME)!!");
        br.addItem("ParameterBean");
        br.addElement((Object)className);
        br.addItem("Property");
        br.addElement((Object)propertyName);
        br.addItem("Table");
        br.addElement((Object)tableName);
        br.addItem("NotFound Column");
        br.addElement((Object)columnName);
        br.addItem("Option");
        br.addElement((Object)option);
        String msg = br.buildExceptionMessage();
        throw new DfParameterBeanReferenceColumnNotFoundException(msg);
    }

    protected String getPmbMetaDataPropertyOption() {
        return this._pmbMetaDataPropertyOptionFinder.findPmbMetaDataPropertyOption(this._className, this._propertyName);
    }

    protected List<String> splitOption(String option) {
        return DfPmbPropertyOptionFinder.splitOption(option);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

