/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.takefinally.sequence.factory;

import java.util.List;
import javax.sql.DataSource;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.logic.replaceschema.takefinally.sequence.DfSequenceHandler;
import org.seasar.dbflute.logic.replaceschema.takefinally.sequence.DfSequenceHandlerDB2;
import org.seasar.dbflute.logic.replaceschema.takefinally.sequence.DfSequenceHandlerH2;
import org.seasar.dbflute.logic.replaceschema.takefinally.sequence.DfSequenceHandlerOracle;
import org.seasar.dbflute.logic.replaceschema.takefinally.sequence.DfSequenceHandlerPostgreSQL;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSequenceHandlerFactory {
    protected DataSource _dataSource;
    protected DfBasicProperties _basicProperties;
    protected DfDatabaseProperties _databaseProperties;

    public DfSequenceHandlerFactory(DataSource dataSource, DfBasicProperties basicProperties, DfDatabaseProperties databaseProperties) {
        this._dataSource = dataSource;
        this._basicProperties = basicProperties;
        this._databaseProperties = databaseProperties;
    }

    public DfSequenceHandler createSequenceHandler() {
        List<UnifiedSchema> targetSchemaList = this.createTargetSchemaList();
        if (this._basicProperties.isDatabasePostgreSQL()) {
            return new DfSequenceHandlerPostgreSQL(this._dataSource, targetSchemaList);
        }
        if (this._basicProperties.isDatabaseOracle()) {
            return new DfSequenceHandlerOracle(this._dataSource, targetSchemaList);
        }
        if (this._basicProperties.isDatabaseDB2()) {
            return new DfSequenceHandlerDB2(this._dataSource, targetSchemaList);
        }
        if (this._basicProperties.isDatabaseH2()) {
            return new DfSequenceHandlerH2(this._dataSource, targetSchemaList);
        }
        return null;
    }

    protected List<UnifiedSchema> createTargetSchemaList() {
        return this._databaseProperties.getTargetSchemaList();
    }
}

