/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.loaddata.impl;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbsractDataWriter {
    protected DataSource _dataSource;
    protected UnifiedSchema _unifiedSchema;
    protected boolean _loggingInsertSql;
    protected boolean _suppressBatchUpdate;
    protected final DfColumnHandler _columnHandler = new DfColumnHandler();
    protected final Map<String, Map<String, DfColumnMetaInfo>> _metaInfoCacheMap = StringKeyMap.createAsFlexibleOrdered();
    protected final Map<String, Map<String, Class<?>>> _bindTypeCacheMap = StringKeyMap.createAsFlexibleOrdered();
    protected final Map<String, Map<String, StringProcessor>> _stringProcessorCacheMap = StringKeyMap.createAsFlexibleOrdered();
    protected final List<StringProcessor> _stringProcessorList = DfCollectionUtil.newArrayList();
    protected final Map<String, Map<String, Integer>> _nullTypeCacheMap;

    public DfAbsractDataWriter(DataSource dataSource) {
        this._stringProcessorList.add(new DateStringProcessor());
        this._stringProcessorList.add(new BooleanStringProcessor());
        this._stringProcessorList.add(new NumberStringProcessor());
        this._stringProcessorList.add(new UUIDStringProcessor());
        this._stringProcessorList.add(new ArrayStringProcessor());
        this._stringProcessorList.add(new XmlStringProcessor());
        this._stringProcessorList.add(new RealStringProcessor());
        this._nullTypeCacheMap = StringKeyMap.createAsFlexibleOrdered();
        this._dataSource = dataSource;
    }

    protected boolean processNull(String tableName, String columnName, Object value, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        Integer cachedType;
        if (!this.isNullValue(value)) {
            return false;
        }
        StringKeyMap cacheMap = this._nullTypeCacheMap.get(tableName);
        if (cacheMap == null) {
            cacheMap = StringKeyMap.createAsFlexibleOrdered();
            this._nullTypeCacheMap.put(tableName, (Map<String, Integer>)cacheMap);
        }
        if ((cachedType = (Integer)cacheMap.get(columnName)) != null) {
            ps.setNull(bindCount, cachedType);
            return true;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null) {
            String mappedJdbcType = this._columnHandler.getColumnJdbcType(columnMetaInfo);
            Integer mappedJdbcDefValue = TypeMap.getJdbcDefValueByJdbcType(mappedJdbcType);
            try {
                ps.setNull(bindCount, mappedJdbcDefValue);
                cacheMap.put(columnName, mappedJdbcDefValue);
            }
            catch (SQLException e) {
                int plainJdbcDefValue = columnMetaInfo.getJdbcDefValue();
                try {
                    ps.setNull(bindCount, plainJdbcDefValue);
                    cacheMap.put(columnName, plainJdbcDefValue);
                }
                catch (SQLException ignored) {
                    ExceptionMessageBuilder br = new ExceptionMessageBuilder();
                    br.addNotice("Failed to execute setNull(bindCount, jdbcDefValue).");
                    br.addItem("Column");
                    br.addElement((Object)(tableName + "." + columnName));
                    br.addElement((Object)columnMetaInfo.toString());
                    br.addItem("Mapped JDBC Type");
                    br.addElement((Object)mappedJdbcType);
                    br.addItem("First JDBC Def-Value");
                    br.addElement((Object)mappedJdbcDefValue);
                    br.addItem("Retry JDBC Def-Value");
                    br.addElement((Object)plainJdbcDefValue);
                    br.addItem("Retry Message");
                    br.addElement((Object)ignored.getMessage());
                    String msg = br.buildExceptionMessage();
                    throw new DfJDBCException(msg, e);
                }
            }
        } else {
            Integer tryType = 12;
            try {
                ps.setNull(bindCount, tryType);
                cacheMap.put(columnName, tryType);
            }
            catch (SQLException e) {
                tryType = 2;
                try {
                    ps.setNull(bindCount, tryType);
                    cacheMap.put(columnName, tryType);
                }
                catch (SQLException ignored) {
                    tryType = 93;
                    try {
                        ps.setNull(bindCount, tryType);
                        cacheMap.put(columnName, tryType);
                    }
                    catch (SQLException iignored) {
                        tryType = 1111;
                        try {
                            ps.setNull(bindCount, tryType);
                            cacheMap.put(columnName, tryType);
                        }
                        catch (SQLException iiignored) {
                            throw e;
                        }
                    }
                }
            }
        }
        return true;
    }

    protected boolean isNullValue(Object value) {
        return value == null;
    }

    protected boolean processNotNullNotString(String tableName, String columnName, Object obj, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        Class<?> columnType;
        if (!this.isNotNullNotString(obj)) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && (columnType = this.getBindType(tableName, columnMetaInfo)) != null) {
            this.bindNotNullValueByColumnType(tableName, columnName, conn, ps, bindCount, obj, columnType);
            return true;
        }
        this.bindNotNullValueByInstance(tableName, columnName, conn, ps, bindCount, obj);
        return true;
    }

    protected boolean isNotNullNotString(Object obj) {
        return obj != null && !(obj instanceof String);
    }

    protected void processNotNullString(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        StringProcessor processor;
        if (value == null) {
            String msg = "This method is only for NotNull and StringExpression:";
            msg = msg + " value=" + value + " type=" + (value != null ? value.getClass() : "null");
            throw new IllegalStateException(msg);
        }
        value = Srl.unquoteDouble((String)value);
        StringKeyMap cacheMap = this._stringProcessorCacheMap.get(tableName);
        if (cacheMap == null) {
            cacheMap = StringKeyMap.createAsFlexibleOrdered();
            this._stringProcessorCacheMap.put(tableName, (Map<String, StringProcessor>)cacheMap);
        }
        if ((processor = (StringProcessor)cacheMap.get(columnName)) != null) {
            boolean processed = processor.process(tableName, columnName, value, conn, ps, bindCount, columnMetaInfoMap);
            if (!processed) {
                this.throwColumnValueProcessingFailureException(processor, tableName, columnName, value);
            }
            return;
        }
        for (StringProcessor tryProcessor : this._stringProcessorList) {
            if (!tryProcessor.process(tableName, columnName, value, conn, ps, bindCount, columnMetaInfoMap)) continue;
            cacheMap.put(columnName, tryProcessor);
            break;
        }
    }

    protected void throwColumnValueProcessingFailureException(StringProcessor processor, String tableName, String columnName, String value) throws SQLException {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The column value could not be treated by the processor.");
        br.addItem("Advice");
        br.addElement((Object)"The column has string expressions judging the type of the column");
        br.addElement((Object)"by analyzing the value of first record.");
        br.addElement((Object)"But the value of second or more record did not match the type.");
        br.addElement((Object)"So confirm your expressions.");
        br.addItem("Table Name");
        br.addElement((Object)tableName);
        br.addItem("Column Name");
        br.addElement((Object)columnName);
        br.addItem("String Expression");
        br.addElement((Object)value);
        br.addItem("Processor");
        br.addElement((Object)processor);
        String msg = br.buildExceptionMessage();
        throw new DfJDBCException(msg);
    }

    protected String buildProcessorToString(StringProcessor processor) {
        return DfTypeUtil.toClassTitle((Object)processor);
    }

    protected boolean processDate(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        Class<?> columnType;
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && (columnType = this.getBindType(tableName, columnMetaInfo)) != null) {
            if (!Date.class.isAssignableFrom(columnType)) {
                return false;
            }
            this.bindNotNullValueByColumnType(tableName, columnName, conn, ps, bindCount, value, columnType);
            return true;
        }
        try {
            Timestamp timestamp = DfTypeUtil.toTimestamp((Object)value);
            ps.setTimestamp(bindCount, timestamp);
            return true;
        }
        catch (DfTypeUtil.ParseTimestampException ignored) {
            try {
                Time time = DfTypeUtil.toTime((Object)value);
                ps.setTime(bindCount, time);
                return true;
            }
            catch (DfTypeUtil.ParseTimeException ignored2) {
                return false;
            }
        }
    }

    protected boolean processBoolean(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        Class<?> columnType;
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && (columnType = this.getBindType(tableName, columnMetaInfo)) != null) {
            if (!Boolean.class.isAssignableFrom(columnType)) {
                return false;
            }
            this.bindNotNullValueByColumnType(tableName, columnName, conn, ps, bindCount, value, columnType);
            return true;
        }
        try {
            Boolean booleanValue = DfTypeUtil.toBoolean((Object)value);
            ps.setBoolean(bindCount, booleanValue);
            return true;
        }
        catch (DfTypeUtil.ParseBooleanException ignored) {
            return false;
        }
    }

    protected boolean processNumber(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        Class<?> columnType;
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && (columnType = this.getBindType(tableName, columnMetaInfo)) != null) {
            if (!Number.class.isAssignableFrom(columnType)) {
                return false;
            }
            this.bindNotNullValueByColumnType(tableName, columnName, conn, ps, bindCount, value, columnType);
            return true;
        }
        if (!this.isBigDecimalValue(value = this.filterBigDecimalValue(value))) {
            return false;
        }
        BigDecimal bigDecimalValue = this.getBigDecimalValue(columnName, value);
        try {
            long longValue = bigDecimalValue.longValueExact();
            ps.setLong(bindCount, longValue);
            return true;
        }
        catch (ArithmeticException e) {
            ps.setBigDecimal(bindCount, bigDecimalValue);
            return true;
        }
    }

    protected String filterBigDecimalValue(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        return value;
    }

    protected boolean isBigDecimalValue(String value) {
        if (value == null) {
            return false;
        }
        try {
            new BigDecimal(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected BigDecimal getBigDecimalValue(String columnName, String value) {
        try {
            return new BigDecimal(value);
        }
        catch (RuntimeException e) {
            String msg = "The value should be big decimal: ";
            msg = msg + " columnName=" + columnName + " value=" + value;
            throw new IllegalStateException(msg, e);
        }
    }

    protected boolean processUUID(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        Class<?> columnType;
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && (columnType = this.getBindType(tableName, columnMetaInfo)) != null) {
            if (!UUID.class.isAssignableFrom(columnType)) {
                return false;
            }
            this.bindNotNullValueByColumnType(tableName, columnName, conn, ps, bindCount, value, columnType);
            return true;
        }
        return false;
    }

    protected String filterUUIDValue(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        return value;
    }

    protected boolean processArray(String tableName, String columnName, String value, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && this.getBasicProperties().isDatabasePostgreSQL()) {
            int jdbcDefValue = columnMetaInfo.getJdbcDefValue();
            String dbTypeName = columnMetaInfo.getDbTypeName();
            if (jdbcDefValue != 2003 || !dbTypeName.startsWith("_")) {
                return false;
            }
            value = this.filterArrayValue(value);
            ps.setObject(bindCount, (Object)value, 1111);
            return true;
        }
        return false;
    }

    protected String filterArrayValue(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        return value;
    }

    protected boolean processXml(String tableName, String columnName, String value, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && this.getBasicProperties().isDatabasePostgreSQL()) {
            String dbTypeName = columnMetaInfo.getDbTypeName();
            if (!dbTypeName.startsWith("xml")) {
                return false;
            }
            value = this.filterXmlValue(value);
            ps.setObject(bindCount, (Object)value, 1111);
            return true;
        }
        return false;
    }

    protected String filterXmlValue(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        return value;
    }

    protected void bindNotNullValueByColumnType(String tableName, String columnName, Connection conn, PreparedStatement ps, int bindCount, Object value, Class<?> bindType) throws SQLException {
        ValueType valueType = TnValueTypes.getValueType(bindType);
        try {
            valueType.bindValue(conn, ps, bindCount, value);
        }
        catch (SQLException e) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
            msg = msg + "Failed to bind the value!" + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Column]" + this.ln() + tableName + "." + columnName + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Bind Type]" + this.ln() + bindType + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Value Type]" + this.ln() + valueType + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Bound Value]" + this.ln() + value + this.ln();
            msg = msg + "- - - - - - - - - -/";
            throw new DfJDBCException(msg, e);
        }
    }

    protected void bindNotNullValueByInstance(String tableName, String columnName, Connection conn, PreparedStatement ps, int bindCount, Object obj) throws SQLException {
        this.bindNotNullValueByColumnType(tableName, columnName, conn, ps, bindCount, obj, obj.getClass());
    }

    protected Class<?> getBindType(String tableName, DfColumnMetaInfo columnMetaInfo) {
        String columnName;
        Class bindType;
        StringKeyMap cacheMap = this._bindTypeCacheMap.get(tableName);
        if (cacheMap == null) {
            cacheMap = StringKeyMap.createAsFlexibleOrdered();
            this._bindTypeCacheMap.put(tableName, (Map<String, Class<?>>)cacheMap);
        }
        if ((bindType = (Class<String>)cacheMap.get(columnName = columnMetaInfo.getColumnName())) != null) {
            return bindType;
        }
        String jdbcType = this._columnHandler.getColumnJdbcType(columnMetaInfo);
        Integer jdbcDefValue = TypeMap.getJdbcDefValueByJdbcType(jdbcType);
        if (jdbcDefValue == null) {
            jdbcDefValue = columnMetaInfo.getJdbcDefValue();
        }
        bindType = jdbcDefValue == 1 || jdbcDefValue == 12 || jdbcDefValue == -1 || jdbcDefValue == 2005 ? String.class : (jdbcDefValue == -6 || jdbcDefValue == 5 || jdbcDefValue == 4 ? Integer.class : (jdbcDefValue == -5 ? Long.class : (jdbcDefValue == 3 || jdbcDefValue == 2 ? BigDecimal.class : (jdbcDefValue == 93 ? Timestamp.class : (jdbcDefValue == 92 ? Time.class : (jdbcDefValue == 91 ? Date.class : (jdbcDefValue == -7 || jdbcDefValue == 16 ? Boolean.class : (jdbcDefValue == 1111 && "UUID".equalsIgnoreCase(jdbcType) ? UUID.class : Object.class))))))));
        cacheMap.put(columnName, bindType);
        return bindType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, DfColumnMetaInfo> getColumnMetaInfo(String tableName) {
        StringKeyMap stringKeyMap;
        if (this._metaInfoCacheMap.containsKey(tableName)) {
            return this._metaInfoCacheMap.get(tableName);
        }
        StringKeyMap columnMetaInfoMap = StringKeyMap.createAsFlexible();
        Connection conn = null;
        try {
            try {
                conn = this._dataSource.getConnection();
                DatabaseMetaData metaData = conn.getMetaData();
                List<DfColumnMetaInfo> columnList = this._columnHandler.getColumnList(metaData, this._unifiedSchema, tableName);
                for (DfColumnMetaInfo columnMetaInfo : columnList) {
                    columnMetaInfoMap.put(columnMetaInfo.getColumnName(), columnMetaInfo);
                }
                this._metaInfoCacheMap.put(tableName, (Map<String, DfColumnMetaInfo>)columnMetaInfoMap);
                stringKeyMap = columnMetaInfoMap;
                Object var9_10 = null;
                if (conn == null) return stringKeyMap;
            }
            catch (SQLException e) {
                String msg = "Failed to get column meta informations: table=" + tableName;
                throw new IllegalStateException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException ignored) {
            // empty catch block
            return stringKeyMap;
        }
        conn.close();
        return stringKeyMap;
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public UnifiedSchema getUnifiedSchema() {
        return this._unifiedSchema;
    }

    public void setUnifiedSchema(UnifiedSchema unifiedSchema) {
        this._unifiedSchema = unifiedSchema;
    }

    public boolean isLoggingInsertSql() {
        return this._loggingInsertSql;
    }

    public void setLoggingInsertSql(boolean loggingInsertSql) {
        this._loggingInsertSql = loggingInsertSql;
    }

    public boolean isSuppressBatchUpdate() {
        return this._suppressBatchUpdate;
    }

    public void setSuppressBatchUpdate(boolean suppressBatchUpdate) {
        this._suppressBatchUpdate = suppressBatchUpdate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RealStringProcessor
    implements StringProcessor {
        protected RealStringProcessor() {
        }

        @Override
        public boolean process(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
            ps.setString(bindCount, value);
            return true;
        }

        public String toString() {
            return DfAbsractDataWriter.this.buildProcessorToString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlStringProcessor
    implements StringProcessor {
        protected XmlStringProcessor() {
        }

        @Override
        public boolean process(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
            return DfAbsractDataWriter.this.processXml(tableName, columnName, value, ps, bindCount, columnMetaInfoMap);
        }

        public String toString() {
            return DfAbsractDataWriter.this.buildProcessorToString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArrayStringProcessor
    implements StringProcessor {
        protected ArrayStringProcessor() {
        }

        @Override
        public boolean process(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
            return DfAbsractDataWriter.this.processArray(tableName, columnName, value, ps, bindCount, columnMetaInfoMap);
        }

        public String toString() {
            return DfAbsractDataWriter.this.buildProcessorToString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UUIDStringProcessor
    implements StringProcessor {
        protected UUIDStringProcessor() {
        }

        @Override
        public boolean process(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
            return DfAbsractDataWriter.this.processUUID(tableName, columnName, value, conn, ps, bindCount, columnMetaInfoMap);
        }

        public String toString() {
            return DfAbsractDataWriter.this.buildProcessorToString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NumberStringProcessor
    implements StringProcessor {
        protected NumberStringProcessor() {
        }

        @Override
        public boolean process(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
            return DfAbsractDataWriter.this.processNumber(tableName, columnName, value, conn, ps, bindCount, columnMetaInfoMap);
        }

        public String toString() {
            return DfAbsractDataWriter.this.buildProcessorToString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BooleanStringProcessor
    implements StringProcessor {
        protected BooleanStringProcessor() {
        }

        @Override
        public boolean process(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
            return DfAbsractDataWriter.this.processBoolean(tableName, columnName, value, conn, ps, bindCount, columnMetaInfoMap);
        }

        public String toString() {
            return DfAbsractDataWriter.this.buildProcessorToString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DateStringProcessor
    implements StringProcessor {
        protected DateStringProcessor() {
        }

        @Override
        public boolean process(String tableName, String columnName, String value, Connection conn, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
            return DfAbsractDataWriter.this.processDate(tableName, columnName, value, conn, ps, bindCount, columnMetaInfoMap);
        }

        public String toString() {
            return DfAbsractDataWriter.this.buildProcessorToString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface StringProcessor {
        public boolean process(String var1, String var2, String var3, Connection var4, PreparedStatement var5, int var6, Map<String, DfColumnMetaInfo> var7) throws SQLException;
    }
}

