/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.info;

import java.util.ArrayList;
import java.util.List;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureNotParamResultMetaInfo;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureMetaInfo {
    protected String _procedureCatalog;
    protected UnifiedSchema _procedureSchema;
    protected String _procedureName;
    protected DfProcedureType _procedureType;
    protected String _procedureFullQualifiedName;
    protected String _procedureSchemaQualifiedName;
    protected String _procedureSqlName;
    protected String _procedureComment;
    protected String _procedurePackage;
    protected boolean _procedureSynonym;
    protected boolean _packageProcedure;
    protected final List<DfProcedureColumnMetaInfo> _procedureColumnList = new ArrayList<DfProcedureColumnMetaInfo>();
    protected final List<DfProcedureNotParamResultMetaInfo> _notParamResultList = new ArrayList<DfProcedureNotParamResultMetaInfo>();

    public String getProcedureDisplayNameForSchemaHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildProcedureSqlName());
        String typeDisp = this._procedureType.alias() + (this._procedureSynonym ? ", Synonym" : "");
        sb.append(" <span class=\"type\">(").append(typeDisp).append(")</span>");
        return sb.toString();
    }

    public boolean hasProcedureComment() {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this._procedureComment);
    }

    public String getProcedureCommentForSchemaHtml() {
        DfDocumentProperties prop = DfBuildProperties.getInstance().getDocumentProperties();
        String comment = this._procedureComment;
        comment = prop.resolvePreTextForSchemaHtml(comment);
        return comment;
    }

    public boolean isPackageProcdure() {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this._procedurePackage);
    }

    public String buildProcedureKeyName() {
        return this._procedureName;
    }

    public String buildProcedureLoggingName() {
        return this._procedureFullQualifiedName;
    }

    public String buildProcedureSqlName() {
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)this._procedureSqlName)) {
            return this._procedureSqlName;
        }
        DfBasicProperties prop = DfBuildProperties.getInstance().getBasicProperties();
        String sqlName = this.getProcedureSchema().buildSqlName(this.getProcedureName());
        this._procedureSqlName = prop.isDatabaseDB2() && !sqlName.contains(".") ? this.getProcedureSchema().buildSchemaQualifiedName(sqlName) : sqlName;
        if (prop.isDatabaseSQLServer()) {
            this._procedureSqlName = Srl.substringLastFront((String)this._procedureSqlName, (String[])new String[]{";"});
        }
        return this._procedureSqlName;
    }

    public String buildProcedurePureName() {
        return Srl.substringLastRear((String)this._procedureName, (String[])new String[]{"."});
    }

    public int getBindParameterCount() {
        int count = 0;
        for (DfProcedureColumnMetaInfo columnInfo : this._procedureColumnList) {
            if (!columnInfo.isBindParameter()) continue;
            ++count;
        }
        return count;
    }

    public int getInputParameterCount() {
        int count = 0;
        for (DfProcedureColumnMetaInfo columnInfo : this._procedureColumnList) {
            if (!columnInfo.isInputParameter()) continue;
            ++count;
        }
        return count;
    }

    public boolean isCalledBySelect() {
        return this.isSQLServerTableValuedFunction();
    }

    public boolean hasOverloadParameter() {
        for (DfProcedureColumnMetaInfo columnInfo : this._procedureColumnList) {
            if (columnInfo.getOverloadNo() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isSQLServerTableValuedFunction() {
        if (!this.getBasicProperties().isDatabaseSQLServer()) {
            return false;
        }
        for (DfProcedureColumnMetaInfo columnInfo : this._procedureColumnList) {
            if (!columnInfo.isSQLServerTableReturnValue()) continue;
            return true;
        }
        return false;
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    public String toString() {
        return "{" + this._procedureFullQualifiedName + ", " + (Object)((Object)this._procedureType) + ", " + this._procedureComment + ", " + this._procedureColumnList + ", notParamResult=" + this._notParamResultList.size() + "}";
    }

    public String getProcedureCatalog() {
        return this._procedureCatalog;
    }

    public void setProcedureCatalog(String procedureCatalog) {
        this._procedureCatalog = procedureCatalog;
    }

    public UnifiedSchema getProcedureSchema() {
        return this._procedureSchema;
    }

    public void setProcedureSchema(UnifiedSchema procedureSchema) {
        this._procedureSchema = procedureSchema;
    }

    public String getProcedureName() {
        return this._procedureName;
    }

    public void setProcedureName(String procedureName) {
        this._procedureName = procedureName;
    }

    public DfProcedureType getProcedureType() {
        return this._procedureType;
    }

    public void setProcedureType(DfProcedureType procedureType) {
        this._procedureType = procedureType;
    }

    public String getProcedureFullQualifiedName() {
        return this._procedureFullQualifiedName;
    }

    public void setProcedureFullQualifiedName(String procedureFullQualifiedName) {
        this._procedureFullQualifiedName = procedureFullQualifiedName;
    }

    public String getProcedureSchemaQualifiedName() {
        return this._procedureSchemaQualifiedName;
    }

    public void setProcedureSchemaQualifiedName(String procedureSchemaQualifiedName) {
        this._procedureSchemaQualifiedName = procedureSchemaQualifiedName;
    }

    protected void setProcedureSqlName(String procedureSqlName) {
        this._procedureSqlName = procedureSqlName;
    }

    public String getProcedureComment() {
        return this._procedureComment;
    }

    public void setProcedureComment(String procedureComment) {
        this._procedureComment = procedureComment;
    }

    public String getProcedurePackage() {
        return this._procedurePackage;
    }

    public void setProcedurePackage(String procedurePackage) {
        this._procedurePackage = procedurePackage;
    }

    public boolean isProcedureSynonym() {
        return this._procedureSynonym;
    }

    public void setProcedureSynonym(boolean procedureSynonym) {
        this._procedureSynonym = procedureSynonym;
    }

    public List<DfProcedureColumnMetaInfo> getProcedureColumnList() {
        return this._procedureColumnList;
    }

    public void addProcedureColumn(DfProcedureColumnMetaInfo procedureColumn) {
        this._procedureColumnList.add(procedureColumn);
    }

    public List<DfProcedureNotParamResultMetaInfo> getNotParamResultList() {
        return this._notParamResultList;
    }

    public void addNotParamResult(DfProcedureNotParamResultMetaInfo notParamResult) {
        this._notParamResultList.add(notParamResult);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DfProcedureType {
        procedureResultUnknown("ResultUnknown"),
        procedureNoResult("NoResult"),
        procedureReturnsResult("ReturnsResult");

        private String _alias;

        private DfProcedureType(String alias) {
            this._alias = alias;
        }

        public String alias() {
            return this._alias;
        }
    }
}

