/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.doc.dataxls;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.torque.engine.database.model.Column;
import org.seasar.dbflute.helper.dataset.DfDataRow;
import org.seasar.dbflute.helper.dataset.DfDataSet;
import org.seasar.dbflute.helper.dataset.DfDataTable;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnTypes;
import org.seasar.dbflute.helper.io.xls.DfXlsWriter;
import org.seasar.dbflute.logic.doc.dataxls.DfTemplateDataExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDataXlsTemplateHandler {
    protected DataSource _dataSource;

    public DfDataXlsTemplateHandler(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public TemplateDataResult outputData(Map<String, List<Column>> tableColumnMap, int limit, File xlsFile) {
        DfTemplateDataExtractor extractor = new DfTemplateDataExtractor(this._dataSource);
        Map<String, List<Map<String, String>>> dumpDataMap = extractor.extractData(tableColumnMap, limit);
        return this.transferToXls(tableColumnMap, dumpDataMap, xlsFile);
    }

    protected TemplateDataResult transferToXls(Map<String, List<Column>> tableColumnMap, Map<String, List<Map<String, String>>> templateDataMap, File xlsFile) {
        LinkedHashMap<String, List<Column>> overTableColumnMap = new LinkedHashMap<String, List<Column>>();
        LinkedHashMap<String, List<Map<String, String>>> overTemplateDataMap = new LinkedHashMap<String, List<Map<String, String>>>();
        Set<String> tableNameSet = templateDataMap.keySet();
        DfDataSet dataSet = new DfDataSet();
        for (String tableName : tableNameSet) {
            List<Column> columnList = tableColumnMap.get(tableName);
            int dotIndex = tableName.indexOf(".");
            DfDataTable dataTable = dotIndex >= 0 ? new DfDataTable(tableName.substring(dotIndex + ".".length())) : new DfDataTable(tableName);
            int columnIndex = 0;
            for (Column column : columnList) {
                dataTable.addColumn(column.getName(), DfDtsColumnTypes.STRING);
                ++columnIndex;
            }
            List<Map<String, String>> recordList = templateDataMap.get(tableName);
            if (recordList.size() > 65000) {
                overTableColumnMap.put(tableName, columnList);
                overTemplateDataMap.put(tableName, recordList);
                continue;
            }
            for (Map<String, String> recordMap : recordList) {
                Set<String> columnNameSet = recordMap.keySet();
                DfDataRow dataRow = dataTable.addRow();
                for (String columnName : columnNameSet) {
                    String value = recordMap.get(columnName);
                    dataRow.addValue(columnName, value);
                }
            }
            dataSet.addTable(dataTable);
        }
        DfXlsWriter writer = new DfXlsWriter(xlsFile).stringCellType();
        try {
            writer.write(dataSet);
        }
        catch (RuntimeException e) {
            String msg = "Failed to write the xls file: " + xlsFile;
            msg = msg + " tableNames=" + tableNameSet;
            throw new IllegalStateException(msg, e);
        }
        TemplateDataResult templateDataResult = new TemplateDataResult();
        templateDataResult.setOverTableColumnMap(overTableColumnMap);
        templateDataResult.setOverTemplateDataMap(overTemplateDataMap);
        return templateDataResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateDataResult {
        protected Map<String, List<Column>> overTableColumnMap;
        protected Map<String, List<Map<String, String>>> overTemplateDataMap;

        public Map<String, List<Column>> getOverTableColumnMap() {
            return this.overTableColumnMap;
        }

        public void setOverTableColumnMap(Map<String, List<Column>> overTableColumnMap) {
            this.overTableColumnMap = overTableColumnMap;
        }

        public Map<String, List<Map<String, String>>> getOverTemplateDataMap() {
            return this.overTemplateDataMap;
        }

        public void setOverTemplateDataMap(Map<String, List<Map<String, String>>> overTemplateDataMap) {
            this.overTemplateDataMap = overTemplateDataMap;
        }
    }
}

