/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.DfDBFluteTaskFailureException;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.jdbc.connection.DfConnectionMetaInfo;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

public final class DfDBFluteTaskUtil {
    private static final Log _log = LogFactory.getLog(DfDBFluteTaskUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Properties getBuildProperties(String file, Project project) {
        prop = new Properties();
        try {
            sources = DfStringUtil.splitList((String)file, (String)",").toArray(new String[0]);
            for (i = 0; i < sources.length; ++i) {
                block26: {
                    source = sources[i];
                    currentProp = new Properties();
                    fis = null;
                    try {
                        currentDirFile = new File(source);
                        targetFile = currentDirFile.exists() != false ? currentDirFile : project.resolveFile(source);
                        DfDBFluteTaskUtil._log.info((Object)("...Using contextProperties: " + targetFile));
                        fis = new FileInputStream(targetFile);
                        currentProp.load(fis);
                        var17_18 = null;
                        ** if (fis == null) goto lbl-1000
                    }
                    catch (Throwable var16_24) {
                        var17_18 = null;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                        }
                        throw var16_24;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            fis.close();
                        }
                        catch (IOException ignored) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block26;
                        catch (IOException e) {
                            block27: {
                                classLoader = project.getClass().getClassLoader();
                                ins = null;
                                try {
                                    ins = classLoader.getResourceAsStream(source);
                                    if (ins == null) {
                                        msg = "Context properties file " + source;
                                        msg = msg + " could not be found in the file system or on the classpath!";
                                        throw new BuildException(msg, (Throwable)e);
                                    }
                                    currentProp.load(ins);
                                    var14_16 = null;
                                    ** if (ins == null) goto lbl-1000
                                }
                                catch (Throwable var13_23) {
                                    var14_16 = null;
                                    if (ins != null) {
                                        try {
                                            ins.close();
                                        }
                                        catch (IOException ignored) {
                                            // empty catch block
                                        }
                                    }
                                    throw var13_23;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        ins.close();
                                    }
                                    catch (IOException ignored) {}
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block27;
                                    catch (IOException ignored) {
                                        msg = "Failed to load contextProperties:";
                                        msg = msg + " file=" + source + " project=" + project;
                                        throw new BuildException(msg, (Throwable)e);
                                    }
                                }
                            }
                            var17_18 = null;
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException ignored) {}
                            }
                        }
                    }
                }
                entrySet = currentProp.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    prop.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            entrySet = prop.entrySet();
            DfDBFluteTaskUtil._log.info((Object)("[Build-Properties]: size=" + prop.size()));
            for (Map.Entry<Object, Object> entry : entrySet) {
                DfDBFluteTaskUtil._log.info((Object)("  " + entry.getKey() + " = " + entry.getValue()));
            }
            DfDBFluteTaskUtil._log.info((Object)"");
        }
        catch (RuntimeException e) {
            br = new ExceptionMessageBuilder();
            br.addNotice("Failed to get build.properties.");
            br.addItem("Advice");
            br.addElement((Object)"Check the existence of build.properties on DBFlute client directory");
            br.addItem("File");
            br.addElement((Object)file);
            br.addItem("Project");
            br.addElement((Object)project);
            msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg, e);
        }
        return prop;
    }

    public static void logException(Exception e, String taskName, DfConnectionMetaInfo metaInfo) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        DfDBFluteTaskUtil.setupCommonMessage(br, taskName, metaInfo);
        if (e instanceof SQLException) {
            DfDBFluteTaskUtil.buildSQLExceptionMessage(br, (SQLException)e);
        }
        String msg = br.buildExceptionMessage();
        _log.error((Object)msg, (Throwable)e);
    }

    protected static void setupCommonMessage(ExceptionMessageBuilder br, String taskName, DfConnectionMetaInfo metaInfo) {
        br.addNotice("Failed to execute DBFlute Task '" + taskName + "'.");
        br.addItem("Advice");
        br.addElement((Object)"Check the exception messages and the stack traces.");
        if (metaInfo != null) {
            br.addItem("Database Product");
            br.addElement((Object)metaInfo.getProductDisp());
            br.addItem("JDBC Driver");
            br.addElement((Object)metaInfo.getDriverDisp());
        }
    }

    protected static void buildSQLExceptionMessage(ExceptionMessageBuilder br, SQLException e) {
        String sqlState = DfJDBCException.extractSQLState(e);
        br.addItem("SQLState");
        br.addElement((Object)sqlState);
        Integer errorCode = DfJDBCException.extractErrorCode(e);
        br.addItem("ErrorCode");
        br.addElement((Object)errorCode);
        br.addItem("SQLException");
        br.addElement((Object)e.getClass().getName());
        if (e instanceof DfJDBCException) {
            br.addElement((Object)"*Look at the message on the stack trace");
        } else {
            br.addElement((Object)DfJDBCException.extractMessage(e));
        }
        SQLException nextEx = e.getNextException();
        if (nextEx != null) {
            br.addItem("NextException");
            br.addElement((Object)nextEx.getClass().getName());
            br.addElement((Object)DfJDBCException.extractMessage(nextEx));
            SQLException nextNextEx = nextEx.getNextException();
            if (nextNextEx != null) {
                br.addItem("NextNextException");
                br.addElement((Object)nextNextEx.getClass().getName());
                br.addElement((Object)DfJDBCException.extractMessage(nextNextEx));
            }
        }
    }

    public static void logError(Error e, String taskName, DfConnectionMetaInfo metaInfo) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        DfDBFluteTaskUtil.setupCommonMessage(br, taskName, metaInfo);
        String msg = br.buildExceptionMessage();
        _log.error((Object)msg, (Throwable)e);
    }

    public static String getDisplayTaskName(String taskName) {
        if (taskName.endsWith("df-jdbc")) {
            return "JDBC";
        }
        if (taskName.equals("df-doc")) {
            return "Doc";
        }
        if (taskName.equals("df-generate")) {
            return "Generate";
        }
        if (taskName.equals("df-sql2entity")) {
            return "Sql2Entity";
        }
        if (taskName.equals("df-outside-sql-test")) {
            return "OutsideSqlTest";
        }
        if (taskName.equals("df-create-schema")) {
            return "ReplaceSchema";
        }
        if (taskName.equals("df-load-data")) {
            return "ReplaceSchema";
        }
        if (taskName.equals("df-take-finally")) {
            return "ReplaceSchema";
        }
        return taskName;
    }

    public static void throwTaskFailure(String displayTaskName) {
        String msg = DfDBFluteTaskUtil.ln() + "/* * * * * * * * * * * * * * * * * * * * * * *";
        msg = msg + DfDBFluteTaskUtil.ln() + "Failed to execute DBFlute task: " + displayTaskName;
        msg = msg + DfDBFluteTaskUtil.ln() + "Look at the log: console or dbflute.log";
        msg = msg + DfDBFluteTaskUtil.ln() + "* * * * * * * * * */";
        throw new DfDBFluteTaskFailureException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void shutdownIfDerbyEmbedded(String driver) throws SQLException {
        if (!driver.startsWith("org.apache.derby.")) return;
        if (!driver.endsWith(".EmbeddedDriver")) {
            return;
        }
        String shutdownUrl = "jdbc:derby:;shutdown=true";
        Connection conn = null;
        try {
            try {
                _log.info((Object)"...Shutting down the connection to Derby");
                conn = DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException e) {
                if ("XJ015".equals(e.getSQLState())) {
                    _log.info((Object)(" --> success: " + e.getMessage()));
                    Object var6_4 = null;
                    if (conn == null) return;
                    conn.close();
                    return;
                }
                String msg = "Failed to shut down the connection to Derby:";
                msg = msg + " shutdownUrl=" + "jdbc:derby:;shutdown=true";
                throw new DfJDBCException(msg, e);
            }
            Object var6_3 = null;
            if (conn == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (conn == null) throw throwable;
            conn.close();
            throw throwable;
        }
        conn.close();
    }

    protected static DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected static DfBasicProperties getBasicProperties() {
        return DfDBFluteTaskUtil.getProperties().getBasicProperties();
    }

    protected static DfDatabaseProperties getDatabaseProperties() {
        return DfDBFluteTaskUtil.getProperties().getDatabaseProperties();
    }

    protected static String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

