/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.transform;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.Unique;
import org.apache.torque.engine.database.transform.DTDResolver;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler {
    private static SAXParserFactory _saxFactory = SAXParserFactory.newInstance();
    private final AppData _appData;
    private Database _currentDB;
    private Table _currentTable;
    private Column _currentColumn;
    private ForeignKey _currentFK;
    private Index _currentIndex;
    private Unique _currentUnique;
    private String _currentPackage;
    private String _currentXmlFile;
    private boolean _firstPass;
    private final Stack<ParseStackElement> _parsingStack = new Stack();
    private Vector<String> _alreadyReadFiles;

    public XmlToAppData(String databaseType) {
        this._appData = new AppData(databaseType);
        this._firstPass = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppData parseFile(String xmlFile) throws IOException {
        if (!this._firstPass) {
            throw new Error("No more double pass");
        }
        if (this._alreadyReadFiles != null && this._alreadyReadFiles.contains(xmlFile)) {
            return this._appData;
        }
        if (this._alreadyReadFiles == null) {
            this._alreadyReadFiles = new Vector(3, 1);
        }
        this._alreadyReadFiles.add(xmlFile);
        this._currentXmlFile = xmlFile;
        String encoding = this.getProejctSchemaXMLEncoding();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlFile), encoding));
            InputSource is = new InputSource(br);
            SAXParser parser = _saxFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            this.handleException(e, xmlFile, encoding);
        }
        catch (SAXException e) {
            this.handleException(e, xmlFile, encoding);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        this._firstPass = false;
        return this._appData;
    }

    protected String getProejctSchemaXMLEncoding() {
        return DfBuildProperties.getInstance().getBasicProperties().getProejctSchemaXMLEncoding();
    }

    protected void handleException(Exception e, String xmlFile, String encoding) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to parse SchemaXML.");
        br.addItem("SchemaXML");
        br.addElement((Object)xmlFile);
        br.addItem("Encoding");
        br.addElement((Object)encoding);
        br.addItem("Exception");
        br.addElement((Object)e.getClass().getName());
        br.addElement((Object)e.getMessage());
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, e);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return new DTDResolver().resolveEntity(publicId, systemId);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        try {
            if (rawName.equals("database")) {
                this._currentDB = this._appData.addDatabase(attributes);
            } else if (rawName.equals("table")) {
                this._currentTable = this._currentDB.addTable(attributes);
            } else if (rawName.equals("column")) {
                this._currentColumn = this._currentTable.addColumn(attributes);
            } else if (rawName.equals("inheritance")) {
                this._currentColumn.addInheritance(attributes);
            } else if (rawName.equals("foreign-key")) {
                this._currentFK = this._currentTable.addForeignKey(attributes);
            } else if (rawName.equals("reference")) {
                this._currentFK.addReference(attributes);
            } else if (rawName.equals("index")) {
                this._currentIndex = this._currentTable.addIndex(attributes);
            } else if (rawName.equals("index-column")) {
                this._currentIndex.addColumn(attributes);
            } else if (rawName.equals("unique")) {
                this._currentUnique = this._currentTable.addUnique(attributes);
            } else if (rawName.equals("unique-column")) {
                this._currentUnique.addColumn(attributes);
            } else if (rawName.equals("id-method-parameter")) {
                this._currentTable.addIdMethodParameter(attributes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void endElement(String uri, String localName, String rawName) {
    }

    static {
        _saxFactory.setValidating(true);
    }

    protected static class ParseStackElement {
        private String currentPackage;
        private String currentXmlFile;
        private boolean firstPass;

        public ParseStackElement(XmlToAppData parser) {
            this.currentPackage = parser._currentPackage;
            this.currentXmlFile = parser._currentXmlFile;
            this.firstPass = parser._firstPass;
            parser._parsingStack.push(this);
        }

        public static void popState(XmlToAppData parser) {
            if (!parser._parsingStack.isEmpty()) {
                ParseStackElement elem = (ParseStackElement)parser._parsingStack.pop();
                parser._currentPackage = elem.currentPackage;
                parser._currentXmlFile = elem.currentXmlFile;
                parser._firstPass = elem.firstPass;
            }
        }

        public static void pushState(XmlToAppData parser) {
            new ParseStackElement(parser);
        }
    }
}

