/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.properties.assistant.commoncolumn.CommonColumnSetupResource;
import org.seasar.dbflute.util.DfPropertyUtil;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfCommonColumnProperties
extends DfAbstractHelperProperties {
    public static final String KEY_commonColumnMap = "commonColumnMap";
    protected Map<String, Object> _commonColumnTopMap;
    protected Map<String, String> _commonColumnMap;
    protected List<String> _commonColumnNameList;
    public static final String COMMON_COLUMN_CONVERSION_PREFIX_MARK = "$-";
    protected List<String> _commonColumnNameConversionList;
    public static final String KEY_commonColumnSetupBeforeInsertInterceptorLogicMap = "commonColumnSetupBeforeInsertInterceptorLogicMap";
    protected Map<String, Object> _beforeInsertMap;
    public static final String KEY_commonColumnSetupBeforeUpdateInterceptorLogicMap = "commonColumnSetupBeforeUpdateInterceptorLogicMap";
    protected Map<String, Object> _beforeUpdateMap;
    protected static final String COMMON_COLUMN_SETUP_RESOURCE_PREFIX_MARK = "@";
    protected static final String COMMON_COLUMN_SETUP_RESOURCE_SECOND_MARK = "@";
    protected static final String COMMON_COLUMN_SETUP_RESOURCE_VARIABLE_PREFIX = "_";
    protected Map<String, CommonColumnSetupResource> _commonColumnSetupResourceMap = new LinkedHashMap<String, CommonColumnSetupResource>();

    public DfCommonColumnProperties(Properties prop) {
        super(prop);
    }

    public Map<String, String> getCommonColumnMap() {
        if (this._commonColumnTopMap == null) {
            this._commonColumnTopMap = this.mapProp("torque.commonColumnMap", DEFAULT_EMPTY_MAP);
            if (this._commonColumnTopMap.containsKey(KEY_commonColumnMap)) {
                Map commonColumnMap = (Map)this._commonColumnTopMap.get(KEY_commonColumnMap);
                StringKeyMap flmap = StringKeyMap.createAsFlexibleOrdered();
                flmap.putAll(commonColumnMap);
                this._commonColumnMap = flmap;
            } else {
                this._commonColumnMap = new HashMap<String, String>();
            }
        }
        return this._commonColumnMap;
    }

    public List<String> getCommonColumnNameList() {
        if (this._commonColumnNameList == null) {
            Map<String, String> commonColumnMap = this.getCommonColumnMap();
            this._commonColumnNameList = new ArrayList<String>(commonColumnMap.keySet());
        }
        return this._commonColumnNameList;
    }

    public List<String> getCommonColumnNameConversionList() {
        if (this._commonColumnNameConversionList == null) {
            this._commonColumnNameConversionList = new ArrayList<String>();
            Map<String, String> commonColumnMap = this.getCommonColumnMap();
            Set<String> keySet = commonColumnMap.keySet();
            for (String columnName : keySet) {
                if (!columnName.startsWith(COMMON_COLUMN_CONVERSION_PREFIX_MARK)) continue;
                this._commonColumnNameConversionList.add(columnName);
            }
        }
        return this._commonColumnNameConversionList;
    }

    public boolean isCommonColumnConversion(String commonColumnName) {
        return commonColumnName.startsWith(COMMON_COLUMN_CONVERSION_PREFIX_MARK);
    }

    public String filterCommonColumn(String commonColumnName) {
        if (commonColumnName.startsWith(COMMON_COLUMN_CONVERSION_PREFIX_MARK)) {
            return commonColumnName.substring(COMMON_COLUMN_CONVERSION_PREFIX_MARK.length());
        }
        return commonColumnName;
    }

    public boolean isExistCommonColumnSetupElement() {
        Map<String, Object> insertElementMap = this.getBeforeInsertMap();
        Map<String, Object> updateElementMap = this.getBeforeUpdateMap();
        return !insertElementMap.isEmpty() || !updateElementMap.isEmpty();
    }

    public Map<String, Object> getBeforeInsertMap() {
        if (this._beforeInsertMap == null) {
            this.getCommonColumnMap();
            if (this._commonColumnTopMap != null && this._commonColumnTopMap.containsKey("beforeInsertMap")) {
                this._beforeInsertMap = (Map)this._commonColumnTopMap.get("beforeInsertMap");
            } else {
                String key = "torque.commonColumnSetupBeforeInsertInterceptorLogicMap";
                this._beforeInsertMap = this.mapProp("torque.commonColumnSetupBeforeInsertInterceptorLogicMap", DEFAULT_EMPTY_MAP);
            }
            this.filterCommonColumnSetupValue(this._beforeInsertMap);
        }
        return this._beforeInsertMap;
    }

    public boolean containsValidColumnNameKeyCommonColumnSetupBeforeInsertInterceptorLogicMap(String columnName) {
        Map<String, Object> map = this.getBeforeInsertMap();
        String logic = (String)map.get(columnName);
        return logic != null && logic.trim().length() != 0;
    }

    public String getCommonColumnSetupBeforeInsertInterceptorLogicByColumnName(String columnName) {
        Map<String, Object> map = this.getBeforeInsertMap();
        return (String)map.get(columnName);
    }

    public Map<String, Object> getBeforeUpdateMap() {
        if (this._beforeUpdateMap == null) {
            this.getCommonColumnMap();
            if (this._commonColumnTopMap != null && this._commonColumnTopMap.containsKey("beforeUpdateMap")) {
                this._beforeUpdateMap = (Map)this._commonColumnTopMap.get("beforeUpdateMap");
            } else {
                String key = "torque.commonColumnSetupBeforeUpdateInterceptorLogicMap";
                this._beforeUpdateMap = this.mapProp("torque.commonColumnSetupBeforeUpdateInterceptorLogicMap", DEFAULT_EMPTY_MAP);
            }
            this.filterCommonColumnSetupValue(this._beforeUpdateMap);
        }
        return this._beforeUpdateMap;
    }

    public boolean containsValidColumnNameKeyCommonColumnSetupBeforeUpdateInterceptorLogicMap(String columnName) {
        Map<String, Object> map = this.getBeforeUpdateMap();
        String logic = (String)map.get(columnName);
        return logic != null && logic.trim().length() != 0;
    }

    public String getCommonColumnSetupBeforeUpdateInterceptorLogicByColumnName(String columnName) {
        Map<String, Object> map = this.getBeforeUpdateMap();
        return (String)map.get(columnName);
    }

    public boolean isCommonColumnSetupInvokingLogic(String logic) {
        return logic.startsWith("$");
    }

    public String removeCommonColumnSetupInvokingMark(String logic) {
        String filtered = this.filterInvokingLogic(logic.substring("$".length()));
        if (!filtered.trim().endsWith(";")) {
            filtered = filtered + ";";
        }
        return filtered;
    }

    protected String filterInvokingLogic(String logic) {
        String tmp = DfPropertyUtil.convertAll(logic, "$$Semicolon$$", ";");
        tmp = DfPropertyUtil.convertAll(tmp, "$$StartBrace$$", "{");
        tmp = DfPropertyUtil.convertAll(tmp, "$$EndBrace$$", "}");
        return tmp;
    }

    protected void filterCommonColumnSetupValue(Map<String, Object> map) {
        String baseCommonPackage = this.getBasicProperties().getBaseCommonPackage();
        String projectPrefix = this.getBasicProperties().getProjectPrefix();
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            boolean valid;
            String value = (String)map.get(key);
            if (value != null && value.contains("$$allcommon$$")) {
                value = DfStringUtil.replace((String)value, (String)"$$allcommon$$", (String)baseCommonPackage);
            }
            if (value != null && value.contains("$$AccessContext$$")) {
                String accessContext;
                if (DfBuildProperties.getInstance().isVersionJavaOverNinety()) {
                    accessContext = "org.seasar.dbflute.AccessContext";
                    value = DfStringUtil.replace((String)value, (String)"$$AccessContext$$", (String)"org.seasar.dbflute.AccessContext");
                } else {
                    accessContext = baseCommonPackage + "." + projectPrefix + "AccessContext";
                    value = DfStringUtil.replace((String)value, (String)"$$AccessContext$$", (String)accessContext);
                }
            }
            String prefixMark = "@";
            String secondMark = "@";
            String variablePrefix = COMMON_COLUMN_SETUP_RESOURCE_VARIABLE_PREFIX;
            if (value != null && value.startsWith("@") && (valid = this.setupCommonColumnSetupResource(value))) {
                String tmp = value.substring("@".length());
                value = COMMON_COLUMN_SETUP_RESOURCE_VARIABLE_PREFIX + tmp.substring(tmp.indexOf("@") + "@".length());
            }
            map.put(key, value);
        }
    }

    public boolean hasCommonColumnSetupResource() {
        Map<String, CommonColumnSetupResource> map = this.getCommonColumnSetupResourceMap();
        return map != null && !map.isEmpty();
    }

    public List<CommonColumnSetupResource> getCommonColumnSetupResourceList() {
        return new ArrayList<CommonColumnSetupResource>(this.getCommonColumnSetupResourceMap().values());
    }

    protected Map<String, CommonColumnSetupResource> getCommonColumnSetupResourceMap() {
        return this._commonColumnSetupResourceMap;
    }

    protected boolean setupCommonColumnSetupResource(String value) {
        String prefixMark = "@";
        String secondMark = "@";
        if (!value.startsWith("@")) {
            return false;
        }
        String remainderString = value.substring("@".length());
        if (!remainderString.contains("@")) {
            String msg = "The common column setup may be wrong format.";
            msg = msg + " Not found second mark[" + "@" + "]" + ": value=" + value;
            msg = msg + " right answer=@org....DataProvider@dataProvider.getDate()";
            throw new IllegalStateException(msg);
        }
        int secondMarkIndex = remainderString.indexOf("@");
        String className = remainderString.substring(0, secondMarkIndex);
        int methodCallDotIndex = (remainderString = remainderString.substring(secondMarkIndex + 1)).indexOf(".");
        if (methodCallDotIndex < 0) {
            String msg = "The common column setup may be wrong format.";
            msg = msg + " Not found method call: value=" + value;
            msg = msg + " right answer=...DataProvider@dataProvider.getDate()";
            throw new IllegalStateException(msg);
        }
        String propertyName = remainderString.substring(0, remainderString.indexOf("."));
        CommonColumnSetupResource resource = this.createCommonColumnSetupResource(className, propertyName);
        this._commonColumnSetupResourceMap.put(propertyName, resource);
        return true;
    }

    protected CommonColumnSetupResource createCommonColumnSetupResource(String className, String propertyName) {
        CommonColumnSetupResource resource = this.newCommonColumnSetupResource();
        resource.setClassName(className);
        resource.setPropertyName(propertyName);
        return resource;
    }

    protected CommonColumnSetupResource newCommonColumnSetupResource() {
        return new CommonColumnSetupResource(COMMON_COLUMN_SETUP_RESOURCE_VARIABLE_PREFIX);
    }
}

