/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.pmbean;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.helper.language.grammar.DfGrammarInfo;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbMetaData;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbPropertyOptionClassification;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbPropertyOptionFinder;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbPropertyOptionReference;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfClassificationProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.properties.DfTypeMappingProperties;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfPmbBasicHandler {
    protected Map<String, DfPmbMetaData> _pmbMetaDataMap;
    protected DfBasicProperties _basicProperties;
    protected DfClassificationProperties _classificationProperties;
    private static DfColumnHandler _columnHandler = new DfColumnHandler();

    public DfPmbBasicHandler(Map<String, DfPmbMetaData> pmbMetaDataMap, DfBasicProperties basicProperties, DfClassificationProperties classificationProperties) {
        this._pmbMetaDataMap = pmbMetaDataMap;
        this._basicProperties = basicProperties;
        this._classificationProperties = classificationProperties;
    }

    public boolean isExistPmbMetaData() {
        return this._pmbMetaDataMap != null && !this._pmbMetaDataMap.isEmpty();
    }

    public Collection<DfPmbMetaData> getPmbMetaDataList() {
        if (this._pmbMetaDataMap == null || this._pmbMetaDataMap.isEmpty()) {
            String msg = "The pmbMetaDataMap should not be null or empty.";
            throw new IllegalStateException(msg);
        }
        return this._pmbMetaDataMap.values();
    }

    public String getSuperClassDefinition(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        DfPmbMetaData metaData = this.findPmbMetaData(className);
        String superClassName = metaData.getSuperClassName();
        if (superClassName == null || superClassName.trim().length() == 0) {
            return "";
        }
        if (DfBuildProperties.getInstance().isVersionJavaOverNinety() && superClassName.contains("SimplePagingBean")) {
            superClassName = "org.seasar.dbflute.cbean.SimplePagingBean";
        }
        DfLanguageDependencyInfo languageDependencyInfo = this._basicProperties.getLanguageDependencyInfo();
        return " " + languageDependencyInfo.getGrammarInfo().getExtendsStringMark() + " " + superClassName;
    }

    public boolean hasPmbMetaDataCheckSafetyResult(String className) {
        String definition = this.getSuperClassDefinition(className);
        return definition.contains("SimplePagingBean");
    }

    public Map<String, String> getPropertyNameOptionMap(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        DfPmbMetaData metaData = this.findPmbMetaData(className);
        return metaData.getPropertyNameOptionMap();
    }

    protected DfPmbMetaData findPmbMetaData(String className) {
        if (this._pmbMetaDataMap == null || this._pmbMetaDataMap.isEmpty()) {
            String msg = "The pmbMetaDataMap should not be null or empty: className=" + className;
            throw new IllegalStateException(msg);
        }
        DfPmbMetaData metaData = this._pmbMetaDataMap.get(className);
        if (metaData == null) {
            String msg = "The className has no meta data: className=" + className;
            throw new IllegalStateException(msg);
        }
        return metaData;
    }

    public Set<String> getPropertySet(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        return this.getPropertyNameTypeMap(className).keySet();
    }

    public String getPropertyType(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassName(className);
        this.assertArgumentPmbMetaDataPropertyName(propertyName);
        return this.getPropertyNameTypeMap(className).get(propertyName);
    }

    protected Map<String, String> getPropertyNameTypeMap(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        DfPmbMetaData metaData = this.findPmbMetaData(className);
        return metaData.getPropertyNameTypeMap();
    }

    public String getPropertyTypeRemovedCSharpNullable(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassName(className);
        this.assertArgumentPmbMetaDataPropertyName(propertyName);
        String propertyType = this.getPropertyType(className, propertyName);
        return propertyType.endsWith("?") ? Srl.substringLastFront((String)propertyType, (String[])new String[]{"?"}) : propertyType;
    }

    public boolean isPmbMetaDataPropertyJavaNativeStringObject(String className, String propertyName) {
        String propertyType = this.getPropertyType(className, propertyName);
        DfTypeMappingProperties prop = this.getProperties().getTypeMappingProperties();
        return prop.isJavaNativeStringObject(propertyType);
    }

    public boolean isPmbMetaDataPropertyJavaNativeNumberObject(String className, String propertyName) {
        String propertyType = this.getPropertyType(className, propertyName);
        DfTypeMappingProperties prop = this.getProperties().getTypeMappingProperties();
        return prop.isJavaNativeNumberObject(propertyType);
    }

    public boolean isPmbMetaDataPropertyJavaNativeBooleanObject(String className, String propertyName) {
        String propertyType = this.getPropertyType(className, propertyName);
        DfTypeMappingProperties prop = this.getProperties().getTypeMappingProperties();
        return prop.isJavaNativeBooleanObject(propertyType);
    }

    public boolean isForProcedure(String className) {
        return this.findPmbMetaData(className).getProcedureName() != null;
    }

    public String getProcedureName(String className) {
        return this.findPmbMetaData(className).getProcedureName();
    }

    public boolean isProcedureCalledBySelect(String className) {
        DfPmbMetaData pmbMetaData = this.findPmbMetaData(className);
        return pmbMetaData.isProcedureCalledBySelect();
    }

    public boolean isRefCustomizeEntity(String className) {
        DfPmbMetaData metaData = this._pmbMetaDataMap.get(className);
        if (metaData == null) {
            return false;
        }
        return metaData.isRefCustomizeEntity();
    }

    public boolean hasProcedureOverload(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        Map<String, DfProcedureColumnMetaInfo> columnInfoMap = this.getPropertyNameColumnInfoMap(className);
        if (columnInfoMap == null) {
            return false;
        }
        Collection<DfProcedureColumnMetaInfo> values = columnInfoMap.values();
        for (DfProcedureColumnMetaInfo columnInfo : values) {
            if (columnInfo.getOverloadNo() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isPropertyOptionProcedureParameterIn(String className, String propertyName) {
        String option = this.findPropertyOption(className, propertyName);
        return option != null && option.trim().equalsIgnoreCase(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnIn.toString());
    }

    public boolean isPropertyOptionProcedureParameterOut(String className, String propertyName) {
        String option = this.findPropertyOption(className, propertyName);
        return option != null && option.trim().equalsIgnoreCase(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnOut.toString());
    }

    public boolean isPropertyOptionProcedureParameterInOut(String className, String propertyName) {
        String option = this.findPropertyOption(className, propertyName);
        return option != null && option.trim().equalsIgnoreCase(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnInOut.toString());
    }

    public boolean isPropertyOptionProcedureParameterReturn(String className, String propertyName) {
        String option = this.findPropertyOption(className, propertyName);
        return option != null && option.trim().equalsIgnoreCase(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn.toString());
    }

    public boolean isPropertyOptionProcedureParameterResult(String className, String propertyName) {
        String option = this.findPropertyOption(className, propertyName);
        return option != null && option.trim().equalsIgnoreCase(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnResult.toString());
    }

    public String getPropertyColumnName(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        return this.getPropertyNameColumnNameMap(className).get(propertyName);
    }

    protected Map<String, String> getPropertyNameColumnNameMap(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        DfPmbMetaData metaData = this.findPmbMetaData(className);
        return metaData.getPropertyNameColumnNameMap();
    }

    public boolean needsStringClobHandling(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        DfProcedureColumnMetaInfo metaInfo = this.getProcedureColumnInfo(className, propertyName);
        if (metaInfo == null) {
            return false;
        }
        return _columnHandler.isConceptTypeStringClob(metaInfo.getDbTypeName());
    }

    public boolean needsBytesOidHandling(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        DfProcedureColumnMetaInfo metaInfo = this.getProcedureColumnInfo(className, propertyName);
        if (metaInfo == null) {
            return false;
        }
        return _columnHandler.isConceptTypeBytesOid(metaInfo.getDbTypeName());
    }

    public boolean needsFixedLengthStringHandling(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        DfProcedureColumnMetaInfo metaInfo = this.getProcedureColumnInfo(className, propertyName);
        if (metaInfo == null) {
            return false;
        }
        return _columnHandler.isConceptTypeFixedLengthString(metaInfo.getDbTypeName());
    }

    public boolean needsObjectBindingBigDecimalHandling(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        DfProcedureColumnMetaInfo metaInfo = this.getProcedureColumnInfo(className, propertyName);
        if (metaInfo == null) {
            return false;
        }
        return _columnHandler.isConceptTypeObjectBindingBigDecimal(metaInfo.getDbTypeName());
    }

    public boolean needsOracleArrayHandling(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        if (!this.getBasicProperties().isDatabaseOracle() || !this.getLittleAdjustmentProperties().isAvailableDatabaseNativeJDBC()) {
            return false;
        }
        DfProcedureColumnMetaInfo metaInfo = this.getProcedureColumnInfo(className, propertyName);
        return metaInfo != null && metaInfo.hasTypeArrayInfo();
    }

    public boolean needsOracleStructHandling(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        if (!this.getBasicProperties().isDatabaseOracle() || !this.getLittleAdjustmentProperties().isAvailableDatabaseNativeJDBC()) {
            return false;
        }
        DfProcedureColumnMetaInfo metaInfo = this.getProcedureColumnInfo(className, propertyName);
        return metaInfo != null && metaInfo.hasTypeStructInfo();
    }

    public String getProcedureParameterOracleArrayTypeName(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        DfProcedureColumnMetaInfo columnInfo = this.getProcedureColumnInfo(className, propertyName);
        if (columnInfo != null && columnInfo.hasTypeArrayInfo()) {
            return columnInfo.getTypeArrayInfo().getTypeSqlName();
        }
        return "";
    }

    public String getProcedureParameterOracleArrayElementTypeName(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        DfProcedureColumnMetaInfo columnInfo = this.getProcedureColumnInfo(className, propertyName);
        if (columnInfo != null && columnInfo.hasTypeArrayInfo()) {
            return columnInfo.getTypeArrayInfo().getElementType();
        }
        return "";
    }

    public String getProcedureParameterOracleArrayElementJavaNative(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        DfProcedureColumnMetaInfo columnInfo = this.getProcedureColumnInfo(className, propertyName);
        if (columnInfo != null && columnInfo.hasTypeArrayElementJavaNative()) {
            return columnInfo.getTypeArrayInfo().getElementJavaNative();
        }
        return "Object";
    }

    public String getProcedureParameterOracleArrayElementJavaNativeTypeLiteral(String className, String propertyName) {
        String javaNative = this.getProcedureParameterOracleArrayElementJavaNative(className, propertyName);
        DfGrammarInfo grammarInfo = this.getBasicProperties().getLanguageDependencyInfo().getGrammarInfo();
        return grammarInfo.getClassTypeLiteral(Srl.substringFirstFrontIgnoreCase((String)javaNative, (String[])new String[]{"<"}));
    }

    public String getProcedureParameterOracleStructTypeName(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        DfProcedureColumnMetaInfo columnInfo = this.getProcedureColumnInfo(className, propertyName);
        if (columnInfo != null && columnInfo.hasTypeStructInfo()) {
            return columnInfo.getTypeStructInfo().getTypeSqlName();
        }
        return "";
    }

    public String getProcedureParameterOracleStructEntityType(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        DfProcedureColumnMetaInfo columnInfo = this.getProcedureColumnInfo(className, propertyName);
        if (columnInfo != null && columnInfo.hasTypeStructEntityType()) {
            return columnInfo.getTypeStructInfo().getEntityType();
        }
        return "Object";
    }

    public String getProcedureParameterOracleStructEntityTypeTypeLiteral(String className, String propertyName) {
        String entityType = this.getProcedureParameterOracleStructEntityType(className, propertyName);
        DfGrammarInfo grammarInfo = this.getBasicProperties().getLanguageDependencyInfo().getGrammarInfo();
        return grammarInfo.getClassTypeLiteral(Srl.substringFirstFrontIgnoreCase((String)entityType, (String[])new String[]{"<"}));
    }

    protected DfProcedureColumnMetaInfo getProcedureColumnInfo(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassPropertyName(className, propertyName);
        Map<String, DfProcedureColumnMetaInfo> columnInfoMap = this.getPropertyNameColumnInfoMap(className);
        if (columnInfoMap != null) {
            return columnInfoMap.get(propertyName);
        }
        return null;
    }

    protected Map<String, DfProcedureColumnMetaInfo> getPropertyNameColumnInfoMap(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        DfPmbMetaData metaData = this.findPmbMetaData(className);
        return metaData.getPropertyNameColumnInfoMap();
    }

    public boolean hasPropertyOptionOriginalOnlyOneSetter(String className, String propertyName) {
        return this.hasPropertyOptionAnyLikeSearch(className, propertyName) || this.hasPropertyOptionAnyFromTo(className, propertyName);
    }

    public boolean hasPropertyOptionAnyLikeSearch(String className) {
        DfPmbMetaData metaData = this._pmbMetaDataMap.get(className);
        if (metaData == null) {
            return false;
        }
        Set<String> propertyNameSet = metaData.getPropertyNameTypeMap().keySet();
        for (String propertyName : propertyNameSet) {
            if (!this.hasPropertyOptionAnyLikeSearch(className, propertyName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPropertyOptionAnyLikeSearch(String className, String propertyName) {
        return this.isPropertyOptionLikeSearch(className, propertyName) || this.isPropertyOptionPrefixSearch(className, propertyName) || this.isPropertyOptionContainSearch(className, propertyName) || this.isPropertyOptionSuffixSearch(className, propertyName);
    }

    public boolean isPropertyOptionLikeSearch(String className, String propertyName) {
        return this.containsPropertyOption(className, propertyName, "like");
    }

    public boolean isPropertyOptionPrefixSearch(String className, String propertyName) {
        return this.containsPropertyOption(className, propertyName, "likePrefix");
    }

    public boolean isPropertyOptionContainSearch(String className, String propertyName) {
        return this.containsPropertyOption(className, propertyName, "likeContain");
    }

    public boolean isPropertyOptionSuffixSearch(String className, String propertyName) {
        return this.containsPropertyOption(className, propertyName, "likeSuffix");
    }

    public boolean hasPropertyOptionAnyFromTo(String className) {
        DfPmbMetaData metaData = this._pmbMetaDataMap.get(className);
        if (metaData == null) {
            return false;
        }
        Set<String> propertyNameSet = metaData.getPropertyNameTypeMap().keySet();
        for (String propertyName : propertyNameSet) {
            if (!this.hasPropertyOptionAnyFromTo(className, propertyName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPropertyOptionAnyFromTo(String className, String propertyName) {
        return this.isPropertyOptionFromDate(className, propertyName) || this.isPropertyOptionToDate(className, propertyName);
    }

    public boolean isPropertyOptionFromDate(String className, String propertyName) {
        return this.containsPropertyOption(className, propertyName, "fromDate");
    }

    public boolean isPropertyOptionToDate(String className, String propertyName) {
        return this.containsPropertyOption(className, propertyName, "toDate");
    }

    public boolean isPropertyOptionClassification(String className, String propertyName, AppData appData) {
        if (this.isPropertyOptionSpecifiedClassification(className, propertyName)) {
            return true;
        }
        Column column = this.getPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null && column.hasClassification();
    }

    protected boolean isPropertyOptionSpecifiedClassification(String className, String propertyName) {
        DfPmbPropertyOptionClassification obj = this.createPropertyOptionClassification(className, propertyName);
        return obj.isPmbMetaDataPropertyOptionClassification();
    }

    public String getPropertyOptionClassificationName(String className, String propertyName, AppData appData) {
        if (this.isPropertyOptionSpecifiedClassification(className, propertyName)) {
            DfPmbPropertyOptionClassification obj = this.createPropertyOptionClassification(className, propertyName);
            return obj.getPmbMetaDataPropertyOptionClassificationName();
        }
        Column column = this.getPropertyOptionClassificationColumn(className, propertyName, appData);
        return column.getClassificationName();
    }

    public List<Map<String, String>> getPropertyOptionClassificationMapList(String className, String propertyName, AppData appData) {
        if (this.isPropertyOptionSpecifiedClassification(className, propertyName)) {
            DfPmbPropertyOptionClassification obj = this.createPropertyOptionClassification(className, propertyName);
            return obj.getPmbMetaDataPropertyOptionClassificationMapList();
        }
        Column column = this.getPropertyOptionClassificationColumn(className, propertyName, appData);
        return column.getClassificationMapList();
    }

    protected Column getPropertyOptionClassificationColumn(String className, String propertyName, AppData appData) {
        Column column = this.getPropertyOptionReferenceColumn(className, propertyName, appData);
        if (column == null) {
            String msg = "The reference column should exist at this timing:";
            msg = msg + " property=" + className + "." + propertyName;
            throw new IllegalStateException(msg);
        }
        if (!column.hasClassification()) {
            String msg = "The reference column should have a classification at this timing:";
            msg = msg + " property=" + className + "." + propertyName + " column=" + column;
            throw new IllegalStateException(msg);
        }
        return column;
    }

    public boolean hasPropertyOptionReference(String className) {
        DfPmbMetaData metaData = this._pmbMetaDataMap.get(className);
        if (metaData == null) {
            return false;
        }
        Set<String> propertyNameSet = metaData.getPropertyNameTypeMap().keySet();
        for (String propertyName : propertyNameSet) {
            if (!this.hasPropertyOptionAnyFromTo(className, propertyName)) continue;
            return true;
        }
        return false;
    }

    public String getPropertyRefName(String className, String propertyName, AppData appData) {
        Column column = this.getPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.getName() : "";
    }

    public String getPropertyRefAlias(String className, String propertyName, AppData appData) {
        Column column = this.getPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.getAliasExpression() : "";
    }

    public String getPropertyRefLineDisp(String className, String propertyName, AppData appData) {
        Column column = this.getPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? "{" + column.getColumnDefinitionLineDisp() + "}" : "";
    }

    public boolean isPropertyRefColumnChar(String className, String propertyName, AppData appData) {
        Column column = this.getPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.isJdbcTypeChar() : false;
    }

    public String getPropertyRefDbType(String className, String propertyName, AppData appData) {
        Column column = this.getPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.getDbType() : "";
    }

    public String getPropertyRefSize(String className, String propertyName, AppData appData) {
        Column column = this.getPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.getColumnSizeSettingExpression() : "";
    }

    protected Column getPropertyOptionReferenceColumn(String className, String propertyName, AppData appData) {
        DfPmbPropertyOptionReference reference = this.createPropertyOptionReference(className, propertyName);
        return reference.getPmbMetaDataPropertyOptionReferenceColumn(appData);
    }

    public String getPropertyRefColumnInfo(String className, String propertyName, AppData appData) {
        if (this.isForProcedure(className)) {
            DfProcedureColumnMetaInfo metaInfo = this.getProcedureColumnInfo(className, propertyName);
            return metaInfo != null ? ": {" + metaInfo.getColumnDefinitionLineDisp() + "}" : "";
        }
        StringBuilder sb = new StringBuilder();
        String optionDisp = this.getPropertyOptionDisp(className, propertyName);
        sb.append(optionDisp);
        String name = this.getPropertyRefName(className, propertyName, appData);
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)name)) {
            String alias = this.getPropertyRefAlias(className, propertyName, appData);
            String lineDisp = this.getPropertyRefLineDisp(className, propertyName, appData);
            sb.append(" :: refers to " + alias + name + ": " + lineDisp);
        }
        return sb.toString();
    }

    protected String getPropertyOptionDisp(String className, String propertyName) {
        String option = this.findPropertyOption(className, propertyName);
        return option != null ? ":" + option : "";
    }

    protected boolean containsPropertyOption(String className, String propertyName, String option) {
        String specified = this.findPropertyOption(className, propertyName);
        if (specified == null) {
            return false;
        }
        List<String> splitList = this.splitOption(specified);
        for (String element : splitList) {
            if (!element.trim().equalsIgnoreCase(option)) continue;
            return true;
        }
        return false;
    }

    protected List<String> splitOption(String option) {
        return DfPmbPropertyOptionFinder.splitOption(option);
    }

    protected DfPmbPropertyOptionClassification createPropertyOptionClassification(String className, String propertyName) {
        DfPmbPropertyOptionFinder finder = this.createPropertyOptionFinder(className, propertyName);
        return new DfPmbPropertyOptionClassification(className, propertyName, this._classificationProperties, finder);
    }

    protected DfPmbPropertyOptionReference createPropertyOptionReference(String className, String propertyName) {
        DfPmbPropertyOptionFinder finder = this.createPropertyOptionFinder(className, propertyName);
        return new DfPmbPropertyOptionReference(className, propertyName, finder);
    }

    protected String findPropertyOption(String className, String propertyName) {
        DfPmbPropertyOptionFinder finder = this.createPropertyOptionFinder(className, propertyName);
        return finder.findPmbMetaDataPropertyOption(className, propertyName);
    }

    protected DfPmbPropertyOptionFinder createPropertyOptionFinder(String className, String propertyName) {
        return new DfPmbPropertyOptionFinder(className, propertyName, this._pmbMetaDataMap);
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    protected DfLittleAdjustmentProperties getLittleAdjustmentProperties() {
        return this.getProperties().getLittleAdjustmentProperties();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected void assertArgumentPmbMetaDataClassPropertyName(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassName(className);
        this.assertArgumentPmbMetaDataPropertyName(propertyName);
    }

    protected void assertArgumentPmbMetaDataClassName(String className) {
        if (className == null || className.trim().length() == 0) {
            String msg = "The className should not be null or empty: [" + className + "]";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertArgumentPmbMetaDataPropertyName(String propertyName) {
        if (propertyName == null || propertyName.trim().length() == 0) {
            String msg = "The propertyName should not be null or empty: [" + propertyName + "]";
            throw new IllegalArgumentException(msg);
        }
    }
}

