/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.schemadiff;

import java.util.Map;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfAbstractDiff;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfNextPreviousDiff
extends DfAbstractDiff {
    protected final String _next;
    protected final String _previous;

    protected DfNextPreviousDiff(String nextValue, String previousValue) {
        this._next = nextValue;
        this._previous = previousValue;
    }

    protected DfNextPreviousDiff(Map<String, Object> nextPreviousDiffMap) {
        this._next = (String)nextPreviousDiffMap.get("next");
        this._previous = (String)nextPreviousDiffMap.get("previous");
    }

    public static DfNextPreviousDiff create(String nextValue, String previousValue) {
        return new DfNextPreviousDiff(nextValue, previousValue);
    }

    public static DfNextPreviousDiff create(Map<String, Object> nextPreviousDiffMap) {
        return new DfNextPreviousDiff(nextPreviousDiffMap);
    }

    public Map<String, String> createNextPreviousDiffMap() {
        Map map = DfCollectionUtil.newLinkedHashMap();
        map.put("next", this._next);
        map.put("previous", this._previous);
        return map;
    }

    public boolean hasDiff() {
        return !this.isSame(this._next, this._previous);
    }

    public String getDisplayForHtml() {
        return this.escape(this._previous + " -> " + this._next);
    }

    protected String escape(String value) {
        return this.getDocumentProperties().resolveTextForSchemaHtml(value);
    }

    protected DfDocumentProperties getDocumentProperties() {
        return DfBuildProperties.getInstance().getDocumentProperties();
    }

    public String getNext() {
        return this._next;
    }

    public String getPrevious() {
        return this._previous;
    }
}

