/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.synonym;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.handler.DfAutoIncrementHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfForeignKeyHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfIndexHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfTableHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfUniqueKeyHandler;
import org.seasar.dbflute.logic.jdbc.metadata.DfAbstractMetaDataExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractorOracle;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfForeignKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.synonym.DfSynonymExtractor;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSynonymExtractorOracle
extends DfAbstractMetaDataExtractor
implements DfSynonymExtractor {
    private static final Log _log = LogFactory.getLog(DfSynonymExtractorOracle.class);
    protected DataSource _dataSource;
    protected List<UnifiedSchema> _unifiedSchemaList;
    protected Map<String, DfTableMetaInfo> _generatedTableMap;
    protected DfTableHandler _tableHandler = new DfTableHandler();
    protected DfUniqueKeyHandler _uniqueKeyHandler = new DfUniqueKeyHandler();
    protected DfAutoIncrementHandler _autoIncrementHandler = new DfAutoIncrementHandler();
    protected DfForeignKeyHandler _foreignKeyHandler = new DfForeignKeyHandler(){

        public boolean isTableExcept(UnifiedSchema unifiedSchema, String tableName) {
            return false;
        }
    };
    protected DfIndexHandler _indexHandler = new DfIndexHandler();

    /*
     * Loose catch block
     */
    @Override
    public Map<String, DfSynonymMetaInfo> extractSynonymMap() {
        StringKeyMap synonymMap;
        block26: {
            SQLException ignored2222;
            ResultSet rs;
            Statement statement;
            Connection conn;
            block24: {
                synonymMap = StringKeyMap.createAsFlexibleOrdered();
                String sql = this.buildSynonymSelect();
                conn = null;
                statement = null;
                rs = null;
                conn = this._dataSource.getConnection();
                statement = conn.createStatement();
                _log.info((Object)sql);
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    String synonymKey;
                    UnifiedSchema synonymOwner = this.createAsDynamicSchema(null, rs.getString("OWNER"));
                    String synonymName = rs.getString("SYNONYM_NAME");
                    UnifiedSchema tableOwner = this.createAsDynamicSchema(null, rs.getString("TABLE_OWNER"));
                    String tableName = rs.getString("TABLE_NAME");
                    String dbLinkName = rs.getString("DB_LINK");
                    if (this._tableHandler.isTableExcept(synonymOwner, synonymName)) continue;
                    DfSynonymMetaInfo info = new DfSynonymMetaInfo();
                    info.setSynonymOwner(synonymOwner);
                    info.setSynonymName(synonymName);
                    info.setTableOwner(tableOwner);
                    info.setTableName(tableName);
                    info.setDBLinkName(dbLinkName);
                    this.judgeSynonymSelectable(info);
                    if (dbLinkName != null && dbLinkName.trim().length() > 0) {
                        try {
                            synonymKey = this.buildSynonymMapKey(synonymOwner, synonymName);
                            synonymMap.put(synonymKey, this.setupDBLinkSynonym(conn, info));
                        }
                        catch (Exception continued) {
                            _log.info((Object)("Failed to get meta data of " + synonymName + ": " + continued.getMessage()));
                        }
                        continue;
                    }
                    if (!tableOwner.hasSchema()) continue;
                    try {
                        this.setupBasicConstraintInfo(info, tableOwner, tableName, conn);
                    }
                    catch (Exception continued) {
                        _log.info((Object)("Failed to get meta data of " + synonymName + ": " + continued.getMessage()));
                        continue;
                    }
                    synonymKey = this.buildSynonymMapKey(synonymOwner, synonymName);
                    synonymMap.put(synonymKey, info);
                }
                Object var14_16 = null;
                if (statement == null) break block24;
                try {
                    statement.close();
                }
                catch (SQLException ignored2222) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignored2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ignored2222) {}
            }
            break block26;
            {
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
            catch (Throwable throwable) {
                SQLException ignored2222;
                Object var14_17 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException ignored2222) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.translateFKTable((Map<String, DfSynonymMetaInfo>)synonymMap);
        this.setupTableColumnComment((Map<String, DfSynonymMetaInfo>)synonymMap);
        return synonymMap;
    }

    protected String buildSynonymSelect() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (UnifiedSchema unifiedSchema : this._unifiedSchemaList) {
            if (count > 0) {
                sb.append(", ");
            }
            sb.append("'").append(unifiedSchema.getPureSchema()).append("'");
            ++count;
        }
        String sql = "select * from ALL_SYNONYMS where OWNER in (" + sb.toString() + ")";
        return sql;
    }

    protected String buildSynonymMapKey(UnifiedSchema synonymOwner, String synonymName) {
        return synonymOwner.buildSchemaQualifiedName(synonymName);
    }

    protected void judgeSynonymSelectable(DfSynonymMetaInfo info) {
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        String synonymSqlName = info.buildSynonymSqlName();
        String sql = "select * from " + synonymSqlName + " where 0 = 1";
        try {
            ArrayList<String> columnList = new ArrayList<String>();
            columnList.add("dummy");
            facade.selectStringList(sql, columnList);
            info.setSelectable(true);
        }
        catch (RuntimeException ignored) {
            info.setSelectable(false);
        }
    }

    protected void setupBasicConstraintInfo(DfSynonymMetaInfo info, UnifiedSchema tableOwner, String tableName, Connection conn) throws SQLException {
        DatabaseMetaData md = conn.getMetaData();
        DfPrimaryKeyMetaInfo pkInfo = this.getPKList(md, tableOwner, tableName);
        info.setPrimaryKey(pkInfo);
        List<String> pkList = pkInfo.getPrimaryKeyList();
        if (info.isSelectable()) {
            for (String primaryKeyName : pkList) {
                boolean autoIncrement = this.isAutoIncrement(conn, tableOwner, tableName, primaryKeyName);
                if (!autoIncrement) continue;
                info.setAutoIncrement(autoIncrement);
                break;
            }
        }
        Map<String, Map<Integer, String>> uqMap = this.getUQMap(md, tableOwner, tableName, pkList);
        info.setUniqueKeyMap(uqMap);
        Map<String, DfForeignKeyMetaInfo> fkMap = this.getFKMap(md, tableOwner, tableName);
        info.setForeignKeyMap(fkMap);
        uqMap = info.getUniqueKeyMap();
        Map<String, Map<Integer, String>> indexMap = this.getIndexMap(md, tableOwner, tableName, uqMap);
        info.setIndexMap(indexMap);
    }

    protected DfSynonymMetaInfo setupDBLinkSynonym(Connection conn, DfSynonymMetaInfo info) throws SQLException {
        UnifiedSchema synonymOwner = info.getSynonymOwner();
        String synonymName = info.getSynonymName();
        String tableName = info.getTableName();
        String dbLinkName = info.getDBLinkName();
        List<DfColumnMetaInfo> columnMetaInfoList = this.getDBLinkSynonymColumns(conn, synonymOwner, synonymName);
        info.setColumnMetaInfoList4DBLink(columnMetaInfoList);
        DfPrimaryKeyMetaInfo pkInfo = this.getDBLinkSynonymPKInfo(conn, tableName, dbLinkName);
        info.setPrimaryKey(pkInfo);
        Map<String, Map<Integer, String>> uniqueKeyMap = this.getDBLinkSynonymUQMap(conn, tableName, dbLinkName);
        info.setUniqueKeyMap(uniqueKeyMap);
        info.setForeignKeyMap(new LinkedHashMap<String, DfForeignKeyMetaInfo>());
        info.setIndexMap(new LinkedHashMap<String, Map<Integer, String>>());
        return info;
    }

    protected DfPrimaryKeyMetaInfo getPKList(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName) {
        try {
            return this._uniqueKeyHandler.getPrimaryKey(metaData, unifiedSchema, tableName);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Map<String, Map<Integer, String>> getUQMap(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName, List<String> primaryKeyNameList) {
        try {
            return this._uniqueKeyHandler.getUniqueKeyMap(metaData, unifiedSchema, tableName, primaryKeyNameList);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Map<String, DfForeignKeyMetaInfo> getFKMap(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName) {
        try {
            return this._foreignKeyHandler.getForeignKeyMap(metaData, unifiedSchema, tableName);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Map<String, Map<Integer, String>> getIndexMap(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName, Map<String, Map<Integer, String>> uniqueKeyMap) {
        try {
            return this._indexHandler.getIndexMap(metaData, unifiedSchema, tableName, uniqueKeyMap);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected boolean isAutoIncrement(Connection conn, UnifiedSchema tableOwner, String tableName, String primaryKeyColumnName) {
        return false;
    }

    protected void translateFKTable(Map<String, DfSynonymMetaInfo> synonymMap) {
        Collection<DfSynonymMetaInfo> synonymList = synonymMap.values();
        LinkedHashMap tableForeignSynonymListMap = new LinkedHashMap();
        for (DfSynonymMetaInfo synonym : synonymList) {
            String synonymName = synonym.getSynonymName();
            String tableName = synonym.getTableName();
            List foreignSynonymList = (List)tableForeignSynonymListMap.get(tableName);
            if (foreignSynonymList != null) {
                foreignSynonymList.add(synonymName);
                continue;
            }
            ArrayList<String> foreignNewSynonymList = new ArrayList<String>();
            foreignNewSynonymList.add(synonymName);
            tableForeignSynonymListMap.put(tableName, foreignNewSynonymList);
        }
        for (DfSynonymMetaInfo synonym : synonymList) {
            Map<String, DfForeignKeyMetaInfo> fkMap = synonym.getForeignKeyMap();
            if (fkMap == null || fkMap.isEmpty()) continue;
            Set<String> fkNameSet = fkMap.keySet();
            Map additionalFKMap = DfCollectionUtil.newLinkedHashMap();
            Map removedFKMap = DfCollectionUtil.newLinkedHashMap();
            for (String fkName : fkNameSet) {
                DfForeignKeyMetaInfo fk = fkMap.get(fkName);
                fk.setLocalTableName(synonym.getSynonymName());
                String orignalForeignTableName = fk.getForeignTableName();
                List foreignSynonymList = (List)tableForeignSynonymListMap.get(orignalForeignTableName);
                if (foreignSynonymList == null || foreignSynonymList.isEmpty()) {
                    if (this._tableHandler.isTableExcept(synonym.getTableOwner(), orignalForeignTableName)) {
                        removedFKMap.put(fkName, orignalForeignTableName);
                        continue;
                    }
                    if (this.isForeignTableGenerated(orignalForeignTableName)) continue;
                    removedFKMap.put(fkName, orignalForeignTableName);
                    continue;
                }
                String originalForeignKeyName = fk.getForeignKeyName();
                boolean firstDone = false;
                for (int i = 0; i < foreignSynonymList.size(); ++i) {
                    String newForeignKeyName = originalForeignKeyName + "_SYNONYM" + (i + 1);
                    String newForeignTableName = (String)foreignSynonymList.get(i);
                    if (!firstDone) {
                        fk.setForeignKeyName(newForeignKeyName);
                        fk.setForeignTableName(newForeignTableName);
                        firstDone = true;
                        continue;
                    }
                    DfForeignKeyMetaInfo additionalFK = new DfForeignKeyMetaInfo();
                    additionalFK.setForeignKeyName(newForeignKeyName);
                    additionalFK.setLocalTableName(fk.getLocalTableName());
                    additionalFK.setForeignTableName(newForeignTableName);
                    additionalFK.setColumnNameMap(fk.getColumnNameMap());
                    additionalFKMap.put(additionalFK.getForeignKeyName(), additionalFK);
                }
            }
            fkMap.putAll(additionalFKMap);
            if (removedFKMap.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("...Excepting foreign keys from the synonym:").append(this.ln()).append("[Excepted Foreign Key]");
            Set removedFKKeySet = removedFKMap.keySet();
            for (String removedKey : removedFKKeySet) {
                sb.append(this.ln()).append(" ").append(removedKey);
                sb.append(" (").append(synonym.getSynonymName()).append(" to ");
                sb.append((String)removedFKMap.get(removedKey)).append(")");
                fkMap.remove(removedKey);
            }
            _log.info((Object)sb.toString());
        }
    }

    protected boolean isForeignTableGenerated(String foreignTableName) {
        if (this._generatedTableMap == null || this._generatedTableMap.isEmpty()) {
            return true;
        }
        DfTableMetaInfo info = this._generatedTableMap.get(foreignTableName);
        if (info == null) {
            return false;
        }
        return !info.isOutOfGenerateTarget();
    }

    protected void setupTableColumnComment(Map<String, DfSynonymMetaInfo> synonymMap) {
        Map tabColCommentMap;
        Map<String, Set<String>> ownerTabSetMap = this.createOwnerTableSetMap(synonymMap);
        Map ownerTabCommentMap = DfCollectionUtil.newLinkedHashMap();
        Map ownerTabColCommentMap = DfCollectionUtil.newLinkedHashMap();
        Set<String> ownerSet = ownerTabSetMap.keySet();
        for (String owner : ownerSet) {
            Set<String> tableSet = ownerTabSetMap.get(owner);
            DfDbCommentExtractorOracle extractor = this.createDbCommentExtractor(this.createAsDynamicSchema(null, owner));
            Map<String, DfDbCommentExtractor.UserTabComments> tabCommentMap = extractor.extractTableComment(tableSet);
            tabColCommentMap = extractor.extractColumnComment(tableSet);
            ownerTabCommentMap.put(owner, tabCommentMap);
            ownerTabColCommentMap.put(owner, tabColCommentMap);
        }
        for (DfSynonymMetaInfo synonym : synonymMap.values()) {
            Map colCommentMap;
            DfDbCommentExtractor.UserTabComments userTabComments;
            UnifiedSchema owner = synonym.getTableOwner();
            String tableName = synonym.getTableName();
            Map tableCommentMap = (Map)ownerTabCommentMap.get(owner);
            if (tableCommentMap != null && (userTabComments = (DfDbCommentExtractor.UserTabComments)tableCommentMap.get(tableName)) != null && userTabComments.hasComments()) {
                synonym.setTableComment(userTabComments.getComments());
            }
            if ((tabColCommentMap = (Map)ownerTabColCommentMap.get(owner)) == null || (colCommentMap = (Map)tabColCommentMap.get(tableName)) == null || colCommentMap.isEmpty()) continue;
            synonym.setColumnCommentMap(colCommentMap);
        }
    }

    protected DfDbCommentExtractorOracle createDbCommentExtractor(UnifiedSchema schema) {
        DfDbCommentExtractorOracle extractor = new DfDbCommentExtractorOracle();
        extractor.setDataSource(this._dataSource);
        extractor.setUnifiedSchema(schema);
        return extractor;
    }

    protected Map<String, Set<String>> createOwnerTableSetMap(Map<String, DfSynonymMetaInfo> synonymMap) {
        LinkedHashMap<String, Set<String>> ownerTabSetMap = new LinkedHashMap<String, Set<String>>();
        for (DfSynonymMetaInfo synonym : synonymMap.values()) {
            UnifiedSchema owner = synonym.getTableOwner();
            if (synonym.isDBLink()) continue;
            LinkedHashSet<String> tableSet = (LinkedHashSet<String>)ownerTabSetMap.get(owner);
            if (tableSet == null) {
                tableSet = new LinkedHashSet<String>();
                ownerTabSetMap.put(owner.getPureSchema(), tableSet);
            }
            tableSet.add(synonym.getTableName());
        }
        return ownerTabSetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DfColumnMetaInfo> getDBLinkSynonymColumns(Connection conn, UnifiedSchema synonymOwner, String synonymName) throws SQLException {
        SQLException ignored22;
        ArrayList<DfColumnMetaInfo> arrayList;
        ResultSet rs;
        block11: {
            ArrayList<DfColumnMetaInfo> columnList = new ArrayList<DfColumnMetaInfo>();
            Statement st = null;
            rs = null;
            try {
                st = conn.createStatement();
                String synonymSqlName = synonymOwner.buildSchemaQualifiedName(synonymName);
                String sql = "select * from " + synonymSqlName + " where 0=1";
                rs = st.executeQuery(sql);
                ResultSetMetaData metaData = rs.getMetaData();
                int count = metaData.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    int index = i + 1;
                    String columnName = metaData.getColumnName(index);
                    int columnType = metaData.getColumnType(index);
                    String columnTypeName = metaData.getColumnTypeName(index);
                    int precision = metaData.getPrecision(index);
                    int scale = metaData.getScale(index);
                    int nullableType = metaData.isNullable(index);
                    DfColumnMetaInfo column = new DfColumnMetaInfo();
                    column.setColumnName(columnName);
                    column.setJdbcDefValue(columnType);
                    column.setDbTypeName(columnTypeName);
                    column.setColumnSize(precision);
                    column.setDecimalDigits(scale);
                    column.setRequired(nullableType == 0);
                    columnList.add(column);
                }
                arrayList = columnList;
                Object var21_21 = null;
                if (st == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    SQLException ignored22;
                    Object var21_22 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException ignored22) {
                            // empty catch block
                        }
                    }
                    if (rs == null) break block13;
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored22) {}
                }
                throw throwable;
            }
            try {
                st.close();
            }
            catch (SQLException ignored22) {
                // empty catch block
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ignored22) {
                // empty catch block
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DfPrimaryKeyMetaInfo getDBLinkSynonymPKInfo(Connection conn, String tableName, String dbLinkName) throws SQLException {
        SQLException ignored22;
        DfPrimaryKeyMetaInfo dfPrimaryKeyMetaInfo;
        ResultSet rs;
        block11: {
            DfPrimaryKeyMetaInfo pkInfo = new DfPrimaryKeyMetaInfo();
            StringBuilder sb = new StringBuilder();
            sb.append("select cols.OWNER, cols.CONSTRAINT_NAME, cols.TABLE_NAME, cols.COLUMN_NAME");
            sb.append("  from USER_CONS_COLUMNS@" + dbLinkName + " cols");
            sb.append("    left outer join USER_CONSTRAINTS@" + dbLinkName + " cons");
            sb.append("      on cols.CONSTRAINT_NAME = cons.CONSTRAINT_NAME");
            sb.append(" where cols.TABLE_NAME = '" + tableName + "'");
            sb.append("   and cons.CONSTRAINT_TYPE = 'P'");
            sb.append(" order by cols.POSITION");
            Statement statement = null;
            rs = null;
            try {
                statement = conn.createStatement();
                rs = statement.executeQuery(sb.toString());
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    String pkName = rs.getString("CONSTRAINT_NAME");
                    pkInfo.addPrimaryKey(columnName, pkName);
                }
                dfPrimaryKeyMetaInfo = pkInfo;
                Object var11_10 = null;
                if (statement == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    SQLException ignored22;
                    Object var11_11 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException ignored22) {
                            // empty catch block
                        }
                    }
                    if (rs == null) break block13;
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored22) {}
                }
                throw throwable;
            }
            try {
                statement.close();
            }
            catch (SQLException ignored22) {
                // empty catch block
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ignored22) {
                // empty catch block
            }
        }
        return dfPrimaryKeyMetaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Map<Integer, String>> getDBLinkSynonymUQMap(Connection conn, String tableName, String dbLinkName) throws SQLException {
        SQLException ignored22;
        LinkedHashMap<String, Map<Integer, String>> linkedHashMap;
        ResultSet rs;
        block12: {
            LinkedHashMap<String, Map<Integer, String>> uniqueMap = new LinkedHashMap<String, Map<Integer, String>>();
            StringBuilder sb = new StringBuilder();
            sb.append("select cols.OWNER, cols.CONSTRAINT_NAME, cols.TABLE_NAME, cols.COLUMN_NAME, cols.POSITION");
            sb.append("  from USER_CONS_COLUMNS@" + dbLinkName + " cols");
            sb.append("    left outer join USER_CONSTRAINTS@" + dbLinkName + " cons");
            sb.append("      on cols.CONSTRAINT_NAME = cons.CONSTRAINT_NAME");
            sb.append(" where cols.TABLE_NAME = '" + tableName + "'");
            sb.append("   and cons.CONSTRAINT_TYPE = 'U'");
            sb.append(" order by cols.CONSTRAINT_NAME, cols.POSITION");
            Statement statement = null;
            rs = null;
            try {
                statement = conn.createStatement();
                rs = statement.executeQuery(sb.toString());
                while (rs.next()) {
                    String constraintName = rs.getString("CONSTRAINT_NAME");
                    String columnName = rs.getString("COLUMN_NAME");
                    Integer position = rs.getInt("POSITION");
                    LinkedHashMap<Integer, String> uniqueElementMap = (LinkedHashMap<Integer, String>)uniqueMap.get(uniqueMap);
                    if (uniqueElementMap == null) {
                        uniqueElementMap = new LinkedHashMap<Integer, String>();
                        uniqueMap.put(constraintName, uniqueElementMap);
                    }
                    uniqueElementMap.put(position, columnName);
                }
                linkedHashMap = uniqueMap;
                Object var13_12 = null;
                if (statement == null) break block12;
            }
            catch (Throwable throwable) {
                block14: {
                    SQLException ignored22;
                    Object var13_13 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException ignored22) {
                            // empty catch block
                        }
                    }
                    if (rs == null) break block14;
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored22) {}
                }
                throw throwable;
            }
            try {
                statement.close();
            }
            catch (SQLException ignored22) {
                // empty catch block
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ignored22) {
                // empty catch block
            }
        }
        return linkedHashMap;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setTargetSchemaList(List<UnifiedSchema> unifiedSchemaList) {
        this._unifiedSchemaList = unifiedSchemaList;
    }

    public void setGeneratedTableMap(Map<String, DfTableMetaInfo> generatedTableMap) {
        this._generatedTableMap = generatedTableMap;
    }
}

