/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.generate.dataassert;

import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfAssertionFailureCountNotExistsException;
import org.seasar.dbflute.exception.DfAssertionFailureCountNotZeroException;
import org.seasar.dbflute.exception.DfAssertionFailureListNotExistsException;
import org.seasar.dbflute.exception.DfAssertionFailureListNotZeroException;
import org.seasar.dbflute.exception.DfAssertionInvalidMarkException;
import org.seasar.dbflute.logic.generate.dataassert.DfDataAssertHandler;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDataAssertProvider {
    private static Log _log = LogFactory.getLog(DfDataAssertProvider.class);
    protected final Map<String, DfDataAssertHandler> _assertHandlerMap = new LinkedHashMap<String, DfDataAssertHandler>();
    protected String _dataLoadingType;

    public DfDataAssertProvider(String dataLoadingType) {
        this._assertHandlerMap.put("assertCountZero", new DfDataAssertHandler(){

            public void handle(File sqlFile, Statement statement, String sql) throws SQLException {
                DfDataAssertProvider.this.assertCountZero(sqlFile, statement, sql);
            }
        });
        this._assertHandlerMap.put("assertCountExists", new DfDataAssertHandler(){

            public void handle(File sqlFile, Statement statement, String sql) throws SQLException {
                DfDataAssertProvider.this.assertCountExists(sqlFile, statement, sql);
            }
        });
        this._assertHandlerMap.put("assertListZero", new DfDataAssertHandler(){

            public void handle(File sqlFile, Statement statement, String sql) throws SQLException {
                DfDataAssertProvider.this.assertListZero(sqlFile, statement, sql);
            }
        });
        this._assertHandlerMap.put("assertListExists", new DfDataAssertHandler(){

            public void handle(File sqlFile, Statement statement, String sql) throws SQLException {
                DfDataAssertProvider.this.assertListExists(sqlFile, statement, sql);
            }
        });
        this._dataLoadingType = dataLoadingType;
    }

    public DfDataAssertHandler provideDataAssertHandler(String sql) {
        if (!sql.contains("--")) {
            return null;
        }
        String starter = "#df:";
        String terminator = "#";
        String typeAtMark = "@";
        sql = DfStringUtil.replace((String)sql, (String)"-- #", (String)"--#");
        Set<Map.Entry<String, DfDataAssertHandler>> entrySet = this._assertHandlerMap.entrySet();
        DfDataAssertHandler defaultHandler = null;
        for (Map.Entry<String, DfDataAssertHandler> entry : entrySet) {
            String key = entry.getKey();
            String firstMark = "--#df:" + key + "#";
            if (sql.contains(firstMark)) {
                return entry.getValue();
            }
            String secondMark = "--#df:" + key + "@" + this._dataLoadingType + "#";
            if (sql.contains(secondMark)) {
                return entry.getValue();
            }
            final String thirdMark = "--#df:" + key;
            int keyIndex = sql.indexOf(thirdMark);
            if (keyIndex < 0) continue;
            String rearString = sql.substring(keyIndex + thirdMark.length());
            if (rearString.contains(this.ln())) {
                rearString = rearString.substring(0, rearString.indexOf(this.ln()));
            }
            if (!rearString.contains("#")) {
                String msg = "The data assert mark should ends '#':" + this.ln() + sql;
                throw new DfAssertionInvalidMarkException(msg);
            }
            final String option = rearString.substring(0, rearString.indexOf("#"));
            if (option.startsWith("@")) {
                defaultHandler = new DfDataAssertHandler(){

                    public void handle(File sqlFile, Statement stmt, String sql) throws SQLException {
                        String msg = "...Skipping for the different dataLoadingType:";
                        msg = msg + " " + thirdMark + option + "#";
                        _log.info((Object)msg);
                    }
                };
                continue;
            }
            String msg = "Unknown option '" + option + "':" + this.ln() + sql;
            throw new DfAssertionInvalidMarkException(msg);
        }
        return defaultHandler;
    }

    protected void assertCountZero(File sqlFile, Statement statement, String sql) throws SQLException {
        this.assertCount(sqlFile, statement, sql, false);
    }

    protected void assertCountExists(File sqlFile, Statement statement, String sql) throws SQLException {
        this.assertCount(sqlFile, statement, sql, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assertCount(File sqlFile, Statement statement, String sql, boolean exists) throws SQLException {
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(sql);
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            if (exists) {
                if (count == 0) {
                    this.throwAssertionFailureCountNotExistsException(sqlFile, sql, count);
                } else {
                    String result = "[RESULT]: count=" + count;
                    _log.info((Object)result);
                }
            } else if (count > 0) {
                this.throwAssertionFailureCountNotZeroException(sqlFile, sql, count);
            }
            Object var9_8 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    protected void assertListZero(File sqlFile, Statement statement, String sql) throws SQLException {
        this.assertList(sqlFile, statement, sql, false);
    }

    protected void assertListExists(File sqlFile, Statement statement, String sql) throws SQLException {
        this.assertList(sqlFile, statement, sql, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assertList(File sqlFile, Statement statement, String sql, boolean exists) throws SQLException {
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
            int count = 0;
            while (rs.next()) {
                LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();
                for (int i = 1; i <= columnCount; ++i) {
                    recordMap.put(metaData.getColumnName(i), rs.getString(i));
                }
                resultList.add(recordMap);
                ++count;
            }
            if (exists) {
                if (count == 0) {
                    this.throwAssertionFailureListNotExistsException(sqlFile, sql, count, resultList);
                } else {
                    String result = "[RESULT]: count=" + count + this.ln();
                    for (Map map : resultList) {
                        result = result + map + this.ln();
                    }
                    _log.info((Object)result.trim());
                }
            } else if (count > 0) {
                this.throwAssertionFailureListNotZeroException(sqlFile, sql, count, resultList);
            }
            Object var14_14 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    protected void throwAssertionFailureCountNotZeroException(File sqlFile, String sql, int resultCount) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The SQL expects ZERO but the result is NOT ZERO!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your test data!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL File]" + this.ln() + sqlFile + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Executed SQL]" + this.ln() + sql + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Result Count]" + this.ln() + resultCount + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfAssertionFailureCountNotZeroException(msg);
    }

    protected void throwAssertionFailureCountNotExistsException(File sqlFile, String sql, int resultCount) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The SQL expects EXISTS but the result is NOT EXISTS!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your test data!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL File]" + this.ln() + sqlFile + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Executed SQL]" + this.ln() + sql + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Result Count]" + this.ln() + resultCount + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfAssertionFailureCountNotExistsException(msg);
    }

    protected void throwAssertionFailureListNotZeroException(File sqlFile, String sql, int resultCount, List<Map<String, String>> resultList) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The SQL expects ZERO but the result is NOT ZERO!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your test data!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL File]" + this.ln() + sqlFile + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Executed SQL]" + this.ln() + sql + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Result Count]" + this.ln() + resultCount + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Result List]" + this.ln();
        for (Map<String, String> recordMap : resultList) {
            msg = msg + recordMap + this.ln();
        }
        msg = msg + "* * * * * * * * * */";
        throw new DfAssertionFailureListNotZeroException(msg);
    }

    protected void throwAssertionFailureListNotExistsException(File sqlFile, String sql, int resultCount, List<Map<String, String>> resultList) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The SQL expects EXISTS but the result is NOT EXISTS!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your test data!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL File]" + this.ln() + sqlFile + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Executed SQL]" + this.ln() + sql + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Result Count]" + this.ln() + resultCount + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Result List]" + this.ln();
        for (Map<String, String> recordMap : resultList) {
            msg = msg + recordMap + this.ln();
        }
        msg = msg + "* * * * * * * * * */";
        throw new DfAssertionFailureListNotExistsException(msg);
    }

    protected String ln() {
        return "\n";
    }
}

