/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.seasar.dbflute.exception.DfTableDuplicateException;
import org.seasar.dbflute.exception.DfTableNotFoundException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.doc.historyhtml.DfSchemaHistory;
import org.seasar.dbflute.logic.jdbc.handler.DfAutoIncrementHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfForeignKeyHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfIndexHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfTableHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfUniqueKeyHandler;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.comment.factory.DfDbCommentExtractorFactory;
import org.seasar.dbflute.logic.jdbc.metadata.identity.DfIdentityExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.identity.factory.DfIdentityExtractorFactory;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfForeignKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.synonym.DfSynonymExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.synonym.factory.DfSynonymExtractorFactory;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfSchemaDiff;
import org.seasar.dbflute.properties.DfAdditionalTableProperties;
import org.seasar.dbflute.task.bs.DfAbstractTask;
import org.seasar.dbflute.util.Srl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorqueJDBCTransformTask
extends DfAbstractTask {
    private static final Log _log = LogFactory.getLog(TorqueJDBCTransformTask.class);
    protected DocumentImpl _doc;
    protected Element _databaseNode;
    protected DfTableHandler _tableHandler = new DfTableHandler();
    protected DfColumnHandler _columnHandler = new DfColumnHandler();
    protected DfUniqueKeyHandler _uniqueKeyHandler = new DfUniqueKeyHandler();
    protected DfIndexHandler _indexHandler = new DfIndexHandler();
    protected DfForeignKeyHandler _foreignKeyHandler = new DfForeignKeyHandler();
    protected DfAutoIncrementHandler _autoIncrementHandler = new DfAutoIncrementHandler();
    protected Map<String, Map<String, DfDbCommentExtractor.UserColComments>> _columnCommentAllMap;
    protected Map<String, String> _identityMap;
    protected Map<String, DfSynonymMetaInfo> _supplementarySynonymInfoMap;
    protected Map<String, DfTableMetaInfo> _generatedTableMap;
    protected final DfSchemaDiff _schemaDiff = new DfSchemaDiff();

    @Override
    protected boolean isUseDataSource() {
        return true;
    }

    @Override
    protected void doExecute() {
        _log.info((Object)"");
        _log.info((Object)"...Starting to process JDBC to SchemaXML");
        this.loadPreviousSchema();
        this._doc = this.createDocumentImpl();
        this._doc.appendChild((Node)this._doc.createComment(" Auto-generated by JDBC task! "));
        String filePath = this.getBasicProperties().getProejctSchemaXMLFilePath();
        String encoding = this.getBasicProperties().getProejctSchemaXMLEncoding();
        try {
            this.initializeIdentityMapIfNeeds();
            this.generateXML();
            _log.info((Object)"...Serializing XML:");
            _log.info((Object)("  filePath = " + filePath));
            _log.info((Object)("  encoding = " + encoding));
            FileOutputStream fis = new FileOutputStream(filePath);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fis, encoding);
            OutputFormat outputFormar = new OutputFormat("xml", encoding, true);
            XMLSerializer xmlSerializer = new XMLSerializer((Writer)writer, outputFormar);
            xmlSerializer.serialize((Document)this._doc);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unsupported encoding: " + encoding;
            throw new IllegalStateException(msg, e);
        }
        catch (FileNotFoundException e) {
            String msg = "Not found file: " + filePath;
            throw new IllegalStateException(msg, e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.loadNextSchema();
    }

    protected DocumentImpl createDocumentImpl() {
        return new DocumentImpl(this.createDocumentType());
    }

    protected DocumentType createDocumentType() {
        return new DocumentTypeImpl(null, "database", null, "http://dbflute.sandbox.seasar.org/meta/database.dtd");
    }

    protected void generateXML() throws Exception {
        _log.info((Object)"...Instantiate DB-driver");
        Class.forName(this._driver);
        _log.info((Object)"...Getting DB-connection");
        Connection conn = this.getDataSource().getConnection();
        _log.info((Object)"...Getting DB-meta-data");
        DatabaseMetaData metaData = conn.getMetaData();
        List<DfTableMetaInfo> tableList = this.getTableNames(metaData);
        this._generatedTableMap = StringKeyMap.createAsCaseInsensitive();
        for (DfTableMetaInfo info : tableList) {
            this._generatedTableMap.put(info.getTableName(), info);
        }
        this.loadSupplementarySynonymInfoIfNeeds();
        this.processSynonymTable(tableList);
        this._foreignKeyHandler.exceptForeignTableNotGenerated(this._generatedTableMap);
        this._databaseNode = this._doc.createElement("database");
        this._databaseNode.setAttribute("name", this._mainSchema.getPureSchema());
        _log.info((Object)"");
        _log.info((Object)"$ /= = = = = = = = = = = = = = = = = = = = = = = = = =");
        _log.info((Object)"$ [Table List]");
        int tableCount = 0;
        for (int i = 0; i < tableList.size(); ++i) {
            DfTableMetaInfo tableInfo = tableList.get(i);
            if (!this.processTable(conn, metaData, tableInfo)) continue;
            ++tableCount;
        }
        _log.info((Object)"$ ");
        _log.info((Object)"$ [Table Count]");
        _log.info((Object)("$ " + tableCount));
        _log.info((Object)"$ = = = = = = = = = =/");
        _log.info((Object)"");
        boolean additionalTableExists = this.setupAddtionalTableIfNeeds();
        if (tableList.isEmpty() && !additionalTableExists) {
            this.throwTableNotFoundException();
        }
        this._doc.appendChild((Node)this._databaseNode);
    }

    protected boolean processTable(Connection conn, DatabaseMetaData metaData, DfTableMetaInfo tableInfo) throws SQLException {
        String tableComment;
        if (tableInfo.isOutOfGenerateTarget()) {
            _log.info((Object)("$ " + tableInfo.buildTableFullQualifiedName() + " is out of generation target!"));
            return false;
        }
        _log.info((Object)("$ " + tableInfo.toString()));
        Element tableElement = this._doc.createElement("table");
        tableElement.setAttribute("name", tableInfo.getTableName());
        tableElement.setAttribute("type", tableInfo.getTableType());
        UnifiedSchema unifiedSchema = tableInfo.getUnifiedSchema();
        if (unifiedSchema.hasSchema()) {
            tableElement.setAttribute("schema", unifiedSchema.getIdentifiedSchema());
        }
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)(tableComment = tableInfo.getTableComment()))) {
            tableElement.setAttribute("comment", tableComment);
        }
        DfPrimaryKeyMetaInfo pkInfo = this.getPrimaryColumnMetaInfo(metaData, tableInfo);
        List<DfColumnMetaInfo> columns = this.getColumns(metaData, tableInfo);
        for (int j = 0; j < columns.size(); ++j) {
            DfColumnMetaInfo columnInfo = columns.get(j);
            Element columnElement = this._doc.createElement("column");
            this.processColumnName(columnInfo, columnElement);
            this.processColumnType(columnInfo, columnElement);
            this.processColumnDbType(columnInfo, columnElement);
            this.processColumnJavaType(columnInfo, columnElement);
            this.processColumnSize(columnInfo, columnElement);
            this.processRequired(columnInfo, columnElement);
            this.processPrimaryKey(columnInfo, pkInfo, columnElement);
            this.processColumnComment(columnInfo, columnElement);
            this.processDefaultValue(columnInfo, columnElement);
            this.processAutoIncrement(tableInfo, columnInfo, pkInfo, conn, columnElement);
            tableElement.appendChild(columnElement);
        }
        this.processForeignKey(metaData, tableInfo, tableElement);
        Map<String, Map<Integer, String>> uniqueKeyMap = this.processUniqueKey(metaData, tableInfo, tableElement);
        this.processIndex(metaData, tableInfo, tableElement, uniqueKeyMap);
        this._databaseNode.appendChild(tableElement);
        return true;
    }

    protected void processColumnName(DfColumnMetaInfo columnInfo, Element columnElement) {
        String columnName = columnInfo.getColumnName();
        columnElement.setAttribute("name", columnName);
    }

    protected void processColumnType(DfColumnMetaInfo columnInfo, Element columnElement) {
        columnElement.setAttribute("type", this.getColumnJdbcType(columnInfo));
    }

    protected void processColumnDbType(DfColumnMetaInfo columnInfo, Element columnElement) {
        columnElement.setAttribute("dbType", columnInfo.getDbTypeName());
    }

    protected void processColumnJavaType(DfColumnMetaInfo columnInfo, Element columnElement) {
        String jdbcType = this.getColumnJdbcType(columnInfo);
        int columnSize = columnInfo.getColumnSize();
        int decimalDigits = columnInfo.getDecimalDigits();
        String javaNative = TypeMap.findJavaNativeByJdbcType(jdbcType, columnSize, decimalDigits);
        columnElement.setAttribute("javaType", javaNative);
    }

    protected String getColumnJdbcType(DfColumnMetaInfo columnInfo) {
        return this._columnHandler.getColumnJdbcType(columnInfo);
    }

    protected void processColumnSize(DfColumnMetaInfo columnInfo, Element columnElement) {
        int columnSize = columnInfo.getColumnSize();
        int decimalDigits = columnInfo.getDecimalDigits();
        if (DfColumnHandler.isColumnSizeValid(columnSize)) {
            if (DfColumnHandler.isDecimalDigitsValid(decimalDigits)) {
                columnElement.setAttribute("size", columnSize + ", " + decimalDigits);
            } else {
                columnElement.setAttribute("size", String.valueOf(columnSize));
            }
        }
    }

    protected void processRequired(DfColumnMetaInfo columnInfo, Element columnElement) {
        if (columnInfo.isRequired()) {
            columnElement.setAttribute("required", "true");
        }
    }

    protected void processPrimaryKey(DfColumnMetaInfo columnInfo, DfPrimaryKeyMetaInfo pkInfo, Element columnElement) {
        String columnName = columnInfo.getColumnName();
        if (pkInfo.containsColumn(columnName)) {
            columnElement.setAttribute("primaryKey", "true");
            String pkName = pkInfo.getPrimaryKeyName(columnName);
            if (pkName != null && pkName.trim().length() > 0) {
                columnElement.setAttribute("pkName", pkInfo.getPrimaryKeyName(columnName));
            }
        }
    }

    protected void processColumnComment(DfColumnMetaInfo columnInfo, Element columnElement) {
        String columnComment = columnInfo.getColumnComment();
        if (columnComment != null) {
            columnElement.setAttribute("comment", columnComment);
        }
    }

    protected void processDefaultValue(DfColumnMetaInfo columnInfo, Element columnElement) {
        String defaultValue = columnInfo.getDefaultValue();
        if (defaultValue != null) {
            if (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            if (defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            columnElement.setAttribute("default", defaultValue);
        }
    }

    protected void processAutoIncrement(DfTableMetaInfo tableInfo, DfColumnMetaInfo columnInfo, DfPrimaryKeyMetaInfo pkInfo, Connection conn, Element columnElement) throws SQLException {
        String columnName = columnInfo.getColumnName();
        if (pkInfo.containsColumn(columnName) && this.isAutoIncrementColumn(conn, tableInfo, columnInfo)) {
            columnElement.setAttribute("autoIncrement", "true");
        }
    }

    protected void processForeignKey(DatabaseMetaData metaData, DfTableMetaInfo tableInfo, Element tableElement) throws SQLException {
        Map<String, DfForeignKeyMetaInfo> foreignKeyMap = this.getForeignKeys(metaData, tableInfo);
        Set<String> foreignKeyKeySet = foreignKeyMap.keySet();
        for (String foreignKeyName : foreignKeyKeySet) {
            DfForeignKeyMetaInfo foreignKeyMetaInfo = foreignKeyMap.get(foreignKeyName);
            Element foreignKeyElement = this._doc.createElement("foreign-key");
            foreignKeyElement.setAttribute("foreignTable", foreignKeyMetaInfo.getForeignTableName());
            foreignKeyElement.setAttribute("name", foreignKeyMetaInfo.getForeignKeyName());
            Map<String, String> columnNameMap = foreignKeyMetaInfo.getColumnNameMap();
            Set<String> columnNameKeySet = columnNameMap.keySet();
            for (String localColumnName : columnNameKeySet) {
                String foreignColumnName = columnNameMap.get(localColumnName);
                Element referenceElement = this._doc.createElement("reference");
                referenceElement.setAttribute("local", localColumnName);
                referenceElement.setAttribute("foreign", foreignColumnName);
                foreignKeyElement.appendChild(referenceElement);
            }
            tableElement.appendChild(foreignKeyElement);
        }
    }

    protected Map<String, Map<Integer, String>> processUniqueKey(DatabaseMetaData metaData, DfTableMetaInfo tableInfo, Element tableElement) throws SQLException {
        Map<String, Map<Integer, String>> uniqueMap = this.getUniqueKeyMap(metaData, tableInfo);
        Set<String> uniqueKeySet = uniqueMap.keySet();
        for (String uniqueIndexName : uniqueKeySet) {
            Map<Integer, String> uniqueElementMap = uniqueMap.get(uniqueIndexName);
            if (uniqueElementMap.isEmpty()) {
                String msg = "The uniqueKey has no elements: " + uniqueIndexName + " : " + uniqueMap;
                throw new IllegalStateException(msg);
            }
            Element uniqueKeyElement = this._doc.createElement("unique");
            uniqueKeyElement.setAttribute("name", uniqueIndexName);
            Set<Integer> uniqueElementKeySet = uniqueElementMap.keySet();
            for (Integer ordinalPosition : uniqueElementKeySet) {
                String columnName = uniqueElementMap.get(ordinalPosition);
                Element uniqueColumnElement = this._doc.createElement("unique-column");
                uniqueColumnElement.setAttribute("name", columnName);
                uniqueColumnElement.setAttribute("position", ordinalPosition.toString());
                uniqueKeyElement.appendChild(uniqueColumnElement);
            }
            tableElement.appendChild(uniqueKeyElement);
        }
        return uniqueMap;
    }

    protected void processIndex(DatabaseMetaData metaData, DfTableMetaInfo tableInfo, Element tableElement, Map<String, Map<Integer, String>> uniqueKeyMap) throws SQLException {
        Map<String, Map<Integer, String>> indexMap = this.getIndexMap(metaData, tableInfo, uniqueKeyMap);
        Set<String> indexKeySet = indexMap.keySet();
        for (String indexName : indexKeySet) {
            Map<Integer, String> indexElementMap = indexMap.get(indexName);
            if (indexElementMap.isEmpty()) {
                String msg = "The index has no elements: " + indexName + " : " + indexMap;
                throw new IllegalStateException(msg);
            }
            Element indexElement = this._doc.createElement("index");
            indexElement.setAttribute("name", indexName);
            Set<Integer> uniqueElementKeySet = indexElementMap.keySet();
            for (Integer ordinalPosition : uniqueElementKeySet) {
                String columnName = indexElementMap.get(ordinalPosition);
                Element uniqueColumnElement = this._doc.createElement("index-column");
                uniqueColumnElement.setAttribute("name", columnName);
                uniqueColumnElement.setAttribute("position", ordinalPosition.toString());
                indexElement.appendChild(uniqueColumnElement);
            }
            tableElement.appendChild(indexElement);
        }
    }

    protected void throwTableNotFoundException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "A table was NOT FOUND in the schema!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the database connection settings." + this.ln();
        msg = msg + "If you've not created the schema yet, please create it." + this.ln();
        msg = msg + "You can create easily by using replace-schema." + this.ln();
        msg = msg + "Set up ./playsql/replace-schema.sql and execute ReplaceSchema task." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Connection Settings]" + this.ln();
        msg = msg + " driver = " + this._driver + this.ln();
        msg = msg + " url    = " + this._url + this.ln();
        msg = msg + " schema = " + this._mainSchema + this.ln();
        msg = msg + " user   = " + this._userId + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfTableNotFoundException(msg);
    }

    public List<DfTableMetaInfo> getTableNames(DatabaseMetaData dbMeta) throws SQLException {
        List<DfTableMetaInfo> tableList = this._tableHandler.getTableList(dbMeta, this._mainSchema);
        this.helpTableComments(tableList, this._mainSchema);
        this.resolveAdditionalSchema(dbMeta, tableList);
        this.assertDuplicateTable(tableList);
        return tableList;
    }

    protected void assertDuplicateTable(List<DfTableMetaInfo> tableList) {
        StringSet tableNameSet = StringSet.createAsCaseInsensitive();
        StringSet duplicateTableSet = StringSet.createAsCaseInsensitive();
        for (DfTableMetaInfo info : tableList) {
            String tableName = info.getTableName();
            if (tableNameSet.contains(tableName)) {
                duplicateTableSet.add(tableName);
                continue;
            }
            tableNameSet.add(tableName);
        }
        if (!duplicateTableSet.isEmpty()) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
            msg = msg + "The same-name table between different schema is unsupported!" + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Advice]" + this.ln();
            msg = msg + "Use view or synonym (or alias) that refers to the table." + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Duplicate Table]" + this.ln() + duplicateTableSet + this.ln();
            msg = msg + "* * * * * * * * * */";
            throw new DfTableDuplicateException(msg);
        }
    }

    protected void resolveAdditionalSchema(DatabaseMetaData dbMeta, List<DfTableMetaInfo> tableList) throws SQLException {
        List<UnifiedSchema> schemaList = this.getDatabaseProperties().getAdditionalSchemaList();
        for (UnifiedSchema additionalSchema : schemaList) {
            List<DfTableMetaInfo> additionalTableList = this._tableHandler.getTableList(dbMeta, additionalSchema);
            this.helpTableComments(additionalTableList, additionalSchema);
            tableList.addAll(additionalTableList);
        }
    }

    protected void helpTableComments(List<DfTableMetaInfo> tableList, UnifiedSchema unifiedSchema) {
        DfDbCommentExtractor extractor = this.createDbCommentExtractor(unifiedSchema);
        if (extractor != null) {
            HashSet<String> tableSet = new HashSet<String>();
            for (DfTableMetaInfo table : tableList) {
                tableSet.add(table.getTableName());
            }
            try {
                Map<String, DfDbCommentExtractor.UserTabComments> tableCommentMap = extractor.extractTableComment(tableSet);
                for (DfTableMetaInfo table : tableList) {
                    table.acceptTableComment(tableCommentMap);
                }
            }
            catch (RuntimeException ignored) {
                _log.info((Object)("Failed to extract table comments: extractor=" + extractor), (Throwable)ignored);
            }
            try {
                if (this._columnCommentAllMap == null) {
                    this._columnCommentAllMap = extractor.extractColumnComment(tableSet);
                } else {
                    this._columnCommentAllMap.putAll(extractor.extractColumnComment(tableSet));
                }
            }
            catch (RuntimeException ignored) {
                _log.info((Object)("Failed to extract column comments: extractor=" + extractor), (Throwable)ignored);
            }
        }
    }

    protected void processSynonymTable(List<DfTableMetaInfo> tableList) {
        this.judgeOutOfTargetSynonym(tableList);
        this.helpSynonymTableComments(tableList);
    }

    protected void judgeOutOfTargetSynonym(List<DfTableMetaInfo> tableList) {
        for (DfTableMetaInfo table : tableList) {
            DfSynonymMetaInfo synonym;
            if (!this.canHandleSynonym(table) || (synonym = this.getSynonymMetaInfo(table)) == null || synonym.isSelectable()) continue;
            table.setOutOfGenerateTarget(true);
        }
    }

    protected void helpSynonymTableComments(List<DfTableMetaInfo> tableList) {
        for (DfTableMetaInfo table : tableList) {
            DfSynonymMetaInfo synonym;
            if (!this.canHandleSynonym(table) || table.hasTableComment() || (synonym = this.getSynonymMetaInfo(table)) == null || !synonym.hasTableComment()) continue;
            table.setTableComment(synonym.getTableComment());
        }
    }

    public List<DfColumnMetaInfo> getColumns(DatabaseMetaData dbMeta, DfTableMetaInfo tableInfo) throws SQLException {
        DfSynonymMetaInfo synonym;
        List<DfColumnMetaInfo> columnList = this._columnHandler.getColumnList(dbMeta, tableInfo);
        if (this.canHandleSynonym(tableInfo) && columnList.isEmpty() && (synonym = this.getSynonymMetaInfo(tableInfo)) != null && synonym.isDBLink()) {
            columnList = synonym.getColumnMetaInfoList4DBLink();
        }
        this.helpColumnComments(tableInfo, columnList);
        return columnList;
    }

    protected void helpColumnComments(DfTableMetaInfo tableInfo, List<DfColumnMetaInfo> columnList) {
        if (this._columnCommentAllMap != null) {
            String tableName = tableInfo.getTableName();
            Map<String, DfDbCommentExtractor.UserColComments> columnCommentMap = this._columnCommentAllMap.get(tableName);
            for (DfColumnMetaInfo column : columnList) {
                column.acceptColumnComment(columnCommentMap);
            }
        }
        this.helpSynonymColumnComments(tableInfo, columnList);
    }

    protected void helpSynonymColumnComments(DfTableMetaInfo tableInfo, List<DfColumnMetaInfo> columnList) {
        for (DfColumnMetaInfo column : columnList) {
            DfDbCommentExtractor.UserColComments userColComments;
            DfSynonymMetaInfo synonym;
            if (!this.canHandleSynonym(tableInfo) || column.hasColumnComment() || (synonym = this.getSynonymMetaInfo(tableInfo)) == null || !synonym.hasColumnCommentMap() || (userColComments = synonym.getColumnCommentMap().get(column.getColumnName())) == null || !userColComments.hasComments()) continue;
            column.setColumnComment(userColComments.getComments());
        }
    }

    protected DfPrimaryKeyMetaInfo getPrimaryColumnMetaInfo(DatabaseMetaData metaData, DfTableMetaInfo tableInfo) throws SQLException {
        DfPrimaryKeyMetaInfo pkInfo = this._uniqueKeyHandler.getPrimaryKey(metaData, tableInfo);
        List<String> pkList = pkInfo.getPrimaryKeyList();
        if (!this.canHandleSynonym(tableInfo) || !pkList.isEmpty()) {
            return pkInfo;
        }
        DfSynonymMetaInfo synonym = this.getSynonymMetaInfo(tableInfo);
        if (synonym != null) {
            return synonym.getPrimaryKey();
        }
        return pkInfo;
    }

    protected Map<String, Map<Integer, String>> getUniqueKeyMap(DatabaseMetaData metaData, DfTableMetaInfo tableInfo) throws SQLException {
        Map<String, Map<Integer, String>> uniqueKeyMap = this._uniqueKeyHandler.getUniqueKeyMap(metaData, tableInfo);
        if (!this.canHandleSynonym(tableInfo) || !uniqueKeyMap.isEmpty()) {
            return uniqueKeyMap;
        }
        DfSynonymMetaInfo synonym = this.getSynonymMetaInfo(tableInfo);
        return synonym != null ? synonym.getUniqueKeyMap() : uniqueKeyMap;
    }

    protected boolean isAutoIncrementColumn(Connection conn, DfTableMetaInfo tableInfo, DfColumnMetaInfo primaryKeyColumnInfo) throws SQLException {
        DfSynonymMetaInfo synonym;
        if (this._autoIncrementHandler.isAutoIncrementColumn(conn, tableInfo, primaryKeyColumnInfo)) {
            return true;
        }
        if (this.canHandleSynonym(tableInfo) && (synonym = this.getSynonymMetaInfo(tableInfo)) != null && synonym.isAutoIncrement()) {
            return true;
        }
        if (this._identityMap == null) {
            return false;
        }
        String primaryKeyColumnName = primaryKeyColumnInfo.getColumnName();
        String columnName = this._identityMap.get(tableInfo.getTableName());
        return primaryKeyColumnName.equals(columnName);
    }

    protected void initializeIdentityMapIfNeeds() {
        DfIdentityExtractor extractor = this.createIdentityExtractor();
        if (extractor == null) {
            return;
        }
        try {
            _log.info((Object)"...Initializing identity map");
            this._identityMap = extractor.extractIdentityMap();
            _log.info((Object)("  -> size=" + this._identityMap.size()));
        }
        catch (Exception ignored) {
            _log.info((Object)"DfIdentityExtractor.extractIdentityMap() threw the exception!", (Throwable)ignored);
        }
    }

    protected Map<String, DfForeignKeyMetaInfo> getForeignKeys(DatabaseMetaData metaData, DfTableMetaInfo tableInfo) throws SQLException {
        Map<String, DfForeignKeyMetaInfo> foreignKeyMap = this._foreignKeyHandler.getForeignKeyMap(metaData, tableInfo);
        if (!this.canHandleSynonym(tableInfo) || !foreignKeyMap.isEmpty()) {
            return foreignKeyMap;
        }
        DfSynonymMetaInfo synonym = this.getSynonymMetaInfo(tableInfo);
        return synonym != null ? synonym.getForeignKeyMap() : foreignKeyMap;
    }

    protected Map<String, Map<Integer, String>> getIndexMap(DatabaseMetaData metaData, DfTableMetaInfo tableInfo, Map<String, Map<Integer, String>> uniqueKeyMap) throws SQLException {
        Map<String, Map<Integer, String>> indexMap = this._indexHandler.getIndexMap(metaData, tableInfo, uniqueKeyMap);
        if (!this.canHandleSynonym(tableInfo) || !indexMap.isEmpty()) {
            return indexMap;
        }
        DfSynonymMetaInfo synonym = this.getSynonymMetaInfo(tableInfo);
        return synonym != null ? synonym.getIndexMap() : indexMap;
    }

    protected void loadSupplementarySynonymInfoIfNeeds() {
        DfSynonymExtractor extractor = this.createSynonymExtractor();
        if (extractor == null) {
            return;
        }
        try {
            _log.info((Object)"...Loading supplementary synonym informations");
            this._supplementarySynonymInfoMap = extractor.extractSynonymMap();
            StringBuilder sb = new StringBuilder();
            sb.append("Finished loading synonyms:").append(this.ln()).append("[Supplementary Synonyms]");
            Set<Map.Entry<String, DfSynonymMetaInfo>> entrySet = this._supplementarySynonymInfoMap.entrySet();
            for (Map.Entry<String, DfSynonymMetaInfo> entry : entrySet) {
                sb.append(this.ln()).append(" ").append(entry.getValue().toString());
            }
            _log.info((Object)sb.toString());
        }
        catch (RuntimeException ignored) {
            _log.info((Object)"DfSynonymExtractor.extractSynonymMap() threw the exception!", (Throwable)ignored);
        }
    }

    protected boolean canHandleSynonym(DfTableMetaInfo tableInfo) {
        return this._supplementarySynonymInfoMap != null && tableInfo.canHandleSynonym();
    }

    protected DfSynonymMetaInfo getSynonymMetaInfo(DfTableMetaInfo tableInfo) {
        if (!this.canHandleSynonym(tableInfo)) {
            String msg = "The table meta information should be for synonym: " + tableInfo;
            throw new IllegalStateException(msg);
        }
        String key = tableInfo.buildTableFullQualifiedName();
        DfSynonymMetaInfo info = this._supplementarySynonymInfoMap.get(key);
        if (info != null) {
            return info;
        }
        key = tableInfo.buildSchemaQualifiedName();
        info = this._supplementarySynonymInfoMap.get(key);
        if (info != null) {
            return info;
        }
        return null;
    }

    protected boolean setupAddtionalTableIfNeeds() {
        boolean exists = false;
        String tableType = "TABLE";
        DfAdditionalTableProperties prop = this.getProperties().getAdditionalTableProperties();
        Map<String, Object> tableMap = prop.getAdditionalTableMap();
        Set<String> tableNameKey = tableMap.keySet();
        for (String tableName : tableNameKey) {
            _log.info((Object)("...Processing additional table: " + tableName + "(" + "TABLE" + ")"));
            Element tableElement = this._doc.createElement("table");
            tableElement.setAttribute("name", tableName);
            tableElement.setAttribute("type", "TABLE");
            Map<String, Map<String, String>> columnMap = prop.findColumnMap(tableName);
            String tableComment = prop.findTableComment(tableName);
            if (tableComment != null && tableComment.trim().length() > 0) {
                tableElement.setAttribute("comment", tableComment);
            }
            Set<String> columnNameKey = columnMap.keySet();
            for (String columnName : columnNameKey) {
                Element columnElement = this._doc.createElement("column");
                columnElement.setAttribute("name", columnName);
                String columnType = prop.findColumnType(tableName, columnName);
                String columnDbType = prop.findColumnDbType(tableName, columnName);
                String columnSize = prop.findColumnSize(tableName, columnName);
                boolean required = prop.isColumnRequired(tableName, columnName);
                boolean primaryKey = prop.isColumnPrimaryKey(tableName, columnName);
                String pkName = prop.findColumnPKName(tableName, columnName);
                boolean autoIncrement = prop.isColumnAutoIncrement(tableName, columnName);
                String columnDefault = prop.findColumnDefault(tableName, columnName);
                String columnComment = prop.findColumnComment(tableName, columnName);
                this.setupAdditionalTableColumnAttribute(columnElement, "type", columnType);
                this.setupAdditionalTableColumnAttribute(columnElement, "dbType", columnDbType);
                this.setupAdditionalTableColumnAttribute(columnElement, "size", columnSize);
                this.setupAdditionalTableColumnAttribute(columnElement, "required", String.valueOf(required));
                this.setupAdditionalTableColumnAttribute(columnElement, "primaryKey", String.valueOf(primaryKey));
                this.setupAdditionalTableColumnAttribute(columnElement, "pkName", pkName);
                this.setupAdditionalTableColumnAttribute(columnElement, "autoIncrement", String.valueOf(autoIncrement));
                this.setupAdditionalTableColumnAttribute(columnElement, "default", columnDefault);
                this.setupAdditionalTableColumnAttribute(columnElement, "comment", columnComment);
                tableElement.appendChild(columnElement);
            }
            exists = true;
            this._databaseNode.appendChild(tableElement);
        }
        return exists;
    }

    protected void setupAdditionalTableColumnAttribute(Element columnElement, String key, String value) {
        if (value != null && value.trim().length() > 0) {
            columnElement.setAttribute(key, value);
        }
    }

    protected DfDbCommentExtractor createDbCommentExtractor(UnifiedSchema unifiedSchema) {
        DfDbCommentExtractorFactory factory = this.createDbCommentExtractorFactory(unifiedSchema);
        return factory.createDbCommentExtractor();
    }

    protected DfDbCommentExtractorFactory createDbCommentExtractorFactory(UnifiedSchema unifiedSchema) {
        return new DfDbCommentExtractorFactory(this.getBasicProperties(), this.getDataSource(), unifiedSchema);
    }

    protected DfIdentityExtractor createIdentityExtractor() {
        DfIdentityExtractorFactory factory = this.createIdentityExtractorFactory();
        return factory.createIdentityExtractor();
    }

    protected DfIdentityExtractorFactory createIdentityExtractorFactory() {
        return new DfIdentityExtractorFactory(this.getBasicProperties(), this.getDataSource());
    }

    protected DfSynonymExtractor createSynonymExtractor() {
        DfSynonymExtractorFactory factory = this.createSynonymExtractorFactory();
        return factory.createSynonymExtractor();
    }

    protected DfSynonymExtractorFactory createSynonymExtractorFactory() {
        return new DfSynonymExtractorFactory(this.getDataSource(), this.getBasicProperties(), this.getDatabaseProperties(), this._generatedTableMap);
    }

    protected void loadPreviousSchema() {
        try {
            this.doLoadPreviousSchema();
        }
        catch (RuntimeException continued) {
            _log.warn((Object)"*Failed to load previous schema", (Throwable)continued);
        }
    }

    protected void doLoadPreviousSchema() {
        _log.info((Object)"...Loading previous schema (schema diff process)");
        this._schemaDiff.loadPreviousSchema();
        if (this._schemaDiff.isFirstTime()) {
            _log.info((Object)"  -> no previous (first time)");
        }
    }

    protected void loadNextSchema() {
        try {
            this.doLoadNextSchema();
        }
        catch (RuntimeException continued) {
            _log.warn((Object)"*Failed to load next schema", (Throwable)continued);
        }
    }

    protected void doLoadNextSchema() {
        if (this._schemaDiff.isFirstTime() || this._schemaDiff.isLoadingFailure()) {
            return;
        }
        _log.info((Object)"...Loading next schema (schema diff process)");
        this._schemaDiff.loadNextSchema();
        this._schemaDiff.analyzeDiff();
        if (this._schemaDiff.hasDiff()) {
            try {
                _log.info((Object)"  -> different from previous");
                DfSchemaHistory schemaHistory = new DfSchemaHistory();
                _log.info((Object)"...Serializing schema-diff:");
                _log.info((Object)("  filePath = " + schemaHistory.getSchemaHistoryFilePath()));
                schemaHistory.serializeSchemaDiff(this._schemaDiff);
            }
            catch (IOException e) {
                String msg = "*Failed to serialize schema-diff";
                throw new IllegalStateException(msg, e);
            }
        } else {
            _log.info((Object)"  -> same as previous");
        }
    }
}

