/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.exception.EntityAlreadyUpdatedException;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicHandler;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnAbstractAutoHandler
extends TnBasicHandler {
    protected final TnBeanMetaData _beanMetaData;
    protected final TnPropertyType[] _boundPropTypes;
    protected Object[] _bindVariables;
    protected ValueType[] _bindVariableValueTypes;
    protected Timestamp _timestamp;
    protected Integer _versionNo;
    protected boolean _optimisticLockHandling;
    protected boolean _versionNoAutoIncrementOnMemory;
    protected UpdateOption<ConditionBean> _updateOption;

    public TnAbstractAutoHandler(DataSource dataSource, StatementFactory statementFactory, TnBeanMetaData beanMetaData, TnPropertyType[] boundPropTypes) {
        super(dataSource, statementFactory);
        this._beanMetaData = beanMetaData;
        this._boundPropTypes = boundPropTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] args) {
        Connection conn = this.getConnection();
        try {
            int n = this.execute(conn, args[0]);
            return n;
        }
        finally {
            this.close(conn);
        }
    }

    public int execute(Object[] args, Class<?>[] argTypes) {
        return this.execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(Connection conn, Object bean) {
        int ret;
        this.preUpdateBean(bean);
        this.setupBindVariables(bean);
        this.logSql(this._bindVariables, this.getArgTypes(this._bindVariables));
        PreparedStatement ps = this.prepareStatement(conn);
        try {
            this.bindArgs(conn, ps, this._bindVariables, this._bindVariableValueTypes);
            ret = this.executeUpdate(ps);
        }
        finally {
            this.close(ps);
        }
        if (this._optimisticLockHandling && ret < 1) {
            throw this.createEntityAlreadyUpdatedException(bean, ret);
        }
        this.postUpdateBean(bean, ret);
        return ret;
    }

    protected EntityAlreadyUpdatedException createEntityAlreadyUpdatedException(Object bean, int rows) {
        return new EntityAlreadyUpdatedException(bean, rows);
    }

    protected void preUpdateBean(Object bean) {
    }

    protected void postUpdateBean(Object bean, int ret) {
    }

    protected abstract void setupBindVariables(Object var1);

    protected void setupInsertBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        TnBeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < this._boundPropTypes.length; ++i) {
            TnPropertyType pt = this._boundPropTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(timestampPropertyName)) {
                this.setTimestamp(ResourceContext.getAccessTimestamp());
                varList.add(this._timestamp);
            } else if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName)) {
                this.setVersionNo(0);
                varList.add(this._versionNo);
            } else {
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varValueTypeList.add(pt.getValueType());
        }
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void setupUpdateBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        TnBeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < this._boundPropTypes.length; ++i) {
            TnPropertyType pt = this._boundPropTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(timestampPropertyName)) {
                this.setTimestamp(ResourceContext.getAccessTimestamp());
                varList.add(this._timestamp);
            } else if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName)) {
                if (!this._versionNoAutoIncrementOnMemory) continue;
                Object value = pt.getPropertyDesc().getValue(bean);
                int intValue = DfTypeUtil.toPrimitiveInt(value) + 1;
                this.setVersionNo(intValue);
                varList.add(this._versionNo);
            } else {
                if (this._updateOption != null && this._updateOption.hasStatement(pt.getColumnDbName())) continue;
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varValueTypeList.add(pt.getValueType());
        }
        this.addAutoUpdateWhereBindVariables(varList, varValueTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void setupDeleteBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        this.addAutoUpdateWhereBindVariables(varList, varValueTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void addAutoUpdateWhereBindVariables(List<Object> varList, List<ValueType> varValueTypeList, Object bean) {
        DfPropertyDesc pd;
        TnBeanMetaData bmd = this.getBeanMetaData();
        for (int i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            TnPropertyType pt = bmd.getPropertyTypeByColumnName(bmd.getPrimaryKeyDbName(i));
            DfPropertyDesc pd2 = pt.getPropertyDesc();
            varList.add(pd2.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
        if (this._optimisticLockHandling && bmd.hasVersionNoPropertyType()) {
            TnPropertyType pt = bmd.getVersionNoPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
        if (this._optimisticLockHandling && bmd.hasTimestampPropertyType()) {
            TnPropertyType pt = bmd.getTimestampPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
    }

    protected void updateTimestampIfNeed(Object bean) {
        if (this._timestamp != null) {
            DfPropertyDesc pd = this.getBeanMetaData().getTimestampPropertyType().getPropertyDesc();
            pd.setValue(bean, this._timestamp);
        }
    }

    protected void updateVersionNoIfNeed(Object bean) {
        if (this._versionNo != null) {
            DfPropertyDesc pd = this.getBeanMetaData().getVersionNoPropertyType().getPropertyDesc();
            pd.setValue(bean, this._versionNo);
        }
    }

    public TnBeanMetaData getBeanMetaData() {
        return this._beanMetaData;
    }

    protected Object[] getBindVariables() {
        return this._bindVariables;
    }

    protected void setBindVariables(Object[] bindVariables) {
        this._bindVariables = bindVariables;
    }

    protected ValueType[] getBindVariableValueTypes() {
        return this._bindVariableValueTypes;
    }

    protected void setBindVariableValueTypes(ValueType[] bindVariableValueTypes) {
        this._bindVariableValueTypes = bindVariableValueTypes;
    }

    protected void setTimestamp(Timestamp timestamp) {
        this._timestamp = timestamp;
    }

    protected void setVersionNo(Integer versionNo) {
        this._versionNo = versionNo;
    }

    public void setOptimisticLockHandling(boolean optimisticLockHandling) {
        this._optimisticLockHandling = optimisticLockHandling;
    }

    public void setVersionNoAutoIncrementOnMemory(boolean versionNoAutoIncrementOnMemory) {
        this._versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
    }

    public void setUpdateOption(UpdateOption<ConditionBean> updateOption) {
        this._updateOption = updateOption;
    }
}

