/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.info;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.jdbc.ClassificationMeta;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnInfo {
    protected static final List<String> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    protected final DBMeta _dbmeta;
    protected final String _columnDbName;
    protected final ColumnSqlName _columnSqlName;
    protected final String _columnSynonym;
    protected final String _columnAlias;
    protected final boolean _notNull;
    protected final String _propertyName;
    protected final Class<?> _propertyType;
    protected final boolean _primary;
    protected final boolean _autoIncrement;
    protected final String _columnDbType;
    protected final Integer _columnSize;
    protected final Integer _decimalDigits;
    protected final boolean _commonColumn;
    protected final DBMeta.OptimisticLockType _optimisticLockType;
    protected final String _columnComment;
    protected final List<String> _foreignPropList;
    protected final List<String> _referrerPropList;
    protected final ClassificationMeta _classificationMeta;

    public ColumnInfo(DBMeta dbmeta, String columnDbName, String columnSqlName, String columnSynonym, String columnAlias, boolean notNull, String propertyName, Class<?> propertyType, boolean primary, boolean autoIncrement, String columnDbType, Integer columnSize, Integer decimalDigits, boolean commonColumn, DBMeta.OptimisticLockType optimisticLockType, String columnComment, List<String> foreignPropList, List<String> referrerPropList, ClassificationMeta classificationMeta) {
        this.assertObjectNotNull("dbmeta", dbmeta);
        this.assertObjectNotNull("columnDbName", columnDbName);
        this.assertObjectNotNull("columnSqlName", columnSqlName);
        this.assertObjectNotNull("propertyName", propertyName);
        this.assertObjectNotNull("propertyType", propertyType);
        this._dbmeta = dbmeta;
        this._columnDbName = columnDbName;
        this._columnSqlName = new ColumnSqlName(columnSqlName);
        this._columnSynonym = columnSynonym;
        this._columnAlias = columnAlias;
        this._notNull = notNull;
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._primary = primary;
        this._autoIncrement = autoIncrement;
        this._columnSize = columnSize;
        this._columnDbType = columnDbType;
        this._decimalDigits = decimalDigits;
        this._commonColumn = commonColumn;
        this._optimisticLockType = optimisticLockType != null ? optimisticLockType : DBMeta.OptimisticLockType.NONE;
        this._columnComment = columnComment;
        this._foreignPropList = foreignPropList != null ? foreignPropList : EMPTY_LIST;
        this._referrerPropList = referrerPropList != null ? referrerPropList : EMPTY_LIST;
        this._classificationMeta = classificationMeta;
    }

    public <PROPERTY> PROPERTY read(Entity entity) {
        return (PROPERTY)this.invokeMethod(this.reader(), entity, new Object[0]);
    }

    public Method reader() {
        String methodName;
        Class<? extends Entity> entityType = this._dbmeta.getEntityType();
        Method method = this.findMethod(entityType, methodName = this.buildAccessorName("get"), new Class[0]);
        if (method == null) {
            String msg = "Failed to find the method by the name:";
            msg = msg + " methodName=" + methodName;
            throw new IllegalStateException(msg);
        }
        return method;
    }

    public void write(Entity entity, Object value) {
        Object converted = Number.class.isAssignableFrom(this._propertyType) ? DfTypeUtil.toNumber(value, this._propertyType) : (Timestamp.class.isAssignableFrom(this._propertyType) ? DfTypeUtil.toTimestamp(value) : (Time.class.isAssignableFrom(this._propertyType) ? DfTypeUtil.toTime(value) : (Date.class.isAssignableFrom(this._propertyType) ? DfTypeUtil.toDate(value) : (Boolean.class.isAssignableFrom(this._propertyType) ? DfTypeUtil.toBoolean(value) : (byte[].class.isAssignableFrom(this._propertyType) ? (value instanceof Serializable ? (Object)DfTypeUtil.toBinary((Serializable)value) : value) : (UUID.class.isAssignableFrom(this._propertyType) ? DfTypeUtil.toUUID(value) : value))))));
        this.invokeMethod(this.writer(), entity, new Object[]{converted});
    }

    public Method writer() {
        Class<? extends Entity> entityType = this._dbmeta.getEntityType();
        String methodName = this.buildAccessorName("set");
        Method method = this.findMethod(entityType, this.buildAccessorName("set"), new Class[]{this._propertyType});
        if (method == null) {
            String msg = "Failed to find the method by the name:";
            msg = msg + " methodName=" + methodName;
            msg = msg + " propertyType=" + this._propertyType;
            throw new IllegalStateException(msg);
        }
        return this.findMethod(this._dbmeta.getEntityType(), this.buildAccessorName("set"), new Class[]{this._propertyType});
    }

    protected String buildAccessorName(String prefix) {
        return prefix + this.initCap(this._propertyName);
    }

    public Class<?> getGenericType() {
        return DfReflectionUtil.getGenericType(this.reader().getGenericReturnType());
    }

    protected String initCap(String name) {
        return Srl.initCap(name);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        return DfReflectionUtil.getAccessibleMethod(clazz, methodName, argTypes);
    }

    protected Object invokeMethod(Method method, Object target, Object[] args) {
        return DfReflectionUtil.invokeForcedly(method, target, args);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this._dbmeta.hashCode() + this._columnDbName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo target = (ColumnInfo)obj;
        if (!this._dbmeta.equals(target.getDBMeta())) {
            return false;
        }
        return this._columnDbName.equals(target.getColumnDbName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._dbmeta.getTableDbName());
        sb.append(".").append(this._columnDbName);
        sb.append(":{");
        sb.append(this._columnDbType);
        if (this._columnSize != null) {
            sb.append("(").append(this._columnSize);
            if (this._decimalDigits != null) {
                sb.append(", ").append(this._decimalDigits);
            }
            sb.append(")");
        }
        sb.append(", ").append(this._propertyType.getName());
        sb.append("}");
        return sb.toString();
    }

    public DBMeta getDBMeta() {
        return this._dbmeta;
    }

    public String getColumnDbName() {
        return this._columnDbName;
    }

    public ColumnSqlName getColumnSqlName() {
        return this._columnSqlName;
    }

    public String getColumnSynonym() {
        return this._columnSynonym;
    }

    public String getColumnAlias() {
        return this._columnAlias;
    }

    public boolean isNotNull() {
        return this._notNull;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Class<?> getPropertyType() {
        return this._propertyType;
    }

    public boolean isPropertyTypeString() {
        return String.class.isAssignableFrom(this.getPropertyType());
    }

    public boolean isPropertyTypeNumber() {
        return Number.class.isAssignableFrom(this.getPropertyType());
    }

    public boolean isPropertyTypeDate() {
        return Date.class.isAssignableFrom(this.getPropertyType());
    }

    public boolean isPrimary() {
        return this._primary;
    }

    public boolean isAutoIncrement() {
        return this._autoIncrement;
    }

    public String getColumnDbType() {
        return this._columnDbType;
    }

    public Integer getColumnSize() {
        return this._columnSize;
    }

    public Integer getDecimalDigits() {
        return this._decimalDigits;
    }

    public boolean isCommonColumn() {
        return this._commonColumn;
    }

    public boolean isOptimisticLock() {
        return this.isVersionNo() || this.isUpdateDate();
    }

    public boolean isVersionNo() {
        return DBMeta.OptimisticLockType.VERSION_NO == this._optimisticLockType;
    }

    public boolean isUpdateDate() {
        return DBMeta.OptimisticLockType.UPDATE_DATE == this._optimisticLockType;
    }

    public String getColumnComment() {
        return this._columnComment;
    }

    public List<ForeignInfo> getForeignInfoList() {
        ArrayList<ForeignInfo> foreignInfoList = new ArrayList<ForeignInfo>();
        for (String foreignProp : this._foreignPropList) {
            foreignInfoList.add(this.getDBMeta().findForeignInfo(foreignProp));
        }
        return Collections.unmodifiableList(foreignInfoList);
    }

    public List<ReferrerInfo> getReferrerInfoList() {
        ArrayList<ReferrerInfo> referrerInfoList = new ArrayList<ReferrerInfo>();
        for (String fkProp : this._referrerPropList) {
            referrerInfoList.add(this.getDBMeta().findReferrerInfo(fkProp));
        }
        return Collections.unmodifiableList(referrerInfoList);
    }

    public ClassificationMeta getClassificationMeta() {
        return this._classificationMeta;
    }
}

