/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.logic.factory.DfProcedureSynonymExtractorFactory;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.synonym.DfProcedureSynonymExtractor;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfOutsideSqlProperties;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfColumnHandler.class);
    protected boolean _suppressAdditionalSchema;
    protected boolean _suppressFilterByProperty;
    protected DataSource _procedureSynonymDataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DfProcedureMetaInfo> getAvailableProcedureMap(DatabaseMetaData metaData) throws SQLException {
        LinkedHashMap<String, DfProcedureMetaInfo> linkedHashMap;
        block6: {
            DfDatabaseProperties databaseProperties = this.getProperties().getDatabaseProperties();
            String schemaName = databaseProperties.getDatabaseSchema();
            DfOutsideSqlProperties outsideSqlProperties = this.getProperties().getOutsideSqlProperties();
            if (!outsideSqlProperties.isGenerateProcedureParameterBean()) {
                return this.newLinkedHashMap();
            }
            Connection conn = null;
            try {
                List<DfProcedureMetaInfo> procedureList = this.getPlainProcedureList(metaData, schemaName);
                this.setupAdditionalSchemaProcedure(metaData, procedureList);
                this.setupProcedureSynonym(procedureList);
                List<DfProcedureMetaInfo> filteredList = this.filterByProperty(procedureList);
                LinkedHashMap<String, DfProcedureMetaInfo> procedureHandlingMap = this.newLinkedHashMap();
                for (DfProcedureMetaInfo metaInfo : filteredList) {
                    if (this.handleDuplicateProcedure(metaInfo, procedureHandlingMap, schemaName)) continue;
                    procedureHandlingMap.put(metaInfo.getProcedureUniqueName(), metaInfo);
                }
                LinkedHashMap<String, DfProcedureMetaInfo> procedureOrderedMap = this.newLinkedHashMap();
                LinkedHashMap additionalSchemaProcedureMap = this.newLinkedHashMap();
                Set entrySet = procedureHandlingMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    String key = (String)entry.getKey();
                    DfProcedureMetaInfo metaInfo = (DfProcedureMetaInfo)entry.getValue();
                    if (databaseProperties.isAdditionalSchema(metaInfo.getProcedureSchema())) {
                        additionalSchemaProcedureMap.put(key, metaInfo);
                        continue;
                    }
                    procedureOrderedMap.put(key, metaInfo);
                }
                procedureOrderedMap.putAll(additionalSchemaProcedureMap);
                linkedHashMap = procedureOrderedMap;
                Object var17_16 = null;
                if (conn == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var17_17 = null;
                    if (conn == null) break block7;
                    conn.close();
                }
                throw throwable;
            }
            conn.close();
        }
        return linkedHashMap;
    }

    protected void setupAdditionalSchemaProcedure(DatabaseMetaData metaData, List<DfProcedureMetaInfo> procedureList) throws SQLException {
        if (this._suppressAdditionalSchema) {
            return;
        }
        DfDatabaseProperties databaseProperties = this.getProperties().getDatabaseProperties();
        Map<String, DfAdditionalSchemaInfo> additionalSchemaMap = databaseProperties.getAdditionalSchemaMap();
        Set<String> additionalSchemaSet = additionalSchemaMap.keySet();
        for (String additionalSchema : additionalSchemaSet) {
            List<DfProcedureMetaInfo> additionalProcedureList = this.getPlainProcedureList(metaData, additionalSchema);
            for (DfProcedureMetaInfo metaInfo : additionalProcedureList) {
                String procedureSchema = metaInfo.getProcedureSchema();
                if (procedureSchema != null && procedureSchema.trim().length() != 0) continue;
                metaInfo.setProcedureSchema(additionalSchema);
            }
            procedureList.addAll(additionalProcedureList);
        }
    }

    protected void setupProcedureSynonym(List<DfProcedureMetaInfo> procedureList) {
        if (this._procedureSynonymDataSource == null) {
            return;
        }
        DfOutsideSqlProperties prop = this.getProperties().getOutsideSqlProperties();
        DfOutsideSqlProperties.ProcedureSynonymHandlingType handlingType = prop.getProcedureSynonymHandlingType();
        if (handlingType.equals((Object)DfOutsideSqlProperties.ProcedureSynonymHandlingType.NONE)) {
            return;
        }
        DfProcedureSynonymExtractor extractor = this.createProcedureSynonymExtractor();
        if (extractor == null) {
            return;
        }
        Map<String, DfProcedureSynonymMetaInfo> procedureSynonymMap = extractor.extractProcedureSynonymMap();
        if (!handlingType.equals((Object)DfOutsideSqlProperties.ProcedureSynonymHandlingType.INCLUDE)) {
            if (handlingType.equals((Object)DfOutsideSqlProperties.ProcedureSynonymHandlingType.SWITCH)) {
                _log.info((Object)("...Clearing normal procedures: count=" + procedureList.size()));
                procedureList.clear();
            } else {
                String msg = "Unexpected handling type of procedure sysnonym: " + (Object)((Object)handlingType);
                throw new IllegalStateException(msg);
            }
        }
        DfDatabaseProperties databaseProperties = this.getProperties().getDatabaseProperties();
        String mainSchemaName = databaseProperties.getDatabaseSchema();
        _log.info((Object)("...Adding procedure synonyms as procedure: count=" + procedureSynonymMap.size()));
        Set<Map.Entry<String, DfProcedureSynonymMetaInfo>> entrySet = procedureSynonymMap.entrySet();
        ArrayList<DfProcedureMetaInfo> procedureSynonymList = new ArrayList<DfProcedureMetaInfo>();
        for (Map.Entry<String, DfProcedureSynonymMetaInfo> entry : entrySet) {
            DfProcedureSynonymMetaInfo metaInfo = entry.getValue();
            if (!this.isSynonymAllowedSchema(metaInfo)) continue;
            String beforeName = metaInfo.getProcedureMetaInfo().getProcedureFullName();
            DfProcedureMetaInfo mergedProcedure = metaInfo.createMergedProcedure(mainSchemaName);
            String afterName = mergedProcedure.getProcedureFullName();
            _log.info((Object)("  " + beforeName + " to " + afterName));
            procedureSynonymList.add(mergedProcedure);
        }
        procedureList.addAll(procedureSynonymList);
    }

    protected boolean isSynonymAllowedSchema(DfProcedureSynonymMetaInfo procedureSynonymMetaInfo) {
        DfSynonymMetaInfo synonymMetaInfo = procedureSynonymMetaInfo.getSynonymMetaInfo();
        String synonymOwner = synonymMetaInfo.getSynonymOwner();
        DfDatabaseProperties databaseProperties = this.getProperties().getDatabaseProperties();
        String mainSchema = databaseProperties.getDatabaseSchema();
        if (mainSchema != null && mainSchema.equalsIgnoreCase(synonymOwner) && databaseProperties.hasObjectTypeSynonym()) {
            return true;
        }
        Map<String, DfAdditionalSchemaInfo> additionalSchemaMap = databaseProperties.getAdditionalSchemaMap();
        DfAdditionalSchemaInfo additionalSchemaInfo = additionalSchemaMap.get(synonymOwner);
        return additionalSchemaInfo != null && additionalSchemaInfo.hasObjectTypeSynonym();
    }

    protected DfProcedureSynonymExtractor createProcedureSynonymExtractor() {
        DfProcedureSynonymExtractorFactory factory = new DfProcedureSynonymExtractorFactory(this._procedureSynonymDataSource, this.getBasicProperties(), this.getProperties().getDatabaseProperties());
        return factory.createSynonymExtractor();
    }

    protected List<DfProcedureMetaInfo> filterByProperty(List<DfProcedureMetaInfo> procedureList) {
        if (this._suppressFilterByProperty) {
            return procedureList;
        }
        DfOutsideSqlProperties outsideSqlProperties = this.getProperties().getOutsideSqlProperties();
        ArrayList<DfProcedureMetaInfo> resultList = new ArrayList<DfProcedureMetaInfo>();
        _log.info((Object)("...Filtering procedures by the property: before=" + procedureList.size()));
        int passedCount = 0;
        for (DfProcedureMetaInfo metaInfo : procedureList) {
            String procedureName;
            String procedureFullName = this.buildProcedureFullName(metaInfo);
            String procedureCatalog = metaInfo.getProcedureCatalog();
            if (!outsideSqlProperties.isTargetProcedureCatalog(procedureCatalog)) {
                _log.info((Object)("  passed: non-target catalog - " + procedureFullName));
                ++passedCount;
                continue;
            }
            String procedureSchema = metaInfo.getProcedureSchema();
            if (!outsideSqlProperties.isTargetProcedureSchema(procedureSchema)) {
                _log.info((Object)("  passed: non-target schema - " + procedureFullName));
                ++passedCount;
                continue;
            }
            if (!outsideSqlProperties.isTargetProcedureName(procedureFullName) && !outsideSqlProperties.isTargetProcedureName(procedureName = metaInfo.getProcedureName())) {
                _log.info((Object)("  passed: non-target name - " + procedureFullName));
                ++passedCount;
                continue;
            }
            resultList.add(metaInfo);
        }
        if (passedCount == 0) {
            _log.info((Object)("  --> All procedures are target: count=" + procedureList.size()));
        }
        return resultList;
    }

    protected boolean handleDuplicateProcedure(DfProcedureMetaInfo metaInfo, Map<String, DfProcedureMetaInfo> procdureMap, String schemaName) {
        String procedureUniqueName = metaInfo.getProcedureUniqueName();
        DfProcedureMetaInfo first = procdureMap.get(procedureUniqueName);
        if (first == null) {
            return false;
        }
        String firstSchema = first.getProcedureSchema();
        String secondSchema = metaInfo.getProcedureSchema();
        if (firstSchema != null && !firstSchema.equalsIgnoreCase(secondSchema) && firstSchema.equalsIgnoreCase(schemaName)) {
            this.showDuplicateProcedure(first, metaInfo, true, "main schema");
            return true;
        }
        if (secondSchema != null && !secondSchema.equalsIgnoreCase(firstSchema) && secondSchema.equalsIgnoreCase(schemaName)) {
            procdureMap.remove(procedureUniqueName);
            this.showDuplicateProcedure(first, metaInfo, false, "main schema");
            return false;
        }
        this.showDuplicateProcedure(first, metaInfo, true, "first one");
        return true;
    }

    protected void showDuplicateProcedure(DfProcedureMetaInfo first, DfProcedureMetaInfo second, boolean electFirst, String reason) {
        String firstName = first.getProcedureFullName();
        String secondName = second.getProcedureFullName();
        String firstType = first.isProcedureSynonym() ? "(synonym)" : "";
        String secondType = second.isProcedureSynonym() ? "(synonym)" : "";
        String msg = "*Found the same-name procedure, so elects " + reason + ":";
        msg = electFirst ? msg + " elect=" + firstName + firstType + " skipped=" + secondName + secondType : msg + " elect=" + secondName + secondType + " skipped=" + firstName + firstType;
        _log.info((Object)msg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DfProcedureMetaInfo> getPlainProcedureList(DatabaseMetaData metaData, String schemaName) throws SQLException {
        schemaName = this.filterSchemaName(schemaName);
        if (this.isPostgreSQL() && (schemaName == null || schemaName.trim().length() == 0)) {
            schemaName = "public";
        }
        ArrayList<DfProcedureMetaInfo> metaInfoList = new ArrayList<DfProcedureMetaInfo>();
        ResultSet columnResultSet = null;
        try {
            try {
                ResultSet procedureRs = metaData.getProcedures(null, schemaName, null);
                this.setupProcedureMetaInfo(metaInfoList, procedureRs);
                for (DfProcedureMetaInfo procedureMetaInfo : metaInfoList) {
                    String procedureName = procedureMetaInfo.getProcedureName();
                    ResultSet columnRs = metaData.getProcedureColumns(null, schemaName, procedureName, null);
                    this.setupProcedureColumnMetaInfo(procedureMetaInfo, columnRs);
                }
                Object var11_12 = null;
                if (columnResultSet == null) return metaInfoList;
            }
            catch (SQLException e) {
                String msg = "Failed to get a list of procedures:";
                msg = msg + " schemaName=" + schemaName;
                throw new DfJDBCException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (columnResultSet == null) throw throwable;
            try {
                columnResultSet.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ignored) {}
        columnResultSet.close();
        return metaInfoList;
    }

    protected void setupProcedureMetaInfo(List<DfProcedureMetaInfo> procedureMetaInfoList, ResultSet procedureRs) throws SQLException {
        while (procedureRs.next()) {
            String procedureCatalog = procedureRs.getString("PROCEDURE_CAT");
            String procedureSchema = procedureRs.getString("PROCEDURE_SCHEM");
            String procedureName = procedureRs.getString("PROCEDURE_NAME");
            Integer procedureType = new Integer(procedureRs.getString("PROCEDURE_TYPE"));
            String procedureComment = procedureRs.getString("REMARKS");
            if (this.isPostgreSQL() && procedureName != null && procedureName.toLowerCase().startsWith("pl")) continue;
            DfProcedureMetaInfo metaInfo = new DfProcedureMetaInfo();
            metaInfo.setProcedureCatalog(procedureCatalog);
            metaInfo.setProcedureSchema(procedureSchema);
            metaInfo.setProcedureName(procedureName);
            if (procedureType == 0) {
                metaInfo.setProcedureType(DfProcedureMetaInfo.DfProcedureType.procedureResultUnknown);
            } else if (procedureType == 1) {
                metaInfo.setProcedureType(DfProcedureMetaInfo.DfProcedureType.procedureNoResult);
            } else if (procedureType == 2) {
                metaInfo.setProcedureType(DfProcedureMetaInfo.DfProcedureType.procedureReturnsResult);
            } else {
                throw new IllegalStateException("Unknown procedureType: " + procedureType);
            }
            metaInfo.setProcedureComment(procedureComment);
            metaInfo.setProcedureFullName(this.buildProcedureFullName(metaInfo));
            metaInfo.setProcedureSqlName(this.buildProcedureSqlName(metaInfo));
            metaInfo.setProcedureUniqueName(this.buildProcedureUniqueName(metaInfo));
            procedureMetaInfoList.add(metaInfo);
        }
    }

    protected void setupProcedureColumnMetaInfo(DfProcedureMetaInfo procedureMetaInfo, ResultSet columnRs) throws SQLException {
        while (columnRs.next()) {
            String length;
            String columnName = columnRs.getString("COLUMN_NAME");
            String columnType = columnRs.getString("COLUMN_TYPE");
            boolean unknowType = false;
            Integer procedureColumnType = columnType != null ? new Integer(columnType) : 0;
            String dataType = columnRs.getString("DATA_TYPE");
            Integer jdbcType = dataType != null ? new Integer(dataType) : 1111;
            String dbTypeName = columnRs.getString("TYPE_NAME");
            String precision = columnRs.getString("PRECISION");
            Integer columnSize = precision != null && precision.trim().length() != 0 ? new Integer(precision) : ((length = columnRs.getString("LENGTH")) != null ? new Integer(length) : null);
            String scale = columnRs.getString("SCALE");
            Integer decimalDigits = scale != null ? new Integer(scale) : null;
            String columnComment = columnRs.getString("REMARKS");
            DfProcedureColumnMetaInfo procedureColumnMetaInfo = new DfProcedureColumnMetaInfo();
            procedureColumnMetaInfo.setColumnName(columnName);
            if (procedureColumnType == 0) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnUnknown);
            } else if (procedureColumnType == 1) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnIn);
            } else if (procedureColumnType == 2) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnInOut);
            } else if (procedureColumnType == 4) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnOut);
            } else if (procedureColumnType == 5) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn);
            } else if (procedureColumnType == 3) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnResult);
            } else {
                throw new IllegalStateException("Unknown procedureColumnType: " + procedureColumnType);
            }
            procedureColumnMetaInfo.setJdbcType(jdbcType);
            procedureColumnMetaInfo.setDbTypeName(dbTypeName);
            procedureColumnMetaInfo.setColumnSize(columnSize);
            procedureColumnMetaInfo.setDecimalDigits(decimalDigits);
            procedureColumnMetaInfo.setColumnComment(columnComment);
            procedureMetaInfo.addProcedureColumnMetaInfo(procedureColumnMetaInfo);
        }
        this.adjustProcedureColumnList(procedureMetaInfo);
    }

    protected String buildProcedureFullName(DfProcedureMetaInfo metaInfo) {
        return this.buildProcedureArrangeName(metaInfo, true, true);
    }

    protected String buildProcedureSqlName(DfProcedureMetaInfo metaInfo) {
        boolean includeMainSchema = this.isDB2();
        return this.buildProcedureArrangeName(metaInfo, true, includeMainSchema);
    }

    protected String buildProcedureUniqueName(DfProcedureMetaInfo metaInfo) {
        return this.buildProcedureArrangeName(metaInfo, false, false);
    }

    protected String buildProcedureArrangeName(DfProcedureMetaInfo metaInfo, boolean includeSchema, boolean includeMainSchema) {
        String procedureCatalog;
        String procedureSchema;
        DfDatabaseProperties databaseProperties = this.getProperties().getDatabaseProperties();
        StringBuilder sb = new StringBuilder();
        if (includeSchema && (procedureSchema = metaInfo.getProcedureSchema()) != null && procedureSchema.trim().length() > 0) {
            if (includeMainSchema) {
                sb.append(procedureSchema).append(".");
            } else if (databaseProperties.isAdditionalSchema(procedureSchema)) {
                sb.append(procedureSchema).append(".");
            }
        }
        if ((procedureCatalog = metaInfo.getProcedureCatalog()) != null && procedureCatalog.trim().length() > 0 && this.getBasicProperties().isDatabaseOracle()) {
            sb.append(procedureCatalog).append(".");
        }
        String procedureName = metaInfo.getProcedureName();
        return sb.append(procedureName).toString();
    }

    protected void adjustProcedureColumnList(DfProcedureMetaInfo procedureMetaInfo) {
        this.adjustPostgreSQLResultSetParameter(procedureMetaInfo);
    }

    protected void adjustPostgreSQLResultSetParameter(DfProcedureMetaInfo procedureMetaInfo) {
        if (!this.isPostgreSQL()) {
            return;
        }
        List<DfProcedureColumnMetaInfo> columnMetaInfoList = procedureMetaInfo.getProcedureColumnMetaInfoList();
        boolean existsResultSetParameter = false;
        boolean existsResultSetReturn = false;
        int resultSetReturnIndex = 0;
        String resultSetReturnName = null;
        int index = 0;
        for (DfProcedureColumnMetaInfo columnMetaInfo : columnMetaInfoList) {
            DfProcedureColumnMetaInfo.DfProcedureColumnType procedureColumnType = columnMetaInfo.getProcedureColumnType();
            String dbTypeName = columnMetaInfo.getDbTypeName();
            if (procedureColumnType.equals((Object)DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnOut) && "refcursor".equalsIgnoreCase(dbTypeName)) {
                existsResultSetParameter = true;
            }
            if (procedureColumnType.equals((Object)DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn) && "refcursor".equalsIgnoreCase(dbTypeName)) {
                existsResultSetReturn = true;
                resultSetReturnIndex = index;
                resultSetReturnName = columnMetaInfo.getColumnName();
            }
            ++index;
        }
        if (existsResultSetParameter && existsResultSetReturn) {
            String name = procedureMetaInfo.getProcedureFullName() + "." + resultSetReturnName;
            _log.info((Object)("...Removing the result set return which is unnecessary: " + name));
            columnMetaInfoList.remove(resultSetReturnIndex);
        }
    }

    public void suppressAdditionalSchema() {
        this._suppressAdditionalSchema = true;
    }

    public void suppressFilterByProperty() {
        this._suppressFilterByProperty = true;
    }

    public void includeProcedureSynonym(DataSource dataSource) {
        this._procedureSynonymDataSource = dataSource;
    }
}

