/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.dataset;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.dataset.DfDataColumn;
import org.seasar.dbflute.helper.dataset.DfDataRow;
import org.seasar.dbflute.helper.dataset.states.DfDtsRowStates;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnType;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnTypes;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfUniqueKeyHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDataTable {
    private String _tableName;
    private Map<String, DfDataColumn> _columnMap = StringKeyMap.createAsFlexibleOrdered();
    private List<DfDataColumn> _columnList = new ArrayList<DfDataColumn>();
    private List<DfDataRow> _rows = new ArrayList<DfDataRow>();
    private List<DfDataRow> _removedRows = new ArrayList<DfDataRow>();
    private boolean _hasMetaData = false;

    public DfDataTable(String tableName) {
        this.setTableName(tableName);
    }

    public int getRowSize() {
        return this._rows.size();
    }

    public DfDataRow getRow(int index) {
        return this._rows.get(index);
    }

    public DfDataRow addRow() {
        DfDataRow row = new DfDataRow(this);
        this._rows.add(row);
        row.setState(DfDtsRowStates.CREATED);
        return row;
    }

    public int getRemovedRowSize() {
        return this._removedRows.size();
    }

    public DfDataRow getRemovedRow(int index) {
        return this._removedRows.get(index);
    }

    public DfDataRow[] removeRows() {
        int i = 0;
        while (i < this._rows.size()) {
            DfDataRow row = this.getRow(i);
            if (row.getState().equals(DfDtsRowStates.REMOVED)) {
                this._removedRows.add(row);
                this._rows.remove(i);
                continue;
            }
            ++i;
        }
        return this._removedRows.toArray(new DfDataRow[this._removedRows.size()]);
    }

    public int getColumnSize() {
        return this._columnMap.size();
    }

    public DfDataColumn getColumn(int index) {
        return this._columnList.get(index);
    }

    public DfDataColumn getColumn(String columnName) {
        DfDataColumn column = this.getColumn0(columnName);
        if (column == null) {
            String msg = "The column was not found in the table: ";
            msg = msg + " tableName=" + this._tableName + " columnName=" + columnName;
            throw new IllegalStateException(msg);
        }
        return column;
    }

    private DfDataColumn getColumn0(String columnName) {
        return this._columnMap.get(columnName);
    }

    public boolean hasColumn(String columnName) {
        return this.getColumn0(columnName) != null;
    }

    public String getColumnName(int index) {
        return this.getColumn(index).getColumnName();
    }

    public DfDtsColumnType getColumnType(int index) {
        return this.getColumn(index).getColumnType();
    }

    public DfDtsColumnType getColumnType(String columnName) {
        return this.getColumn(columnName).getColumnType();
    }

    public DfDataColumn addColumn(String columnName) {
        return this.addColumn(columnName, DfDtsColumnTypes.OBJECT);
    }

    public DfDataColumn addColumn(String columnName, DfDtsColumnType columnType) {
        DfDataColumn column = new DfDataColumn(columnName, columnType, this._columnMap.size());
        this._columnMap.put(columnName, column);
        this._columnList.add(column);
        return column;
    }

    public boolean hasMetaData() {
        return this._hasMetaData;
    }

    public void setupMetaData(DatabaseMetaData metaData, String schemaName) {
        Map<String, DfColumnMetaInfo> metaMap = this.extractColumnMetaMap(metaData, schemaName);
        Set<String> primaryKeySet = this.getPrimaryKeySet(metaData, schemaName);
        for (int i = 0; i < this.getColumnSize(); ++i) {
            DfDataColumn column = this.getColumn(i);
            if (primaryKeySet.contains(column.getColumnName())) {
                column.setPrimaryKey(true);
            } else {
                column.setPrimaryKey(false);
            }
            DfColumnMetaInfo metaInfo = metaMap.get(column.getColumnName());
            if (metaInfo != null) {
                column.setWritable(true);
                int jdbcDefValue = metaInfo.getJdbcDefValue();
                column.setColumnType(DfDtsColumnTypes.getColumnType(jdbcDefValue));
                continue;
            }
            column.setWritable(false);
        }
        this._hasMetaData = true;
    }

    protected Map<String, DfColumnMetaInfo> extractColumnMetaMap(DatabaseMetaData metaData, String schemaName) {
        List<DfColumnMetaInfo> metaList = new DfColumnHandler().getColumnList(metaData, schemaName, this._tableName);
        HashMap<String, DfColumnMetaInfo> metaMap = new HashMap<String, DfColumnMetaInfo>();
        for (DfColumnMetaInfo metaInfo : metaList) {
            metaMap.put(metaInfo.getColumnName(), metaInfo);
        }
        return metaMap;
    }

    protected Set<String> getPrimaryKeySet(DatabaseMetaData metaData, String schemaName) {
        try {
            DfPrimaryKeyMetaInfo pkInfo = new DfUniqueKeyHandler().getPrimaryKey(metaData, schemaName, this._tableName);
            List<String> list = pkInfo.getPrimaryKeyList();
            return new HashSet<String>(list);
        }
        catch (SQLException e) {
            String msg = "SQLException occured: schemaName=" + schemaName + " tableName=" + this._tableName;
            throw new IllegalStateException(msg);
        }
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(100);
        buf.append(this._tableName);
        buf.append(":");
        for (i = 0; i < this._columnMap.size(); ++i) {
            buf.append(this.getColumnName(i));
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append("\n");
        for (i = 0; i < this._rows.size(); ++i) {
            buf.append(this.getRow(i) + "\n");
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    public boolean equals(Object o) {
        int i;
        if (o == this) {
            return true;
        }
        if (!(o instanceof DfDataTable)) {
            return false;
        }
        DfDataTable other = (DfDataTable)o;
        if (this.getRowSize() != other.getRowSize()) {
            return false;
        }
        for (i = 0; i < this.getRowSize(); ++i) {
            if (this.getRow(i).equals(other.getRow(i))) continue;
            return false;
        }
        if (this.getRemovedRowSize() != other.getRemovedRowSize()) {
            return false;
        }
        for (i = 0; i < this.getRemovedRowSize(); ++i) {
            if (this.getRemovedRow(i).equals(other.getRemovedRow(i))) continue;
            return false;
        }
        return true;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }
}

