/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.friends.torque;

import java.util.List;
import org.apache.torque.engine.database.model.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfTorqueColumnListToStringUtil {
    public static String getColumnArgsString(List<Column> columnList) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String javaNative = pk.getJavaNative();
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(javaNative).append(" ").append(uncapitalisedJavaName);
        }
        return sb.toString();
    }

    public static String getColumnArgsJavaDocString(List<Column> columnList, String ln) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            if (sb.length() > 0) {
                sb.append(ln).append("     * ");
            }
            sb.append("@param ").append(uncapitalisedJavaName);
            sb.append(" The one of primary key. (NotNull)");
        }
        return sb.toString();
    }

    public static String getColumnArgsAssertString(List<Column> columnList) {
        return DfTorqueColumnListToStringUtil.doGetColumnArgsAssertString(columnList, false);
    }

    public static String getColumnArgsAssertStringCSharp(List<Column> columnList) {
        return DfTorqueColumnListToStringUtil.doGetColumnArgsAssertString(columnList, true);
    }

    private static String doGetColumnArgsAssertString(List<Column> columnList, boolean initCap) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            sb.append(initCap ? "A" : "a").append("ssertObjectNotNull(\"");
            sb.append(uncapitalisedJavaName).append("\", ");
            sb.append(uncapitalisedJavaName).append(");");
        }
        return sb.toString();
    }

    public static String getColumnArgsSetupString(String beanName, List<Column> columnList) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        String beanPrefix = beanName != null ? beanName + "." : "";
        String result = "";
        for (Column pk : columnList) {
            String javaName = pk.getJavaName();
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            String setterString = beanPrefix + "set" + javaName + "(" + uncapitalisedJavaName + ");";
            if ("".equals(result)) {
                result = setterString;
                continue;
            }
            result = result + setterString;
        }
        return result;
    }

    public static String getColumnArgsSetupStringCSharp(String beanName, List<Column> columnList) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        String beanPrefix = beanName != null ? beanName + "." : "";
        String result = "";
        for (Column pk : columnList) {
            String javaName = pk.getJavaName();
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            String setterString = beanPrefix + javaName + " = " + uncapitalisedJavaName + ";";
            if ("".equals(result)) {
                result = setterString;
                continue;
            }
            result = result + setterString;
        }
        return result;
    }

    public static String getColumnArgsConditionSetupString(List<Column> columnList) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String javaName = pk.getJavaName();
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            String setterString = "cb.query().set" + javaName + "_Equal(" + uncapitalisedJavaName + ");";
            sb.append(setterString);
        }
        return sb.toString();
    }

    public static String getColumnArgsConditionSetupStringCSharp(List<Column> columnList) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String javaName = pk.getJavaName();
            String uncapitalisedJavaName = pk.getUncapitalisedJavaName();
            String setterString = "cb.Query().Set" + javaName + "_Equal(" + uncapitalisedJavaName + ");";
            sb.append(setterString);
        }
        return sb.toString();
    }

    public static String getColumnNameCommaString(List<Column> columnList) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column col : columnList) {
            String name = col.getName();
            if ("".equals(result)) {
                result = name;
                continue;
            }
            result = result + ", " + name;
        }
        return result;
    }

    public static String getColumnJavaNameCommaString(List<Column> columnList) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column col : columnList) {
            String name = col.getJavaName();
            if ("".equals(result)) {
                result = name;
                continue;
            }
            result = result + ", " + name;
        }
        return result;
    }

    public static String getColumnUncapitalisedJavaNameCommaString(List<Column> columnList) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column col : columnList) {
            String name = col.getUncapitalisedJavaName();
            if ("".equals(result)) {
                result = name;
                continue;
            }
            result = result + ", " + name;
        }
        return result;
    }

    public static String getColumnGetterCommaString(List<Column> columnList) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column col : columnList) {
            String javaName = col.getJavaName();
            String getterString = "get" + javaName + "()";
            if ("".equals(result)) {
                result = getterString;
                continue;
            }
            result = result + ", " + getterString;
        }
        return result;
    }

    public static String getColumnOrderByString(List<Column> columnList, String sortString) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        StringBuilder sb = new StringBuilder();
        for (Column pk : columnList) {
            String name = pk.getName();
            if ("".equals(sb.toString())) {
                sb.append(name).append(" ").append(sortString);
                continue;
            }
            sb.append(", ").append(name).append(" ").append(sortString);
        }
        return sb.toString();
    }

    public static String getColumnDispValueString(List<Column> columnList, String getterPrefix) {
        DfTorqueColumnListToStringUtil.validateColumnList(columnList);
        String result = "";
        for (Column pk : columnList) {
            String javaName = pk.getJavaName();
            String getterString = getterPrefix + javaName + "()";
            if ("".equals(result)) {
                result = getterString;
                continue;
            }
            result = result + " + \"-\" + " + getterString;
        }
        return result;
    }

    private static void validateColumnList(List<Column> columnList) {
        if (columnList == null) {
            String msg = "The columnList is null.";
            throw new IllegalStateException(msg);
        }
    }
}

