/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.logic.bqp.DfBehaviorQueryPathSetupper;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.task.bs.DfAbstractDbMetaTexenTask;

public class TorqueDataModelTask
extends DfAbstractDbMetaTexenTask {
    private static final Log _log = LogFactory.getLog(TorqueDataModelTask.class);

    protected void doExecute() {
        this.setupControlTemplate();
        super.doExecute();
        this.setupBehaviorQueryPath();
        this.showSkippedFileInformation();
        this.refreshResources();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setupControlTemplate() {
        DfLittleAdjustmentProperties littleProp = DfBuildProperties.getInstance().getLittleAdjustmentProperties();
        if (littleProp.isAlternateGenerateControlValid()) {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * * * * * * *");
            _log.info((Object)"* Process Alternate Control *");
            _log.info((Object)"* * * * * * * * * * * * * * *");
            String control = littleProp.getAlternateGenerateControl();
            _log.info((Object)("...Using alternate control: " + control));
            this.setControlTemplate(control);
            return;
        }
        if (!this.getBasicProperties().isTargetLanguageMain()) {
            String language = this.getBasicProperties().getTargetLanguage();
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * *");
            _log.info((Object)("* Process " + language + "    *"));
            _log.info((Object)"* * * * * * * * * *");
            String control = "om/" + language + "/Control-" + language + ".vm";
            _log.info((Object)("...Using " + language + " control: " + control));
            this.setControlTemplate(control);
            return;
        }
        if (this.getBasicProperties().isTargetLanguageJava()) {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * *");
            _log.info((Object)"* Process Java  *");
            _log.info((Object)"* * * * * * * * *");
            String control = "om/ControlGenerateJava.vm";
            _log.info((Object)"...Using Java control: om/ControlGenerateJava.vm");
            this.setControlTemplate("om/ControlGenerateJava.vm");
            return;
        }
        if (this.getBasicProperties().isTargetLanguageCSharp()) {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * *");
            _log.info((Object)"* Process CSharp  *");
            _log.info((Object)"* * * * * * * * * *");
            String control = "om/ControlGenerateCSharp.vm";
            _log.info((Object)"...Using CSharp control: om/ControlGenerateCSharp.vm");
            this.setControlTemplate("om/ControlGenerateCSharp.vm");
            return;
        }
        String msg = "Unknown Main Language: " + this.getBasicProperties().getTargetLanguage();
        throw new IllegalStateException(msg);
    }

    protected boolean isUseDataSource() {
        return true;
    }

    protected void setupBehaviorQueryPath() {
        List<File> sqlFileList = this.collectSqlFileList();
        DfBehaviorQueryPathSetupper setupper = new DfBehaviorQueryPathSetupper(this.getProperties());
        setupper.setupBehaviorQueryPath(sqlFileList);
    }
}

