/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.transform;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.Unique;
import org.apache.torque.engine.database.transform.DTDResolver;
import org.seasar.dbflute.DfBuildProperties;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler {
    private AppData app;
    private Database currDB;
    private Table currTable;
    private Column currColumn;
    private ForeignKey currFK;
    private Index currIndex;
    private Unique currUnique;
    private boolean firstPass;
    private String currentPackage;
    private String currentXmlFile;
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private Vector<String> alreadyReadFiles;
    private Stack<ParseStackElement> parsingStack = new Stack();

    public XmlToAppData(String databaseType) {
        this.app = new AppData(databaseType);
        this.firstPass = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppData parseFile(String xmlFile) {
        try {
            if (!this.firstPass) {
                throw new Error("No more double pass");
            }
            if (this.alreadyReadFiles != null && this.alreadyReadFiles.contains(xmlFile)) {
                return this.app;
            }
            if (this.alreadyReadFiles == null) {
                this.alreadyReadFiles = new Vector(3, 1);
            }
            this.alreadyReadFiles.add(xmlFile);
            this.currentXmlFile = xmlFile;
            String encoding = this.getProejctSchemaXMLEncoding();
            InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(xmlFile), encoding);
            BufferedReader br = new BufferedReader(fr);
            try {
                InputSource is = new InputSource(br);
                SAXParser parser = saxFactory.newSAXParser();
                parser.parse(is, (DefaultHandler)this);
            }
            finally {
                br.close();
            }
        }
        catch (Exception e) {
            String msg = this.getClass().getSimpleName() + ".parseFile() threw the exception:";
            msg = msg + " xmlFile=" + xmlFile;
            throw new RuntimeException(msg, e);
        }
        this.firstPass = false;
        return this.app;
    }

    protected String getProejctSchemaXMLEncoding() {
        return DfBuildProperties.getInstance().getBasicProperties().getProejctSchemaXMLEncoding();
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return new DTDResolver().resolveEntity(publicId, systemId);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        try {
            if (rawName.equals("database")) {
                this.currDB = this.app.addDatabase(attributes);
            } else if (rawName.equals("table")) {
                this.currTable = this.currDB.addTable(attributes);
            } else if (rawName.equals("column")) {
                this.currColumn = this.currTable.addColumn(attributes);
            } else if (rawName.equals("inheritance")) {
                this.currColumn.addInheritance(attributes);
            } else if (rawName.equals("foreign-key")) {
                this.currFK = this.currTable.addForeignKey(attributes);
            } else if (rawName.equals("reference")) {
                this.currFK.addReference(attributes);
            } else if (rawName.equals("index")) {
                this.currIndex = this.currTable.addIndex(attributes);
            } else if (rawName.equals("index-column")) {
                this.currIndex.addColumn(attributes);
            } else if (rawName.equals("unique")) {
                this.currUnique = this.currTable.addUnique(attributes);
            } else if (rawName.equals("unique-column")) {
                this.currUnique.addColumn(attributes);
            } else if (rawName.equals("id-method-parameter")) {
                this.currTable.addIdMethodParameter(attributes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void endElement(String uri, String localName, String rawName) {
    }

    static {
        saxFactory.setValidating(true);
    }

    protected static class ParseStackElement {
        private String currentPackage;
        private String currentXmlFile;
        private boolean firstPass;

        public ParseStackElement(XmlToAppData parser) {
            this.currentPackage = parser.currentPackage;
            this.currentXmlFile = parser.currentXmlFile;
            this.firstPass = parser.firstPass;
            parser.parsingStack.push(this);
        }

        public static void popState(XmlToAppData parser) {
            if (!parser.parsingStack.isEmpty()) {
                ParseStackElement elem = (ParseStackElement)parser.parsingStack.pop();
                parser.currentPackage = elem.currentPackage;
                parser.currentXmlFile = elem.currentXmlFile;
                parser.firstPass = elem.firstPass;
            }
        }

        public static void pushState(XmlToAppData parser) {
            new ParseStackElement(parser);
        }
    }
}

