/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.seasar.dbflute.exception.EndCommentNotFoundException;
import org.seasar.dbflute.exception.IfCommentConditionNotFoundException;
import org.seasar.dbflute.twowaysql.DisplaySqlBuilder;
import org.seasar.dbflute.twowaysql.SqlTokenizer;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.context.CommandContextCreator;
import org.seasar.dbflute.twowaysql.factory.SqlAnalyzerFactory;
import org.seasar.dbflute.twowaysql.node.BeginNode;
import org.seasar.dbflute.twowaysql.node.BindVariableNode;
import org.seasar.dbflute.twowaysql.node.ContainerNode;
import org.seasar.dbflute.twowaysql.node.ElseNode;
import org.seasar.dbflute.twowaysql.node.EmbeddedValueNode;
import org.seasar.dbflute.twowaysql.node.IfNode;
import org.seasar.dbflute.twowaysql.node.Node;
import org.seasar.dbflute.twowaysql.node.PrefixSqlNode;
import org.seasar.dbflute.twowaysql.node.SqlNode;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAnalyzer {
    protected String _specifiedSql;
    protected boolean _blockNullParameter;
    protected SqlTokenizer _tokenizer;
    protected Stack<Node> _nodeStack = new Stack();
    protected List<String> _researchIfCommentList;
    protected List<String> _researchBindVariableCommentList;
    protected List<String> _researchEmbeddedValueCommentList;

    public SqlAnalyzer(String sql, boolean blockNullParameter) {
        sql = sql.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        this._specifiedSql = sql;
        this._blockNullParameter = blockNullParameter;
        this._tokenizer = new SqlTokenizer(sql);
    }

    public Node analyze() {
        this.push(new ContainerNode());
        while (99 != this._tokenizer.next()) {
            this.parseToken();
        }
        return this.pop();
    }

    protected void parseToken() {
        switch (this._tokenizer.getTokenType()) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
            }
        }
    }

    protected void parseSql() {
        Node node;
        String sql = this._tokenizer.getToken();
        if (this.isElseMode()) {
            sql = this.replaceString(sql, "--", "");
        }
        if (((node = this.peek()) instanceof IfNode || node instanceof ElseNode) && node.getChildSize() == 0) {
            SqlTokenizer st = new SqlTokenizer(sql);
            st.skipWhitespace();
            String token = st.skipToken();
            st.skipWhitespace();
            if (sql.startsWith(",")) {
                if (sql.startsWith(", ")) {
                    node.addChild(this.createPrefixSqlNode(", ", sql.substring(2)));
                } else {
                    node.addChild(this.createPrefixSqlNode(",", sql.substring(1)));
                }
            } else if ("AND".equalsIgnoreCase(token) || "OR".equalsIgnoreCase(token)) {
                node.addChild(this.createPrefixSqlNode(st.getBefore(), st.getAfter()));
            } else {
                node.addChild(this.createSqlNodeAsIfElseChildNode(sql));
            }
        } else {
            node.addChild(this.createSqlNode(sql));
        }
    }

    protected void parseComment() {
        String comment = this._tokenizer.getToken();
        if (SqlAnalyzer.isTargetComment(comment)) {
            if (SqlAnalyzer.isIfComment(comment)) {
                this.parseIf();
            } else if (SqlAnalyzer.isBeginComment(comment)) {
                this.parseBegin();
            } else {
                if (SqlAnalyzer.isEndComment(comment)) {
                    return;
                }
                this.parseCommentBindVariable();
            }
        } else if (comment != null && 0 < comment.length()) {
            String before = this._tokenizer.getBefore();
            this.peek().addChild(this.createSqlNode(before.substring(before.lastIndexOf("/*"))));
        }
    }

    protected void parseIf() {
        String condition = this._tokenizer.getToken().substring(2).trim();
        if (DfStringUtil.isNullOrEmpty(condition)) {
            this.throwIfCommentConditionNotFoundException();
        }
        IfNode ifNode = this.createIfNode(condition);
        this.peek().addChild(ifNode);
        this.push(ifNode);
        this.parseEnd();
    }

    protected void throwIfCommentConditionNotFoundException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The condition of IF comment was not found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the IF comment expression." + this.ln();
        msg = msg + "It may exist the IF comment that DOESN'T have a condition." + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    (x) - /*IF*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.ln();
        msg = msg + "    (o) - /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._tokenizer.getToken() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentConditionNotFoundException(msg);
    }

    protected void parseBegin() {
        BeginNode beginNode = this.createBeginNode();
        this.peek().addChild(beginNode);
        this.push(beginNode);
        this.parseEnd();
    }

    protected void parseEnd() {
        while (99 != this._tokenizer.next()) {
            if (this._tokenizer.getTokenType() == 2 && SqlAnalyzer.isEndComment(this._tokenizer.getToken())) {
                this.pop();
                return;
            }
            this.parseToken();
        }
        this.throwEndCommentNotFoundException();
    }

    protected void throwEndCommentNotFoundException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The end comment was not found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the parameter comment logic." + this.ln();
        msg = msg + "It may exist the parameter comment that DOESN'T have an end comment." + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    (x) - /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3" + this.ln();
        msg = msg + "    (o) - /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new EndCommentNotFoundException(msg);
    }

    protected void parseElse() {
        Node parent = this.peek();
        if (!(parent instanceof IfNode)) {
            return;
        }
        IfNode ifNode = (IfNode)this.pop();
        ElseNode elseNode = new ElseNode();
        ifNode.setElseNode(elseNode);
        this.push(elseNode);
        this._tokenizer.skipWhitespace();
    }

    protected void parseCommentBindVariable() {
        String expr = this._tokenizer.getToken();
        String testValue = this._tokenizer.skipToken(true);
        if (expr.startsWith("$")) {
            this.peek().addChild(this.createEmbeddedValueNode(expr.substring(1), testValue));
        } else {
            this.peek().addChild(this.createBindVariableNode(expr, testValue));
        }
    }

    protected void parseBindVariable() {
        String expr = this._tokenizer.getToken();
        this.peek().addChild(this.createBindVariableNode(expr, null));
    }

    protected Node pop() {
        return this._nodeStack.pop();
    }

    protected Node peek() {
        return this._nodeStack.peek();
    }

    protected void push(Node node) {
        this._nodeStack.push(node);
    }

    protected boolean isElseMode() {
        for (int i = 0; i < this._nodeStack.size(); ++i) {
            if (!(this._nodeStack.get(i) instanceof ElseNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTargetComment(String comment) {
        return comment != null && comment.length() > 0 && Character.isJavaIdentifierStart(comment.charAt(0));
    }

    private static boolean isIfComment(String comment) {
        return comment.startsWith("IF");
    }

    private static boolean isBeginComment(String content) {
        return content != null && "BEGIN".equals(content);
    }

    private static boolean isEndComment(String content) {
        return content != null && "END".equals(content);
    }

    protected BeginNode createBeginNode() {
        return new BeginNode();
    }

    protected IfNode createIfNode(String expr) {
        this.researchIfNeed(this._researchIfCommentList, expr);
        return new IfNode(expr, this._specifiedSql);
    }

    protected BindVariableNode createBindVariableNode(String expr, String testValue) {
        this.researchIfNeed(this._researchBindVariableCommentList, expr);
        return new BindVariableNode(expr, testValue, this._specifiedSql, this._blockNullParameter);
    }

    protected EmbeddedValueNode createEmbeddedValueNode(String expr, String testValue) {
        this.researchIfNeed(this._researchEmbeddedValueCommentList, expr);
        return new EmbeddedValueNode(expr, testValue, this._specifiedSql, this._blockNullParameter);
    }

    protected SqlNode createSqlNode(String sql) {
        return SqlNode.createSqlNode(sql);
    }

    protected SqlNode createSqlNodeAsIfElseChildNode(String sql) {
        return SqlNode.createSqlNodeAsIfElseChild(sql);
    }

    protected PrefixSqlNode createPrefixSqlNode(String prefix, String sql) {
        return new PrefixSqlNode(prefix, sql);
    }

    public List<String> researchIfComment() {
        ArrayList<String> resultList = new ArrayList<String>();
        this._researchIfCommentList = resultList;
        return resultList;
    }

    public List<String> researchBindVariableComment() {
        ArrayList<String> resultList = new ArrayList<String>();
        this._researchBindVariableCommentList = resultList;
        return resultList;
    }

    public List<String> researchEmbeddedValueComment() {
        ArrayList<String> resultList = new ArrayList<String>();
        this._researchEmbeddedValueCommentList = resultList;
        return resultList;
    }

    protected void researchIfNeed(List<String> researchList, String expr) {
        if (researchList != null) {
            researchList.add(expr);
        }
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    public static String convertTwoWaySql2DisplaySql(SqlAnalyzerFactory factory, String twoWaySql, Object arg, String logDateFormat, String logTimestampFormat) {
        String[] argNames = new String[]{"pmb"};
        Class[] argTypes = new Class[]{arg.getClass()};
        Object[] args = new Object[]{arg};
        return SqlAnalyzer.convertTwoWaySql2DisplaySql(factory, twoWaySql, argNames, argTypes, args, logDateFormat, logTimestampFormat);
    }

    public static String convertTwoWaySql2DisplaySql(SqlAnalyzerFactory factory, String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args, String logDateFormat, String logTimestampFormat) {
        SqlAnalyzer parser = factory.create(twoWaySql, false);
        Node node = parser.analyze();
        CommandContextCreator creator = new CommandContextCreator(argNames, argTypes);
        CommandContext context = creator.createCommandContext(args);
        node.accept(context);
        String preparedSql = context.getSql();
        return DisplaySqlBuilder.buildDisplaySql(preparedSql, context.getBindVariables(), logDateFormat, logTimestampFormat);
    }
}

