/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.dbflute.cbean.FetchAssistContext;
import org.seasar.dbflute.cbean.FetchBean;
import org.seasar.dbflute.cbean.FetchNarrowingBean;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.s2dao.jdbc.TnFetchAssistResultSet;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnBasicSelectHandler
extends TnBasicHandler {
    private TnResultSetHandler resultSetHandler;

    public TnBasicSelectHandler(DataSource dataSource, String sql, TnResultSetHandler resultSetHandler, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
        this.setSql(sql);
        this.setResultSetHandler(resultSetHandler);
    }

    public Object execute(Object[] args) {
        return this.execute(args, this.getArgTypes(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object[] args, Class<?>[] argTypes) {
        Connection conn = this.getConnection();
        try {
            Object object = this.execute(conn, args, argTypes);
            return object;
        }
        finally {
            this.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Connection conn, Object[] args, Class<?>[] argTypes) {
        this.logSql(args, argTypes);
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(conn);
            this.bindArgs(ps, args, argTypes);
            Object object = this.execute(ps);
            return object;
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps);
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            this.close(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(PreparedStatement ps) throws SQLException {
        if (this.resultSetHandler == null) {
            throw new IllegalStateException("The resultSetHandler should not be null!");
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.createResultSet(ps);
            Object object = this.resultSetHandler.handle(resultSet);
            return object;
        }
        finally {
            this.close(resultSet);
        }
    }

    protected ResultSet createResultSet(PreparedStatement ps) throws SQLException {
        TnFetchAssistResultSet wrapper;
        ResultSet resultSet = ps.executeQuery();
        if (!this.isUseFunctionalResultSet()) {
            return resultSet;
        }
        FetchBean selbean = FetchAssistContext.getFetchBeanOnThread();
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
            boolean offsetByCursorForcedly = context.isOffsetByCursorForcedly();
            boolean limitByCursorForcedly = context.isLimitByCursorForcedly();
            wrapper = this.createFunctionalResultSet(resultSet, selbean, offsetByCursorForcedly, limitByCursorForcedly);
        } else {
            wrapper = this.createFunctionalResultSet(resultSet, selbean, false, false);
        }
        return wrapper;
    }

    protected boolean isUseFunctionalResultSet() {
        FetchBean fcbean = FetchAssistContext.getFetchBeanOnThread();
        if (fcbean != null && fcbean.getSafetyMaxResultSize() > 0) {
            return true;
        }
        FetchNarrowingBean fnbean = FetchAssistContext.getFetchNarrowingBeanOnThread();
        if (fnbean != null && fnbean.isFetchNarrowingEffective()) {
            OutsideSqlContext outsideSqlContext;
            if (fnbean.isFetchNarrowingSkipStartIndexEffective() || fnbean.isFetchNarrowingLoopCountEffective()) {
                return true;
            }
            if (OutsideSqlContext.isExistOutsideSqlContextOnThread() && ((outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread()).isOffsetByCursorForcedly() || outsideSqlContext.isLimitByCursorForcedly())) {
                return true;
            }
        }
        return false;
    }

    protected TnFetchAssistResultSet createFunctionalResultSet(ResultSet resultSet, FetchBean fcbean, boolean offsetByCursorForcedly, boolean limitByCursorForcedly) {
        return new TnFetchAssistResultSet(resultSet, fcbean, offsetByCursorForcedly, limitByCursorForcedly);
    }

    public TnResultSetHandler getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setResultSetHandler(TnResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }
}

