/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.chelper.HpSpQyCall;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HpAbstractSpecification<CQ extends ConditionQuery> {
    protected ConditionBean _baseCB;
    protected HpSpQyCall<CQ> _qyCall;
    protected CQ _query;
    protected boolean _forDerivedReferrer;
    protected boolean _forScalarSelect;
    protected boolean _forScalarSubQuery;
    protected boolean _alreadySpecifyRequiredColumn;
    protected boolean _forGeneralOneSpecificaion;
    protected DBMetaProvider _dbmetaProvider;

    protected HpAbstractSpecification(ConditionBean baseCB, HpSpQyCall<CQ> qyCall, boolean forDerivedReferrer, boolean forScalarSelect, boolean forScalarSubQuery, DBMetaProvider dbmetaProvider) {
        this._baseCB = baseCB;
        this._qyCall = qyCall;
        this._forDerivedReferrer = forDerivedReferrer;
        this._forScalarSelect = forScalarSelect;
        this._forScalarSubQuery = forScalarSubQuery;
        this._dbmetaProvider = dbmetaProvider;
    }

    protected void doColumn(String columnName) {
        this.assertColumn(columnName);
        if (this._query == null) {
            this._query = this._qyCall.qy();
        }
        if (this.isRequiredColumnSpecificationEnabled()) {
            this._alreadySpecifyRequiredColumn = true;
            this.doSpecifyRequiredColumn();
        }
        String relationPath = this._query.getRelationPath() != null ? this._query.getRelationPath() : "";
        String tableAliasName = this._query.isBaseQuery((ConditionQuery)this._query) ? this._baseCB.getSqlClause().getLocalTableAliasName() : this._baseCB.getSqlClause().resolveJoinAliasName(relationPath, this._query.getNestLevel());
        this._baseCB.getSqlClause().specifySelectColumn(tableAliasName, columnName);
    }

    protected boolean isRequiredColumnSpecificationEnabled() {
        return !this._forGeneralOneSpecificaion && !this._forDerivedReferrer && !this._forScalarSelect && !this._forScalarSubQuery && !this._alreadySpecifyRequiredColumn;
    }

    protected void assertColumn(String columnName) {
        if (this._forGeneralOneSpecificaion || this._forDerivedReferrer) {
            return;
        }
        if (this._query == null && !this._qyCall.has()) {
            this.throwSpecifyColumnNotSetupSelectColumnException(columnName);
        }
    }

    protected void assertForeign(String foreignPropertyName) {
        if (this._forScalarSelect) {
            this.throwScalarSelectInvalidForeignSpecificationException(foreignPropertyName);
        }
        if (this._forScalarSubQuery) {
            this.throwScalarSubQueryInvalidForeignSpecificationException(foreignPropertyName);
        }
    }

    protected abstract void doSpecifyRequiredColumn();

    protected abstract String getTableDbName();

    protected void throwSpecifyColumnNotSetupSelectColumnException(String columnName) {
        ConditionBeanContext.throwSpecifyColumnNotSetupSelectColumnException(this._baseCB, this.getTableDbName(), columnName);
    }

    protected void throwDerivedReferrerInvalidForeignSpecificationException(String foreignPropertyName) {
        ConditionBeanContext.throwDerivedReferrerInvalidForeignSpecificationException(foreignPropertyName);
    }

    protected void throwScalarSelectInvalidForeignSpecificationException(String foreignPropertyName) {
        ConditionBeanContext.throwScalarSelectInvalidForeignSpecificationException(foreignPropertyName);
    }

    protected void throwScalarSubQueryInvalidForeignSpecificationException(String foreignPropertyName) {
        ConditionBeanContext.throwScalarSubQueryInvalidForeignSpecificationException(foreignPropertyName);
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }
}

