/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.sequence;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.handler.DfAutoIncrementHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfTableHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfUniqueKeyHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceHandlerJdbc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSequenceHandlerPostgreSQL
extends DfSequenceHandlerJdbc {
    private static final Log _log = LogFactory.getLog(DfSequenceHandlerPostgreSQL.class);

    public DfSequenceHandlerPostgreSQL(DataSource dataSource, String schema, List<String> allSchemaList) {
        super(dataSource, schema, allSchemaList);
    }

    @Override
    public void incrementSequenceToDataMax(Map<String, String> tableSequenceMap) {
        super.incrementSequenceToDataMax(tableSequenceMap);
        try {
            this.handleSerialTypeSequence(tableSequenceMap);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSerialTypeSequence(Map<String, String> tableSequenceMap) throws SQLException {
        SQLException ignored22;
        Connection conn;
        block12: {
            StringSet doneSequenceSet = StringSet.createAsFlexibleOrdered();
            doneSequenceSet.addAll(tableSequenceMap.values());
            DfTableHandler tableHandler = new DfTableHandler(){

                @Override
                protected List<String> getRealTableExceptList(String schemaName) {
                    return new ArrayList<String>();
                }

                @Override
                protected List<String> getRealTableTargetList(String schemaName) {
                    return new ArrayList<String>();
                }
            };
            conn = null;
            Statement st = null;
            try {
                conn = this._dataSource.getConnection();
                st = conn.createStatement();
                DatabaseMetaData metaData = conn.getMetaData();
                List<DfTableMetaInfo> tableList = tableHandler.getTableList(metaData, this._schema);
                DfUniqueKeyHandler uniqueKeyHandler = new DfUniqueKeyHandler();
                DfColumnHandler columnHandler = new DfColumnHandler(){

                    @Override
                    protected Map<String, List<String>> getRealColumnExceptMap(String schemaName) {
                        return new HashMap<String, List<String>>();
                    }
                };
                DfAutoIncrementHandler autoIncrementHandler = new DfAutoIncrementHandler();
                _log.info((Object)"...Incrementing serial type sequence");
                for (DfTableMetaInfo tableMetaInfo : tableList) {
                    Integer actualValue;
                    Integer count;
                    String sequenceName;
                    String excludedPrefixString;
                    int endIndex;
                    Map<String, DfColumnMetaInfo> columnMetaMap;
                    DfColumnMetaInfo columnMetaInfo;
                    String defaultValue;
                    String primaryKeyColumnName;
                    String tableName = tableMetaInfo.getTableName();
                    DfPrimaryKeyMetaInfo pkInfo = uniqueKeyHandler.getPrimaryKey(metaData, this._schema, tableMetaInfo);
                    List<String> pkList = pkInfo.getPrimaryKeyList();
                    if (pkList.size() != 1 || !autoIncrementHandler.isAutoIncrementColumn(conn, tableMetaInfo, primaryKeyColumnName = pkList.get(0)) || (defaultValue = (columnMetaInfo = (columnMetaMap = columnHandler.getColumnMetaInfo(metaData, this._schema, tableName)).get(primaryKeyColumnName)).getDefaultValue()) == null) continue;
                    String prefix = "nextval('";
                    if (!defaultValue.startsWith("nextval('") || (endIndex = (excludedPrefixString = defaultValue.substring("nextval('".length())).indexOf("'")) < 0 || doneSequenceSet.contains((Object)(sequenceName = excludedPrefixString.substring(0, endIndex))) || (count = this.selectCount(st, tableName)) == null || count == 0 || (actualValue = this.selectDataMax(st, tableName, primaryKeyColumnName)) == null) continue;
                    this.callSequenceLoop(st, sequenceName, actualValue);
                }
                Object var27_26 = null;
                if (st == null) break block12;
            }
            catch (Throwable throwable) {
                SQLException ignored22;
                Object var27_27 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ignored22) {
                        _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored22);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored22) {
                        _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored22);
                    }
                }
                throw throwable;
            }
            try {
                st.close();
            }
            catch (SQLException ignored22) {
                _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored22);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException ignored22) {
                _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored22);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Integer selectNextVal(Statement st, String sequenceName) throws SQLException {
        Integer n;
        block5: {
            ResultSet rs = null;
            try {
                rs = st.executeQuery("select nextval ('" + sequenceName + "')");
                rs.next();
                n = rs.getInt(1);
                Object var6_5 = null;
                if (rs == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_6 = null;
                    if (rs == null) break block6;
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored) {
                        _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                    }
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignored) {
                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
            }
        }
        return n;
    }
}

