/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.comment;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDbCommentExtractorSqlServer
extends DfDbCommentExtractorBase {
    @Override
    protected List<DfDbCommentExtractor.UserTabComments> selectUserTabComments(Connection conn, Set<String> tableSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("select cast(objtype as nvarchar(500)) as OBJECT_TYPE");
        sb.append(", cast(objname as nvarchar(500)) as TABLE_NAME");
        sb.append(", cast(value as nvarchar(4000)) as COMMENTS");
        sb.append(" from fn_listextendedproperty");
        sb.append("('MS_Description', 'schema', '").append(this._schema).append("'");
        sb.append(", 'table', default, default, default)");
        sb.append(" order by TABLE_NAME asc");
        String sql = sb.toString();
        return this.doSelectUserTabComments(sql, conn, tableSet);
    }

    @Override
    protected List<DfDbCommentExtractor.UserColComments> selectUserColComments(Connection conn, Set<String> tableSet) {
        ArrayList<DfDbCommentExtractor.UserColComments> resultList = new ArrayList<DfDbCommentExtractor.UserColComments>();
        for (String tableName : tableSet) {
            String sql = this.buildUserColCommentsSql(tableName);
            List<DfDbCommentExtractor.UserColComments> userColComments = this.doSelectUserColComments(sql, conn, tableSet);
            resultList.addAll(userColComments);
        }
        return resultList;
    }

    protected String buildUserColCommentsSql(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("select '").append(tableName).append("' as TABLE_NAME");
        sb.append(", cast(objname as nvarchar(500)) as COLUMN_NAME");
        sb.append(", cast(value as nvarchar(4000)) as COMMENTS");
        sb.append(" from fn_listextendedproperty");
        sb.append("('MS_Description', 'schema', '").append(this._schema).append("'");
        sb.append(", 'table', '").append(tableName).append("', 'column', default)");
        sb.append(" order by TABLE_NAME asc, COLUMN_NAME asc");
        return sb.toString();
    }
}

