/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.engine.database.model.NameGenerator;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaNameGenerator
implements NameGenerator {
    @Override
    public String generateName(List<?> inputs) {
        String schemaName = (String)inputs.get(0);
        String method = (String)inputs.get(1);
        String javaName = null;
        javaName = "underscore".equals(method) ? this.underscoreMethod(schemaName) : ("javaname".equals(method) ? this.javanameMethod(schemaName) : ("nochange".equals(method) ? this.nochangeMethod(schemaName) : this.underscoreMethod(schemaName)));
        return javaName;
    }

    protected String underscoreMethod(String schemaName) {
        StringBuffer name = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(schemaName, String.valueOf('_'));
        DfLittleAdjustmentProperties prop = DfBuildProperties.getInstance().getLittleAdjustmentProperties();
        boolean availableToLowerInGeneratorUnderscoreMethod = prop.isAvailableToLowerInGeneratorUnderscoreMethod();
        while (tok.hasMoreTokens()) {
            String namePart = (String)tok.nextElement();
            if (availableToLowerInGeneratorUnderscoreMethod) {
                namePart = namePart.toLowerCase();
            }
            name.append(StringUtils.capitalise((String)namePart));
        }
        return name.toString();
    }

    protected String javanameMethod(String schemaName) {
        StringBuffer name = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(schemaName, String.valueOf('_'));
        while (tok.hasMoreTokens()) {
            String namePart = (String)tok.nextElement();
            name.append(StringUtils.capitalise((String)namePart));
        }
        return name.toString();
    }

    protected final String nochangeMethod(String name) {
        return name;
    }
}

