/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task.replaceschema;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.io.data.DfSeparatedDataResultInfo;
import org.seasar.dbflute.helper.io.data.DfSeparatedDataSeveralHandlingInfo;
import org.seasar.dbflute.helper.io.data.impl.DfSeparatedDataHandlerImpl;
import org.seasar.dbflute.helper.io.data.impl.DfXlsDataHandlerImpl;
import org.seasar.dbflute.helper.io.data.impl.DfXlsDataHandlerSqlServer;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfReplaceSchemaProperties;
import org.seasar.dbflute.task.replaceschema.DfAbstractReplaceSchemaTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfLoadDataTask
extends DfAbstractReplaceSchemaTask {
    private static final Log _log = LogFactory.getLog(DfLoadDataTask.class);
    protected boolean validTaskEndInformation = true;
    protected DfXlsDataHandlerImpl xlsDataHandlerImpl;

    @Override
    protected void doExecute() {
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * * *");
        _log.info((Object)"*                   *");
        _log.info((Object)"* Load Data         *");
        _log.info((Object)"*                   *");
        _log.info((Object)"* * * * * * * * * * *");
        this.writeDbFromSeparatedFileAsCommonData("tsv", "\t");
        this.writeDbFromSeparatedFileAsCommonData("csv", ",");
        this.writeDbFromXlsAsCommonData();
        this.writeDbFromSeparatedFileAsAdditionalData("tsv", "\t");
        this.writeDbFromSeparatedFileAsAdditionalData("csv", ",");
        this.writeDbFromXlsAsAdditionalData();
    }

    @Override
    protected boolean isValidTaskEndInformation() {
        return this.validTaskEndInformation;
    }

    protected String getDataLoadingType() {
        return this.getMyProperties().getDataLoadingType();
    }

    public boolean isLoggingInsertSql() {
        return this.getMyProperties().isLoggingInsertSql();
    }

    public boolean isSuppressBatchUpdate() {
        return this.getMyProperties().isSuppressBatchUpdate();
    }

    protected DfReplaceSchemaProperties getMyProperties() {
        return DfBuildProperties.getInstance().getReplaceSchemaProperties();
    }

    protected void writeDbFromSeparatedFileAsCommonData(String typeName, String delimter) {
        this.writeDbFromSeparatedFile(typeName, delimter, this.getCommonDataDirectoryPath(typeName), "common");
    }

    protected void writeDbFromSeparatedFileAsAdditionalData(String typeName, String delimter) {
        this.writeDbFromSeparatedFile(typeName, delimter, this.getAdditionalDataDirectoryPath(this.getDataLoadingType(), typeName), this.getDataLoadingType());
    }

    protected void writeDbFromSeparatedFile(String typeName, String delimter, String directoryPath, String location) {
        DfSeparatedDataHandlerImpl handler = new DfSeparatedDataHandlerImpl();
        handler.setLoggingInsertSql(this.isLoggingInsertSql());
        handler.setDataSource(this.getDataSource());
        DfSeparatedDataSeveralHandlingInfo handlingInfo = new DfSeparatedDataSeveralHandlingInfo();
        handlingInfo.setBasePath(directoryPath);
        handlingInfo.setTypeName(typeName);
        handlingInfo.setDelimter(delimter);
        handlingInfo.setErrorContinue(true);
        DfSeparatedDataResultInfo resultInfo = handler.writeSeveralData(handlingInfo);
        this.showNotFoundColumn(typeName, resultInfo.getNotFoundColumnMap());
    }

    protected void showNotFoundColumn(String typeName, Map<String, Set<String>> notFoundColumnMap) {
        if (notFoundColumnMap.isEmpty()) {
            return;
        }
        _log.warn((Object)"* * * * * * * * * * * * * * *");
        _log.warn((Object)("Not Persistent Columns in " + typeName));
        _log.warn((Object)"* * * * * * * * * * * * * * *");
        Set<Map.Entry<String, Set<String>>> entrySet = notFoundColumnMap.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            String tableName = entry.getKey();
            Set<String> columnNameSet = entry.getValue();
            _log.warn((Object)("[" + tableName + "]"));
            for (String columnName : columnNameSet) {
                _log.warn((Object)("    " + columnName));
            }
            _log.warn((Object)" ");
        }
    }

    protected String getReplaceSchemaSqlFileDirectoryName() {
        String sqlFileName = this.getMyProperties().getReplaceSchemaSqlFile();
        return sqlFileName.substring(0, sqlFileName.lastIndexOf("/"));
    }

    protected String getCommonDataDirectoryPath(String typeName) {
        return this.getReplaceSchemaSqlFileDirectoryName() + "/data/common/" + typeName;
    }

    protected String getAdditionalDataDirectoryPath(String envType, String typeName) {
        return this.getReplaceSchemaSqlFileDirectoryName() + "/data/" + envType + "/" + typeName;
    }

    protected void writeDbFromXlsAsCommonData() {
        this.writeDbFromXls(this.getCommonDataDirectoryPath("xls"));
    }

    protected void writeDbFromXlsAsAdditionalData() {
        this.writeDbFromXls(this.getAdditionalDataDirectoryPath(this.getDataLoadingType(), "xls"));
    }

    protected void writeDbFromXls(String directoryPath) {
        DfXlsDataHandlerImpl xlsDataHandler = this.getXlsDataHandlerImpl();
        xlsDataHandler.writeSeveralData(directoryPath, this.getDataSource());
    }

    protected DfXlsDataHandlerImpl getXlsDataHandlerImpl() {
        DfBasicProperties basicProperties = DfBuildProperties.getInstance().getBasicProperties();
        if (this.xlsDataHandlerImpl == null) {
            DfXlsDataHandlerImpl xlsDataHandler = basicProperties.isDatabaseSqlServer() ? new DfXlsDataHandlerSqlServer() : new DfXlsDataHandlerImpl();
            xlsDataHandler.setLoggingInsertSql(this.isLoggingInsertSql());
            xlsDataHandler.setSuppressBatchUpdate(this.isSuppressBatchUpdate());
            xlsDataHandler.setSchemaName(this._schema);
            xlsDataHandler.setSkipSheet(this.getMyProperties().getSkipSheet());
            this.xlsDataHandlerImpl = xlsDataHandler;
        }
        return this.xlsDataHandlerImpl;
    }

    public void setValidTaskEndInformation(String validTaskEndInformation) {
        this.validTaskEndInformation = validTaskEndInformation != null && validTaskEndInformation.trim().equalsIgnoreCase("true");
    }
}

