/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.dataset.types;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.seasar.dbflute.helper.dataset.types.DfDtsBigDecimalType;
import org.seasar.dbflute.helper.dataset.types.DfDtsBinaryType;
import org.seasar.dbflute.helper.dataset.types.DfDtsBooleanType;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnType;
import org.seasar.dbflute.helper.dataset.types.DfDtsObjectType;
import org.seasar.dbflute.helper.dataset.types.DfDtsStringType;
import org.seasar.dbflute.helper.dataset.types.DfDtsTimestampType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDtsColumnTypes {
    public static final DfDtsColumnType STRING = new DfDtsStringType();
    public static final DfDtsColumnType NOT_TRIM_STRING = new DfDtsStringType(false);
    public static final DfDtsColumnType BIGDECIMAL = new DfDtsBigDecimalType();
    public static final DfDtsColumnType TIMESTAMP = new DfDtsTimestampType();
    public static final DfDtsColumnType BINARY = new DfDtsBinaryType();
    public static final DfDtsColumnType OBJECT = new DfDtsObjectType();
    public static final DfDtsColumnType BOOLEAN = new DfDtsBooleanType();
    private static Map<Class<?>, DfDtsColumnType> typesByClass = new HashMap();
    private static Map<Integer, DfDtsColumnType> typesBySqlType = new HashMap<Integer, DfDtsColumnType>();

    protected DfDtsColumnTypes() {
    }

    public static DfDtsColumnType getColumnType(int type) {
        DfDtsColumnType columnType = typesBySqlType.get(new Integer(type));
        if (columnType != null) {
            return columnType;
        }
        return OBJECT;
    }

    public static DfDtsColumnType getColumnType(Object value) {
        if (value == null) {
            return OBJECT;
        }
        return DfDtsColumnTypes.getColumnType(value.getClass());
    }

    public static DfDtsColumnType getColumnType(Class<?> clazz) {
        DfDtsColumnType columnType = typesByClass.get(clazz);
        if (columnType != null) {
            return columnType;
        }
        return OBJECT;
    }

    public static DfDtsColumnType registerColumnType(int sqlType, DfDtsColumnType columnType) {
        return typesBySqlType.put(new Integer(sqlType), columnType);
    }

    public static DfDtsColumnType registerColumnType(Class<?> clazz, DfDtsColumnType columnType) {
        return typesByClass.put(clazz, columnType);
    }

    static {
        DfDtsColumnTypes.registerColumnType(String.class, STRING);
        DfDtsColumnTypes.registerColumnType(Short.TYPE, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Short.class, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Integer.TYPE, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Integer.class, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Long.TYPE, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Long.class, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Float.TYPE, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Float.class, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Double.TYPE, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Double.class, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Boolean.TYPE, BOOLEAN);
        DfDtsColumnTypes.registerColumnType(Boolean.class, BOOLEAN);
        DfDtsColumnTypes.registerColumnType(BigDecimal.class, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(Timestamp.class, TIMESTAMP);
        DfDtsColumnTypes.registerColumnType(java.sql.Date.class, TIMESTAMP);
        DfDtsColumnTypes.registerColumnType(Date.class, TIMESTAMP);
        DfDtsColumnTypes.registerColumnType(Calendar.class, TIMESTAMP);
        DfDtsColumnTypes.registerColumnType(new byte[0].getClass(), BINARY);
        DfDtsColumnTypes.registerColumnType(-6, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(5, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(4, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(-5, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(7, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(6, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(8, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(3, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(2, BIGDECIMAL);
        DfDtsColumnTypes.registerColumnType(16, BOOLEAN);
        DfDtsColumnTypes.registerColumnType(91, TIMESTAMP);
        DfDtsColumnTypes.registerColumnType(92, TIMESTAMP);
        DfDtsColumnTypes.registerColumnType(93, TIMESTAMP);
        DfDtsColumnTypes.registerColumnType(-2, BINARY);
        DfDtsColumnTypes.registerColumnType(-3, BINARY);
        DfDtsColumnTypes.registerColumnType(-4, BINARY);
        DfDtsColumnTypes.registerColumnType(1, STRING);
        DfDtsColumnTypes.registerColumnType(-1, STRING);
        DfDtsColumnTypes.registerColumnType(12, STRING);
    }
}

