/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.util;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfNameHintUtil {
    public static final String PREFIX_MARK = "prefix:";
    public static final String SUFFIX_MARK = "suffix:";
    public static final String CONTAIN_MARK = "contain:";

    public static boolean isTargetByHint(String name, List<String> targetList, List<String> exceptList) {
        if (targetList == null) {
            throw new IllegalArgumentException("The argument 'targetList' should not be null!");
        }
        if (exceptList == null) {
            throw new IllegalArgumentException("The argument 'exceptList' should not be null!");
        }
        if (targetList != null && !targetList.isEmpty()) {
            return DfNameHintUtil.isHitByTargetList(name, targetList);
        }
        for (String tableHint : exceptList) {
            if (!DfNameHintUtil.isHitByTheHint(name, tableHint)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isHitByTargetList(String name, List<String> targetList) {
        for (String tableHint : targetList) {
            if (!DfNameHintUtil.isHitByTheHint(name, tableHint)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHitByTheHint(String name, String hint) {
        String prefixMark = PREFIX_MARK;
        String suffixMark = SUFFIX_MARK;
        String containMark = CONTAIN_MARK;
        if (hint.toLowerCase().startsWith(PREFIX_MARK.toLowerCase())) {
            String pureHint = hint.substring(PREFIX_MARK.length(), hint.length());
            if (name.toLowerCase().startsWith(pureHint.toLowerCase())) {
                return true;
            }
        } else if (hint.toLowerCase().startsWith(SUFFIX_MARK.toLowerCase())) {
            String pureHint = hint.substring(SUFFIX_MARK.length(), hint.length());
            if (name.toLowerCase().endsWith(pureHint.toLowerCase())) {
                return true;
            }
        } else if (hint.toLowerCase().startsWith(CONTAIN_MARK.toLowerCase())) {
            String pureHint = hint.substring(CONTAIN_MARK.length(), hint.length());
            if (name.toLowerCase().contains(pureHint.toLowerCase())) {
                return true;
            }
        } else if (name.equalsIgnoreCase(hint)) {
            return true;
        }
        return false;
    }
}

