/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task.bs;

import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.jdbc.DfRunnerInformation;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileFireMan;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerExecute;
import org.seasar.dbflute.task.bs.DfAbstractTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbstractSqlExecutionTask
extends DfAbstractTask {
    private static final Log _log = LogFactory.getLog(DfAbstractSqlExecutionTask.class);

    @Override
    protected boolean isUseDataSource() {
        return true;
    }

    @Override
    protected void doExecute() {
        DfRunnerInformation runInfo = this.createRunnerInformation();
        DfSqlFileFireMan fireMan = this.createSqlFileFireMan();
        List<File> sqlFileList = this.getTargetSqlFileList();
        fireMan.execute(this.getSqlFileRunner(runInfo), sqlFileList);
        this.showTargetSqlFileInformation(sqlFileList);
    }

    protected DfSqlFileFireMan createSqlFileFireMan() {
        return new DfSqlFileFireMan();
    }

    protected DfRunnerInformation createRunnerInformation() {
        DfRunnerInformation runInfo = new DfRunnerInformation();
        runInfo.setDriver(this._driver);
        runInfo.setUrl(this._url);
        runInfo.setUser(this._userId);
        runInfo.setPassword(this._password);
        runInfo.setAutoCommit(this.isAutoCommit());
        runInfo.setErrorContinue(this.isErrorContinue());
        runInfo.setRollbackOnly(this.isRollbackOnly());
        this.customizeRunnerInformation(runInfo);
        return runInfo;
    }

    protected abstract List<File> getTargetSqlFileList();

    protected abstract DfSqlFileRunnerExecute getSqlFileRunner(DfRunnerInformation var1);

    protected abstract String getSqlDirectory();

    protected abstract boolean isAutoCommit();

    protected abstract boolean isErrorContinue();

    protected abstract boolean isRollbackOnly();

    protected abstract void customizeRunnerInformation(DfRunnerInformation var1);

    protected void showTargetSqlFileInformation(List<File> sqlFileList) {
        _log.info((Object)" ");
        _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
        _log.info((Object)("Target SQL files: " + sqlFileList.size()));
        _log.info((Object)" ");
        for (File sqlFile : sqlFileList) {
            _log.info((Object)("  " + sqlFile.getName()));
        }
        _log.info((Object)"- - - - - - - - - -/");
        _log.info((Object)" ");
    }
}

